/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerRelationPageReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerRelationService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerRelationDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerRelationEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerRelationServiceImpl
implements ICustomerRelationService {
    private Logger logger = LoggerFactory.getLogger(ICustomerRelationService.class);
    @Resource
    private CustomerRelationDas customerRelationDas;
    @Autowired
    private ICustomerService customerService;
    @Autowired
    private CustomerDas customerDas;

    @Override
    public Long addCustomerRelation(CustomerRelationReqDto addReqDto) {
        CustomerRelationEo customerRelationEo = new CustomerRelationEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerRelationEo);
        this.customerRelationDas.insert((BaseEo)customerRelationEo);
        return customerRelationEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBatchCustomerRelation(List<CustomerRelationReqDto> dtoList) {
        List fullIds;
        if (CollectionUtil.isEmpty(dtoList)) {
            return;
        }
        List<String> codes = dtoList.stream().map(CustomerRelationReqDto::getParentThirdCode).collect(Collectors.toList());
        this.removeCustomerRelationByParentCode(codes);
        ArrayList customerRelationEos = new ArrayList();
        DtoHelper.dtoList2EoList(dtoList, customerRelationEos, CustomerRelationEo.class);
        if (CollectionUtil.isNotEmpty(customerRelationEos)) {
            List thirdPs = dtoList.stream().flatMap(r -> Lists.newArrayList((Object[])new String[]{r.getParentThirdCode(), r.getThirdCode()}).stream()).collect(Collectors.toList());
            List customerEos = ((ExtQueryChainWrapper)this.customerDas.filter().in((Object)"third_party_id", thirdPs)).list();
            Map customerEoMap = customerEos.stream().collect(Collectors.toMap(StdCustomerEo::getThirdPartyId, Function.identity(), (o, o1) -> o));
            customerRelationEos.forEach(r -> {
                Optional.ofNullable(customerEoMap.get(r.getParentThirdCode())).ifPresent(p -> {
                    if (StringUtils.equals((CharSequence)r.getOrgLevel(), (CharSequence)"1")) {
                        r.setBrandId(p.getOrgInfoId());
                        r.setBrandName(p.getName());
                        r.setBrandCode(p.getCode());
                        r.setParentCusId(p.getId());
                        return;
                    }
                    r.setOrgCode(p.getThirdPartyId());
                    r.setOrgName(p.getName());
                    r.setParentThirdName(p.getName());
                    r.setBrandId(p.getMerchantId());
                    r.setParentCode(p.getCode());
                    r.setParentCusId(p.getId());
                });
                Optional.ofNullable(customerEoMap.get(r.getThirdCode())).ifPresent(p -> {
                    r.setThirdName(p.getName());
                    r.setCode(p.getCode());
                    r.setCusId(p.getId());
                    if (StringUtils.equals((CharSequence)r.getOrgLevel(), (CharSequence)"1")) {
                        r.setOrgCode(p.getThirdPartyId());
                        r.setOrgName(p.getName());
                    }
                });
            });
        }
        if (!(fullIds = customerRelationEos.stream().filter(r -> StringUtils.isBlank((CharSequence)r.getBrandCode())).map(CustomerRelationEo::getBrandId).distinct().collect(Collectors.toList())).isEmpty()) {
            Optional.ofNullable(((ExtQueryChainWrapper)this.customerDas.filter().in((Object)"org_info_id", fullIds)).list()).filter(CollectionUtils::isNotEmpty).ifPresent(eos -> {
                Map customerEoMap = eos.stream().collect(Collectors.toMap(StdCustomerEo::getOrgInfoId, Function.identity(), (o, o1) -> o));
                customerRelationEos.forEach(r -> Optional.ofNullable(customerEoMap.get(r.getBrandId())).ifPresent(eo -> {
                    r.setBrandName(eo.getName());
                    r.setBrandCode(eo.getCode());
                }));
            });
        }
        this.customerRelationDas.insertBatch(customerRelationEos);
    }

    @Override
    public void modifyCustomerRelation(CustomerRelationReqDto modifyReqDto) {
        CustomerRelationEo customerRelationEo = new CustomerRelationEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerRelationEo);
        this.customerRelationDas.updateSelective((BaseEo)customerRelationEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerRelation(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerRelationDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void removeCustomerRelationByParentCode(List<String> codes) {
        QueryWrapper filter = new QueryWrapper();
        filter.in((Object)"parent_third_code", codes);
        int delete = this.customerRelationDas.getMapper().delete((Wrapper)filter);
    }

    @Override
    public CustomerRelationRespDto queryById(Long id) {
        if (ObjectUtils.isEmpty((Object)id)) {
            return null;
        }
        CustomerRelationEo customerRelationEo = (CustomerRelationEo)((ExtQueryChainWrapper)this.customerRelationDas.filter().eq((Object)"id", (Object)id)).one();
        if (ObjectUtils.isEmpty((Object)customerRelationEo)) {
            return null;
        }
        CustomerRelationRespDto customerRelationRespDto = new CustomerRelationRespDto();
        DtoHelper.eo2Dto((BaseEo)customerRelationEo, (BaseVo)customerRelationRespDto);
        return customerRelationRespDto;
    }

    @Override
    public PageInfo<CustomerRelationRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerRelationReqDto customerRelationReqDto = (CustomerRelationReqDto)JSON.parseObject((String)filter, CustomerRelationReqDto.class);
        CustomerRelationEo customerRelationEo = new CustomerRelationEo();
        DtoHelper.dto2Eo((BaseVo)customerRelationReqDto, (BaseEo)customerRelationEo);
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerRelationDas.filter().eq(ObjectUtils.isNotEmpty((Object)customerRelationReqDto.getCusId()), (Object)"cus_id", (Object)customerRelationReqDto.getCusId())).eq(ObjectUtils.isNotEmpty((Object)customerRelationReqDto.getParentCusId()), (Object)"parent_cus_id", (Object)customerRelationReqDto.getParentCusId())).like(StringUtils.isNotEmpty((CharSequence)customerRelationReqDto.getThirdCode()), (Object)"third_code", (Object)customerRelationReqDto.getThirdCode())).like(StringUtils.isNotEmpty((CharSequence)customerRelationReqDto.getParentThirdCode()), (Object)"parent_third_code", (Object)customerRelationReqDto.getParentThirdCode())).like(StringUtils.isNotEmpty((CharSequence)customerRelationReqDto.getParentOrgId()), (Object)"parent_org_id", (Object)customerRelationReqDto.getParentOrgId())).like(StringUtils.isNotEmpty((CharSequence)customerRelationReqDto.getOrgLevel()), (Object)"org_level", (Object)customerRelationReqDto.getOrgLevel())).like(StringUtils.isNotEmpty((CharSequence)customerRelationReqDto.getBrandCode()), (Object)"brand_code", (Object)customerRelationReqDto.getBrandCode())).like(StringUtils.isNotEmpty((CharSequence)customerRelationReqDto.getBrandName()), (Object)"brand_name", (Object)customerRelationReqDto.getBrandName())).like(StringUtils.isNotEmpty((CharSequence)customerRelationReqDto.getCode()), (Object)"code", (Object)customerRelationReqDto.getCode())).like(StringUtils.isNotEmpty((CharSequence)customerRelationReqDto.getParentCode()), (Object)"parent_code", (Object)customerRelationReqDto.getParentCode())).page(pageNum, pageSize);
        return this.getCustomerRelationRespDtoPageInfo((PageInfo<CustomerRelationEo>)eoPageInfo);
    }

    @Override
    public CustomerRespDto queryMiddleCustomerInfo(Long smallCusId, Long greatCusId) {
        this.logger.info("\u6839\u636e\u5927\u5c0fB\u5ba2\u6237ID\u5224\u65ad\u5e76\u67e5\u8be2\u4e2dB\u4fe1\u606f\uff1a{}=={}", (Object)smallCusId, (Object)greatCusId);
        if (ObjectUtils.isEmpty((Object)smallCusId) && ObjectUtils.isEmpty((Object)greatCusId)) {
            return null;
        }
        Long cusId = null;
        cusId = ObjectUtils.isNotEmpty((Object)smallCusId) ? smallCusId : greatCusId;
        CustomerRespDto customerRespDto = this.customerService.queryById(cusId);
        if (ObjectUtils.isEmpty((Object)customerRespDto)) {
            return null;
        }
        CustomerRelationReqDto reqDto = new CustomerRelationReqDto();
        if (ObjectUtils.isNotEmpty((Object)smallCusId)) {
            reqDto.setThirdCode(customerRespDto.getThirdPartyId());
        } else {
            reqDto.setParentThirdCode(customerRespDto.getThirdPartyId());
        }
        List<CustomerRelationRespDto> customerRelationRespList = this.queryList(reqDto);
        if (CollectionUtil.isNotEmpty(customerRelationRespList)) {
            return customerRespDto;
        }
        return null;
    }

    @Override
    public List<CustomerRelationRespDto> queryList(CustomerRelationReqDto reqDto) {
        CustomerRelationEo customerRelationEo = new CustomerRelationEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerRelationEo);
        List select = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerRelationDas.filter().eq(ObjectUtils.isNotEmpty((Object)reqDto.getCusId()), (Object)"cus_id", (Object)reqDto.getCusId())).eq(ObjectUtils.isNotEmpty((Object)reqDto.getParentCusId()), (Object)"parent_cus_id", (Object)reqDto.getParentCusId())).like(StringUtils.isNotEmpty((CharSequence)reqDto.getThirdCode()), (Object)"third_code", (Object)reqDto.getThirdCode())).like(StringUtils.isNotEmpty((CharSequence)reqDto.getParentThirdCode()), (Object)"parent_third_code", (Object)reqDto.getParentThirdCode())).like(StringUtils.isNotEmpty((CharSequence)reqDto.getParentOrgId()), (Object)"parent_org_id", (Object)reqDto.getParentOrgId())).like(StringUtils.isNotEmpty((CharSequence)reqDto.getOrgLevel()), (Object)"org_level", (Object)reqDto.getOrgLevel())).like(StringUtils.isNotEmpty((CharSequence)reqDto.getBrandCode()), (Object)"brand_code", (Object)reqDto.getBrandCode())).like(StringUtils.isNotEmpty((CharSequence)reqDto.getBrandName()), (Object)"brand_name", (Object)reqDto.getBrandName())).like(StringUtils.isNotEmpty((CharSequence)reqDto.getCode()), (Object)"code", (Object)reqDto.getCode())).like(StringUtils.isNotEmpty((CharSequence)reqDto.getParentCode()), (Object)"parent_code", (Object)reqDto.getParentCode())).list();
        ArrayList<CustomerRelationRespDto> dtoList = new ArrayList<CustomerRelationRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, dtoList, CustomerRelationRespDto.class);
        return dtoList;
    }

    @Override
    public void replenishCustomerRelation(List<String> codes) {
        if (CollectionUtil.isEmpty(codes)) {
            return;
        }
        List customerRelationEos = this.customerRelationDas.queryCurrentCustomerRelation(codes);
        if (CollectionUtil.isNotEmpty((Collection)customerRelationEos)) {
            customerRelationEos.forEach(eo -> this.customerRelationDas.updateSelective((BaseEo)eo));
        }
    }

    @Override
    public CustomerRelationRespDto queryByCustomer(Long customerId) {
        CustomerRelationEo customerRelationEo = this.customerRelationDas.queryByCustomer(customerId);
        CustomerRelationRespDto relationRespDto = new CustomerRelationRespDto();
        DtoHelper.eo2Dto((BaseEo)customerRelationEo, (BaseVo)relationRespDto);
        if (ObjectUtils.isEmpty((Object)relationRespDto.getId())) {
            return null;
        }
        return relationRespDto;
    }

    @Override
    public PageInfo<CustomerRelationRespDto> queryByPage(CustomerRelationPageReqDto pageReqDto) {
        CustomerRelationEo customerRelationEo = new CustomerRelationEo();
        DtoHelper.dto2Eo((BaseVo)pageReqDto, (BaseEo)customerRelationEo);
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerRelationDas.filter().in(CollectionUtils.isNotEmpty((Collection)pageReqDto.getThirdPartyCodes()), (Object)"third_code", (Collection)pageReqDto.getThirdPartyCodes())).in(CollectionUtils.isNotEmpty((Collection)pageReqDto.getBrands()), (Object)"brand_code", (Collection)pageReqDto.getBrands())).in(CollectionUtils.isNotEmpty((Collection)pageReqDto.getOrgCodes()), (Object)"org_code", (Collection)pageReqDto.getOrgCodes())).in(CollectionUtils.isNotEmpty((Collection)pageReqDto.getOrgLevels()), (Object)"org_level", (Collection)pageReqDto.getOrgLevels())).in(CollectionUtils.isNotEmpty((Collection)pageReqDto.getDealerCodes()), (Object)"parent_third_code", (Collection)pageReqDto.getDealerCodes())).like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getOrgName()), (Object)"org_name", (Object)pageReqDto.getOrgName())).like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getDealerName()), (Object)"third_name", (Object)pageReqDto.getDealerName())).eq(ObjectUtils.isNotEmpty((Object)pageReqDto.getCusId()), (Object)"cus_id", (Object)pageReqDto.getCusId())).eq(ObjectUtils.isNotEmpty((Object)pageReqDto.getParentCusId()), (Object)"parent_cus_id", (Object)pageReqDto.getParentCusId())).like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getThirdCode()), (Object)"third_code", (Object)pageReqDto.getThirdCode())).like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getParentThirdCode()), (Object)"parent_third_code", (Object)pageReqDto.getParentThirdCode())).like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getDealerCode()), (Object)"parent_third_code", (Object)pageReqDto.getDealerCode())).like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getParentOrgId()), (Object)"parent_org_id", (Object)pageReqDto.getParentOrgId())).like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getOrgLevel()), (Object)"org_level", (Object)pageReqDto.getOrgLevel())).like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getBrandCode()), (Object)"brand_code", (Object)pageReqDto.getBrandCode())).like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getBrandName()), (Object)"brand_name", (Object)pageReqDto.getBrandName())).like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getCode()), (Object)"code", (Object)pageReqDto.getCode())).like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getParentCode()), (Object)"parent_code", (Object)pageReqDto.getParentCode())).page(pageReqDto.getPageNum(), pageReqDto.getPageSize());
        return this.getCustomerRelationRespDtoPageInfo((PageInfo<CustomerRelationEo>)eoPageInfo);
    }

    @NotNull
    private PageInfo<CustomerRelationRespDto> getCustomerRelationRespDtoPageInfo(PageInfo<CustomerRelationEo> eoPageInfo) {
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerRelationRespDto.class);
        dtoPageInfo.setList(dtoList);
        if (CollectionUtil.isNotEmpty(dtoList)) {
            dtoList.forEach(r -> {
                r.setParentOrgName(r.getParentThirdName());
                r.setOrgLevelName(StringUtils.equals((CharSequence)r.getOrgLevel(), (CharSequence)"1") ? "\u5927B" : "\u4e2dB");
            });
        }
        return dtoPageInfo;
    }
}

