/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.entity.NacosPropertiesOrgEntity;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerAreaListExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeRegionRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IEmployeeRegionService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerAreaMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmployeeRegionDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EmployeeRegionEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerAreaEo;
import com.dtyunxi.yundt.cube.center.customer.dao.mapper.EmployeeRegionMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerAreaEo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmployeeRegionServiceImpl
implements IEmployeeRegionService {
    public final Logger logger = LoggerFactory.getLogger(EmployeeRegionServiceImpl.class);
    @Resource
    private EmployeeRegionDas employeeRegionDas;
    @Resource
    private EmployeeRegionMapper employeeRegionMapper;
    @Resource
    private CustomerAreaMapper customerAreaMapper;
    @Resource
    private NacosPropertiesOrgEntity nacosPropertiesOrgEntity;
    @Resource
    private HttpServletRequest request;

    public String getHeaderOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        this.logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    @Override
    public Long addEmployeeRegion(EmployeeRegionReqDto addReqDto) {
        EmployeeRegionEo employeeRegionEo = new EmployeeRegionEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)employeeRegionEo);
        this.employeeRegionDas.insert((BaseEo)employeeRegionEo);
        return employeeRegionEo.getId();
    }

    @Override
    public void modifyEmployeeRegion(EmployeeRegionReqDto modifyReqDto) {
        EmployeeRegionEo employeeRegionEo = new EmployeeRegionEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)employeeRegionEo);
        this.employeeRegionDas.updateSelective((BaseEo)employeeRegionEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeEmployeeRegion(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.employeeRegionDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public EmployeeRegionRespDto queryById(Long id) {
        EmployeeRegionEo employeeRegionEo = (EmployeeRegionEo)this.employeeRegionDas.selectByPrimaryKey(id);
        EmployeeRegionRespDto employeeRegionRespDto = new EmployeeRegionRespDto();
        DtoHelper.eo2Dto((BaseEo)employeeRegionEo, (BaseVo)employeeRegionRespDto);
        return employeeRegionRespDto;
    }

    @Override
    public PageInfo<EmployeeRegionRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        EmployeeRegionReqDto employeeRegionReqDto = (EmployeeRegionReqDto)JSON.parseObject((String)filter, EmployeeRegionReqDto.class);
        EmployeeRegionEo employeeRegionEo = new EmployeeRegionEo();
        DtoHelper.dto2Eo((BaseVo)employeeRegionReqDto, (BaseEo)employeeRegionEo);
        PageInfo eoPageInfo = this.employeeRegionDas.selectPage((BaseEo)employeeRegionEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, EmployeeRegionRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<EmployeeRegionRespDto> queryEmployeeRegionList(EmployeeRegionQueryReqDto queryReqDto) {
        this.logger.info("\u67e5\u8be2\u4eba\u5458\u6240\u5c5e\u533a\u57df\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        String merchantId = null;
        if (ObjectUtils.isEmpty((Object)queryReqDto.getMerchantId())) {
            merchantId = this.getHeaderOrgId();
            this.logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)merchantId);
        } else {
            merchantId = String.valueOf(queryReqDto.getMerchantId());
        }
        if (StringUtils.isBlank((CharSequence)merchantId)) {
            merchantId = this.nacosPropertiesOrgEntity.orgId();
            this.logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)merchantId);
        }
        queryReqDto.setMerchantId(StringUtils.isBlank((CharSequence)merchantId) ? null : Long.valueOf(Long.parseLong(merchantId)));
        AssertUtil.assertNotBlank((String)merchantId, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        EmployeeRegionEo employeeCustomerEo = EmployeeRegionEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)employeeCustomerEo);
        List eoList = this.employeeRegionDas.select((BaseEo)employeeCustomerEo);
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return Lists.newArrayList();
        }
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoList, (Collection)respDtos, EmployeeRegionRespDto.class);
        List regionCodeList = respDtos.stream().map(EmployeeRegionRespDto::getRegionCode).distinct().collect(Collectors.toList());
        Map<Object, Object> areaEoMap = new HashMap();
        QueryWrapper areaEoQueryWrapper = new QueryWrapper();
        areaEoQueryWrapper.in((Object)"code", regionCodeList);
        areaEoQueryWrapper.eq((Object)"dr", (Object)"0");
        List customerAreaEos = this.customerAreaMapper.selectList((Wrapper)areaEoQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)customerAreaEos)) {
            areaEoMap = customerAreaEos.stream().collect(Collectors.toMap(StdCustomerAreaEo::getCode, Function.identity(), (k1, k2) -> k1));
        }
        for (EmployeeRegionRespDto respDto : respDtos) {
            if (areaEoMap.isEmpty() || !areaEoMap.containsKey(respDto.getRegionCode())) continue;
            respDto.setRegionName(((CustomerAreaEo)areaEoMap.get(respDto.getRegionCode())).getName());
        }
        return respDtos;
    }

    @Override
    public List<CustomerAreaRespDto> queryCustomerAreaByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        QueryWrapper areaEoQueryWrapper = new QueryWrapper();
        areaEoQueryWrapper.in((Object)"code", codes);
        areaEoQueryWrapper.eq((Object)"dr", (Object)"0");
        List customerAreaEos = this.customerAreaMapper.selectList((Wrapper)areaEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)customerAreaEos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)customerAreaEos, (Collection)respDtos, CustomerAreaRespDto.class);
        return respDtos;
    }

    @Override
    public List<String> querySubCustomerAreaByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        QueryWrapper areaEoQueryWrapper = new QueryWrapper();
        areaEoQueryWrapper.in((Object)"parent_code", codes);
        areaEoQueryWrapper.eq((Object)"dr", (Object)"0");
        List customerAreaEos = this.customerAreaMapper.selectList((Wrapper)areaEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)customerAreaEos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)customerAreaEos, (Collection)respDtos, CustomerAreaRespDto.class);
        return customerAreaEos.stream().map(StdCustomerAreaEo::getCode).collect(Collectors.toList());
    }

    @Override
    public List<EmployeeRegionRespDto> queryEmployeeRegionByCodes(EmployeeRegionQueryReqDto reqDto) {
        if (Objects.isNull(reqDto.getMerchantId())) {
            throw new BizException("\u5546\u5bb6ID(\u7ec4\u7ec7ID)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqDto.getRegionCodes())) {
            return Lists.newArrayList();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"region_code", (Collection)reqDto.getRegionCodes());
        queryWrapper.eq((Object)"merchant_id", (Object)reqDto.getMerchantId());
        queryWrapper.eq((Object)"dr", (Object)"0");
        List eoList = this.employeeRegionMapper.selectList((Wrapper)queryWrapper);
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoList, (Collection)respDtos, EmployeeRegionRespDto.class);
        return respDtos;
    }

    @Override
    public List<CustomerAreaRespDto> queryCustomerAreaByNames(CustomerAreaListExtReqDto reqDto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in(CollectionUtils.isNotEmpty((Collection)reqDto.getNameList()), (Object)"name", (Collection)reqDto.getNameList());
        queryWrapper.eq((Object)"dr", (Object)"0");
        queryWrapper.eq(Objects.nonNull(reqDto.getOrgInfoId()), (Object)"org_info_id", (Object)reqDto.getOrgInfoId());
        List eoList = this.customerAreaMapper.selectList((Wrapper)queryWrapper);
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoList, (Collection)respDtos, CustomerAreaRespDto.class);
        return respDtos;
    }
}

