/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseCoordinateQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.PositionQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ServiceAreaRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseDeliveryQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseTypeDto;
import com.dtyunxi.yundt.cube.center.inventory.api.fallback.WarehouseFallBack;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"\u5e93\u5b58\u4e2d\u5fc3\uff1a\u4ed3\u5e93\u67e5\u8be2\u670d\u52a1"})
@FeignClient(name="${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}", path="/v2/warehouse", url="${yundt.cube.center.inventory.api:}", fallback=WarehouseFallBack.class)
public interface IWarehouseQueryApi {
    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eId\u67e5\u8be2\u4ed3\u5e93\u8be6\u60c5", notes="\u6839\u636eId\u67e5\u8be2\u4ed3\u5e93\u8be6\u60c5 \t\n id:\u4ed3\u5e93id \t\n filter {\"instanceId\":0,\"tenantId\":1}")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4ed3\u5e93id", dataType="Long", paramType="path", required=true), @ApiImplicitParam(name="filter", value="{\"instanceId\":0,\"tenantId\":1}", dataType="String", paramType="query")})
    public RestResponse<WarehouseRespDto> queryWarehouseById(@NotNull(message="\u4ed3\u5e93Id\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(value="id") @NotNull(message="\u4ed3\u5e93Id\u4e0d\u80fd\u4e3a\u7a7a") Long var1, @RequestParam(name="filter", required=false) String var2);

    @GetMapping(value={"/base/{id}"})
    @ApiOperation(value="\u6839\u636eId\u67e5\u8be2\u4ed3\u5e93\u57fa\u7840\u4fe1\u606f\uff0c\u4e0d\u5305\u542b\u914d\u9001\u4fe1\u606f", notes="\u6839\u636eId\u67e5\u8be2\u4ed3\u5e93\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4ed3\u5e93id", dataType="Long", paramType="path", required=true)})
    public RestResponse<WarehouseRespDto> queryWarehouseBaseById(@NotNull(message="\u4ed3\u5e93Id\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(value="id") @NotNull(message="\u4ed3\u5e93Id\u4e0d\u80fd\u4e3a\u7a7a") Long var1);

    @GetMapping(value={"/code/{code}"})
    @ApiOperation(value="\u6839\u636ecode\u67e5\u8be2\u4ed3\u5e93\u8be6\u60c5", notes="\u6839\u636ecode\u67e5\u8be2\u4ed3\u5e93\u8be6\u60c5 \t\n code:\u4ed3\u5e93code\t\n filter {\"instanceId\":0,\"tenantId\":1}")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u4ed3\u5e93\u7f16\u7801code", dataType="String", paramType="path", required=true), @ApiImplicitParam(name="filter", value="{\"instanceId\":0,\"tenantId\":1}", dataType="String", paramType="query")})
    public RestResponse<WarehouseRespDto> queryWarehouseByCode(@NotBlank(message="\u4ed3\u5e93code\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(value="code") @NotBlank(message="\u4ed3\u5e93code\u4e0d\u80fd\u4e3a\u7a7a") String var1, @RequestParam(name="filter", required=false) String var2);

    @GetMapping(value={"/page"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u4ed3\u5e93\u5206\u9875\u5217\u8868", notes="\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u4ed3\u5e93\u5206\u9875\u5217\u8868 \t\n filter:WarehouseQueryReqDto \t\n {\n  \"id\":0,\n  \"code\": \"string\",\n  \"name\": \"string\",\n  \"status\": \"string\",\n  \"type\": \"string\"\n  \"addr\": \"string\",\n  \"areaCode\": \"string\",\n  \"cityCode\": \"string\",\n  \"provCode\": \"string\",\n  \"groupId\": 0,\n  \"instanceId\": 0,\n  \"tenantId\": 0,\n}")
    public RestResponse<PageInfo<WarehouseRespDto>> queryWarehouseByPage(@RequestParam(name="filter", required=false) String var1, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer var2, @Max(value=100L, message="\u6700\u5927\u503c\u4e0d\u80fd\u8d85\u8fc7100") @RequestParam(name="pageSize", required=false, defaultValue="10") @Max(value=100L, message="\u6700\u5927\u503c\u4e0d\u80fd\u8d85\u8fc7100") Integer var3);

    @GetMapping(value={"/group-id/{groupId}/list"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u5206\u7ec4id\u67e5\u8be2\u4ed3\u5e93\u5217\u8868", notes="\u6839\u636e\u5206\u7ec4id\u67e5\u8be2\u4ed3\u5e93\u5217\u8868 \t\n groupId:\u5206\u7ec4id \t\n filter {\"instanceId\":0,\"tenantId\":1}")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", value="\u5206\u7ec4id", dataType="Long", paramType="path", required=true), @ApiImplicitParam(name="filter", value="{\"instanceId\":0,\"tenantId\":1}", dataType="String", paramType="query")})
    public RestResponse<List<WarehouseRespDto>> queryWarehouseByGroupId(@NotNull(message="\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(value="groupId") @NotNull(message="\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a") Long var1, @RequestParam(name="filter") String var2);

    @GetMapping(value={"/position/{id}"})
    @ApiOperation(value="\u6839\u636e\u4ed3\u4f4did\u67e5\u8be2\u4ed3\u4f4d\u4fe1\u606f", notes="\u6839\u636e\u4ed3\u4f4did\u67e5\u8be2\u4ed3\u4f4d\u4fe1\u606f id:\u4ed3\u4f4did \t\n filter {\"instanceId\":0,\"tenantId\":1}")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4ed3\u5e93id", dataType="Long", paramType="path", required=true), @ApiImplicitParam(name="filter", value="{\"instanceId\":0,\"tenantId\":1}", dataType="String", paramType="query")})
    public RestResponse<PositionQueryRespDto> queryPositionById(@NotNull(message="\u4ed3\u4f4did\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(value="id") @NotNull(message="\u4ed3\u4f4did\u4e0d\u80fd\u4e3a\u7a7a") Long var1, @RequestParam(name="filter") String var2);

    @GetMapping(value={"/position/code/{code}"})
    @ApiOperation(value="\u6839\u636e\u4ed3\u4f4d\u7f16\u7801\u67e5\u8be2\u4ed3\u4f4d\u4fe1\u606f", notes="\u6839\u636e\u4ed3\u4f4d\u7f16\u7801\u67e5\u8be2\u4ed3\u4f4d\u4fe1\u606f code:\u4ed3\u4f4d\u7f16\u7801 \t\n groupId:\u5206\u7ec4id \t\n filter {\"instanceId\":0,\"tenantId\":1}")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u4ed3\u5e93\u7f16\u7801code", dataType="String", paramType="path", required=true), @ApiImplicitParam(name="filter", value="{\"instanceId\":0,\"tenantId\":1}", dataType="String", paramType="query")})
    public RestResponse<PositionQueryRespDto> queryPositionByCode(@NotNull(message="\u4ed3\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(value="code") @NotNull(message="\u4ed3\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String var1, @RequestParam(name="filter") String var2);

    @GetMapping(value={"/position/list"})
    @ApiOperation(value="\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u4ed3\u4f4d\u5217\u8868", notes="\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u4ed3\u4f4d\u5217\u8868{\n    \"code\": 0,\n    \"name\": \"string\",\n    \"type\": 0,\n    \"instanceId\": 0,\n    \"tenantId\": 0\n}")
    public RestResponse<List<PositionQueryRespDto>> queryPositionByList(@RequestParam(value="filter") String var1);

    @GetMapping(value={"/position/page"})
    @ApiOperation(value="\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u7b26\u5408\u6761\u4ef6\u7684\u4ed3\u4f4d\u5206\u9875\u5217\u8868", notes="\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u7b26\u5408\u6761\u4ef6\u7684\u4ed3\u4f4d\u5206\u9875\u5217\u8868 \t\n filter:\u4ed3\u4f4d\u67e5\u8be2\u6761\u4ef6 {\n    \"code\": 0,\n    \"name\": \"string\",\n    \"warehouseId\": \"0\",\n    \"type\": 0,\n    \"instanceId\": 0,\n    \"tenantId\": 0\n}\t\n pageNum:\u6307\u5b9a\u9875\u7801 \t\n pageSize:\u9875\u5927\u5c0f")
    public RestResponse<PageInfo<PositionQueryRespDto>> queryPositionByPage(@RequestParam(value="filter") String var1, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer var2, @Max(value=100L, message="\u6700\u5927\u503c\u4e0d\u80fd\u8d85\u8fc7100") @RequestParam(name="pageSize", required=false, defaultValue="10") @Max(value=100L, message="\u6700\u5927\u503c\u4e0d\u80fd\u8d85\u8fc7100") Integer var3);

    @GetMapping(value={"/service-area/{id}"})
    @ApiOperation(value="\u6839\u636e\u670d\u52a1\u533aID\u67e5\u8be2", notes="\u6839\u636e\u670d\u52a1\u533aID\u67e5\u8be2 id:\u670d\u52a1\u533aid \t\n groupId:\u5206\u7ec4id \t\n filter {\"instanceId\":0,\"tenantId\":1}")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u670d\u52a1\u533aid", dataType="Long", paramType="path", required=true), @ApiImplicitParam(name="filter", value="{\"instanceId\":0,\"tenantId\":1}", dataType="String", paramType="query")})
    public RestResponse<ServiceAreaRespDto> queryServiceAreaById(@NotNull(message="\u670d\u52a1\u533aid\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(value="id") @NotNull(message="\u670d\u52a1\u533aid\u4e0d\u80fd\u4e3a\u7a7a") Long var1, @RequestParam(value="filter") String var2);

    @GetMapping(value={"/service-area/page"})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u533a\u5206\u9875\u5217\u8868", notes="\u83b7\u53d6\u670d\u52a1\u533a\u5206\u9875\u5217\u8868 \t\n filter:\u670d\u52a1\u533a\u67e5\u8be2\u6761\u4ef6\u5c01\u88c5\u5bf9\u8c61JSON {\n    \"code\": 0,\n    \"name\": \"string\",\n    \"groupId\": 0,\n    \"instanceId\": 0,\n    \"tenantId\": 0\n}\t\n pageNum:\u6307\u5b9a\u9875\u7801 \t\n pageSize:\u6307\u5b9a\u6bcf\u9875\u8fd4\u56de\u7684\u5bf9\u8c61\u4e2a\u6570")
    public RestResponse<PageInfo<ServiceAreaRespDto>> queryServiceAreaByPage(@RequestParam(value="filter") String var1, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer var2, @Max(value=100L, message="\u6700\u5927\u503c\u4e0d\u80fd\u8d85\u8fc7100") @RequestParam(name="pageSize", required=false, defaultValue="10") @Max(value=100L, message="\u6700\u5927\u503c\u4e0d\u80fd\u8d85\u8fc7100") Integer var3);

    @GetMapping(value={"/warehousePage"})
    @ApiOperation(value="\u67e5\u8be2\u4ed3\u5e93\u5217\u8868", notes="\u67e5\u8be2\u4ed3\u5e93\u5217\u8868")
    public RestResponse<PageInfo<WarehouseRespDto>> queryWarehousePage(@ModelAttribute WarehouseQueryReqDto var1, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer var2, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer var3);

    @PostMapping(value={"/queryByLogAndLat"})
    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u7ecf\u7eac\u5ea6\u6309\u8ddd\u79bb\u8fd4\u56de\u4ed3\u5e93\u5217\u8868", notes="\u6839\u636e\u5f53\u524d\u7ecf\u7eac\u5ea6\u6309\u8ddd\u79bb\u8fd4\u56de\u4ed3\u5e93\u5217\u8868")
    public RestResponse<PageInfo<WarehouseRespDto>> queryByLogAndLat(@RequestBody WarehouseCoordinateQueryReqDto var1);

    @GetMapping(value={"/{warehouseId}/delivery"})
    @ApiOperation(value="\u67e5\u8be2\u4ed3\u5e93\u914d\u9001\u65b9\u5217\u8868", notes="\u67e5\u8be2\u4ed3\u5e93\u914d\u9001\u65b9\u5217\u8868")
    public RestResponse<List<WarehouseDeliveryQueryRespDto>> queryWarehouseDeliveryList(@PathVariable(value="warehouseId") Long var1);

    @GetMapping(value={"/type"})
    @ApiOperation(value="\u67e5\u8be2\u4ed3\u5e93\u7c7b\u578b", notes="\u67e5\u8be2\u4ed3\u5e93\u7c7b\u578b")
    public RestResponse<List<WarehouseTypeDto>> queryWarehouseType(@RequestParam(value="parentCode", required=false) Integer var1);
}

