package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 *
 * 生成编码策略枚举类
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/12/30 3:35 下午
 */
public enum CsGenerateCodeStrategyEnum {

    /** 通用编码，不带任何规则的 **/
    COMMON("Common","通用编码"),

    /** 发货通知单 **/
    DELIVERY_NOTICE_ORDER("DeliveryNoticeOrder","发货通知单"),

    /** 出库通知单 **/
    OUT_NOTICE_ORDER("OutNoticeOrder","出库通知单"),

    /** 出库结果单 **/
    OUT_RESULT_ORDER("OutResultOrder","出库结果单"),

    /** 发货结果单 **/
    DELIVERY_RESULT_ORDE("DeliveryResultOrde","发货结果单"),

    /** 收货通知单 **/
    RECEIVE_NOTICE_ORDER("ReceiveNoticeOrder","收货通知单"),

    /** 入库通知单 **/
    IN_NOTICE_ORDER("InNoticeOrder","入库通知单"),

    /** 入库结果单 **/
    IN_RESULT_ORDER("InResultOrder","入库结果单"),

    /** 收货结果单 **/
    RECEIVE_RESULT_ORDER("ReceiveResultOrder","收货结果单"),

    /** 物理仓 **/
    PHYSICS_WAREHOUSE("PhysicsWarehouse","物理仓"),

    /** 物理仓 **/
    LOGIC_WAREHOUSE("LogicWarehouse","物理仓"),

    /** 虚拟仓 **/
    VIRTUAL_WAREHOUSE("VirtualWarehouse","虚拟仓"),

    /** 渠道仓 **/
    CHANNEL_WAREHOUSE("ChannelWarehouse","渠道仓"),

    ;

    /** 编码 **/
    private String code;

    /** 描述 **/
    private String desc;

    CsGenerateCodeStrategyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsGenerateCodeStrategyEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsGenerateCodeStrategyEnum.values()).stream().filter(eo->code.equals(eo.getCode())).findAny().orElse(null);
    }

}
