/**
 * @(#)CsReceiveResultOrderApi.java 1.0 2021/12/29 11:16
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjReCheckReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;

/**
* CsReceiveResultOrderApi
*
* @author jingran
* @Date: 2021/12/29 11:16
* @since 1.0.0
*/
@Api(tags = {"CsReceiveResultOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csReceiveResultOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsReceiveResultOrderApi {

    /**
     * 添加
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "/add", produces = "application/json")
    @ApiOperation(value = "添加", notes = "添加")
    RestResponse<Long> add(@Validated @RequestBody CsReceiveResultOrderAddReqDto addReqDto);

    /**
     * 修改
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsReceiveResultOrderUpdateReqDto updateReqDto);

    /**
     * 删除
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    /**
     * 复核入库，生成收货结果单
     * 复核入库时，需要操作的是，在页面上选择的那些允许进行入库操作的货品
     *
     * @param reCheckReqDto  请求参数
     */
    @PostMapping(value = "/reCheckInInventory",produces = "application/json")
    @ApiOperation(value = "复核入库，生成收货结果单",notes = "复核入库，生成收货结果单")
    RestResponse<Void> reCheckInInventory(@RequestBody TcbjReCheckReqDto reCheckReqDto);

}