package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyRelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.BizImportRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyRelRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 客户仓库配置表服务接口
*
* @author Ghosn
* @since 2024-10-31
*/
@Api(tags = {"客户仓库配置表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-IWarehouseSupplyRelApi",
    name = "${yundt.cube.center.inventory.api.name:ty-cube-center-inventory}",
    path = "/v1/warehouse/supply",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface IWarehouseSupplyRelApi {

    /**
    * 新增客户仓库配置表
    *
    * @param addReqDto 客户仓库配置表请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增客户仓库配置表", notes = "新增客户仓库配置表")
    RestResponse<Long> addWarehouseSupplyRel(@RequestBody WarehouseSupplyRelReqDto addReqDto);

    /**
    * 修改客户仓库配置表
    *
    * @param modifyReqDto 客户仓库配置表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改客户仓库配置表", notes = "修改客户仓库配置表")
    RestResponse<Void> modifyWarehouseSupplyRel(@RequestBody WarehouseSupplyRelReqDto modifyReqDto);

    /**
    * 删除客户仓库配置表
    *
    * @param ids        客户仓库配置表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除客户仓库配置表", notes = "删除客户仓库配置表")
    RestResponse<Void> removeWarehouseSupplyRel(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);

    /**
     * 数据导入解析写入
     * @param addReqDto
     * @return
     */
    @PostMapping("")
    RestResponse<BizImportRespDto> importWarehouseSupplyRel(@RequestBody BizImportRespDto addReqDto);
}
