package com.dtyunxi.yundt.cube.center.inventory.api.warehouse;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.warehouse.ItemInventoryQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.warehouse.TcbjWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.warehouse.TcbjWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author shuidi
 */
@Api(tags = {"warehouse接口"})
@FeignClient(name = "${yundt.cube.center.warehouse.api.name:ty-cube-center-warehouse}", path = "/v1/warehouse", url = "${yundt.cube.center.warehouse.api:}")
public interface ITcbjWarehouseApi {
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "前端 分页查询仓库", notes = "分页查询")
    RestResponse<PageInfo<TcbjWarehouseRespDto>> notiPage(@Validated @RequestBody TcbjWarehouseReqDto queryDto);

    @PostMapping(value = "/detail", produces = "application/json")
    @ApiOperation(value = "前端 仓库详情", notes = "仓库详情")
    RestResponse<TcbjWarehouseRespDto> detail(@Validated @RequestBody String code);


}
