/**
 * @(#)CsOutNoticeOrderApi.java 1.0 2021/12/29 11:12
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * CsOutNoticeOrderApi
 *
 * @author jingran
 * @Date: 2021/12/29 11:12
 * @since 1.0.0
 */
@Api(tags = {"CsOutNoticeOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csOutNoticeOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsOutNoticeOrderApi {

    /**
     * 添加
     *
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "添加", notes = "添加")
    RestResponse<Long> add(@Validated @RequestBody CsOutNoticeOrderAddReqDto addReqDto);

    /**
     * 修改
     *
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsOutNoticeOrderUpdateReqDto updateReqDto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    /**
     * 根据发货通知单号，创建出库通知单
     *
     * @param relevanceNo 发货通知单号
     * @return 出库通知单id
     */
    @GetMapping(value = "/createOutNoticeOrder", produces = "application/json")
    @ApiOperation(value = "根据发货通知单号，创建出库通知单", notes = "根据发货通知单号，创建出库通知单")
    RestResponse<Long> createOutNoticeOrder(@RequestParam("relevanceNo") String relevanceNo);

}