package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 库存基础查询DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/14 3:32 下午
 */
@ApiModel(value = "CsInventoryBasicsQueryReqDto", description = "库存基础查询DTO")
public class CsInventoryBasicsQueryReqDto implements Serializable {

    /**
     * 查询库存策略选择   com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum
     */
    @ApiModelProperty(name = "inventoryStrategy", value = "查询库存策略选择,com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum")
    private String inventoryStrategy;

    /**
     * 库存编码集合查询
     */
    @ApiModelProperty(name = "warehouseCodeList", value = "库存编码集合查询")
    private List<String> warehouseCodeList;

    /**
     * 货品编码集合查询
     */
    @ApiModelProperty(name = "cargoCodeList", value = "货品编码集合查询")
    private List<String> cargoCodeList;

    /**
     * 批次集合查询
     */
    @ApiModelProperty(name = "batchList", value = "批次集合查询")
    private List<String> batchList;

    public String getInventoryStrategy() {
        return inventoryStrategy;
    }

    public void setInventoryStrategy(String inventoryStrategy) {
        this.inventoryStrategy = inventoryStrategy;
    }

    public List<String> getWarehouseCodeList() {
        return warehouseCodeList;
    }

    public void setWarehouseCodeList(List<String> warehouseCodeList) {
        this.warehouseCodeList = warehouseCodeList;
    }

    public List<String> getCargoCodeList() {
        return cargoCodeList;
    }

    public void setCargoCodeList(List<String> cargoCodeList) {
        this.cargoCodeList = cargoCodeList;
    }

    public List<String> getBatchList() {
        return batchList;
    }

    public void setBatchList(List<String> batchList) {
        this.batchList = batchList;
    }

}
