package com.dtyunxi.yundt.cube.center.inventory.anno.cs.inventory;

import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import org.springframework.stereotype.Component;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 库存类型特殊处理，打上该注解的类并且实现了
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/13 5:55 下午
 */
@Component
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface CsInventorySourceTypeHandler {
    /**
     * 库存类型枚举
     **/
    CsInventorySourceTypeEnum[] sourceType();

    /**
     * 优先级，可以自定义优先级 0-9  0是优先级最高，最先执行，默认是5
     **/
    int priority() default 5;

    /**
     * 是否生效，true：生效(默认)      false：失效
     **/
    boolean effect() default true;
}
