package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author shuidi
 */
@ApiModel(value = "TcbjCompareReqDto", description = "返回信息Dto")
@Data
public class TcbjCompareReqDto {

    @ApiModelProperty(name = "pddNo")
    private String pddNo;

    @ApiModelProperty(name = "id", value = "唯一码")
    private String id;

    @ApiModelProperty(name = "tenantId", value = "营销云租户id")
    private String tenantId;

    @ApiModelProperty(name = "cargos")
    private List<TcbjCompareReqItemDto> cargos;





    @Data
    public static class TcbjCompareReqItemDto {
        /**
         * 商品编码
         */
        @ApiModelProperty(name = "cargoCode", value = "商品编码")
        private String cargoCode;
        /**
         * 仓库编码
         */
        @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
        private String warehouseCode;
        /**
         * 批次
         */
        @ApiModelProperty(name = "batch", value = "批次")
        private String batch;

        @ApiModelProperty(name = "beforeNum", value = "盘点前")
        private Integer beforeNum;

        @ApiModelProperty(name = "afterNum", value = "盘点后")
        private Integer afterNum;

        @ApiModelProperty(name = "productDate", value = "生产日期")
        private Date productDate;

        @ApiModelProperty(name = "expireDate", value = "过期日期")
        private Date expireDate;
    }
}
