/**
 * @(#)CsWarehouseAddressQueryDto.java 1.0 2022/01/10 11:31
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
* @Description CsWarehouseAddressQueryDto
*
* @author jingran
* @Date: 2022/01/10 11:31
* @since 1.0.0
*/
@ApiModel(value = "csWarehouseAddressQueryDto", description = "查询Dto")
public class CsWarehouseAddressQueryDto implements Serializable {

    /** 仓库ID */
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 发货仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "发货仓库名称")
    private String warehouseName;
    /** 仓库分类,physics-物理仓,logic-逻辑仓 */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类,physics-物理仓,logic-逻辑仓")
    private String warehouseClassify;
    /** 是否有效 enable-有效 disable-无效 */
    @ApiModelProperty(name="validFlag",value = "是否有效 enable-有效 disable-无效")
    private String validFlag;
    /** 国家编码 */
    @ApiModelProperty(name="countryCode",value = "国家编码")
    private String countryCode;
    /** 省份编码 */
    @ApiModelProperty(name="provinceCode",value = "省份编码")
    private String provinceCode;
    /** 城市编码 */
    @ApiModelProperty(name="cityCode",value = "城市编码")
    private String cityCode;
    /** 区县编码 */
    @ApiModelProperty(name="districtCode",value = "区县编码")
    private String districtCode;
    /** 详细地址 */
    @ApiModelProperty(name="detailAddress",value = "详细地址")
    private String detailAddress;
    /** 联系人 */
    @ApiModelProperty(name="contacts",value = "联系人")
    private String contacts;
    /** 联系电话 */
    @ApiModelProperty(name="phone",value = "联系电话")
    private String phone;
    /** 邮政编码 */
    @ApiModelProperty(name="postalCode",value = "邮政编码")
    private String postalCode;
    /** 经度 */
    @ApiModelProperty(name="longitude",value = "经度")
    private String longitude;
    /** 纬度 */
    @ApiModelProperty(name="latitude",value = "纬度")
    private String latitude;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照create_time降序")
    private String orderByDesc = "create_time";

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public String getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(String validFlag) {
        this.validFlag = validFlag;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getDistrictCode() {
        return districtCode;
    }

    public void setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
    }

    public String getDetailAddress() {
        return detailAddress;
    }

    public void setDetailAddress(String detailAddress) {
        this.detailAddress = detailAddress;
    }

    public String getContacts() {
        return contacts;
    }

    public void setContacts(String contacts) {
        this.contacts = contacts;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }
}