package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author shuidi
 */
@ApiModel(value = "tcbjInventoryLogRespDto", description = "返回信息Dto")
@Data
public class TcbjInventoryLogRespDto {
    /**
     * 商品编码
     */
    @ApiModelProperty(name = "code", value = "商品编码")
    private String code;
    /**
     * 商品名称
     */
    @ApiModelProperty(name = "name", value = "商品名称")
    private String name;
    /**
     * 商品货号
     */
    @ApiModelProperty(name = "artNo", value = "商品货号")
    private String artNo;
    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")//new
    private String batch;

    /**
     * 库存类型
     */
    @ApiModelProperty(name = "type", value = "库存类型")
    private String type;
    /**
     * 库存变动前
     */
    @ApiModelProperty(name = "oldNum", value = "库存变动前")
    private String oldNum;
    /**
     * 库存变动数
     */
    @ApiModelProperty(name = "changeNum", value = "库存变动数")
    private Double changeNum;
    /**
     * 库存变动后
     */
    @ApiModelProperty(name = "newNum", value = "库存变动后")
    private Double newNum;
    /**
     * 业务单据类型 销售、调拨、退货
     */
    @ApiModelProperty(name = "orderType", value = "业务单据类型")//new
    private Double orderType;
    /**
     * 前置单据号
     */
    @ApiModelProperty(name = "relevanceNo", value = "前置单据号")
    private String relevanceNo;
    /**
     * 变动时间
     */
    @ApiModelProperty(name = "updateTime", value = "变动时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String updateTime;
}
