package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.OptionLogRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
* 接口操作表服务接口
*
* @author songjiang.zxj
* @since 2021-10-21
*/
@Api(tags = {"接口操作表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-IOptionLogQueryApi",
    name = "${yundt.cube.center.inventory.api.name:ty-cube-center-inventory}",
    path = "/v1/inventory/log",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface IOptionLogQueryApi {

    /**
    * 根据id查询接口操作表
    *
    * @param id 接口操作表id
    * @return   接口操作表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询接口操作表", notes = "根据id查询接口操作表")
    RestResponse<OptionLogRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 接口操作表分页数据
    *
    * @param filter   接口操作表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 接口操作表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "接口操作表分页数据", notes = "根据filter查询条件查询接口操作表数据，filter=OptionLogReqDto")
    RestResponse<PageInfo<OptionLogRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
