package com.dtyunxi.yundt.cube.center.inventory.dto.inventory;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * 发送 发货/收货通知单 MQ订单明细消息Dto
 */
@Data
public class MqContentOrderDetailDto {

    /**
     * 产品长编号
     */
    private String easNo;

    /**
     * 审核数量
     */
    private Integer actQuantity;

    /**
     * 下单数量
     */
    private Integer quantity;

    /**
     * 备注
     */
    private String remark;

    /**
     * 批次
     */
    private String batchNum;

    /**
     * 价格（不含税单价）
     */
    private Double price;

    /**
     * 不含税总价
     */
    private Double money;

    /**
     * 含税单价
     */
    private Double actPrice;

    /**
     * 自定义json串，格式：[{“key1”:”val1”},{“key2”:”val2”}],每个对象里面都是string
     */
    @JSONField(name = "OtherField1")
    private String otherField1;
}
