package com.dtyunxi.yundt.cube.center.inventory.api.order.delivery;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.SimpleRequestDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjNotiGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.TcbjResDetailCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjProOccupyRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.req.TcbjAdjustAuReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.req.TcbjDeliveryAuReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.req.TcbjDeliveryNotiReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.req.TcbjDeliveryResReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.resp.TcbjDeliveryNotiDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.resp.TcbjDeliveryNotiRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.resp.TcbjDeliveryResDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.resp.TcbjDeliveryResRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.third.ThirdContent;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @author shuidi
 */
@Api(tags = {"发货单接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name:ty-cube-center-inventory}", path = "/v1/order-delivery", url = "${yundt.cube.center.inventory.api:}")
public interface ITcbjDeliveryApi {

    @PostMapping(value = "gen", produces = "application/json")
    @ApiOperation(value = "old发货单", notes = "old发货单")
    RestResponse<String> gen(@Validated @RequestBody ThirdContent thirdContent);

    @PostMapping(value = "/noti-page", produces = "application/json")
    @ApiOperation(value = "前端 分页发货通知单查询", notes = "分页发货通知单查询")
    RestResponse<PageInfo<TcbjDeliveryNotiRespDto>> notiPage(@Validated @RequestBody TcbjDeliveryNotiReqDto queryDto);

    @PostMapping(value = "/updateExpress", produces = "application/json")
    @ApiOperation(value = "前端 更新发货结果单物流", notes = "更新发货结果单")
    RestResponse<String> update(@Validated @RequestBody TcbjDeliveryNotiReqDto queryDto);

    @PostMapping(value = "/noti-detail", produces = "application/json")
    @ApiOperation(value = "前端 发货通知单详细", notes = "发货通知单详细")
    RestResponse<TcbjDeliveryNotiDetailRespDto> notiDetail(@Validated @RequestBody SimpleRequestDto dto);

    @PostMapping(value = "/res-page", produces = "application/json")
    @ApiOperation(value = "前端 分页发货结果单查询", notes = "分页发货结果单查询")
    RestResponse<PageInfo<TcbjDeliveryResRespDto>> resPage(@Validated @RequestBody TcbjDeliveryResReqDto queryDto);

    @PostMapping(value = "/res-detail", produces = "application/json")
    @ApiOperation(value = "前端 发货结果单详细", notes = "发货结果单详细")
    RestResponse<TcbjDeliveryResDetailRespDto> resDetail(@RequestBody SimpleRequestDto dto);

    @PostMapping(value = "/queryDetailByPreNo", produces = "application/json")
    @ApiOperation(value = "根据前置业务单据查询发货结果详情", notes = "根据前置业务单据查询发货结果详情")
    RestResponse<TcbjDeliveryResDetailRespDto> queryDetailByPreNo(@RequestBody SimpleRequestDto dto);


    @PostMapping(value = "send", produces = "application/json")
    @ApiOperation(value = "订单中心 发货;生成发货通知单", notes = "发货")
    RestResponse<String> send(@Validated @RequestBody TcbjNotiGenReqDto reqDto);

    @PostMapping(value = "sendback", produces = "application/json")
    @ApiOperation(value = "营销云 发货回传;生成发货结果单", notes = "发货回传")
    RestResponse<String> sendback(@Validated @RequestBody TcbjResGenReqDto reqDto);

    @PostMapping(value = "cancel", produces = "application/json")
    @ApiOperation(value = "订单中心 取消发货通知单", notes = "取消发货通知单")
    RestResponse<String> cancel(@Validated @RequestBody SimpleRequestDto dto);

    @PostMapping(value = "/outNum", produces = "application/json")
    @ApiOperation(value = "订单中心 出库数", notes = "出库数")
    RestResponse<List<TcbjResDetailCargoRespDto>> outNum(@Validated @RequestBody SimpleRequestDto dto);

    @PostMapping(value = "/audit", produces = "application/json")
    @ApiOperation(value = "订单中心 审核发货通知单", notes = "审核发货通知单")
    RestResponse<String> audit(@Validated @RequestBody TcbjDeliveryAuReqDto dto);

    @PostMapping(value = "/exportExcel", produces = "application/json")
    @ApiOperation(value = "前端 发货结果单导出", notes = "发货结果单导出")
    RestResponse<Object> exportExcel(@Validated @RequestBody TcbjDeliveryResReqDto queryDto);


    @PostMapping(value = "/importExcel")
    @ApiOperation(value = "前端 导入发货结果单", notes = "导入发货结果单")
    RestResponse<Object> importExcel(@RequestParam("file") MultipartFile serviceFile) throws Exception;

    @GetMapping(value = "/testUpdateReturns")
    @ApiOperation(value = "测试更新退货额度", notes = "测试更新退货额度")
    RestResponse<Void> testUpdateReturns(String orderNo);

}
