package com.dtyunxi.yundt.cube.center.inventory.dto.warehouse;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * @author shuidi
 * @Description TyWarehouseRespDto
 * @Date: 2020/01/03 17:20
 * @since 1.0.0
 */
@ApiModel(value = "tcbjWarehouseRespDto", description = "返回信息Dto")
@Data
public class TcbjWarehouseRespDto {

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "code", value = "仓库编码")
    private String code;
    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "name", value = "仓库名称")
    private String name;
    /**
     * 仓库归属
     */
    @ApiModelProperty(name = "belong", value = "仓库归属")
    private String belong;
    /**
     * 详细地址
     */
    @ApiModelProperty(name = "addr", value = "详细地址")
    private String addr;
    /**
     * 仓库类型
     */
    @ApiModelProperty(name = "type", value = "仓库类型")
    private String type;

    private String strType;
    public String getStrType() {
        switch (type) {
            case "101":
                return "产品仓";
            case "102":
                return "退货仓";
            case "103":
                return "其他仓";
            default:
                return "--";
        }
    }

    @ApiModelProperty(name = "isdefault", value = "是否默认,0非默认,1默认")
    private Integer isdefault;

    @ApiModelProperty(name = "status", value = "仓库启用状态,0启用,1禁用")
    private String status;
}
