package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class GetSubWarehouseReqDto {

    @NotNull(message = "客户id不能为空")
    @ApiModelProperty(notes = "客户id")
    private Long customerId;

    @NotNull(message = "机构id不能为空")
    @ApiModelProperty(notes = "机构id")
    private Long organizationId;

    @NotBlank(message = "仓库类型不能为空")
    @ApiModelProperty(notes = "仓库类型 0产品仓 1退货仓")
    private String warehouseType;

}
