package com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.resp;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author songjiang.zxj
 * @Description TcbjDeliveryExcelRespDto
 * @Date: 2021/10/10 10:25
 */
@ApiModel(value = "tcbjDeliveryExcelRespDto", description = "发货结果单导出Dto")
@Data
public class TcbjDeliveryExcelRespDto  {

    /**
     * 结果单据号
     */
    @Excel(name = "发货结果单号")
    @ApiModelProperty(name = "resNo", value = "结果单据号")
    private String resNo;
    /**
     * 业务类型 查询
     */
    @Excel(name = "业务类型")
    @ApiModelProperty(name = "type", value = "业务类型")
    private String type;

    /**
     * 状态
     */
    @Excel(name = "状态")
    @ApiModelProperty(name = "status", value = "状态")
    private String status;
    /**
     * 商品数量
     */
    @Excel(name = "商品数量")
    @ApiModelProperty(name = "num", value = "商品数量")
    private String num;
    /**
     * 前置业务单据
     */
    @Excel(name = "前置业务单据")
    @ApiModelProperty(name = "preNo", value = "前置业务单据")
    private String preNo;
    /**
     * 发货仓编码
     */
    @Excel(name = "发货仓编码")
    @ApiModelProperty(name = "warehouseCode", value = "发货仓编码")
    private String warehouseCode;

    /**
     * 发货仓名称
     */
    @Excel(name = "发货仓名称")
    @ApiModelProperty(name = "warehouseName", value = "发货仓名称")
    private String warehouseName;

    /**
     * 物流公司
     */
    @Excel(name = "物流公司")
    @ApiModelProperty(name = "expressCo", value = "物流公司")
    private String expressCo;

    /**
     * 物流单号 是否查询
     */
    @Excel(name = "物流单号")
    @ApiModelProperty(name = "expressNo", value = "物流单号")
    private String expressNo;

    /**
     * 创建时间
     */

    @Excel(name = "创建时间",exportFormat="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;


}
