/**
 * @(#)CsPhysicsWarehouseQueryDto.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse;

import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 物理仓分页查询请求DTO
 *
 * @author jingran
 * @Description CsPhysicsWarehouseQueryDto
 * @Date: 2021/12/29 11:15
 * @since 1.0.0
 */
@ApiModel(value = "csPhysicsWarehouseQueryDto", description = "物理仓分页查询请求DTO")
public class CsPhysicsWarehousePageQueryDto extends BasePageDto implements Serializable {

    /**
     * 仓库编码
     **/
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     **/
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 仓库状态 initial-初始,enable-有效,disable-无效
     **/
    @ApiModelProperty(name = "warehouseStatus", value = "仓库状态 initial-初始,enable-有效,disable-无效")
    private String warehouseStatus;
    /**
     * 是否RDC 0-否 1-是，只有珠海不是rdc，待确认是否有业务使用
     **/
    @ApiModelProperty(name = "rdcFlag", value = "是否RDC 0-否 1-是，只有珠海不是rdc，待确认是否有业务使用")
    private String rdcFlag;

    /**
     * eas仓库编码
     **/
    @ApiModelProperty(name = "easWarehouseCode", value = "eas仓库编码")
    private String easWarehouseCode;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseStatus() {
        return warehouseStatus;
    }

    public void setWarehouseStatus(String warehouseStatus) {
        this.warehouseStatus = warehouseStatus;
    }

    public String getRdcFlag() {
        return rdcFlag;
    }

    public void setRdcFlag(String rdcFlag) {
        this.rdcFlag = rdcFlag;
    }

    public String getEasWarehouseCode() {
        return easWarehouseCode;
    }

    public void setEasWarehouseCode(String easWarehouseCode) {
        this.easWarehouseCode = easWarehouseCode;
    }
}