package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

/**
* 客户仓库配置表Eo对象
*
* @author Ghosn
* @since 2024-10-31
*/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "WarehouseSupplyRelReqDto", description = "客户仓库配置表Eo对象")
public class WarehouseSupplyRelReqDto extends RequestDto{
    /**
    *  主键ID
    */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;

    /**
     *  仓库编码
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    /**
     *  仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "是否主仓库")
    private Integer mainWarehouse;

    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  组织code
    */
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;
    /**
    *  所属组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "所属组织名称")
    private String organizationName;
    /**
    *  关系状态
    */
    @ApiModelProperty(name = "status", value = "关系状态")
    private Integer status;
    /**
    *  客户ID
    */
    @ApiModelProperty(name = "customerId", value = "客户ID")
    private Long customerId;
    /**
     *  客户ID
     */
    @ApiModelProperty(name = "customerIds", value = "客户ID")
    private List<Long> customerIds;

    /**
    *  客户编码
    */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;

    /**
     *  仓库编码
     */
    @ApiModelProperty(name = "warehouseCodeList", value = "仓库编码")
    private List<String> warehouseCodeList;

    /**
     *  组织ID
     */
    @ApiModelProperty(name = "organizationIdList", value = "组织ID")
    private List<Long> organizationIdList;

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationCode(String organizationCode){
    this.organizationCode = organizationCode;
    }
    public String getOrganizationCode(){
    return this.organizationCode;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }
    public void setStatus(Integer status){
    this.status = status;
    }
    public Integer getStatus(){
    return this.status;
    }
    public void setCustomerId(Long customerId){
    this.customerId = customerId;
    }
    public Long getCustomerId(){
    return this.customerId;
    }
    public void setCustomerCode(String customerCode){
    this.customerCode = customerCode;
    }
    public String getCustomerCode(){
    return this.customerCode;
    }

    public List<String> getWarehouseCodeList() {
        return warehouseCodeList;
    }

    public void setWarehouseCodeList(List<String> warehouseCodeList) {
        this.warehouseCodeList = warehouseCodeList;
    }

    public Integer getMainWarehouse() {
        return mainWarehouse;
    }

    public void setMainWarehouse(Integer mainWarehouse) {
        this.mainWarehouse = mainWarehouse;
    }

    public List<Long> getCustomerIds() {
        return customerIds;
    }

    public void setCustomerIds(List<Long> customerIds) {
        this.customerIds = customerIds;
    }

    public List<Long> getOrganizationIdList() {
        return organizationIdList;
    }

    public void setOrganizationIdList(List<Long> organizationIdList) {
        this.organizationIdList = organizationIdList;
    }
}
