package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 库存初始化操作请求DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/18 2:21 下午
 */
@ApiModel(value = "csInventoryOperateReqDto",description = "库存初始化操作请求DTO")
public class CsInventoryInitOperateReqDto implements Serializable {
    /**
     * 仓库编码集合
     */
    @ApiModelProperty(name="warehouseCodeList",value = "仓库编码集合")
    private List<String> warehouseCodeList;

    /**
     * 货品明细
     */
    @ApiModelProperty(name="operateCargoReqDtoList",value = "货品明细")
    private List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList;

    public CsInventoryInitOperateReqDto() {
    }

    public List<CsInventoryOperateCargoReqDto> getOperateCargoReqDtoList() {
        return operateCargoReqDtoList;
    }

    public void setOperateCargoReqDtoList(List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList) {
        this.operateCargoReqDtoList = operateCargoReqDtoList;
    }

    public List<String> getWarehouseCodeList() {
        return warehouseCodeList;
    }

    public void setWarehouseCodeList(List<String> warehouseCodeList) {
        this.warehouseCodeList = warehouseCodeList;
    }
}
