package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InventorySubItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.InventorySubItemRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 礼盒子产品关联表服务接口
*
* @author ghosn
* @since 2023-08-15
*/
@Api(tags = {"礼盒子产品关联表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-IInventorySubItemApi",
    name = "yundt-cube-center-inventory",
    path = "/v1/subitem/rel",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface IInventorySubItemApi {

    /**
    * 新增礼盒子产品关联表
    *
    * @param addReqDto 礼盒子产品关联表请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增礼盒子产品关联表", notes = "新增礼盒子产品关联表")
    RestResponse<Long> addInventorySubItem(@RequestBody InventorySubItemReqDto addReqDto);

    /**
    * 修改礼盒子产品关联表
    *
    * @param modifyReqDto 礼盒子产品关联表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改礼盒子产品关联表", notes = "修改礼盒子产品关联表")
    RestResponse<Void> modifyInventorySubItem(@RequestBody InventorySubItemReqDto modifyReqDto);

    /**
    * 删除礼盒子产品关联表
    *
    * @param ids        礼盒子产品关联表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除礼盒子产品关联表", notes = "删除礼盒子产品关联表")
    RestResponse<Void> removeInventorySubItem(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
