package com.dtyunxi.yundt.cube.center.inventory.enums;

public enum CsDocumentActionEnum {
    CANCEL_PAY("cancelPay", "取消支付"),
    SUCCESS_PAY("successPay", "支付成功"),
    AUDIT_PASS("auditPass", "审核通过"),
    AUDIT_ADJUST("auditAdjust", "审核不通过"),
    OUTING("outing", "出库中"),
    SUCCESS_OUT("successOut", "出库成功"),
    CANCEL_OUT("cancelOut", "出库取消"),
    REVERSE_AUDIT("reverseAudit", "反审核"),
    REVERSE_AUDIT_PASS("reverseAuditPass", "复核通过"),
    REVERSE_AUDIT_REFUSE("reverseAuditRefuse", "复核不通过")
    ;

    CsDocumentActionEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private String code;
    private String desc;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(String code) {
        for (CsDocumentActionEnum value : CsDocumentActionEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return null;
    }
}
