/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.listener;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.MqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderDeliveryNoticeCloseEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInBackEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInNoticeCancelEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInNoticeGenEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutBackEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutNoticeCancelEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutNoticeGenEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderReceiveNoticeCloseEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BatchUpdateEvent;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class BaseOrderEventListener {
    private static final Logger log = LoggerFactory.getLogger(BaseOrderEventListener.class);
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    MqService mqService;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderOutBackEvent.class})
    public void outBack(BaseOrderOutBackEvent event) {
        event.execute(source -> {
            MessageVo messageVo = this.buildReceiveDeliveryResultMessageVo((ReceiveDeliveryResultOrderContext)source);
            this.mqService.publicSendResultDetailProcessor(messageVo);
            log.info("\u751f\u6210\u6536\u53d1\u8d27\u7ed3\u679c\u5355,\u5e7f\u64ad\u7ed3\u679c:{}", (Object)LogUtils.buildLogContent(messageVo));
        });
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderInBackEvent.class})
    public void inBack(BaseOrderInBackEvent event) {
        event.execute(source -> {
            MessageVo messageVo = this.buildReceiveDeliveryResultMessageVo((ReceiveDeliveryResultOrderContext)source);
            this.mqService.publicSendResultDetailDelayProcessor(messageVo);
            log.info("\u751f\u6210\u6536\u53d1\u8d27\u7ed3\u679c\u5355,\u5ef6\u65f6\u5e7f\u64ad\u7ed3\u679c:{}", (Object)LogUtils.buildLogContent(messageVo));
        });
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderInNoticeCancelEvent.class})
    public void inNoticeCancelEvent(BaseOrderInNoticeCancelEvent event) {
        event.execute(e -> {});
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderOutNoticeCancelEvent.class})
    public void outNoticeCancelEvent(BaseOrderOutNoticeCancelEvent event) {
        event.execute(e -> {});
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderDeliveryNoticeCloseEvent.class})
    public void deliveryNoticeCloseEvent(BaseOrderDeliveryNoticeCloseEvent event) {
        event.execute(source -> {});
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderReceiveNoticeCloseEvent.class})
    public void receiveNoticeCloseEvent(BaseOrderReceiveNoticeCloseEvent event) {
        event.execute(source -> {});
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderOutNoticeGenEvent.class})
    public void outNoticeGenEvent(BaseOrderOutNoticeGenEvent event) {
        event.execute(e -> this.sendE3((InOutNoticeOrderContext)e));
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderInNoticeGenEvent.class})
    public void inNoticeGenEvent(BaseOrderInNoticeGenEvent event) {
        event.execute(e -> this.sendE3((InOutNoticeOrderContext)e));
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BatchUpdateEvent.class})
    public void handlePush(BatchUpdateEvent batchUpdateEvent) {
    }

    private MessageVo buildReceiveDeliveryResultMessageVo(ReceiveDeliveryResultOrderContext context) {
        MessageVo messageVo = new MessageVo();
        ReceiveDeliveryResultOrderEo receiveDeliveryResultOrderEo = context.getReceiveDeliveryResultOrderEo();
        List receiveDeliveryResultOrderDetailEoList = context.getReceiveDeliveryResultOrderDetailEoList();
        CsDeliveryReceiveResultRespDto csDeliveryReceiveResultRespDto = new CsDeliveryReceiveResultRespDto();
        BeanUtils.copyProperties((Object)receiveDeliveryResultOrderEo, (Object)csDeliveryReceiveResultRespDto);
        ArrayList deliveryReceiveResultDetailRespDtoList = Lists.newArrayList();
        for (ReceiveDeliveryResultOrderDetailEo receiveDeliveryResultOrderDetailEo : receiveDeliveryResultOrderDetailEoList) {
            CsDeliveryReceiveResultDetailRespDto deliveryReceiveResultDetailRespDto = new CsDeliveryReceiveResultDetailRespDto();
            BeanUtils.copyProperties((Object)receiveDeliveryResultOrderDetailEo, (Object)deliveryReceiveResultDetailRespDto);
            deliveryReceiveResultDetailRespDto.setCargoCode(receiveDeliveryResultOrderDetailEo.getSkuCode());
            deliveryReceiveResultDetailRespDto.setCargoName(receiveDeliveryResultOrderDetailEo.getSkuName());
            deliveryReceiveResultDetailRespDto.setLongCode(receiveDeliveryResultOrderDetailEo.getSkuCode());
            deliveryReceiveResultDetailRespDto.setTradeOrderItemId(receiveDeliveryResultOrderDetailEo.getPreOrderItemId());
            deliveryReceiveResultDetailRespDtoList.add(deliveryReceiveResultDetailRespDto);
        }
        csDeliveryReceiveResultRespDto.setDeliveryReceiveResultDetailRespDtoList((List)deliveryReceiveResultDetailRespDtoList);
        messageVo.setData((Object)JSON.toJSONString((Object)csDeliveryReceiveResultRespDto));
        return messageVo;
    }

    private void sendE3(InOutNoticeOrderContext context) {
        log.info("\u51fa\u5165\u901a\u77e5\u5355\u5b8c\u6210\uff0c\u901a\u77e5E3");
        try {
            InOutNoticeOrderEo outNoticeOrderEo = context.getInOutNoticeOrderEo();
            if (!outNoticeOrderEo.getRelevanceTableName().equals(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode()) && CsPcpBusinessTypeEnum.cAllotList().contains(outNoticeOrderEo.getOrderType())) {
                log.info("\u975ecc\u3001cb\u3001bc\u8c03\u62e8\u4e1a\u52a1\uff0c\u65e0\u9700\u901a\u77e5E3");
                return;
            }
            if ("out".equals(outNoticeOrderEo.getOrderType())) {
                log.info("\u51fa\u5e93\u901a\u77e5\u65e0\u9700\u901a\u77e5E3\uff0c\u5355\u636e\u521b\u5efa\u540e\u5df2\u901a\u77e5");
                return;
            }
            MessageVo messageVo = new MessageVo();
            CsOutNoticeOrderRespDto respDto = new CsOutNoticeOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)outNoticeOrderEo, (BaseVo)respDto);
            messageVo.setData((Object)JSON.toJSONString((Object)respDto));
            this.mqService.stockInToE3Processor(messageVo);
        }
        catch (Exception e) {
            log.error("\u51fa\u5165\u901a\u77e5\u5355\u5b8c\u6210\uff0c\u901a\u77e5E3\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

