/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.request.CsBasisOrderBusinessDataReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsBaseOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsWarehouseAddressQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsWarehouseAddressRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasisOrderBusinessDataRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsReceiveNoticeOrderDetailQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsReceiveNoticeOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsReceiveNoticeOrderRespDto;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="csReceiveNoticeOrderQueryService")
public class CsReceiveNoticeOrderQueryServiceImpl
implements ICsReceiveNoticeOrderQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsReceiveNoticeOrderQueryServiceImpl.class);
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    CsCommonService csCommonService;
    @Resource
    ICsWarehouseAddressQueryService csWarehouseAddressQueryService;
    @Resource
    ICsBaseOrderQueryService csBaseOrderQueryService;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;

    @Override
    public ReceiveDeliveryNoticeOrderEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        ReceiveDeliveryNoticeOrderEo csReceiveNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)this.receiveDeliveryNoticeOrderDomain.getMapper().selectById((Serializable)id);
        AssertUtil.isTrue(csReceiveNoticeOrderEo != null && csReceiveNoticeOrderEo.getId() != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        return csReceiveNoticeOrderEo;
    }

    @Override
    public CsReceiveNoticeOrderRespDto queryById(Long id) {
        List resultOrderEoList;
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        ReceiveDeliveryNoticeOrderEo csReceiveNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)this.receiveDeliveryNoticeOrderDomain.getMapper().selectById((Serializable)id);
        AssertUtil.isTrue(csReceiveNoticeOrderEo != null && csReceiveNoticeOrderEo.getId() != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"document_no", (Object)csReceiveNoticeOrderEo.getDocumentNo());
        List detailEoList = this.receiveDeliveryNoticeOrderDetailDomain.getMapper().selectList((Wrapper)wrapper);
        CsReceiveNoticeOrderRespDto dto = new CsReceiveNoticeOrderRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)csReceiveNoticeOrderEo, (String[])new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            ArrayList orderDetailRespDtoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)orderDetailRespDtoList, (Collection)detailEoList, CsReceiveNoticeOrderDetailRespDto.class);
            dto.setReceiveNoticeOrderDetailRespDtoList((List)orderDetailRespDtoList);
        }
        if (StringUtils.isNotBlank((CharSequence)csReceiveNoticeOrderEo.getExtension())) {
            try {
                ContactDto contactDto = (ContactDto)JSON.parseObject((String)csReceiveNoticeOrderEo.getExtension(), ContactDto.class);
                dto.setContactDto(contactDto);
            }
            catch (Exception ex) {
                logger.info("\u6355\u83b7\u5f02\u5e38\uff0c\u903b\u8f91\u4e0d\u5904\u7406\uff1a\u524d\u7f6e\u5355\u636e\u6536\u8d27\u4fe1\u606f\u9519\u8bef");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(resultOrderEoList = this.receiveDeliveryResultOrderDomain.queryByRelevanceNo(csReceiveNoticeOrderEo.getDocumentNo())))) {
            List resultNo = resultOrderEoList.stream().map(ReceiveDeliveryResultOrderEo::getDocumentNo).collect(Collectors.toList());
            dto.setResultNo(resultNo);
        }
        return dto;
    }

    @Override
    public CsReceiveNoticeOrderRespDto queryByDocumentNo(String documentNo) {
        List list = this.receiveDeliveryNoticeOrderDomain.queryByDocumentNo(documentNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u5355\u53f7\u4e0d\u5b58\u5728");
        return this.queryById(((ReceiveDeliveryNoticeOrderEo)list.get(0)).getId());
    }

    @Override
    public PageInfo<CsReceiveNoticeOrderRespDto> queryByPage(CsReceiveNoticeOrderQueryDto queryDto) {
        Consumer<QueryWrapper> consumer;
        logger.info("\u83b7\u53d6\u6536\u8d27\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        QueryWrapper wrapper = new QueryWrapper();
        Long organizationId = this.csCommonService.getUserOrganizationId();
        if (null != organizationId) {
            wrapper.eq((Object)"organization_id", (Object)organizationId);
        }
        if (StringUtil.isNotBlank((String)queryDto.getBusinessType())) {
            wrapper.eq((Object)"business_type", (Object)queryDto.getBusinessType());
        }
        if (StringUtil.isNotBlank((String)queryDto.getOrderStatus())) {
            wrapper.eq((Object)"order_status", (Object)queryDto.getOrderStatus());
        }
        if (StringUtil.isNotBlank((String)queryDto.getPreOrderNo())) {
            wrapper.eq((Object)"pre_order_no", (Object)queryDto.getPreOrderNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getDocumentNo())) {
            wrapper.like((Object)"document_no", (Object)queryDto.getDocumentNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseName())) {
            wrapper.like((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseCode())) {
            wrapper.like((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtil.isNotBlank((String)queryDto.getCreateTimeStart()) && StringUtil.isNotBlank((String)queryDto.getCreateTimeEnd())) {
            wrapper.between((Object)"create_time", (Object)queryDto.getCreateTimeStart(), (Object)queryDto.getCreateTimeEnd());
        }
        if (StringUtil.isNotBlank((String)queryDto.getCommonNo())) {
            consumer = qw -> {
                qw.like((Object)"document_no", (Object)queryDto.getCommonNo());
                qw.or();
                qw.like((Object)"relevance_no", (Object)queryDto.getCommonNo());
                qw.or();
                qw.like((Object)"pre_order_no", (Object)queryDto.getCommonNo());
            };
            wrapper.and(consumer);
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getReceiveLogicWarehouse())) {
            consumer = qw -> {
                qw.like((Object)"warehouse_name", (Object)queryDto.getReceiveLogicWarehouse());
                qw.or();
                qw.like((Object)"warehouse_code", (Object)queryDto.getReceiveLogicWarehouse());
            };
            wrapper.and(consumer);
        }
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.orderByDesc((Object)queryDto.getOrderByDesc());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)wrapper);
        PageInfo info = new PageInfo(list);
        ArrayList rList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)list, rList, CsReceiveNoticeOrderRespDto.class);
        PageInfo result = new PageInfo(rList);
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(rList);
        logger.info("\u83b7\u53d6\u6536\u8d27\u5355-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    @Override
    public PageInfo<CsReceiveNoticeOrderDetailRespDto> queryReceiveNoticeOrderDetails(CsReceiveNoticeOrderDetailQueryDto dto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(dto, "pageNum", "pageSize"));
        if (StringUtil.isNotBlank((String)dto.getIdentification()) && dto.getIdentification().equals("identification")) {
            PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
            List respDtoList = this.receiveDeliveryNoticeOrderDetailDomain.queryReceivePage(dto);
            for (CsReceiveNoticeOrderDetailRespDto respDto : respDtoList) {
                respDto.setCargoCode(respDto.getSkuCode());
                respDto.setLongCode(respDto.getSkuCode());
                respDto.setCargoName(respDto.getSkuName());
            }
            return new PageInfo(respDtoList);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"document_no", (Object)dto.getDocumentNo());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"init_flag", (Object)YesNoEnum.YES.getValue());
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List eos = this.receiveDeliveryNoticeOrderDetailDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)eos)) {
            return new PageInfo();
        }
        PageInfo csOutResultOrderDetailEoPageReceivefo = new PageInfo(eos);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)csOutResultOrderDetailEoPageReceivefo, (String[])new String[]{"list", "navigatepageNums"});
        List list = eos.stream().map(e -> {
            CsReceiveNoticeOrderDetailRespDto respDto = new CsReceiveNoticeOrderDetailRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)e, (String[])new String[0]);
            respDto.setCargoCode(e.getSkuCode());
            respDto.setLongCode(e.getSkuCode());
            respDto.setCargoName(e.getSkuName());
            return respDto;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return pageInfo;
    }

    @Override
    public CsReceiveNoticeOrderRespDto queryVersionSecondByDocumentNo(String documentNo) {
        QueryWrapper deliveryNoticeOrderQueryWrapper = new QueryWrapper();
        deliveryNoticeOrderQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        deliveryNoticeOrderQueryWrapper.eq((Object)"dr", (Object)0);
        deliveryNoticeOrderQueryWrapper.eq((Object)"order_type", (Object)"receive");
        List list = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)deliveryNoticeOrderQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u5355\u53f7\u4e0d\u5b58\u5728");
        ReceiveDeliveryNoticeOrderEo eo = (ReceiveDeliveryNoticeOrderEo)list.get(0);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        logger.info("eo\u54cd\u5e94=>{}", (Object)JSON.toJSONString((Object)eo));
        CsReceiveNoticeOrderRespDto dto = new CsReceiveNoticeOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        dto.setWarehouseCode(eo.getReceiveLogicWarehouseCode());
        dto.setWarehouseName(eo.getReceiveLogicWarehouseName());
        dto.setDeliveryWarehouseCode(eo.getDeliveryLogicWarehouseCode());
        dto.setDeliveryWarehouseName(eo.getDeliveryLogicWarehouseName());
        CsBasisOrderBusinessDataReqDto dataReqDto = new CsBasisOrderBusinessDataReqDto();
        CubeBeanUtils.copyProperties((Object)dataReqDto, (Object)dto, (String[])new String[0]);
        CsBasisOrderBusinessDataRespDto dataRespDto = this.csBaseOrderQueryService.deliveryReceiveNoticeBuildRelOrderInfo(dataReqDto, "receive", "in");
        if (Objects.nonNull(dataRespDto)) {
            dto.setContactDto(dataRespDto.getContactDto());
            dto.setRelOrderInfoList(dataRespDto.getRelOrderInfoList());
        }
        BigDecimal skuNum = this.csBaseOrderQueryService.queryItemMapByDeliveryReceiveNoticeDocumentNo(dto.getDocumentNo());
        dto.setSkuNum(skuNum);
        if (!CsPcpBusinessTypeEnum.returnInWarehouseAddressBusinessType((String)eo.getBusinessType()).booleanValue()) {
            logger.info("\u4e0d\u7528\u8fd4\u56de\u5173\u8054\u4e1a\u52a1\u5355\u4fe1\u606f,\u76f4\u63a5\u8fd4\u56de");
            dto.setContactDto(null);
            logger.info("dto\u54cd\u5e94=>{}", (Object)JSON.toJSONString((Object)dto));
            return dto;
        }
        String physicsWarehouseCode = dto.getReceivePhysicsWarehouseCode();
        PageInfo<CsWarehouseAddressRespDto> addressPageInfo = null;
        if (StringUtils.isNotBlank((CharSequence)physicsWarehouseCode)) {
            CsWarehouseAddressParamQueryDto csWarehouseAddressParamQueryDto = new CsWarehouseAddressParamQueryDto();
            csWarehouseAddressParamQueryDto.setWarehouseCode(physicsWarehouseCode);
            csWarehouseAddressParamQueryDto.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
            csWarehouseAddressParamQueryDto.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
            csWarehouseAddressParamQueryDto.setPageNum(Integer.valueOf(1));
            csWarehouseAddressParamQueryDto.setPageSize(Integer.valueOf(10));
            addressPageInfo = this.csWarehouseAddressQueryService.queryPageInfo(csWarehouseAddressParamQueryDto);
        }
        if (Objects.nonNull(addressPageInfo) && CollectionUtils.isNotEmpty((Collection)addressPageInfo.getList())) {
            ContactDto contactDto = Objects.nonNull(dto.getContactDto()) ? dto.getContactDto() : new ContactDto();
            CsWarehouseAddressRespDto warehouseAddressRespDto = (CsWarehouseAddressRespDto)addressPageInfo.getList().get(0);
            contactDto.setAddress(Objects.nonNull(warehouseAddressRespDto.getCountry()) ? warehouseAddressRespDto.getCountry() : "" + warehouseAddressRespDto.getProvince() + warehouseAddressRespDto.getCity() + warehouseAddressRespDto.getDistrict() + warehouseAddressRespDto.getDetailAddress());
            contactDto.setReciveName(warehouseAddressRespDto.getContacts());
            contactDto.setRecivePhone(warehouseAddressRespDto.getPhone());
            dto.setContactDto(contactDto);
        }
        logger.info("dto\u54cd\u5e94=>{}", (Object)JSON.toJSONString((Object)dto));
        return dto;
    }
}

