/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderDetailQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderDetailInfoQueryReqDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderDetailBatchRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csOutNoticeOrderDetailQueryService")
public class CsOutNoticeOrderDetailQueryServiceImpl
implements ICsOutNoticeOrderDetailQueryService {
    private final String INIT = "init";
    private static Logger logger = LoggerFactory.getLogger(CsOutNoticeOrderDetailQueryServiceImpl.class);
    @Autowired
    private IInOutNoticeOrderDetailDomain csOutNoticeOrderDetailDas;
    @Autowired
    private IInOutNoticeOrderDetailDomain csOutNoticeOrderDetailMapper;
    @Resource
    private CsCommonService csCommonService;
    @Autowired
    private IInOutResultOrderDetailDomain csOutResultOrderDetailMapper;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;

    @Override
    public InOutNoticeOrderDetailEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        return Optional.ofNullable(this.csOutNoticeOrderDetailDas.selectByPrimaryKey(id)).map(eo -> (InOutNoticeOrderDetailEo)BeanUtil.copyProperties((Object)eo, InOutNoticeOrderDetailEo.class, (String[])new String[0])).orElse(null);
    }

    @Override
    public PageInfo<CsOutNoticeOrderDetailRespDto> groupingPage(CsOutNoticeOrderDetailInfoQueryReqDto queryDto) {
        this.checkParams(queryDto);
        QueryWrapper inOutNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        inOutNoticeOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        inOutNoticeOrderDetailEoQueryWrapper.eq((Object)"init_flag", (Object)YesNoEnum.YES.getValue());
        inOutNoticeOrderDetailEoQueryWrapper.eq((Object)"relevance_no", (Object)queryDto.getRelevanceNo());
        inOutNoticeOrderDetailEoQueryWrapper.groupBy((Object[])new String[]{"sku_code", "batch"});
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        List inOutNoticeOrderDetailEos = this.csOutNoticeOrderDetailMapper.getMapper().selectList((Wrapper)inOutNoticeOrderDetailEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)inOutNoticeOrderDetailEos)) {
            return new PageInfo();
        }
        List longCodeList = inOutNoticeOrderDetailEos.stream().map(InOutNoticeOrderDetailEo::getSkuCode).distinct().collect(Collectors.toList());
        QueryWrapper batchQueryWrapper = new QueryWrapper();
        batchQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        batchQueryWrapper.isNotNull((Object)"batch");
        batchQueryWrapper.eq((Object)"relevance_no", (Object)queryDto.getRelevanceNo());
        List batchList = this.csOutResultOrderDetailMapper.getMapper().selectList((Wrapper)batchQueryWrapper);
        Map<Object, Object> batchMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)batchList)) {
            batchMap = batchList.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode));
        }
        List csItemEoList = this.itemSkuProxy.queryBySkuCodes(longCodeList);
        Map<Object, Object> csItemEoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)csItemEoList)) {
            csItemEoMap = csItemEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity()));
        }
        PageInfo selectPage = new PageInfo(inOutNoticeOrderDetailEos);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<CsOutNoticeOrderDetailRespDto> dtoList = new ArrayList<CsOutNoticeOrderDetailRespDto>();
        for (InOutNoticeOrderDetailEo inOutNoticeOrderDetailEo : inOutNoticeOrderDetailEos) {
            CsOutNoticeOrderDetailRespDto respDto = new CsOutNoticeOrderDetailRespDto();
            BeanUtil.copyProperties((Object)inOutNoticeOrderDetailEo, (Object)respDto, (String[])new String[0]);
            respDto.setSkuCode(inOutNoticeOrderDetailEo.getSkuCode());
            respDto.setCargoCode(inOutNoticeOrderDetailEo.getSkuCode());
            respDto.setCargoName(inOutNoticeOrderDetailEo.getSkuName());
            respDto.setLongCode(inOutNoticeOrderDetailEo.getSkuCode());
            String longCode = inOutNoticeOrderDetailEo.getSkuCode();
            ItemSkuDto csItemEo = (ItemSkuDto)csItemEoMap.get(longCode);
            if (null != csItemEo) {
                respDto.setVolume(csItemEo.getVolume());
            }
            List tempEoList = (List)batchMap.get(longCode);
            ArrayList list = Lists.newArrayList();
            if (CollectionUtils.isEmpty((Collection)tempEoList)) {
                CsOutNoticeOrderDetailBatchRespDto batchRespDto = new CsOutNoticeOrderDetailBatchRespDto();
                CubeBeanUtils.copyProperties((Object)batchRespDto, (Object)respDto, (String[])new String[0]);
                list.add(batchRespDto);
            } else {
                for (InOutResultOrderDetailEo detailEo : tempEoList) {
                    CsOutNoticeOrderDetailBatchRespDto batchRespDto = new CsOutNoticeOrderDetailBatchRespDto();
                    CubeBeanUtils.copyProperties((Object)batchRespDto, (Object)detailEo, (String[])new String[0]);
                    batchRespDto.setInOutResultOrderNo(detailEo.getDocumentNo());
                    batchRespDto.setLongCode(detailEo.getSkuCode());
                    batchRespDto.setCargoName(detailEo.getSkuName());
                    list.add(batchRespDto);
                }
            }
            respDto.setDetailBatchRespDtoList((List)list);
            dtoList.add(respDto);
        }
        pageInfo.setList(dtoList);
        return pageInfo;
    }

    private void checkParams(CsOutNoticeOrderDetailInfoQueryReqDto queryDto) {
        AssertUtil.isTrue(null != queryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Integer pageNum = queryDto.getPageNum();
        AssertUtil.isTrue(null != pageNum && pageNum > 0, "\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(null != pageSize && pageSize > 0, "\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
        String relevanceNo = queryDto.getRelevanceNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)relevanceNo), "\u5173\u8054\u4e1a\u52a1\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

