/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.IGenerateCodeService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsBusinessOrderCallBackUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsInPlannedOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsInPlannedOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.in.CsInPlannedOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInPlannedOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsInventorySupplierEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsPlannedOrderAuditEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInPlannedOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInPlannedOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsInventorySupplierMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsPlannedOrderAuditMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsWmsBasicsDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderClosedReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOverchargeAdjustDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOverchargeAdjustReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedRelieveOverchargeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutMatchRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessCallBackStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderAuditResultEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderItemStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderOperateEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.basicdata.enums.DictEnum;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.proxy.data.IPcpDictApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csInPlannedOrderService")
public class CsInPlannedOrderServiceImpl
implements ICsInPlannedOrderService {
    private static final Logger logger = LoggerFactory.getLogger(CsInPlannedOrderServiceImpl.class);
    private final String RELIEVE_REMARK = "relieve";
    private final String INIT = "init";
    private BigDecimal overchargeProportion = new BigDecimal(1.1);
    private final String DEFAULT_EXPIRATION_DATE = "1";
    @Autowired
    private CsInPlannedOrderDas csInPlannedOrderDas;
    @Autowired
    private BaseOrderFacade baseOrderFacade;
    @Autowired
    private ICsInPlannedOrderQueryService csInPlannedOrderQueryService;
    @Autowired
    ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    private CsInventorySupplierMapper csInventorySupplierMapper;
    @Autowired
    private CsInPlannedOrderDetailMapper csInPlannedOrderDetailMapper;
    @Autowired
    private CsInPlannedOrderMapper csInPlannedOrderMapper;
    @Autowired
    private IContext context;
    @Autowired
    private CsPlannedOrderAuditMapper csPlannedOrderAuditMapper;
    @Autowired
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Autowired
    IRelWarehouseDomain relWarehouseDomain;
    @Autowired
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Autowired
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Autowired
    IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Autowired
    private IPcpDictApiProxy pcpDictApiProxy;
    @Autowired
    private CsCommonService csCommonService;
    @Autowired
    private RepeatFilter repeatFilter;
    @Value(value="${inventory.config.is_all_deal_with:1}")
    private Integer isAllDeal;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;
    @Autowired
    private ICsLogicInventoryQueryService inventoryQueryService;

    @Override
    public Long add(CsInPlannedOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsInPlannedOrderEo insertEo = CsInPlannedOrderEo.newInstance();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.csInPlannedOrderDas.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsInPlannedOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsInPlannedOrderEo updateEo = CsInPlannedOrderEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csInPlannedOrderDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        CsInPlannedOrderEo eo = this.csInPlannedOrderQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        this.csInPlannedOrderDas.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long generatePlannedOrder(CsInPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        logger.info("generatePlannedOrder==>\u751f\u6210\u5355\u636e,plannedOrderGenerateReqDto:{}", (Object)LogUtils.buildLogContent(plannedOrderGenerateReqDto));
        this.checkParams(plannedOrderGenerateReqDto);
        String operateFlag = plannedOrderGenerateReqDto.getOperateFlag();
        CsInPlannedOrderAddReqDto addReqDto = new CsInPlannedOrderAddReqDto();
        CubeBeanUtils.copyProperties((Object)addReqDto, (Object)plannedOrderGenerateReqDto, (String[])new String[0]);
        addReqDto.setPlatformOrderNo(plannedOrderGenerateReqDto.getPlatformOrderNo());
        addReqDto.setReceiveWarehouseId(plannedOrderGenerateReqDto.getWarehouseId());
        addReqDto.setReceiveWarehouseCode(plannedOrderGenerateReqDto.getWarehouseCode());
        addReqDto.setReceiveWarehouseName(plannedOrderGenerateReqDto.getWarehouseName());
        addReqDto.setEstimatedTime(plannedOrderGenerateReqDto.getEstimatedTime());
        addReqDto.setExtension(plannedOrderGenerateReqDto.getExtension());
        String orderNo = plannedOrderGenerateReqDto.getOrderNo();
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            String orderType = plannedOrderGenerateReqDto.getOrderType();
            orderNo = this.generateCode(orderType);
        }
        addReqDto.setOrderNo(orderNo);
        addReqDto.setOrderStatus(CsPlannedOrderStatusEnum.WAIT_SUBMIT.getCode());
        if (CsPlannedOrderOperateEnum.SUBMIT.getCode().equals(operateFlag)) {
            addReqDto.setOrderStatus(CsPlannedOrderStatusEnum.WAIT_AUDIT.getCode());
        }
        List itemDetailList = plannedOrderGenerateReqDto.getItemDetailList();
        List longCodes = itemDetailList.stream().map(CsInPlannedOrderGenerateDetailReqDto::getLongCode).distinct().collect(Collectors.toList());
        List batchs = itemDetailList.stream().map(CsInPlannedOrderGenerateDetailReqDto::getBatch).distinct().collect(Collectors.toList());
        CsLogicInventoryQueryDto dto = new CsLogicInventoryQueryDto();
        dto.setLongCodes(longCodes);
        dto.setBatchList(batchs);
        dto.setWarehouseCode(plannedOrderGenerateReqDto.getWarehouseCode());
        List<CsLogicInventoryRespDto> inventoryRespDtos = this.inventoryQueryService.queryInfoList(dto);
        logger.info("\u67e5\u8be2\u5230\u5546\u54c1\u751f\u4ea7\u65e5\u671f\u548c\u8fc7\u671f\u65e5\u671finventoryRespDtos:{}", (Object)JSON.toJSONString(inventoryRespDtos));
        HashMap respDtoMap = new HashMap();
        if (CollectionUtil.isNotEmpty(inventoryRespDtos)) {
            Map dtoMap = inventoryRespDtos.stream().collect(Collectors.toMap(r -> r.getSkuCode() + "_" + r.getBatch(), Function.identity(), (o, o1) -> o));
            respDtoMap.putAll(dtoMap);
        }
        BigDecimal totalPlanQuantity = itemDetailList.stream().map(CsInPlannedOrderGenerateDetailReqDto::getPlanQuantity).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        addReqDto.setTotalQuantity(totalPlanQuantity);
        addReqDto.setNoBatch(StringUtils.isBlank((CharSequence)((CsInPlannedOrderGenerateDetailReqDto)itemDetailList.get(0)).getBatch()) ? YesNoEnum.YES.getValue() : YesNoEnum.NO.getValue());
        Long plannedOrderId = this.add(addReqDto);
        ArrayList orderDetailEoList = Lists.newArrayList();
        for (CsInPlannedOrderGenerateDetailReqDto itemDto : itemDetailList) {
            String key = String.format("%s_%s", itemDto.getLongCode(), itemDto.getBatch());
            CsInPlannedOrderDetailEo csInPlannedOrderDetailEo = new CsInPlannedOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)csInPlannedOrderDetailEo, (Object)itemDto, (String[])new String[0]);
            csInPlannedOrderDetailEo.setCargoName(itemDto.getCargoName());
            csInPlannedOrderDetailEo.setPlatformOrderNo(plannedOrderGenerateReqDto.getPlatformOrderNo());
            csInPlannedOrderDetailEo.setOrderNo(orderNo);
            csInPlannedOrderDetailEo.setLongCode(itemDto.getLongCode());
            csInPlannedOrderDetailEo.setBatch(itemDto.getBatch());
            csInPlannedOrderDetailEo.setPlanQuantity(itemDto.getPlanQuantity());
            csInPlannedOrderDetailEo.setDoneQuantity(BigDecimal.ZERO);
            csInPlannedOrderDetailEo.setWaitQuantity(itemDto.getPlanQuantity());
            csInPlannedOrderDetailEo.setCancelQuantity(BigDecimal.ZERO);
            csInPlannedOrderDetailEo.setOverchargeQuantity(BigDecimal.ZERO);
            if (respDtoMap.containsKey(key)) {
                CsLogicInventoryRespDto csLogicInventoryRespDto = (CsLogicInventoryRespDto)respDtoMap.get(key);
                csInPlannedOrderDetailEo.setExpireTime(csLogicInventoryRespDto.getExpireTime());
                csInPlannedOrderDetailEo.setProduceTime(csLogicInventoryRespDto.getProduceTime());
            }
            csInPlannedOrderDetailEo.setItemStatus(CsPlannedOrderItemStatusEnum.COMMON.getCode());
            csInPlannedOrderDetailEo.setExtension(itemDto.getExtension());
            orderDetailEoList.add(csInPlannedOrderDetailEo);
        }
        this.csInPlannedOrderDetailMapper.insertBatch((List)orderDetailEoList);
        return plannedOrderId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditPlannedOrder(CsInPlannedOrderAuditReqDto plannedOrderAuditReqDto) {
        logger.info("auditPlannedOrder==>\u5ba1\u6838\u5355\u636e,plannedOrderAuditReqDto:{}", (Object)LogUtils.buildLogContent(plannedOrderAuditReqDto));
        this.csCommonService.getSetUserName();
        String key = "IN_PLANNED_AUDIT:" + plannedOrderAuditReqDto.getOrderNo();
        this.repeatFilter.checkRepeat(key, () -> this.checkParams(plannedOrderAuditReqDto), true);
        String orderNo = plannedOrderAuditReqDto.getOrderNo();
        QueryWrapper csInPlannedOrderEoQueryWrapper = new QueryWrapper();
        csInPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)orderNo);
        csInPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)csInPlannedOrderEoQueryWrapper);
        AssertUtil.isTrue(null != csInPlannedOrderEo, "\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CsPlannedOrderStatusEnum.WAIT_AUDIT.getCode().equals(csInPlannedOrderEo.getOrderStatus()), "\u975e\u5f85\u5ba1\u6838\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c");
        QueryWrapper detailEoQueryWrapper = new QueryWrapper();
        detailEoQueryWrapper.eq((Object)"order_no", (Object)csInPlannedOrderEo.getOrderNo());
        detailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List orderDetailEoList = this.csInPlannedOrderDetailMapper.selectList((Wrapper)detailEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)orderDetailEoList), "\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        String auditResult = plannedOrderAuditReqDto.getAuditResult();
        if (CsPlannedOrderAuditResultEnum.AUDIT_PASS.getCode().equals(auditResult)) {
            this.auditPassPlannedOrder(plannedOrderAuditReqDto, csInPlannedOrderEo, orderDetailEoList);
        } else if (CsPlannedOrderAuditResultEnum.AUDIT_FAILED.getCode().equals(auditResult)) {
            this.auditFailedOrder(plannedOrderAuditReqDto, csInPlannedOrderEo);
        }
    }

    @Override
    public void cancelByOrderNo(String orderNo) {
        logger.info("cancelByOrderNo==>\u6839\u636e\u5355\u636e\u53f7\u5173\u95ed\u8ba1\u5212\u5355\u636e,orderNo:{}", (Object)orderNo);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u5355\u636e\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper csInPlannedOrderEoQueryWrapper = new QueryWrapper();
        csInPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)orderNo);
        csInPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)csInPlannedOrderEoQueryWrapper);
        AssertUtil.isTrue(null != csInPlannedOrderEo, "\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        ArrayList<String> statusList = new ArrayList<String>(3);
        statusList.add(CsPlannedOrderStatusEnum.WAIT_SUBMIT.getCode());
        statusList.add(CsPlannedOrderStatusEnum.WAIT_AUDIT.getCode());
        statusList.add(CsPlannedOrderStatusEnum.AUDIT_FAILED.getCode());
        String orderStatus = csInPlannedOrderEo.getOrderStatus();
        if (!statusList.contains(orderStatus)) {
            throw new BizException(String.format("\u5f53\u524d\u3010%s\u3011\u72b6\u6001\u4e0d\u5141\u8bb8\u53d6\u6d88", CsPlannedOrderStatusEnum.getByCode((String)orderStatus).getDesc()));
        }
        csInPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.CANCEL.getCode());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)csInPlannedOrderEo.getId());
        this.csInPlannedOrderMapper.update((Object)csInPlannedOrderEo, (Wrapper)updateWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long editPlannedOrder(CsInPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        logger.info("editPlannedOrder==>\u8ba1\u5212\u5355\u636e\u7f16\u8f91\u91cd\u65b0\u63d0\u4ea4,plannedOrderGenerateReqDto:{}", (Object)LogUtils.buildLogContent(plannedOrderGenerateReqDto));
        String orderNo = plannedOrderGenerateReqDto.getOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u5355\u636e\u53f7\u4e0d\u5b58\u5728");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)orderNo);
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)queryWrapper);
        AssertUtil.isTrue(null != csInPlannedOrderEo, "\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        String orderStatus = csInPlannedOrderEo.getOrderStatus();
        AssertUtil.isTrue(CsPlannedOrderStatusEnum.WAIT_SUBMIT.getCode().equals(orderStatus) || CsPlannedOrderStatusEnum.AUDIT_FAILED.getCode().equals(orderStatus), String.format("\u5f53\u524d\u3010%s\u3011\u72b6\u6001\u4e0d\u5141\u8bb8\u7f16\u8f91", CsPlannedOrderStatusEnum.getByCode((String)orderStatus).getDesc()));
        QueryWrapper deleteOrderWrapper = new QueryWrapper();
        deleteOrderWrapper.eq((Object)"order_no", (Object)orderNo);
        csInPlannedOrderEo.setDr(1);
        this.csInPlannedOrderMapper.update((Object)csInPlannedOrderEo, (Wrapper)deleteOrderWrapper);
        QueryWrapper deleteOrderDetailWrapper = new QueryWrapper();
        deleteOrderDetailWrapper.eq((Object)"order_no", (Object)orderNo);
        this.csInPlannedOrderDetailMapper.delete((Wrapper)deleteOrderDetailWrapper);
        plannedOrderGenerateReqDto.setCreateTime(csInPlannedOrderEo.getCreateTime());
        plannedOrderGenerateReqDto.setCreatePerson(csInPlannedOrderEo.getCreatePerson());
        Long plannedOrderId = this.generatePlannedOrder(plannedOrderGenerateReqDto);
        return plannedOrderId;
    }

    @Override
    public void submitByOrderNo(String orderNo) {
        logger.info("submitByOrderNo==>\u6839\u636e\u5355\u636e\u53f7\u63d0\u4ea4\u8ba1\u5212\u5355\u636e,orderNo:{}", (Object)orderNo);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u5355\u636e\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper csInPlannedOrderEoQueryWrapper = new QueryWrapper();
        csInPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)orderNo);
        csInPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)csInPlannedOrderEoQueryWrapper);
        AssertUtil.isTrue(null != csInPlannedOrderEo, "\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        String orderStatus = csInPlannedOrderEo.getOrderStatus();
        AssertUtil.isTrue(CsPlannedOrderStatusEnum.WAIT_SUBMIT.getCode().equals(orderStatus) || CsPlannedOrderStatusEnum.AUDIT_FAILED.getCode().equals(orderStatus), String.format("\u5f53\u524d\u3010%s\u3011\u72b6\u6001\u4e0d\u5141\u8bb8\u63d0\u4ea4", CsPlannedOrderStatusEnum.getByCode((String)orderStatus).getDesc()));
        csInPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.WAIT_AUDIT.getCode());
        QueryWrapper updateWrapper = new QueryWrapper();
        updateWrapper.eq((Object)"id", (Object)csInPlannedOrderEo.getId());
        this.csInPlannedOrderMapper.update((Object)csInPlannedOrderEo, (Wrapper)updateWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void relieveOverchargeByOrderDocumentNo(CsInPlannedRelieveOverchargeReqDto csInPlannedRelieveOverchargeReqDto) {
        logger.info("relieveOverchargeByOrderDocumentNo==>\u6839\u636e\u5165\u5e93\u7ed3\u679c\u5355\u5355\u53f7\u89e3\u6302\u5165\u5e93\u7ed3\u679c\u5355,csInPlannedRelieveOverchargeReqDto:{}", (Object)LogUtils.buildLogContent(csInPlannedRelieveOverchargeReqDto));
        AssertUtil.isTrue(null != csInPlannedRelieveOverchargeReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String inResultDocumentNo = csInPlannedRelieveOverchargeReqDto.getInResultDocumentNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inResultDocumentNo), "\u5165\u5e93\u7ed3\u679c\u5355\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper csInResultOrderEoQueryWrapper = new QueryWrapper();
        csInResultOrderEoQueryWrapper.eq((Object)"document_no", (Object)inResultDocumentNo);
        csInResultOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutResultOrderEo csInResultOrderEo = (InOutResultOrderEo)this.inOutResultOrderDomain.getMapper().selectOne((Wrapper)csInResultOrderEoQueryWrapper);
        AssertUtil.assertNotNull(csInResultOrderEo, "\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f", new Object[0]);
        String orderStatus = csInResultOrderEo.getOrderStatus();
        String orderType = csInResultOrderEo.getOrderType();
        if ("in".equals(orderType)) {
            AssertUtil.isTrue(BaseOrderStatusEnum.IRO_HANG_UP.getCode().equals(orderStatus), "\u975e\u6302\u8d77\u72b6\u6001\u5355\u636e\u4e0d\u5141\u8bb8\u89e3\u6302");
        } else if ("out".equals(orderType)) {
            AssertUtil.isTrue(BaseOrderStatusEnum.ORO_HANG_UP.getCode().equals(orderStatus), "\u975e\u6302\u8d77\u72b6\u6001\u5355\u636e\u4e0d\u5141\u8bb8\u89e3\u6302");
        }
        QueryWrapper csInResultOrderDetailEoQueryWrapper = new QueryWrapper();
        csInResultOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)inResultDocumentNo);
        csInResultOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List overchargeList = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)csInResultOrderDetailEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)overchargeList), "\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        logger.info("relieveOverchargeByOrderDocumentNo==>\u6839\u636e\u5165\u5e93\u7ed3\u679c\u5355\u5355\u53f7\u89e3\u6302\u5165\u5e93\u7ed3\u679c\u5355,overchargeList:{}", (Object)LogUtils.buildLogContent(overchargeList));
        this.updateInfo2(csInResultOrderEo, overchargeList, csInPlannedRelieveOverchargeReqDto.getRemark());
    }

    private void updateInfo2(InOutResultOrderEo csInOutResultOrderEo, List<InOutResultOrderDetailEo> overchargeList, String remark) {
        logger.info("updateInfo==>\u8c03\u6574\u3001\u89e3\u6302\u66f4\u65b0\u5165\u5e93,\u5f00\u59cb,csInOutResultOrder documentNo:{}", (Object)csInOutResultOrderEo.getDocumentNo());
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)csInOutResultOrderEo.getRelevanceTableName());
        ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        List inOutNoticeOrderEos = this.inOutNoticeOrderDomain.queryByDocumentNo(csInOutResultOrderEo.getPreOrderNo());
        AssertUtil.assertNotEmpty(inOutNoticeOrderEos, "\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4e0d\u5b58\u5728", new Object[0]);
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
        List inOutNoticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.queryInitByDocumentNo(inOutNoticeOrderEo.getDocumentNo());
        List ReceiveDeliveryNoticeOrderEos = this.receiveDeliveryNoticeOrderDomain.queryByDocumentNo(inOutNoticeOrderEo.getPreOrderNo());
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)ReceiveDeliveryNoticeOrderEos.get(0);
        List deliveryNoticeOrderDetailEoList = this.receiveDeliveryNoticeOrderDetailDomain.queryByDocumentNo(inOutNoticeOrderEo.getPreOrderNo());
        boolean inFlag = "in".equals(inOutNoticeOrderEo.getOrderType());
        CsOrderBusinessCallBackContext callBackContext = new CsOrderBusinessCallBackContext();
        CsBasicsReceiveReqDto basicsReceiveBasicsReqDto = this.changeParam(csInOutResultOrderEo, overchargeList);
        businessOrderCallBackService.groupByCargoCodeBatch(basicsReceiveBasicsReqDto);
        logger.info("updateInfo==>\u8c03\u6574\u3001\u89e3\u6302\u66f4\u65b0\u5165\u5e93,\u4ee5\u8d27\u54c1+\u6279\u6b21\u7ef4\u5ea6\u7edf\u8ba1\u56de\u4f20\u5546\u54c1\u660e\u7ec6, documentNo:{},basicsReceiveBasicsReqDto:{}", (Object)csInOutResultOrderEo.getDocumentNo(), (Object)JSON.toJSONString((Object)basicsReceiveBasicsReqDto));
        CsInOutMatchRespDto csInOutMatchRespDto = this.matchInventory(inOutNoticeOrderEo, csInOutResultOrderEo, businessOrderCallBackService, basicsReceiveBasicsReqDto);
        logger.info("updateInfo==>\u8c03\u6574\u3001\u89e3\u6302\u66f4\u65b0\u5165\u5e93,\u5339\u914d\u5b8c\u6210, documentNo:{}", (Object)csInOutResultOrderEo.getDocumentNo());
        this.dealInventory(csInOutResultOrderEo, businessOrderCallBackService, inOutNoticeOrderEo, inFlag, csInOutMatchRespDto);
        logger.info("updateInfo==>\u8c03\u6574\u3001\u89e3\u6302\u66f4\u65b0\u5165\u5e93,\u5e93\u5b58\u5904\u7406\u5b8c\u6210, documentNo:{}", (Object)csInOutResultOrderEo.getDocumentNo());
        ArrayList inOutResultDetailRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)inOutResultDetailRespDtoList, overchargeList, CsInOutResultDetailRespDto.class);
        businessOrderCallBackService.updateNoticeOrderInfo(inOutResultDetailRespDtoList, inOutNoticeOrderDetailEoList, deliveryNoticeOrderDetailEoList);
        logger.info("updateInfo==>\u8c03\u6574\u3001\u89e3\u6302\u66f4\u65b0\u5165\u5e93,\u66f4\u65b0\u5355\u636e\u51fa\u5165\u5e93\u6570\u91cf\u5b8c\u6210, documentNo:{}", (Object)csInOutResultOrderEo.getDocumentNo());
        this.updateStatus(csInOutResultOrderEo, businessOrderCallBackService, inOutNoticeOrderEo, inOutNoticeOrderDetailEoList, receiveDeliveryNoticeOrderEo, inFlag, callBackContext, remark);
        logger.info("updateInfo==>\u8c03\u6574\u3001\u89e3\u6302\u66f4\u65b0\u5165\u5e93,\u66f4\u65b0\u5355\u636e\u72b6\u6001\u3001\u4e3b\u5355\u636e\u72b6\u6001\u5b8c\u6210, documentNo:{}", (Object)csInOutResultOrderEo.getDocumentNo());
        businessOrderCallBackService.generateReceiveResultOrderInfo(basicsReceiveBasicsReqDto, receiveDeliveryNoticeOrderEo, deliveryNoticeOrderDetailEoList, csInOutResultOrderEo, inFlag);
        logger.info("updateInfo==>\u8c03\u6574\u3001\u89e3\u6302\u66f4\u65b0\u5165\u5e93,\u751f\u6210\u6536\u53d1\u8d27\u7ed3\u679c\u5355\u5b8c\u6210, documentNo:{}", (Object)csInOutResultOrderEo.getDocumentNo());
    }

    private void updateStatus(InOutResultOrderEo csInOutResultOrderEo, ICsBusinessOrderCallBackService businessOrderCallBackService, InOutNoticeOrderEo InOutNoticeOrderEo2, List<InOutNoticeOrderDetailEo> InOutNoticeOrderDetailEoList, ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2, boolean inFlag, CsOrderBusinessCallBackContext callBackContext, String remark) {
        businessOrderCallBackService.updateNoticeStatus(InOutNoticeOrderEo2, ReceiveDeliveryNoticeOrderEo2, InOutNoticeOrderDetailEoList, callBackContext);
        businessOrderCallBackService.updateResultStatus(inFlag, csInOutResultOrderEo, remark);
        callBackContext.setInResultOrderNo(csInOutResultOrderEo.getDocumentNo());
        callBackContext.setRelevanceNo(csInOutResultOrderEo.getRelevanceNo());
        callBackContext.setInFlag(Boolean.valueOf(inFlag));
        businessOrderCallBackService.inOutResultOrderCallBack(callBackContext);
    }

    private void dealInventory(InOutResultOrderEo csInResultOrderEo, ICsBusinessOrderCallBackService businessOrderCallBackService, InOutNoticeOrderEo InOutNoticeOrderEo2, boolean inFlag, CsInOutMatchRespDto csInOutMatchRespDto) {
        businessOrderCallBackService.inInventoryDeal(csInOutMatchRespDto, InOutNoticeOrderEo2, inFlag);
        businessOrderCallBackService.outInventoryDeal(csInOutMatchRespDto, InOutNoticeOrderEo2, inFlag, this.isAllDeal);
        logger.info("isAllDeal\u9ed8\u8ba4\u503c\uff1a{}", (Object)this.isAllDeal);
    }

    private CsInOutMatchRespDto matchInventory(InOutNoticeOrderEo InOutNoticeOrderEo2, InOutResultOrderEo csInResultOrderEo, ICsBusinessOrderCallBackService businessOrderCallBackService, CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        List InOutNoticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.queryInitByDocumentNo(csInResultOrderEo.getPreOrderNo());
        return businessOrderCallBackService.matchDetail(InOutNoticeOrderEo2, InOutNoticeOrderDetailEoList, basicsReceiveBasicsReqDto);
    }

    private CsBasicsReceiveReqDto changeParam(InOutResultOrderEo csInResultOrderEo, List<InOutResultOrderDetailEo> overchargeList) {
        CsBasicsReceiveReqDto basicsReceiveReqDto = new CsBasicsReceiveReqDto();
        basicsReceiveReqDto.setWmsOrderNo(csInResultOrderEo.getWmsOrderNo());
        basicsReceiveReqDto.setInOutNoticeOrderNo(csInResultOrderEo.getPreOrderNo());
        List detailReqDtoList = overchargeList.stream().map(obj -> {
            CsWmsBasicsDetailReqDto basicsDetailReqDto = new CsWmsBasicsDetailReqDto();
            CubeBeanUtils.copyProperties((Object)basicsDetailReqDto, (Object)obj, (String[])new String[0]);
            basicsDetailReqDto.setSkuCode(obj.getSkuCode());
            basicsDetailReqDto.setBatch(obj.getBatch());
            basicsDetailReqDto.setQuantity(obj.getDoneQuantity());
            basicsDetailReqDto.setExpireTime(obj.getExpireTime());
            basicsDetailReqDto.setProduceTime(obj.getProduceTime());
            return basicsDetailReqDto;
        }).collect(Collectors.toList());
        basicsReceiveReqDto.setDetailReqDtoList(detailReqDtoList);
        basicsReceiveReqDto.setIsAllDeal(this.isAllDeal);
        return basicsReceiveReqDto;
    }

    private void updateInfo(InOutResultOrderEo csInResultOrderEo, List<InOutResultOrderDetailEo> overchargeList, Boolean relieveFlag, String remark) {
        this.updateInResultInfo(csInResultOrderEo, overchargeList, relieveFlag, remark);
        String preOrderNo = this.updateInNoticeInfo(csInResultOrderEo, overchargeList, relieveFlag);
        this.updateReceiveNoticeInfo(csInResultOrderEo, overchargeList, relieveFlag, preOrderNo);
        CsOrderBusinessCallBackContext context = this.buildContext(csInResultOrderEo, overchargeList);
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = this.generateReceiveResultInfo(csInResultOrderEo, overchargeList, context);
        context.setDocumentNo(csDeliveryResultOrderEo.getDocumentNo());
        context.setRelieveFlag(relieveFlag);
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)csInResultOrderEo.getRelevanceTableName());
        ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        businessOrderCallBackService.deliveryReceiveResultOrderCallBack(context);
        if (relieveFlag.booleanValue()) {
            businessOrderCallBackService.relieveOverchargeCallBack(context);
        } else {
            businessOrderCallBackService.overchargeAdjustCallBack(context);
        }
    }

    private CsOrderBusinessCallBackContext buildContext(InOutResultOrderEo csInResultOrderEo, List<InOutResultOrderDetailEo> overchargeList) {
        CsOrderBusinessCallBackContext context = new CsOrderBusinessCallBackContext();
        Boolean inFlag = true;
        if ("out".equals(csInResultOrderEo.getOrderType())) {
            inFlag = false;
        }
        context.setInFlag(inFlag);
        context.setRelevanceNo(csInResultOrderEo.getRelevanceNo());
        CsInOutResultRespDto csInOutResultRespDto = new CsInOutResultRespDto();
        CubeBeanUtils.copyProperties((Object)csInOutResultRespDto, (Object)csInResultOrderEo, (String[])new String[0]);
        context.setCsInOutResultRespDto(csInOutResultRespDto);
        ArrayList resultDetailRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultDetailRespDtoList, overchargeList, CsInOutResultDetailRespDto.class);
        csInOutResultRespDto.setInOutResultDetailRespDtoList((List)resultDetailRespDtoList);
        return context;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void overchargeAdjust(CsInPlannedOverchargeAdjustReqDto overchargeAdjustReqDto) {
        logger.info("overchargeAdjust==>\u8d85\u6536/\u53d1\u6570\u636e\u8c03\u6574\u4fdd\u5b58\u63d0\u4ea4,overchargeAdjustReqDto:{}", (Object)LogUtils.buildLogContent(overchargeAdjustReqDto));
        this.checkParams(overchargeAdjustReqDto);
        String inResultDocumentNo = overchargeAdjustReqDto.getInResultDocumentNo();
        QueryWrapper csInResultOrderEoQueryWrapper = new QueryWrapper();
        csInResultOrderEoQueryWrapper.eq((Object)"document_no", (Object)inResultDocumentNo);
        csInResultOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutResultOrderEo csInResultOrderEo = (InOutResultOrderEo)this.inOutResultOrderDomain.getMapper().selectOne((Wrapper)csInResultOrderEoQueryWrapper);
        AssertUtil.isTrue(null != csInResultOrderEo, "\u51fa/\u5165\u5e93\u7ed3\u679c\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        List detailReqDtoList = overchargeAdjustReqDto.getDetailReqDtoList();
        List<String> longCodeList = detailReqDtoList.stream().map(CsInPlannedOverchargeAdjustDetailReqDto::getLongCode).distinct().collect(Collectors.toList());
        List<String> batchList = detailReqDtoList.stream().map(CsInPlannedOverchargeAdjustDetailReqDto::getBatch).distinct().collect(Collectors.toList());
        Map<String, List<InOutResultOrderDetailEo>> outResultOrderDetailEoMap = this.getOtherDocumentResult(inResultDocumentNo, csInResultOrderEo, longCodeList, batchList);
        String inOutNoticeDocumentNo = csInResultOrderEo.getPreOrderNo();
        QueryWrapper InOutNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)inOutNoticeDocumentNo);
        InOutNoticeOrderDetailEoQueryWrapper.in((Object)"init_flag", new Object[]{YesNoEnum.YES.getValue()});
        List InOutNoticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)InOutNoticeOrderDetailEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)InOutNoticeOrderDetailEoList), "\u67e5\u8be2\u4e0d\u5230\u901a\u77e5\u5355\u660e\u7ec6\u4fe1\u606f");
        ArrayList lackBatchList = Lists.newArrayList();
        ArrayList inBatchList = Lists.newArrayList();
        InOutNoticeOrderDetailEoList.forEach(eo -> {
            String batch = eo.getBatch();
            if (StringUtils.isNotBlank((CharSequence)batch)) {
                inBatchList.add(eo);
            } else {
                lackBatchList.add(eo);
            }
        });
        Map lackBatchEoMap = lackBatchList.stream().collect(Collectors.toMap(eo -> eo.getSkuCode(), Function.identity()));
        Map inBatchEoMap = inBatchList.stream().collect(Collectors.toMap(eo -> eo.getSkuCode() + "_" + eo.getBatch(), Function.identity()));
        BigDecimal val = this.buildOverchargeProportion(csInResultOrderEo);
        List adjustDetailReqDtoList = overchargeAdjustReqDto.getDetailReqDtoList();
        for (CsInPlannedOverchargeAdjustDetailReqDto adjustDetailReqDto : adjustDetailReqDtoList) {
            BigDecimal overchargeVal;
            BigDecimal subtract;
            InOutNoticeOrderDetailEo batchEo;
            String key = adjustDetailReqDto.getLongCode() + "_" + adjustDetailReqDto.getBatch();
            String longCode = adjustDetailReqDto.getLongCode();
            BigDecimal planQuantity = BigDecimal.ZERO;
            InOutNoticeOrderDetailEo longCodeEo = (InOutNoticeOrderDetailEo)lackBatchEoMap.get(longCode);
            planQuantity = null != longCodeEo ? longCodeEo.getPlanQuantity() : (null != (batchEo = (InOutNoticeOrderDetailEo)inBatchEoMap.get(key)) ? batchEo.getPlanQuantity() : BigDecimal.ZERO);
            BigDecimal adjustQuantity = adjustDetailReqDto.getAdjustQuantity();
            List<InOutResultOrderDetailEo> outResultOrderDetailEoList = outResultOrderDetailEoMap.get(key);
            BigDecimal currentDoneQuantity = BigDecimal.ZERO;
            BigDecimal reduce = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(outResultOrderDetailEoList)) {
                reduce = outResultOrderDetailEoList.stream().map(InOutResultOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if ((subtract = (currentDoneQuantity = reduce.add(adjustQuantity)).subtract(overchargeVal = planQuantity.multiply(val))).compareTo(BigDecimal.ZERO) <= 0) continue;
            throw new BizException(String.format("\u3010%s\u3011\u8c03\u6574\u6570\u91cf\u4e0d\u5141\u8bb8\u8d85\u51fa\u8d85\u6536\u8303\u56f4", adjustDetailReqDto.getLongCode()));
        }
        Map adjustDetailReqDtoMap = detailReqDtoList.stream().collect(Collectors.toMap(eo -> eo.getLongCode() + "_" + eo.getBatch(), Function.identity()));
        QueryWrapper overQueryWrapper = new QueryWrapper();
        overQueryWrapper.eq((Object)"document_no", (Object)inResultDocumentNo);
        List overEoList = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)overQueryWrapper);
        for (InOutResultOrderDetailEo csInResultOrderDetailEo : overEoList) {
            String key = csInResultOrderDetailEo.getSkuCode() + "_" + csInResultOrderDetailEo.getBatch();
            CsInPlannedOverchargeAdjustDetailReqDto adjustDetailReqDto = (CsInPlannedOverchargeAdjustDetailReqDto)adjustDetailReqDtoMap.get(key);
            if (null == adjustDetailReqDto) continue;
            BigDecimal adjustQuantity = adjustDetailReqDto.getAdjustQuantity();
            csInResultOrderDetailEo.setDoneQuantity(adjustQuantity);
        }
        this.updateInfo2(csInResultOrderEo, overEoList, overchargeAdjustReqDto.getRemark());
    }

    private Map<String, List<InOutResultOrderDetailEo>> getOtherDocumentResult(String inResultDocumentNo, InOutResultOrderEo csInResultOrderEo, List<String> longCodeList, List<String> batchList) {
        QueryWrapper csInResultOrderEoQueryWrapper = new QueryWrapper();
        csInResultOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)csInResultOrderEo.getRelevanceNo());
        csInResultOrderEoQueryWrapper.eq((Object)"order_type", (Object)csInResultOrderEo.getOrderType());
        csInResultOrderEoQueryWrapper.notIn((Object)"document_no", new Object[]{inResultDocumentNo});
        List otherResultList = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)csInResultOrderEoQueryWrapper);
        Map<Object, Object> outResultOrderDetailEoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)otherResultList)) {
            List otherDocument = otherResultList.stream().map(InOutResultOrderEo::getDocumentNo).collect(Collectors.toList());
            QueryWrapper csOutResultOrderDetailEoQueryWrapper = new QueryWrapper();
            csOutResultOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
            csOutResultOrderDetailEoQueryWrapper.in((Object)"batch", batchList);
            csOutResultOrderDetailEoQueryWrapper.in((Object)"sku_code", longCodeList);
            csOutResultOrderDetailEoQueryWrapper.eq((Object)"relevance_no", (Object)csInResultOrderEo.getRelevanceNo());
            csOutResultOrderDetailEoQueryWrapper.in((Object)"document_no", otherDocument);
            List csOutResultOrderDetailEoList = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)csOutResultOrderDetailEoQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)csOutResultOrderDetailEoList)) {
                outResultOrderDetailEoMap = csOutResultOrderDetailEoList.stream().collect(Collectors.groupingBy(eo -> eo.getSkuCode() + "_" + eo.getBatch()));
            }
        }
        return outResultOrderDetailEoMap;
    }

    protected BigDecimal buildOverchargeProportion(InOutResultOrderEo csInResultOrderEo) {
        String relevanceTableName = csInResultOrderEo.getRelevanceTableName();
        String orderType = csInResultOrderEo.getOrderType();
        String relevanceNo = csInResultOrderEo.getRelevanceNo();
        if (!CsRelevanceTableNameEnum.CS_IN_PLANNED_ORDER.getCode().equals(relevanceTableName)) {
            return BigDecimal.ONE;
        }
        if (!"in".equals(orderType)) {
            return BigDecimal.ONE;
        }
        String plannedOrderType = this.getPlannedOrderType(relevanceNo);
        String code = DictEnum.PURCHASE_ORDER_RATIO.getCode();
        if (CsPlannedOrderTypeEnum.PRODUCTION.getCode().equals(plannedOrderType)) {
            code = DictEnum.PRODUCTION_ORDER_RATIO.getCode();
        } else if (CsPlannedOrderTypeEnum.OUTSOURCE.getCode().equals(plannedOrderType)) {
            code = DictEnum.OUT_SOURCED_ORDER_RATIO.getCode();
        }
        try {
            logger.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,GROUP_CODE:{},code:{}", (Object)DictEnum.PURCHASE_ORDER_RATIO.getGroupCode(), (Object)code);
            DictDto dictDto = this.pcpDictApiProxy.queryByGroupCodeAndCode(DictEnum.PURCHASE_ORDER_RATIO.getGroupCode(), code);
            logger.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,dictDto:{}", (Object)LogUtils.buildLogContent(dictDto));
            AssertUtil.isTrue(null != dictDto, "\u8ba1\u5212\u5165\u5355\u636e\u7c7b\u672a\u914d\u7f6e\u8d85\u6536\u6bd4\u4f8b\u4fe1\u606f");
            if (null == dictDto) {
                return this.overchargeProportion;
            }
            String value = dictDto.getValue();
            Integer intVal = Integer.valueOf(value);
            BigDecimal decimalVal = new BigDecimal(intVal).divide(new BigDecimal(100));
            this.overchargeProportion = decimalVal.add(BigDecimal.ONE);
            logger.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,\u57fa\u7840\u6570\u636e\u4e2d\u5fc3\u8ba1\u7b97\u4e4b\u540e\u7684,overchargeProportion:{}", (Object)this.overchargeProportion);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.overchargeProportion;
    }

    private String getPlannedOrderType(String relevanceNo) {
        QueryWrapper csInPlannedOrderEoQueryWrapper = new QueryWrapper();
        csInPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csInPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)relevanceNo);
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)csInPlannedOrderEoQueryWrapper);
        AssertUtil.isTrue(null != csInPlannedOrderEo, "\u67e5\u8be2\u4e0d\u5230\u8ba1\u5212\u5355\u636e\u4fe1\u606f");
        return csInPlannedOrderEo.getOrderType();
    }

    @Override
    public void updateInventoryFoyPlannedOrder(CsInPlannedOrderEo csInPlannedOrderEo, String inResultOrderDocumentNo, CsOrderBusinessCallBackContext callBackContext) {
        logger.info("updateInventoryFoyPlannedOrder==>\u5e93\u5b58\u64cd\u4f5c,\u66f4\u65b0\u5e93\u5b58,csInPlannedOrderEo:{},inResultOrderDocumentNo:{}", (Object)LogUtils.buildLogContent(inResultOrderDocumentNo), (Object)inResultOrderDocumentNo);
    }

    @Override
    public void closedOrder(CsInPlannedOrderClosedReqDto closedReqDto) {
        QueryWrapper csInPlannedOrderEoQueryWrapper = new QueryWrapper();
        csInPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)closedReqDto.getOrderNo());
        csInPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)csInPlannedOrderEoQueryWrapper);
        AssertUtil.isTrue(null != csInPlannedOrderEo, "\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        csInPlannedOrderEo.setClosedFlag(closedReqDto.getClosedFlag());
        csInPlannedOrderEo.setClosedTime(closedReqDto.getClosedTime());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)csInPlannedOrderEo.getId());
        this.csInPlannedOrderMapper.update((Object)csInPlannedOrderEo, (Wrapper)updateWrapper);
    }

    private List<String> getChannelWarehouseCode(String logicWarehouseCode) {
        QueryWrapper csRelWarehouseEoQueryWrapper = new QueryWrapper();
        csRelWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csRelWarehouseEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseCode);
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.CHANNEL.getCode());
        List csRelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)csRelWarehouseEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csRelWarehouseEoList)) {
            return Lists.newArrayList();
        }
        return csRelWarehouseEoList.stream().map(RelWarehouseEo::getRefWarehouseCode).collect(Collectors.toList());
    }

    private void checkParams(CsInPlannedOverchargeAdjustReqDto overchargeAdjustReqDto) {
        AssertUtil.isTrue(null != overchargeAdjustReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String inResultDocumentNo = overchargeAdjustReqDto.getInResultDocumentNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inResultDocumentNo), "\u5165\u5e93\u7ed3\u679c\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List detailReqDtoList = overchargeAdjustReqDto.getDetailReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)detailReqDtoList), "\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsInPlannedOverchargeAdjustDetailReqDto detailReqDto : detailReqDtoList) {
            String batch = detailReqDto.getBatch();
            String longCode = detailReqDto.getLongCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)batch), "\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)longCode), "\u5546\u54c1\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal adjustQuantity = detailReqDto.getAdjustQuantity();
            AssertUtil.isTrue(null != adjustQuantity && adjustQuantity.compareTo(BigDecimal.ZERO) >= 0, "\u8c03\u6574\u6570\u91cf\u53c2\u6570\u6709\u8bef");
        }
    }

    private ReceiveDeliveryResultOrderEo generateReceiveResultInfo(InOutResultOrderEo csInResultOrderEo, List<InOutResultOrderDetailEo> csInResultOrderDetailEoList, CsOrderBusinessCallBackContext context) {
        String orderType = csInResultOrderEo.getOrderType();
        QueryWrapper csInResultOrderDetailEoQueryWrapper = new QueryWrapper();
        csInResultOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)csInResultOrderEo.getDocumentNo());
        csInResultOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List queryCsInResultEoList = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)csInResultOrderDetailEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)queryCsInResultEoList), "\u6536\u5165\u5e93\u7ed3\u679c\u5355\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        QueryWrapper csReceiveNoticeOrderEoQueryWrapper = new QueryWrapper();
        csReceiveNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)csInResultOrderEo.getRelevanceNo());
        csReceiveNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csReceiveNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)("in".equals(csInResultOrderEo.getOrderType()) ? "receive" : "delivery"));
        List deliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)csReceiveNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderEoList), "\u6536\u8d27\u901a\u77e5\u5355\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        ReceiveDeliveryNoticeOrderEo csReceiveNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)deliveryNoticeOrderEoList.get(0);
        ReceiveDeliveryResultOrderEo csReceiveResultOrderEo = new ReceiveDeliveryResultOrderEo();
        BigDecimal totalQuantity = queryCsInResultEoList.stream().map(InOutResultOrderDetailEo::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.RECEIVE_RESULT_ORDER.getCode());
        String documentNo = generateCodeService.getCode();
        csReceiveResultOrderEo.setDocumentNo(documentNo);
        csReceiveResultOrderEo.setWmsOrderNo(csInResultOrderEo.getWmsOrderNo());
        csReceiveResultOrderEo.setRelevanceNo(csInResultOrderEo.getRelevanceNo());
        csReceiveResultOrderEo.setPreOrderNo(csInResultOrderEo.getDocumentNo());
        csReceiveResultOrderEo.setExternalOrderNo(csInResultOrderEo.getExternalOrderNo());
        csReceiveResultOrderEo.setBusinessType(csInResultOrderEo.getBusinessType());
        csReceiveResultOrderEo.setOrderType("receive");
        csReceiveResultOrderEo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_IN_PLANNED_ORDER.getCode());
        csReceiveResultOrderEo.setOrderStatus(BaseOrderStatusEnum.RRO_RECEIVED.getCode());
        csReceiveResultOrderEo.setReceiveLogicWarehouseCode(csReceiveNoticeOrderEo.getReceiveLogicWarehouseCode());
        csReceiveResultOrderEo.setReceiveLogicWarehouseName(csReceiveNoticeOrderEo.getReceiveLogicWarehouseName());
        csReceiveResultOrderEo.setReceivePhysicsWarehouseCode(csReceiveNoticeOrderEo.getReceivePhysicsWarehouseCode());
        csReceiveResultOrderEo.setReceivePhysicsWarehouseName(csReceiveNoticeOrderEo.getReceivePhysicsWarehouseName());
        if ("out".equals(orderType)) {
            csReceiveResultOrderEo.setOrderType("delivery");
            csReceiveResultOrderEo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_OUT_PLANNED_ORDER.getCode());
            csReceiveResultOrderEo.setOrderStatus(BaseOrderStatusEnum.DRO_DELIVERED.getCode());
            csReceiveResultOrderEo.setDeliveryLogicWarehouseCode(csReceiveNoticeOrderEo.getDeliveryLogicWarehouseCode());
            csReceiveResultOrderEo.setDeliveryLogicWarehouseName(csReceiveNoticeOrderEo.getDeliveryLogicWarehouseName());
            csReceiveResultOrderEo.setDeliveryPhysicsWarehouseCode(csReceiveNoticeOrderEo.getDeliveryPhysicsWarehouseCode());
            csReceiveResultOrderEo.setDeliveryPhysicsWarehouseName(csReceiveNoticeOrderEo.getDeliveryPhysicsWarehouseName());
        }
        csReceiveResultOrderEo.setWarehouseId(csReceiveNoticeOrderEo.getWarehouseId());
        csReceiveResultOrderEo.setWarehouseCode(csReceiveNoticeOrderEo.getWarehouseCode());
        csReceiveResultOrderEo.setWarehouseName(csReceiveNoticeOrderEo.getWarehouseName());
        csReceiveResultOrderEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        csReceiveResultOrderEo.setTotalQuantity(totalQuantity);
        csReceiveResultOrderEo.setShippingCompanyCode(csInResultOrderEo.getShippingCompanyCode());
        csReceiveResultOrderEo.setShippingCompany(csInResultOrderEo.getShippingCompany());
        csReceiveResultOrderEo.setShippingCode(csInResultOrderEo.getShippingCode());
        logger.info("generateReceiveResultInfo==>\u751f\u6210\u6536\u8d27\u7ed3\u679c\u5355,csReceiveResultOrderEo:{}", (Object)LogUtils.buildLogContent(csReceiveResultOrderEo));
        this.receiveDeliveryResultOrderDomain.insert((BaseEo)csReceiveResultOrderEo);
        ArrayList insertEoList = Lists.newArrayList();
        for (InOutResultOrderDetailEo csOutResultOrderDetailEo : queryCsInResultEoList) {
            ReceiveDeliveryResultOrderDetailEo csReceiveResultOrderDetailEo = new ReceiveDeliveryResultOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)csReceiveResultOrderDetailEo, (Object)csOutResultOrderDetailEo, (String[])new String[0]);
            csReceiveResultOrderDetailEo.setDocumentNo(documentNo);
            csReceiveResultOrderDetailEo.setRelevanceNo(csInResultOrderEo.getRelevanceNo());
            csReceiveResultOrderDetailEo.setPreOrderNo(csInResultOrderEo.getDocumentNo());
            csReceiveResultOrderDetailEo.setExternalOrderNo(csInResultOrderEo.getExternalOrderNo());
            csReceiveResultOrderDetailEo.setWmsOrderNo(csInResultOrderEo.getWmsOrderNo());
            csReceiveResultOrderDetailEo.setId(null);
            insertEoList.add(csReceiveResultOrderDetailEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)insertEoList)) {
            this.receiveDeliveryResultOrderDetailDomain.insertBatch((List)insertEoList);
        }
        CsDeliveryReceiveResultRespDto csDeliveryReceiveResultRespDto = new CsDeliveryReceiveResultRespDto();
        CubeBeanUtils.copyProperties((Object)csDeliveryReceiveResultRespDto, (Object)csReceiveResultOrderEo, (String[])new String[0]);
        ArrayList deliveryReceiveResultDetailRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)deliveryReceiveResultDetailRespDtoList, (Collection)insertEoList, CsDeliveryReceiveResultDetailRespDto.class);
        context.setDeliveryReceiveResultOrderNo(csReceiveResultOrderEo.getDocumentNo());
        context.setCsDeliveryReceiveResultRespDto(csDeliveryReceiveResultRespDto);
        csDeliveryReceiveResultRespDto.setDeliveryReceiveResultDetailRespDtoList((List)deliveryReceiveResultDetailRespDtoList);
        return csReceiveResultOrderEo;
    }

    private void updateReceiveNoticeInfo(InOutResultOrderEo csInResultOrderEo, List<InOutResultOrderDetailEo> csInResultOrderDetailEoList, Boolean relieveFlag, String documentNo) {
        String orderType = csInResultOrderEo.getOrderType();
        Map inResultOrderDetailEoMap = csInResultOrderDetailEoList.stream().collect(Collectors.toMap(eo -> eo.getSkuCode() + "_" + eo.getBatch(), Function.identity()));
        Map<String, List<InOutResultOrderDetailEo>> outResultEoMap = csInResultOrderDetailEoList.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode));
        List longCodeList = csInResultOrderDetailEoList.stream().map(InOutResultOrderDetailEo::getSkuCode).distinct().collect(Collectors.toList());
        QueryWrapper csReceiveNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        csReceiveNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        csReceiveNoticeOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csReceiveNoticeOrderDetailEoQueryWrapper.in((Object)"sku_code", longCodeList);
        List csReceiveNoticeOrderDetailEoList = this.receiveDeliveryNoticeOrderDetailDomain.getMapper().selectList((Wrapper)csReceiveNoticeOrderDetailEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csReceiveNoticeOrderDetailEoList)) {
            return;
        }
        boolean allReceiveDelivery = true;
        QueryWrapper updateWrapper = new QueryWrapper();
        for (ReceiveDeliveryNoticeOrderDetailEo csReceiveNoticeOrderDetailEo : csReceiveNoticeOrderDetailEoList) {
            Integer initFlag = csReceiveNoticeOrderDetailEo.getInitFlag();
            String longCode = csReceiveNoticeOrderDetailEo.getSkuCode();
            String batch = csReceiveNoticeOrderDetailEo.getBatch();
            if (YesNoEnum.YES.getValue().equals(initFlag)) {
                List<InOutResultOrderDetailEo> csOutResultOrderDetailEoList = outResultEoMap.get(longCode);
                if (CollectionUtils.isEmpty(csOutResultOrderDetailEoList)) continue;
                BigDecimal nowDoneQuantity = csOutResultOrderDetailEoList.stream().map(e -> e.getDoneQuantity()).reduce(BigDecimal::add).get();
                allReceiveDelivery = this.isAllReceiveDelivery(relieveFlag, allReceiveDelivery, csReceiveNoticeOrderDetailEo, nowDoneQuantity);
            } else {
                String key = longCode + "_" + batch;
                InOutResultOrderDetailEo orderDetailEo = (InOutResultOrderDetailEo)inResultOrderDetailEoMap.get(key);
                if (null == orderDetailEo) continue;
                allReceiveDelivery = this.isAllReceiveDelivery(relieveFlag, allReceiveDelivery, csReceiveNoticeOrderDetailEo, orderDetailEo.getDoneQuantity());
            }
            csReceiveNoticeOrderDetailEo.setItemStatus(CsPlannedOrderItemStatusEnum.RELIEVE.getCode());
            updateWrapper.eq((Object)"id", (Object)csReceiveNoticeOrderDetailEo.getId());
            this.receiveDeliveryNoticeOrderDetailDomain.getMapper().update((Object)csReceiveNoticeOrderDetailEo, (Wrapper)updateWrapper);
            updateWrapper.clear();
        }
        QueryWrapper csReceiveNoticeOrderEoQueryWrapper = new QueryWrapper();
        csReceiveNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        csReceiveNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        ReceiveDeliveryNoticeOrderEo csReceiveNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)this.receiveDeliveryNoticeOrderDomain.getMapper().selectOne((Wrapper)csReceiveNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(null != csReceiveNoticeOrderEo, "\u6536\u8d27\u901a\u77e5\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        csReceiveNoticeOrderEo.setOrderStatus(allReceiveDelivery ? BaseOrderStatusEnum.RNO_TOTAL_RECEIVE.getCode() : BaseOrderStatusEnum.RNO_PORTION_RECEIVE.getCode());
        if ("out".equals(orderType)) {
            csReceiveNoticeOrderEo.setOrderStatus(allReceiveDelivery ? BaseOrderStatusEnum.DNO_TOTAL_DELIVERY.getCode() : BaseOrderStatusEnum.DNO_PORTION_DELIVERY.getCode());
        }
        csReceiveNoticeOrderEoQueryWrapper.clear();
        csReceiveNoticeOrderEoQueryWrapper.eq((Object)"id", (Object)csReceiveNoticeOrderEo.getId());
        this.receiveDeliveryNoticeOrderDomain.getMapper().update((Object)csReceiveNoticeOrderEo, (Wrapper)csReceiveNoticeOrderEoQueryWrapper);
    }

    private String updateInNoticeInfo(InOutResultOrderEo csInResultOrderEo, List<InOutResultOrderDetailEo> csInResultOrderDetailEoList, Boolean relieveFlag) {
        String orderType = csInResultOrderEo.getOrderType();
        Map inResultOrderDetailEoMap = csInResultOrderDetailEoList.stream().collect(Collectors.toMap(eo -> eo.getSkuCode() + "_" + eo.getBatch(), Function.identity()));
        Map<String, List<InOutResultOrderDetailEo>> outResultEoMap = csInResultOrderDetailEoList.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode));
        List longCodeList = csInResultOrderDetailEoList.stream().map(InOutResultOrderDetailEo::getSkuCode).distinct().collect(Collectors.toList());
        QueryWrapper csInNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        csInNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)csInResultOrderEo.getPreOrderNo());
        csInNoticeOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csInNoticeOrderDetailEoQueryWrapper.in((Object)"sku_code", longCodeList);
        List csInNoticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)csInNoticeOrderDetailEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csInNoticeOrderDetailEoList)) {
            return null;
        }
        boolean allInOut = true;
        QueryWrapper updateWrapper = new QueryWrapper();
        for (InOutNoticeOrderDetailEo csInNoticeOrderDetailEo : csInNoticeOrderDetailEoList) {
            Integer initFlag = csInNoticeOrderDetailEo.getInitFlag();
            String longCode = csInNoticeOrderDetailEo.getSkuCode();
            String batch = csInNoticeOrderDetailEo.getBatch();
            if (YesNoEnum.YES.getValue().equals(initFlag)) {
                List<InOutResultOrderDetailEo> csOutResultOrderDetailEoList = outResultEoMap.get(longCode);
                if (CollectionUtils.isEmpty(csOutResultOrderDetailEoList)) continue;
                BigDecimal nowDoneQuantity = csOutResultOrderDetailEoList.stream().map(e -> e.getDoneQuantity()).reduce(BigDecimal::add).get();
                allInOut = this.isAllInOut(relieveFlag, allInOut, csInNoticeOrderDetailEo, nowDoneQuantity);
            } else {
                String key = longCode + "_" + batch;
                InOutResultOrderDetailEo orderDetailEo = (InOutResultOrderDetailEo)inResultOrderDetailEoMap.get(key);
                if (null == orderDetailEo) continue;
                allInOut = this.isAllInOut(relieveFlag, allInOut, csInNoticeOrderDetailEo, orderDetailEo.getDoneQuantity());
            }
            csInNoticeOrderDetailEo.setItemStatus(CsPlannedOrderItemStatusEnum.RELIEVE.getCode());
            updateWrapper.eq((Object)"id", (Object)csInNoticeOrderDetailEo.getId());
            this.inOutNoticeOrderDetailDomain.getMapper().update((Object)csInNoticeOrderDetailEo, (Wrapper)updateWrapper);
            updateWrapper.clear();
        }
        QueryWrapper inNoticeOrderEoQueryWrapper = new QueryWrapper();
        inNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)csInResultOrderEo.getPreOrderNo());
        inNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutNoticeOrderEo csInNoticeOrderEo = (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.getMapper().selectOne((Wrapper)inNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(null != csInNoticeOrderEo, "\u5165\u5e93\u901a\u77e5\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        csInNoticeOrderEo.setOrderStatus(allInOut ? BaseOrderStatusEnum.INO_TOTAL_IN.getCode() : BaseOrderStatusEnum.INO_PORTION_IN.getCode());
        if ("out".equals(orderType)) {
            csInResultOrderEo.setOrderStatus(allInOut ? BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode() : BaseOrderStatusEnum.ONO_PORTION_OUT.getCode());
        }
        inNoticeOrderEoQueryWrapper.clear();
        inNoticeOrderEoQueryWrapper.eq((Object)"id", (Object)csInNoticeOrderEo.getId());
        this.inOutNoticeOrderDomain.getMapper().update((Object)csInNoticeOrderEo, (Wrapper)inNoticeOrderEoQueryWrapper);
        return csInNoticeOrderEo.getPreOrderNo();
    }

    private boolean isAllInOut(Boolean relieveFlag, boolean allInOut, InOutNoticeOrderDetailEo csInNoticeOrderDetailEo, BigDecimal nowDoneQuantity) {
        if (relieveFlag.booleanValue()) {
            csInNoticeOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
        } else {
            BigDecimal doneQuantity = Objects.isNull(csInNoticeOrderDetailEo.getDoneQuantity()) ? BigDecimal.ZERO : csInNoticeOrderDetailEo.getDoneQuantity();
            BigDecimal newDoneQuantity = doneQuantity.add(nowDoneQuantity);
            csInNoticeOrderDetailEo.setDoneQuantity(newDoneQuantity.compareTo(csInNoticeOrderDetailEo.getPlanQuantity()) > 0 ? csInNoticeOrderDetailEo.getPlanQuantity() : newDoneQuantity);
            BigDecimal waitQuantity = csInNoticeOrderDetailEo.getPlanQuantity().subtract(csInNoticeOrderDetailEo.getDoneQuantity());
            csInNoticeOrderDetailEo.setWaitQuantity(waitQuantity);
            boolean allInOut1 = BigDecimal.ZERO.compareTo(waitQuantity) >= 0;
            allInOut = allInOut1 && allInOut;
        }
        return allInOut;
    }

    private boolean isAllReceiveDelivery(Boolean relieveFlag, boolean allReceiveDelivery, ReceiveDeliveryNoticeOrderDetailEo csInNoticeOrderDetailEo, BigDecimal nowDoneQuantity) {
        if (relieveFlag.booleanValue()) {
            csInNoticeOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
        } else {
            BigDecimal doneQuantity = Objects.isNull(csInNoticeOrderDetailEo.getDoneQuantity()) ? BigDecimal.ZERO : csInNoticeOrderDetailEo.getDoneQuantity();
            BigDecimal newDoneQuantity = doneQuantity.add(nowDoneQuantity);
            csInNoticeOrderDetailEo.setDoneQuantity(newDoneQuantity.compareTo(csInNoticeOrderDetailEo.getPlanQuantity()) > 0 ? csInNoticeOrderDetailEo.getPlanQuantity() : newDoneQuantity);
            BigDecimal waitQuantity = csInNoticeOrderDetailEo.getPlanQuantity().subtract(csInNoticeOrderDetailEo.getDoneQuantity());
            csInNoticeOrderDetailEo.setWaitQuantity(waitQuantity);
            boolean allReceiveDelivery1 = BigDecimal.ZERO.compareTo(waitQuantity) >= 0;
            allReceiveDelivery = allReceiveDelivery1 && allReceiveDelivery;
        }
        return allReceiveDelivery;
    }

    private void updateInResultInfo(InOutResultOrderEo csInResultOrderEo, List<InOutResultOrderDetailEo> csInResultOrderDetailEoList, Boolean relieveFlag, String remark) {
        String orderType = csInResultOrderEo.getOrderType();
        QueryWrapper updateWrapper = new QueryWrapper();
        BigDecimal totalQuantity = BigDecimal.ZERO;
        for (InOutResultOrderDetailEo originalDetailEo : csInResultOrderDetailEoList) {
            if (!relieveFlag.booleanValue()) {
                originalDetailEo.setPlanQuantity(originalDetailEo.getDoneQuantity());
            }
            originalDetailEo.setWaitQuantity(originalDetailEo.getPlanQuantity().subtract(originalDetailEo.getDoneQuantity()));
            originalDetailEo.setQuantity(originalDetailEo.getDoneQuantity());
            totalQuantity = totalQuantity.add(originalDetailEo.getQuantity());
            originalDetailEo.setItemStatus(CsPlannedOrderItemStatusEnum.RELIEVE.getCode());
            updateWrapper.eq((Object)"id", (Object)originalDetailEo.getId());
            this.inOutResultOrderDetailDomain.getMapper().update((Object)originalDetailEo, (Wrapper)updateWrapper);
            updateWrapper.clear();
        }
        QueryWrapper csInResultOrderEoQueryWrapper = new QueryWrapper();
        csInResultOrderEoQueryWrapper.eq((Object)"id", (Object)csInResultOrderEo.getId());
        csInResultOrderEo.setOrderStatus(BaseOrderStatusEnum.IRO_DONE_IN.getCode());
        if ("out".equals(orderType)) {
            csInResultOrderEo.setOrderStatus(BaseOrderStatusEnum.ORO_DONE_OUT.getCode());
        }
        csInResultOrderEo.setRemark(remark);
        this.inOutResultOrderDomain.getMapper().update((Object)csInResultOrderEo, (Wrapper)csInResultOrderEoQueryWrapper);
    }

    private void auditFailedOrder(CsInPlannedOrderAuditReqDto plannedOrderAuditReqDto, CsInPlannedOrderEo csInPlannedOrderEo) {
        logger.info("auditPassFailedOrder==>\u5ba1\u6838\u4e0d\u901a\u8fc7,plannedOrderAuditReqDto:{},csInPlannedOrderEo:{}", (Object)LogUtils.buildLogContent(plannedOrderAuditReqDto), (Object)LogUtils.buildLogContent(csInPlannedOrderEo));
        csInPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.AUDIT_FAILED.getCode());
        csInPlannedOrderEo.setRemark(plannedOrderAuditReqDto.getRemark());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)csInPlannedOrderEo.getId());
        this.csInPlannedOrderMapper.update((Object)csInPlannedOrderEo, (Wrapper)updateWrapper);
        this.auditPlannedOrderResult(plannedOrderAuditReqDto, csInPlannedOrderEo);
    }

    private void auditPassPlannedOrder(CsInPlannedOrderAuditReqDto plannedOrderAuditReqDto, CsInPlannedOrderEo csInPlannedOrderEo, List<CsInPlannedOrderDetailEo> orderDetailEoList) {
        logger.info("auditPassPlannedOrder==>\u5ba1\u6838\u901a\u8fc7,plannedOrderAuditReqDto:{},csInPlannedOrderEo:{}", (Object)LogUtils.buildLogContent(plannedOrderAuditReqDto), (Object)LogUtils.buildLogContent(csInPlannedOrderEo));
        csInPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.WAIT_IN.getCode());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)csInPlannedOrderEo.getId());
        this.csInPlannedOrderMapper.update((Object)csInPlannedOrderEo, (Wrapper)updateWrapper);
        this.auditPlannedOrderResult(plannedOrderAuditReqDto, csInPlannedOrderEo);
        this.generateDeliveryNoticeOrder(csInPlannedOrderEo, orderDetailEoList);
    }

    private void generateDeliveryNoticeOrder(final CsInPlannedOrderEo csInPlannedOrderEo, List<CsInPlannedOrderDetailEo> orderDetailEoList) {
        logger.info("generateDeliveryNoticeOrder==>\u8ba1\u5212\u5355\u636e(\u91c7\u8d2d\u3001\u751f\u4ea7\u3001\u59d4\u5916)\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,orderNo:{}", (Object)csInPlannedOrderEo.getOrderNo());
        ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        receiveDeliveryNoticeOrderFacadeBo.setPreOrderNo(csInPlannedOrderEo.getPlatformOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setExternalOrderNo(csInPlannedOrderEo.getPlatformOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceNo(csInPlannedOrderEo.getOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setBusinessType(csInPlannedOrderEo.getBusinessType());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_IN_PLANNED_ORDER);
        receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseCode(csInPlannedOrderEo.getReceiveWarehouseCode());
        receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseName(csInPlannedOrderEo.getReceiveWarehouseName());
        receiveDeliveryNoticeOrderFacadeBo.setSourceType(csInPlannedOrderEo.getBusinessType());
        receiveDeliveryNoticeOrderFacadeBo.setExtension(csInPlannedOrderEo.getExtension());
        receiveDeliveryNoticeOrderFacadeBo.setRemark(csInPlannedOrderEo.getRemark());
        String logicWarehouseCode = csInPlannedOrderEo.getReceiveWarehouseCode();
        RelWarehouseEo csRelWarehouseEo = (RelWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)logicWarehouseCode)).eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode())).eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode())).eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode())).one();
        logger.info("generateReceiveOrderInfo==>csRelWarehouseEo:{}", (Object)LogUtils.buildLogContent(csRelWarehouseEo));
        if (null != csRelWarehouseEo) {
            receiveDeliveryNoticeOrderFacadeBo.setPhysicsWarehouseCode(csRelWarehouseEo.getRefWarehouseCode());
            receiveDeliveryNoticeOrderFacadeBo.setPhysicsWarehouseName(csRelWarehouseEo.getRefWarehouseName());
        }
        ArrayList<BaseOrderDetailReqDto> deliveryDetailList = new ArrayList<BaseOrderDetailReqDto>(orderDetailEoList.size());
        for (CsInPlannedOrderDetailEo detail : orderDetailEoList) {
            BaseOrderDetailReqDto basic = new BaseOrderDetailReqDto();
            basic.setSkuCode(detail.getLongCode());
            basic.setSkuName(detail.getCargoName());
            basic.setQuantity(detail.getPlanQuantity());
            basic.setBatch(detail.getBatch());
            basic.setExpireTime(detail.getExpireTime());
            basic.setProduceTime(detail.getProduceTime());
            basic.setExtension(detail.getExtension());
            basic.setPreOrderItemId(detail.getId());
            deliveryDetailList.add(basic);
        }
        receiveDeliveryNoticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(deliveryDetailList);
        receiveDeliveryNoticeOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                context.setTransparentCallback(Boolean.valueOf(true));
                if (context instanceof ReceiveDeliveryNoticeOrderContext) {
                    ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = ((ReceiveDeliveryNoticeOrderContext)context).getReceiveDeliveryNoticeOrderEo();
                    receiveDeliveryNoticeOrderEo.setExtension(csInPlannedOrderEo.getExtension());
                }
            }

            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        this.baseOrderFacade.receiveNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
    }

    private void buildWarehouseInfo(ReceiveDeliveryNoticeOrderEo csReceiveNoticeOrderEo) {
        String logicWarehouseCode = csReceiveNoticeOrderEo.getWarehouseCode();
        QueryWrapper csRelWarehouseEoQueryWrapper = new QueryWrapper();
        csRelWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseCode);
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        List csRelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)csRelWarehouseEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csRelWarehouseEoList), "\u672a\u67e5\u8be2\u5230\u5173\u8054\u7269\u7406\u4ed3\u4fe1\u606f");
        RelWarehouseEo csRelWarehouseEo = (RelWarehouseEo)csRelWarehouseEoList.get(0);
        csReceiveNoticeOrderEo.setReceiveLogicWarehouseCode(csReceiveNoticeOrderEo.getWarehouseCode());
        csReceiveNoticeOrderEo.setReceiveLogicWarehouseName(csReceiveNoticeOrderEo.getWarehouseName());
        csReceiveNoticeOrderEo.setReceivePhysicsWarehouseCode(csRelWarehouseEo.getRefWarehouseCode());
        csReceiveNoticeOrderEo.setReceivePhysicsWarehouseName(csRelWarehouseEo.getRefWarehouseName());
    }

    private void auditPlannedOrderResult(CsInPlannedOrderAuditReqDto plannedOrderAuditReqDto, CsInPlannedOrderEo csInPlannedOrderEo) {
        CsPlannedOrderAuditEo csPlannedOrderAuditEo = new CsPlannedOrderAuditEo();
        csPlannedOrderAuditEo.setPlatformOrderNo(csInPlannedOrderEo.getPlatformOrderNo());
        csPlannedOrderAuditEo.setOrderNo(csInPlannedOrderEo.getOrderNo());
        csPlannedOrderAuditEo.setOrderType(csInPlannedOrderEo.getOrderType());
        csPlannedOrderAuditEo.setBusinessType(csInPlannedOrderEo.getBusinessType());
        csPlannedOrderAuditEo.setAuditResult(plannedOrderAuditReqDto.getAuditResult());
        csPlannedOrderAuditEo.setRemark(plannedOrderAuditReqDto.getRemark());
        csPlannedOrderAuditEo.setAuditUserId(Long.valueOf(null == this.context.userId() ? -1L : this.context.userId()));
        csPlannedOrderAuditEo.setAuditUserName(null == this.context.userName() ? "-1" : this.context.userName());
        csPlannedOrderAuditEo.setUpdateTime(new Date());
        csPlannedOrderAuditEo.setCreateTime(new Date());
        csPlannedOrderAuditEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        csPlannedOrderAuditEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        csPlannedOrderAuditEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        csPlannedOrderAuditEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        this.csPlannedOrderAuditMapper.insert((Object)csPlannedOrderAuditEo);
    }

    private void checkParams(CsInPlannedOrderAuditReqDto plannedOrderAuditReqDto) {
        AssertUtil.isTrue(null != plannedOrderAuditReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String orderNo = plannedOrderAuditReqDto.getOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u5ba1\u6838\u5355\u636e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String auditResult = plannedOrderAuditReqDto.getAuditResult();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)auditResult) && null != CsPlannedOrderAuditResultEnum.getByCode((String)auditResult), "\u5ba1\u6838\u7ed3\u679c\u53c2\u6570\u6709\u8bef");
    }

    private String generateCode(String orderType) {
        IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(orderType);
        String code = generateCodeService.getCode();
        return code;
    }

    private void checkParams(CsInPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        List platformList;
        AssertUtil.isTrue(null != plannedOrderGenerateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String operateFlag = plannedOrderGenerateReqDto.getOperateFlag();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)operateFlag) && null != CsPlannedOrderOperateEnum.getByCode((String)operateFlag), "\u64cd\u4f5c\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        String orderType = plannedOrderGenerateReqDto.getOrderType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderType) && null != CsPlannedOrderTypeEnum.getByCode((String)orderType), "\u5355\u636e\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        String businessType = plannedOrderGenerateReqDto.getBusinessType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)businessType) && null != CsPlannedOrderBusinessTypeEnum.getByCode((String)businessType), "\u4e1a\u52a1\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        String warehouseCode = plannedOrderGenerateReqDto.getWarehouseCode();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseCode), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper csLogicWarehouseEoQueryWrapper = new QueryWrapper();
        csLogicWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        csLogicWarehouseEoQueryWrapper.eq((Object)"warehouse_status", (Object)CsLogicWarehouseStatusEnum.ENABLE.getCode());
        csLogicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectOne((Wrapper)csLogicWarehouseEoQueryWrapper);
        AssertUtil.isTrue(null != csLogicWarehouseEo, "\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
        plannedOrderGenerateReqDto.setWarehouseId(csLogicWarehouseEo.getId());
        plannedOrderGenerateReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
        plannedOrderGenerateReqDto.setOrganizationId(csLogicWarehouseEo.getOrganizationId());
        plannedOrderGenerateReqDto.setOrganizationName(csLogicWarehouseEo.getOrganizationName());
        String supplierCode = plannedOrderGenerateReqDto.getSupplierCode();
        if (StringUtils.isNotBlank((CharSequence)supplierCode)) {
            QueryWrapper csInventorySupplierEoQueryWrapper = new QueryWrapper();
            csInventorySupplierEoQueryWrapper.eq((Object)"supplier_code", (Object)supplierCode);
            csInventorySupplierEoQueryWrapper.eq((Object)"status", (Object)YesNoEnum.YES.getValue());
            csInventorySupplierEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
            CsInventorySupplierEo csInventorySupplierEo = (CsInventorySupplierEo)this.csInventorySupplierMapper.selectOne((Wrapper)csInventorySupplierEoQueryWrapper);
            AssertUtil.isTrue(null != csInventorySupplierEo, "\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u5b58\u5728");
            plannedOrderGenerateReqDto.setSupplierId(csInventorySupplierEo.getId());
            plannedOrderGenerateReqDto.setSupplierName(csInventorySupplierEo.getSupplierName());
        }
        List itemDetailList = plannedOrderGenerateReqDto.getItemDetailList();
        itemDetailList.forEach(dto -> {
            String longCode = dto.getLongCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)longCode), "\u5546\u54c1\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal planQuantity = dto.getPlanQuantity();
            AssertUtil.isTrue(null != planQuantity && planQuantity.compareTo(BigDecimal.ZERO) > 0, "\u5546\u54c1\u6570\u91cf\u53c2\u6570\u6709\u8bef");
            String batch = dto.getBatch();
            if (CsPlannedOrderTypeEnum.PRODUCTION.getCode().equals(orderType)) {
                AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)batch), "\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                AssertUtil.isTrue(StringUtils.isBlank((CharSequence)batch), String.format("\u3010%s\u3011\u4e0d\u5141\u8bb8\u586b\u5199\u6279\u6b21\u4fe1\u606f", CsPlannedOrderTypeEnum.getByCode((String)orderType).getDesc()));
            }
        });
        List longCodeList = itemDetailList.stream().map(CsInPlannedOrderGenerateDetailReqDto::getLongCode).collect(Collectors.toList());
        List csItemEoList = this.itemSkuProxy.queryBySkuCodes(longCodeList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csItemEoList), "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map itemEoMap = csItemEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity()));
        for (CsInPlannedOrderGenerateDetailReqDto detailReqDto : itemDetailList) {
            String longCode = detailReqDto.getLongCode();
            ItemSkuDto csItemEo = (ItemSkuDto)itemEoMap.get(longCode);
            if (null == csItemEo) continue;
            detailReqDto.setArtNo(csItemEo.getSkuCode());
            detailReqDto.setCargoId(csItemEo.getId());
            detailReqDto.setCargoCode(csItemEo.getSkuCode());
            detailReqDto.setCargoName(csItemEo.getSkuName());
        }
        if (StringUtils.isNotBlank((CharSequence)plannedOrderGenerateReqDto.getPlatformOrderNo()) && CollectionUtils.isNotEmpty((Collection)(platformList = ((ExtQueryChainWrapper)this.csInPlannedOrderDas.filter().eq((Object)"platform_order_no", (Object)plannedOrderGenerateReqDto.getPlatformOrderNo())).list()))) {
            List collect = platformList.stream().filter(obj -> !CsPlannedOrderStatusEnum.CANCEL.getCode().equals(obj.getOrderStatus())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                collect = platformList.stream().filter(obj -> plannedOrderGenerateReqDto.getOrganizationName().equals(obj.getOrganizationName())).collect(Collectors.toList());
            }
            AssertUtil.isTrue(CollectionUtils.isEmpty(collect), "EAS\u5355\u53f7\u5df2\u5b58\u5728");
        }
    }
}

