/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsVersionDistinguishEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.FormInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.FormOutDto;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ThirdOrderService {
    private static final Logger log = LoggerFactory.getLogger(ThirdOrderService.class);
    @Resource
    IRelWarehouseDomain relWarehouseDomain;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    CsTransferOrderDas csTransferOrderDas;
    @Autowired
    ICalcInventoryService calcInventoryService;
    @Resource
    IItemSkuQueryApiProxy itemSkuQueryApiProxy;
    @Resource
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    public static final String PREEMPT_SUCCESS_MSG = "\u8c03\u62e8\u5355\u9884\u5360\u6210\u529f";
    private static final String SOURCE_NO = "-";
    private static final String REMARK = "\u62c9\u53d6sap\u8c03\u62e8\u5355\u7684\u4fe1\u606f";

    public void preemptInventory(List<CsInventoryInOutBasicsDto> preemptList) {
        log.info("\u9884\u5360\u5e93\u5b58\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(preemptList));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.info(e.getMessage());
        }
        for (CsInventoryInOutBasicsDto csInventoryInOutBasicsDto : preemptList) {
            String transferOrderNo = csInventoryInOutBasicsDto.getSourceNo();
            CsTransferOrderEo transferOrder = (CsTransferOrderEo)((ExtQueryChainWrapper)this.csTransferOrderDas.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).one();
            if (transferOrder != null) {
                CsTransferOrderEo updateEo = new CsTransferOrderEo();
                try {
                    String inLogicWarehouseCode = transferOrder.getInLogicWarehouseCode();
                    String outLogicWarehouseCode = transferOrder.getOutLogicWarehouseCode();
                    LogicWarehouseEo inWarehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)inLogicWarehouseCode)).one();
                    AssertUtil.isTrue(Objects.nonNull(inWarehouse), inLogicWarehouseCode + "\u4ed3\u5e93\u4e0d\u5b58\u5728");
                    updateEo.setInOrganizationId(inWarehouse.getOrganizationId());
                    updateEo.setInOrganization(inWarehouse.getOrganizationName());
                    LogicWarehouseEo outWarehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)outLogicWarehouseCode)).one();
                    AssertUtil.isTrue(Objects.nonNull(outWarehouse), outLogicWarehouseCode + "\u4ed3\u5e93\u4e0d\u5b58\u5728");
                    updateEo.setOutOrganizationId(outWarehouse.getOrganizationId());
                    updateEo.setOutOrganization(outWarehouse.getOrganizationName());
                    RelWarehouseEo inPhysicWarehouse = this.selectPhysicsWarehouseByLogicWarehouseCode(inLogicWarehouseCode);
                    RelWarehouseEo outPhysicWarehouse = this.selectPhysicsWarehouseByLogicWarehouseCode(outLogicWarehouseCode);
                    updateEo.setOutPhysicsWarehouseCode(outPhysicWarehouse.getWarehouseCode());
                    updateEo.setOutPhysicsWarehouseName(outPhysicWarehouse.getWarehouseName());
                    updateEo.setOutLogicWarehouseName(outWarehouse.getWarehouseName());
                    updateEo.setInLogicWarehouseName(inWarehouse.getWarehouseName());
                    updateEo.setInPhysicsWarehouseCode(inPhysicWarehouse.getWarehouseCode());
                    updateEo.setInPhysicsWarehouseName(inPhysicWarehouse.getWarehouseName());
                    updateEo.setId(transferOrder.getId());
                    this.preempt(csInventoryInOutBasicsDto);
                    updateEo.setExtension(PREEMPT_SUCCESS_MSG);
                }
                catch (Exception e) {
                    log.info("\u8c03\u62e8\u5355\u9884\u5360\u5931\u8d25,\u8c03\u62e8\u5355\u53f7{},message:{}", (Object)transferOrderNo, (Object)e.getMessage());
                    e.printStackTrace();
                    updateEo.setRemark("\u9884\u5360\u5931\u8d25\u539f\u56e0" + e.getMessage());
                    updateEo.setExtension("\u9884\u5360\u5931\u8d25\u539f\u56e0" + e.getMessage());
                }
                this.csTransferOrderDas.updateSelective((BaseEo)updateEo);
                continue;
            }
            log.info("\u8c03\u62e8\u5355\u9884\u5360\u67e5\u8be2\u8c03\u62e8\u5355\u4e0d\u5b58\u5728,\u8c03\u62e8\u5355\u53f7{}", (Object)transferOrderNo);
        }
    }

    private void preempt(CsInventoryInOutBasicsDto csInventoryInOutBasicsDto) {
        PreemptDto preemptDto = new PreemptDto();
        preemptDto.setSourceNo(csInventoryInOutBasicsDto.getSourceNo());
        preemptDto.setSourceType(csInventoryInOutBasicsDto.getSourceType());
        preemptDto.setBusinessType(csInventoryInOutBasicsDto.getBasicDataBusinessType());
        preemptDto.setExternalOrderNo(csInventoryInOutBasicsDto.getExternalOrderNo());
        preemptDto.setNoneLineNo(Boolean.valueOf(true));
        ArrayList detailDtoList = Lists.newArrayList();
        for (CsInventoryInOutBasicsCargoDto basicsCargoDto : csInventoryInOutBasicsDto.getInOutBasicsCargoDtoList()) {
            CalcDetailDto detailDto = new CalcDetailDto();
            detailDto.setLogicWarehouseCode(basicsCargoDto.getWarehouseCode());
            detailDto.setBatch(basicsCargoDto.getBatch());
            detailDto.setSkuCode(basicsCargoDto.getLongCode());
            detailDto.setNum(BigDecimalUtils.abs((BigDecimal)basicsCargoDto.getPreempt()));
            detailDtoList.add(detailDto);
        }
        preemptDto.setDetails((List)detailDtoList);
        this.calcInventoryService.preempt(preemptDto);
    }

    private RelWarehouseEo selectPhysicsWarehouseByLogicWarehouseCode(String logicWarehouseCode) {
        RelWarehouseEo outPhysicWarehouse = (RelWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)logicWarehouseCode)).eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode())).eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode())).eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode())).one();
        AssertUtil.isTrue(Objects.nonNull(outPhysicWarehouse), logicWarehouseCode + "\u5173\u8054\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
        return outPhysicWarehouse;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void updateOutResultOrderAndDetail(InOutResultOrderEo outResultOrderEo, List<InOutResultOrderDetailEo> detailList) {
        FormOutDto dto;
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.PHYSICS.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(Integer.valueOf(1));
        csInventoryInOutBasicsDto.setSourceNo(SOURCE_NO);
        csInventoryInOutBasicsDto.setRemark(REMARK);
        csInventoryInOutBasicsDto.setExternalOrderNo(outResultOrderEo.getExternalOrderNo());
        csInventoryInOutBasicsDto.setOperateVersion(CsVersionDistinguishEnum.SECOND.getCode());
        csInventoryInOutBasicsDto.setBusinessType(outResultOrderEo.getBusinessType());
        ArrayList inOutBasicsCargoDtoList = new ArrayList();
        csInventoryInOutBasicsDto.setBasicDataBusinessType(outResultOrderEo.getDisplayBusinessType());
        csInventoryInOutBasicsDto.setSourceType(CsInventorySourceTypeEnum.TRANSFER_OTHER.getCode());
        String inWarehouseCode = outResultOrderEo.getInLogicWarehouseCode();
        String outWarehouseCode = outResultOrderEo.getOutLogicWarehouseCode();
        InOutResultOrderEo updateEo = new InOutResultOrderEo();
        if ("out".equals(outResultOrderEo.getOrderType())) {
            csInventoryInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
            updateEo.setOrderStatus(BaseOrderStatusEnum.ORO_DONE_OUT.getCode());
        } else {
            csInventoryInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.IN.getCode());
            updateEo.setOrderStatus(BaseOrderStatusEnum.IRO_DONE_IN.getCode());
        }
        LogicWarehouseEo inLogicWarehouse = null;
        RelWarehouseEo inPhysicsWarehouse = null;
        LogicWarehouseEo outLogicWarehouse = null;
        RelWarehouseEo outPhysicsWarehouse = null;
        if (StringUtils.isNotEmpty((String)inWarehouseCode)) {
            inLogicWarehouse = this.queryLogicWarehouseByCode(inWarehouseCode);
            inPhysicsWarehouse = this.selectPhysicsWarehouseByLogicWarehouseCode(inWarehouseCode);
        }
        if (StringUtils.isNotEmpty((String)outWarehouseCode)) {
            outLogicWarehouse = this.queryLogicWarehouseByCode(outWarehouseCode);
            outPhysicsWarehouse = this.selectPhysicsWarehouseByLogicWarehouseCode(outWarehouseCode);
        }
        updateEo.setId(outResultOrderEo.getId());
        if (inLogicWarehouse != null) {
            updateEo.setInLogicWarehouseName(inLogicWarehouse.getWarehouseName());
            updateEo.setInLogicWarehouseCode(inLogicWarehouse.getWarehouseCode());
        }
        if (inPhysicsWarehouse != null) {
            updateEo.setInPhysicsWarehouseCode(inPhysicsWarehouse.getWarehouseCode());
            updateEo.setInPhysicsWarehouseName(inPhysicsWarehouse.getWarehouseName());
        }
        if (outLogicWarehouse != null) {
            updateEo.setOutLogicWarehouseName(outLogicWarehouse.getWarehouseName());
            updateEo.setOutPhysicsWarehouseCode(outLogicWarehouse.getWarehouseCode());
        }
        if (outPhysicsWarehouse != null) {
            updateEo.setOutPhysicsWarehouseCode(outPhysicsWarehouse.getWarehouseCode());
            updateEo.setOutPhysicsWarehouseName(outPhysicsWarehouse.getWarehouseName());
        }
        Set<String> cargoCodeSet = detailList.stream().map(InOutResultOrderDetailEo::getSkuCode).collect(Collectors.toSet());
        Map<String, String> skuMap = this.checkSku(cargoCodeSet);
        ArrayList<InOutResultOrderDetailEo> updateDetailList = new ArrayList<InOutResultOrderDetailEo>(detailList.size());
        BigDecimal total = BigDecimal.ZERO;
        for (InOutResultOrderDetailEo d : detailList) {
            InOutResultOrderDetailEo update2 = new InOutResultOrderDetailEo();
            update2.setId(d.getId());
            update2.setSkuName(skuMap.get(d.getSkuName()));
            total = total.add(d.getQuantity());
            updateDetailList.add(update2);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList(inOutBasicsCargoDtoList);
        updateEo.setTotalQuantity(total);
        this.inOutResultOrderDomain.getMapper().updateById((BaseEo)updateEo);
        updateDetailList.forEach(update -> this.inOutResultOrderDetailDomain.getMapper().updateById((BaseEo)update));
        if ("out".equals(outResultOrderEo.getOrderType())) {
            log.info("deducePhysicsInventory==>\u5176\u4ed6\u51fa\u5165\u5e93\u56de\u8c03\u51cf\u5c11\u7269\u7406\u4ed3\u4ed3\u5e93\u5b58\u603b\u5e93\u5b58,csInventoryInOutBasicsDto:{}", (Object)JSONObject.toJSONString((Object)csInventoryInOutBasicsDto));
            dto = new FormOutDto();
            dto.setIgnorePreempt(Boolean.valueOf(true));
            dto.setValidNegative(Boolean.valueOf(false));
            dto.setNoneLineNo(Boolean.valueOf(true));
            this.wrapper(outResultOrderEo, (CalcDto)dto, detailList);
            this.calcInventoryService.formOut(dto);
        } else {
            log.info("increasePhysicsInventory==>\u5176\u4ed6\u51fa\u5165\u5e93\u56de\u8c03\u589e\u52a0\u7269\u7406\u4ed3\u4ed3\u5e93\u5b58\u603b\u5e93\u5b58,csInventoryInOutBasicsDto:{}", (Object)JSONObject.toJSONString((Object)csInventoryInOutBasicsDto));
            dto = new FormInDto();
            dto.setIgnoreFutureIn(Boolean.valueOf(true));
            dto.setNoneLineNo(Boolean.valueOf(true));
            dto.setValidNegative(Boolean.valueOf(false));
            this.wrapper(outResultOrderEo, (CalcDto)dto, detailList);
            this.calcInventoryService.formIn((FormInDto)dto);
        }
    }

    private void wrapper(InOutResultOrderEo outResultOrderEo, CalcDto dto, List<InOutResultOrderDetailEo> detailList) {
        dto.setExternalOrderNo(outResultOrderEo.getExternalOrderNo());
        dto.setSourceType(CsInventorySourceTypeEnum.TRANSFER_OTHER.getCode());
        dto.setBusinessType((String)DataExtractUtils.ifNullElse((Object)outResultOrderEo.getDisplayBusinessType(), (Object)outResultOrderEo.getBusinessType()));
        dto.setSourceNo((String)DataExtractUtils.ifNullElse((Object)outResultOrderEo.getRelevanceNo(), (Object)SOURCE_NO));
        dto.setDetails(detailList.stream().map(d -> {
            CalcDetailDto detailDto = new CalcDetailDto();
            detailDto.setSkuCode(d.getSkuCode());
            detailDto.setLogicWarehouseCode("out".equals(outResultOrderEo.getOrderType()) ? outResultOrderEo.getOutLogicWarehouseCode() : outResultOrderEo.getInLogicWarehouseCode());
            detailDto.setNum(d.getQuantity());
            detailDto.setProduceDate(d.getProduceTime());
            detailDto.setExpireDate(d.getExpireTime());
            return detailDto;
        }).collect(Collectors.toList()));
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void updateDeliveryResultOrderAndDetail(ReceiveDeliveryResultOrderEo delivery, List<ReceiveDeliveryResultOrderDetailEo> detailList) {
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(Integer.valueOf(1));
        csInventoryInOutBasicsDto.setSourceNo(SOURCE_NO);
        csInventoryInOutBasicsDto.setRemark(REMARK);
        csInventoryInOutBasicsDto.setExternalOrderNo(delivery.getExternalOrderNo());
        csInventoryInOutBasicsDto.setOperateVersion(CsVersionDistinguishEnum.SECOND.getCode());
        csInventoryInOutBasicsDto.setBusinessType(delivery.getBusinessType());
        csInventoryInOutBasicsDto.setBasicDataBusinessType(delivery.getDisplayBusinessType());
        ArrayList inOutBasicsCargoDtoList = new ArrayList();
        csInventoryInOutBasicsDto.setSourceType(CsInventorySourceTypeEnum.TRANSFER_OTHER.getCode());
        String deliveryWarehouseCode = delivery.getDeliveryLogicWarehouseCode();
        String receiveWarehouseCode = delivery.getReceiveLogicWarehouseCode();
        ReceiveDeliveryResultOrderEo updateEo = new ReceiveDeliveryResultOrderEo();
        if ("delivery".equals(delivery.getOrderType())) {
            csInventoryInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
            updateEo.setOrderStatus(BaseOrderStatusEnum.DRO_DELIVERED.getCode());
        } else {
            csInventoryInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.IN.getCode());
            updateEo.setOrderStatus(BaseOrderStatusEnum.RRO_RECEIVED.getCode());
        }
        LogicWarehouseEo receiveLogicWarehouse = null;
        RelWarehouseEo receivePhysicsWarehouse = null;
        LogicWarehouseEo deliveryLogicWarehouse = null;
        RelWarehouseEo deliveryPhysicsWarehouse = null;
        if (StringUtils.isNotEmpty((String)receiveWarehouseCode)) {
            receiveLogicWarehouse = this.queryLogicWarehouseByCode(receiveWarehouseCode);
            receivePhysicsWarehouse = this.selectPhysicsWarehouseByLogicWarehouseCode(receiveWarehouseCode);
        }
        if (StringUtils.isNotEmpty((String)deliveryWarehouseCode)) {
            deliveryLogicWarehouse = this.queryLogicWarehouseByCode(deliveryWarehouseCode);
            deliveryPhysicsWarehouse = this.selectPhysicsWarehouseByLogicWarehouseCode(deliveryWarehouseCode);
        }
        if (receiveLogicWarehouse != null) {
            updateEo.setReceiveLogicWarehouseName(receiveLogicWarehouse.getWarehouseName());
            updateEo.setReceiveLogicWarehouseCode(receiveLogicWarehouse.getWarehouseCode());
        }
        if (receivePhysicsWarehouse != null) {
            updateEo.setReceivePhysicsWarehouseCode(receivePhysicsWarehouse.getWarehouseCode());
            updateEo.setReceivePhysicsWarehouseName(receivePhysicsWarehouse.getWarehouseName());
        }
        if (deliveryLogicWarehouse != null) {
            updateEo.setDeliveryLogicWarehouseName(deliveryLogicWarehouse.getWarehouseName());
            updateEo.setDeliveryLogicWarehouseCode(deliveryLogicWarehouse.getWarehouseCode());
        }
        if (deliveryPhysicsWarehouse != null) {
            updateEo.setDeliveryPhysicsWarehouseCode(deliveryPhysicsWarehouse.getWarehouseCode());
            updateEo.setDeliveryPhysicsWarehouseName(deliveryPhysicsWarehouse.getWarehouseName());
        }
        Set<String> cargoCodeSet = detailList.stream().map(ReceiveDeliveryResultOrderDetailEo::getSkuCode).collect(Collectors.toSet());
        Map<String, String> skuMap = this.checkSku(cargoCodeSet);
        ArrayList<ReceiveDeliveryResultOrderDetailEo> updateDetailList = new ArrayList<ReceiveDeliveryResultOrderDetailEo>(detailList.size());
        BigDecimal total = BigDecimal.ZERO;
        for (ReceiveDeliveryResultOrderDetailEo d : detailList) {
            ReceiveDeliveryResultOrderDetailEo update2 = new ReceiveDeliveryResultOrderDetailEo();
            update2.setId(d.getId());
            update2.setSkuName(skuMap.get(d.getSkuName()));
            total = total.add(d.getQuantity());
            updateDetailList.add(update2);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList(inOutBasicsCargoDtoList);
        updateEo.setTotalQuantity(total);
        updateEo.setId(delivery.getId());
        this.receiveDeliveryResultOrderDomain.getMapper().updateById((BaseEo)updateEo);
        updateDetailList.forEach(update -> this.receiveDeliveryResultOrderDetailDomain.getMapper().updateById((BaseEo)update));
    }

    private LogicWarehouseEo queryLogicWarehouseByCode(String warehouseCode) {
        LogicWarehouseEo warehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)warehouseCode)).one();
        AssertUtil.isTrue(Objects.nonNull(warehouse), warehouseCode + "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        return warehouse;
    }

    private Map<String, String> checkSku(Set<String> itemSet) {
        ArrayList<String> longCodeList = new ArrayList<String>(itemSet);
        List itemList = this.itemSkuQueryApiProxy.queryBySkuCodes(longCodeList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)itemList), "\u67e5\u8be2\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
        return itemList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, ItemSkuDto::getSkuName));
    }
}

