/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.CsBasicsExternalStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.ICsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.wms.ICsWmsService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.CodeGenerateUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsAuditWithdrawTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsCancelTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderDeliveryReceiveConfirmReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderThirdReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsExternalStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.TranferOrderCountRespDto;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class TransferOrderApiImpl
implements ICsTransferOrderApi {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderApiImpl.class);
    @Autowired
    protected ICsTransferOrderService csTransferOrderService;
    @Autowired
    protected CsCommonService csCommonService;
    @Autowired
    protected ICsWmsService csWmsService;
    @Autowired
    protected CsTransferOrderMapper csTransferOrderMapper;
    @Autowired
    protected ICommonsMqService commonsMqService;
    @Resource
    private CsTransferOrderDas csTransferOrderDas;
    @Autowired
    IContext context;
    @Autowired
    ILockService lockService;
    @Resource
    CodeGenerateUtil codeGenerateUtil;
    protected static final Logger logger = LoggerFactory.getLogger(TransferOrderApiImpl.class);

    public RestResponse<Long> addCsTransferOrder(CsTransferOrderReqDto addReqDto) {
        return new RestResponse((Object)this.csTransferOrderService.addCsTransferOrder(addReqDto));
    }

    public RestResponse<Void> modifyCsTransferOrder(CsTransferOrderComboReqDto modifyReqDto) {
        this.csTransferOrderService.modifyCsTransferOrder(modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Integer> modifyTransferOrderByTransferOrderNo(CsTransferOrderReqDto transferOrderReqDto) {
        return null;
    }

    public RestResponse<Void> removeCsTransferOrder(String ids) {
        this.csTransferOrderService.removeCsTransferOrder(ids);
        return RestResponse.VOID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse<Long> addTransferOrder(CsTransferOrderComboReqDto csTransferOrderComboReqDto) {
        this.csCommonService.getSetUserName();
        String saleOrderNo = csTransferOrderComboReqDto.getCsOtherStorageOrderReqDto().getSaleOrderNo();
        if (StringUtils.isNotBlank((CharSequence)saleOrderNo)) {
            Mutex mutex = this.lockService.lock("TransferOrderApiImpl#addTransferOrder", saleOrderNo, 20, 25, TimeUnit.SECONDS);
            try {
                List saleTransferList = this.csTransferOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getSaleOrderNo, (Object)saleOrderNo)).notIn(CsTransferOrderEo::getOrderStatus, (Collection)Lists.newArrayList((Object[])new String[]{CsTransferOrderEnum.Status.AUDIT_FAILED.getCode(), CsTransferOrderEnum.Status.CANCELED.getCode()}))).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                if (CollectionUtils.isNotEmpty((Collection)saleTransferList)) {
                    throw new BizException("\u8be5\u8ba2\u5355\u5df2\u521b\u5efa\u9500\u552e\u8c03\u62e8\uff0c\u8bf7\u52ff\u91cd\u590d\u521b\u5efa");
                }
                Long transferOrderId = this.csTransferOrderService.addTransferOrder(csTransferOrderComboReqDto);
                RestResponse restResponse = new RestResponse((Object)transferOrderId);
                return restResponse;
            }
            finally {
                this.lockService.unlock(mutex);
            }
        }
        return new RestResponse((Object)this.csTransferOrderService.addTransferOrder(csTransferOrderComboReqDto));
    }

    public RestResponse<CsTransferOrderRespDto> addTransferOrderAndResp(CsTransferOrderComboReqDto csTransferOrderComboReqDto) {
        return new RestResponse((Object)this.csTransferOrderService.addTransferOrderAndResp(csTransferOrderComboReqDto));
    }

    public RestResponse<Void> addTransferOrders(List<CsTransferOrderComboReqDto> csTransferOrderComboReqDtoList) {
        this.csTransferOrderService.addTransferOrders(csTransferOrderComboReqDtoList);
        return RestResponse.VOID;
    }

    public RestResponse<List<Long>> addTransferOrderList(List<CsTransferOrderComboReqDto> csTransferOrderComboReqDtos) {
        return null;
    }

    public RestResponse<Void> closeTransferOrder(String transferOrderNo) {
        this.csTransferOrderService.closeTransferOrder(transferOrderNo);
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> auditTransferOrder(CsAuditReqDto auditReqDto) {
        this.csTransferOrderService.auditTransferOrder(auditReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> cancelTransferOrder(CsCancelTransferOrderReqDto cancelTransferOrder) {
        if (StringUtils.isNotBlank((CharSequence)cancelTransferOrder.getKeyWord())) {
            this.csTransferOrderService.cancelNoAuditTransferOrder(cancelTransferOrder);
        }
        if (StringUtils.isNotBlank((CharSequence)cancelTransferOrder.getOutNoticeNo())) {
            CsWmsCancelReqDto csWmsCancelReqDto = new CsWmsCancelReqDto();
            csWmsCancelReqDto.setNoticeOrderNo(cancelTransferOrder.getOutNoticeNo());
            csWmsCancelReqDto.setRemark(cancelTransferOrder.getRemark());
            this.csWmsService.cancelInstruct(csWmsCancelReqDto);
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyCsTransferOrderExtension(CsTransferOrderReqDto csTransferOrderReqDto) {
        this.csTransferOrderService.modifyCsTransferOrderExtension(csTransferOrderReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<String> cancelInstruct(CsBasicsCancelReqDto basicsCancelReqDto) {
        this.checkParams(basicsCancelReqDto);
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        wmsExternalService.cancel(basicsCancelReqDto);
        return RestResponse.SUCCEED;
    }

    public RestResponse<String> getTransferOrderNo() {
        String generateCodeStrategy = CsGenerateCodeStrategyEnum.PCP_TRANSFER_ORDER.getCode();
        return new RestResponse((Object)GenerateCodeUtils.getStrategy(generateCodeStrategy).getCode());
    }

    public RestResponse<String> getBcOrCcTransferNo(String type) {
        if (CsPcpBusinessTypeEnum.BC_ALLOT.getCode().equals(type) || CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode().equals(type)) {
            return new RestResponse((Object)this.codeGenerateUtil.generateNo("BC", 6));
        }
        if (CsPcpBusinessTypeEnum.CC_ALLOT.getCode().equals(type)) {
            return new RestResponse((Object)this.codeGenerateUtil.generateNo("CC", 6));
        }
        return new RestResponse((Object)GenerateCodeUtils.getStrategy(type).getCode());
    }

    public RestResponse<Boolean> hasAllDelivery(List<String> transferNos) {
        AssertUtil.assertNotEmpty(transferNos, "\u8c03\u62e8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Integer count = this.csTransferOrderMapper.selectCount((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"transfer_order_no", transferNos)).in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{CsTransferOrderEnum.Status.WAIT_RECEIVE.getCode(), CsTransferOrderEnum.Status.FINISH.getCode()})));
        return new RestResponse((Object)Objects.equals(transferNos.size(), count));
    }

    public RestResponse<Void> cancelTransferOrderByNO(String transferOrderNo) {
        return null;
    }

    public RestResponse<Void> auditWithdrawTransferOrder(CsAuditWithdrawTransferOrderReqDto auditWithdrawTransferOrderReqDto) {
        return null;
    }

    public RestResponse<Void> updateTransferOrderSapNo(String transferOrderNo, String sapNo) {
        return null;
    }

    public RestResponse<Void> updateTransferOrderCspPushStatus(String transferOrderNo, String cspPushStatus) {
        log.info("\u66f4\u65b0\u8c03\u62e8\u5355csp\u63a8\u9001\u72b6\u6001\uff0c\u8c03\u62e8\u5355\u53f7\uff1a{}\uff0c\u63a8\u9001\u72b6\u6001\uff1a{}", (Object)transferOrderNo, (Object)cspPushStatus);
        CsTransferOrderRespDto respDto = this.queryByTransferByOrderNo(transferOrderNo);
        CsTransferOrderEo updateEo = new CsTransferOrderEo();
        updateEo.setId(respDto.getId());
        updateEo.setCspPushStatus(cspPushStatus);
        this.csTransferOrderDas.updateSelective((BaseEo)updateEo);
        log.info("\u8c03\u62e8\u5355csp\u63a8\u9001\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff0c\u8c03\u62e8\u5355\u53f7\uff1a{}\uff0c\u63a8\u9001\u72b6\u6001\uff1a{}", (Object)transferOrderNo, (Object)cspPushStatus);
        return RestResponse.VOID;
    }

    private CsTransferOrderRespDto queryByTransferByOrderNo(String transferOrderNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"transfer_order_no", (Object)transferOrderNo);
        queryWrapper.eq((Object)"dr", (Object)0);
        List transferOrderList = this.csTransferOrderMapper.selectList((Wrapper)queryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)transferOrderList), "\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
        log.info("\u67e5\u8be2\u8c03\u62e8\u5355\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)transferOrderList));
        CsTransferOrderRespDto csTransferOrderRespDto = new CsTransferOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)((BaseEo)transferOrderList.get(0)), (BaseVo)csTransferOrderRespDto);
        return csTransferOrderRespDto;
    }

    public RestResponse<List<Long>> addTransferOrderByThird(List<CsTransferOrderThirdReqDto> thirdReqDtoList) {
        return null;
    }

    public RestResponse<Void> deliveryReceiveConfirm(CsTransferOrderDeliveryReceiveConfirmReqDto deliveryReceiveConfirmReqDto) {
        return null;
    }

    public RestResponse<Boolean> revocationTransferOrder(String transferOrderNo) {
        return null;
    }

    public RestResponse<Void> pushResultOrder(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    public RestResponse<Void> pushResultOrderByTransferOrderNo(String transferOrderNo, String orderType) {
        return null;
    }

    public RestResponse<Long> addFinishTransferOrder(CsTransferOrderThirdReqDto transferOrderThirdReqDto) {
        return null;
    }

    public RestResponse<Void> sendAddTransferStoreRaisedResultOrderMq(List<String> transferOrderNos) {
        return null;
    }

    public RestResponse<CsTransferOrderRespDto> queryById(Long id) {
        return new RestResponse((Object)this.csTransferOrderService.queryById(id));
    }

    public RestResponse<PageInfo<CsTransferOrderRespDto>> queryByPage(CsTransferOrderQueryDto queryDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.csTransferOrderService.queryByPage(queryDto, pageNum, pageSize));
    }

    public RestResponse<List<CsTransferOrderRespDto>> queryByParam(CsTransferOrderQueryDto queryDto) {
        return null;
    }

    public RestResponse<CsTransferOrderRespDto> queryByTransferOrderNo(String transferOrderNo) {
        return new RestResponse((Object)this.csTransferOrderService.queryByTransferOrderNo(transferOrderNo));
    }

    public RestResponse<List<CsTransferOrderRespDto>> queryTransferOrderList(CsTransferOrderReqDto reqDto) {
        return new RestResponse(this.csTransferOrderService.queryTransferOrderList(reqDto));
    }

    public RestResponse<List<TranferOrderCountRespDto>> transferOrderCount(CsTransferOrderQueryDto queryDto) {
        return new RestResponse(this.csTransferOrderService.transferOrderCount(queryDto));
    }

    private void checkParams(CsBasicsCancelReqDto basicsCancelReqDto) {
        AssertUtil.isTrue(null != basicsCancelReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String inNoticeOrderNo = basicsCancelReqDto.getNoticeOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inNoticeOrderNo), "\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> easAddTransferOrder(EasTransferOrderReqDto easTransferOrderDetailReqDto) {
        this.csCommonService.getSetUserName(easTransferOrderDetailReqDto.getCreatePerson());
        Long transferOrderId = this.csTransferOrderService.easAddTransferOrder(easTransferOrderDetailReqDto);
        if (easTransferOrderDetailReqDto.getAutoAudit().booleanValue()) {
            CsAuditReqDto auditReqDto = this.getCsAuditReqDto(easTransferOrderDetailReqDto);
            this.csTransferOrderService.auditTransferOrder(auditReqDto);
        }
        return new RestResponse((Object)transferOrderId);
    }

    public RestResponse<Void> batchEasAddTransferOrder(List<EasTransferOrderReqDto> easTransferOrderReqDtoList) {
        this.csCommonService.getSetUserName();
        this.csTransferOrderService.batchEasAddTransferOrder(easTransferOrderReqDtoList);
        Long userId = this.context.userId();
        CompletableFuture.runAsync(() -> {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
            this.context.userId(userId);
            this.csCommonService.getSetUserName();
            for (EasTransferOrderReqDto easTransferOrderReqDto : easTransferOrderReqDtoList) {
                CsAuditReqDto auditReqDto = this.getCsAuditReqDto(easTransferOrderReqDto);
                this.auditTransferOrder(auditReqDto);
            }
        });
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> easAddRouterTransferOrder(EasTransferOrderReqDto easTransferOrderDetailReqDto) {
        this.csCommonService.getSetUserName(easTransferOrderDetailReqDto.getCreatePerson());
        Long transferOrderId = this.csTransferOrderService.easAddRouterTransferOrder(easTransferOrderDetailReqDto);
        if (easTransferOrderDetailReqDto.getAutoAudit().booleanValue()) {
            CsAuditReqDto auditReqDto = this.getCsAuditReqDto(easTransferOrderDetailReqDto);
            this.csTransferOrderService.auditTransferOrder(auditReqDto);
        }
        return new RestResponse((Object)transferOrderId);
    }

    public RestResponse<Long> easInsiderTradeTransferOrder(EasTransferOrderReqDto easTransferOrderDetailReqDto) {
        this.csCommonService.getSetUserName(easTransferOrderDetailReqDto.getCreatePerson());
        Long transferOrderId = this.csTransferOrderService.easInsiderTradeTransferOrder(easTransferOrderDetailReqDto);
        return new RestResponse((Object)transferOrderId);
    }

    protected CsAuditReqDto getCsAuditReqDto(EasTransferOrderReqDto easTransferOrderDetailReqDto) {
        CsAuditReqDto auditReqDto = new CsAuditReqDto();
        auditReqDto.setBusinessOrderNo(easTransferOrderDetailReqDto.getBusinessOrderNo());
        auditReqDto.setAuditResult(CsOtherStorageOrderEnum.AuditEnum.AUDIT_PASS.getCode());
        return auditReqDto;
    }

    public RestResponse<Void> cancelByTransferOrderNo(String orderNo) {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u8c03\u62e8\u5355\u5b8c\u7ed3default\uff0ctransferOrderNo:{}", (Object)orderNo);
        return null;
    }

    public RestResponse<Void> modifyTransferOrder(CsTransferOrderRespDto csTransferOrderRespDto) {
        log.info("\u4fee\u6539\u8c03\u62e8\u5355\uff1a{}", (Object)JSON.toJSONString((Object)csTransferOrderRespDto));
        this.csTransferOrderService.modifyTranferOrder(csTransferOrderRespDto);
        return RestResponse.VOID;
    }
}

