/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsInPlannedOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderClosedReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOverchargeAdjustReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedRelieveOverchargeReqDto;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;

public abstract class InPlannedOrderApiImpl
implements ICsInPlannedOrderApi {
    private static final Logger log = LoggerFactory.getLogger(InPlannedOrderApiImpl.class);
    @Autowired
    protected ICsInPlannedOrderService csInPlannedOrderService;

    public RestResponse<Long> add(CsInPlannedOrderAddReqDto addReqDto) {
        log.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csInPlannedOrderService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsInPlannedOrderUpdateReqDto updateReqDto) {
        log.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        this.csInPlannedOrderService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        log.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        this.csInPlannedOrderService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<Long> generatePlannedOrder(CsInPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        plannedOrderGenerateReqDto.setOrderNo(null);
        Long plannedOrderId = this.csInPlannedOrderService.generatePlannedOrder(plannedOrderGenerateReqDto);
        return new RestResponse((Object)plannedOrderId);
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Void> auditPlannedOrder(CsInPlannedOrderAuditReqDto plannedOrderAuditReqDto) {
        this.csInPlannedOrderService.auditPlannedOrder(plannedOrderAuditReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> cancelByOrderNo(String orderNo) {
        this.csInPlannedOrderService.cancelByOrderNo(orderNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> closedOrder(CsInPlannedOrderClosedReqDto closedReqDto) {
        this.csInPlannedOrderService.closedOrder(closedReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Long> editPlannedOrder(CsInPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        Long plannedOrderId = this.csInPlannedOrderService.editPlannedOrder(plannedOrderGenerateReqDto);
        return new RestResponse((Object)plannedOrderId);
    }

    public RestResponse<Void> submitByOrderNo(String orderNo) {
        this.csInPlannedOrderService.submitByOrderNo(orderNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> relieveOverchargeByOrderDocumentNo(CsInPlannedRelieveOverchargeReqDto csInPlannedRelieveOverchargeReqDto) {
        this.csInPlannedOrderService.relieveOverchargeByOrderDocumentNo(csInPlannedRelieveOverchargeReqDto);
        return RestResponse.VOID;
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Void> overchargeAdjust(CsInPlannedOverchargeAdjustReqDto overchargeAdjustReqDto) {
        this.csInPlannedOrderService.overchargeAdjust(overchargeAdjustReqDto);
        return RestResponse.VOID;
    }
}

