/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryOtherBatchDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.ItemBlacklistDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ItemBlacklistPageReqDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.service.entity.IItemBlacklistService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="csLogicInventoryQueryService")
public class CsLogicInventoryQueryServiceImpl
implements ICsLogicInventoryQueryService {
    private static final Logger logger = LoggerFactory.getLogger(CsLogicInventoryQueryServiceImpl.class);
    @Resource
    ILogicInventoryDomain logicInventoryDomain;
    @Resource
    private IItemBlacklistService iItemBlacklistService;

    @Override
    public LogicInventoryEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        return (LogicInventoryEo)this.logicInventoryDomain.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<CsLogicInventoryRespDto> queryByPage(CsLogicInventoryQueryDto queryDto) {
        logger.info("\u83b7\u53d6\u4ed3\u5e93\u5e93\u5b58-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        QueryWrapper<LogicInventoryEo> wrapper = this.getQueryWrapper(queryDto);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List selectList = this.logicInventoryDomain.getMapper().selectList(wrapper);
        if (CollectionUtils.isEmpty((Collection)selectList)) {
            return new PageInfo();
        }
        PageInfo info = new PageInfo(selectList);
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)pageInfo, (String[])new String[]{"list"});
        ArrayList list = Lists.newArrayList();
        for (LogicInventoryEo logicInventoryEo : selectList) {
            CsLogicInventoryRespDto respDto = new CsLogicInventoryRespDto();
            BeanUtils.copyProperties((Object)logicInventoryEo, (Object)respDto);
            respDto.setCargoCode(logicInventoryEo.getSkuCode());
            respDto.setLongCode(logicInventoryEo.getSkuCode());
            respDto.setCargoName(logicInventoryEo.getSkuName());
            list.add(respDto);
        }
        if (Objects.equals(1, queryDto.getWareHouseFilter()) && StringUtils.isNotBlank((CharSequence)queryDto.getInWarehouseCode())) {
            logger.info("\u5f00\u59cb\u8fc7\u6ee4\u9ed1\u540d\u5355");
            ItemBlacklistPageReqDto dto = new ItemBlacklistPageReqDto();
            dto.setPhysicsWarehouseCode(queryDto.getInWarehouseCode());
            List dtoList = this.iItemBlacklistService.queryPhysicsItemBlack(dto);
            List<CsLogicInventoryRespDto> passList = this.getPassList(list, dtoList);
            pageInfo.setList(passList);
            logger.info("\u83b7\u53d6\u4ed3\u5e93\u5e93\u5b58,\u8fc7\u6ee4\u9ed1\u540d\u5355\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)pageInfo));
            return pageInfo;
        }
        pageInfo.setList((List)list);
        logger.info("\u83b7\u53d6\u4ed3\u5e93\u5e93\u5b58-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)pageInfo));
        return pageInfo;
    }

    private List<CsLogicInventoryRespDto> getPassList(List<CsLogicInventoryRespDto> list, List<ItemBlacklistDto> dtoList) {
        List skuCodeList = dtoList.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getBatch())).collect(Collectors.toList());
        List skuCodes = skuCodeList.stream().map(ItemBlacklistDto::getSkuCode).collect(Collectors.toList());
        List batchDtos = Optional.ofNullable(dtoList.stream().filter(o -> Objects.equals(0, o.getConfigureRules())).collect(Collectors.toList())).orElse(Lists.newArrayList());
        List appointBatchDtos = Optional.ofNullable(dtoList.stream().filter(o -> Objects.equals(1, o.getConfigureRules())).collect(Collectors.toList())).orElse(Lists.newArrayList());
        Map skuCodeBatchMap = batchDtos.stream().collect(Collectors.toMap(o -> o.getSkuCode() + "_" + o.getBatch(), Function.identity(), (k1, k2) -> k1));
        Map appointBatchDtoMap = appointBatchDtos.stream().collect(Collectors.toMap(o -> o.getSkuCode() + "_" + o.getBatch(), Function.identity(), (k1, k2) -> k1));
        ArrayList passList = Lists.newArrayList();
        for (CsLogicInventoryRespDto logicInventoryRespDto : list) {
            if (skuCodes.contains(logicInventoryRespDto.getSkuCode())) continue;
            String key = String.format("%s_%s", logicInventoryRespDto.getSkuCode(), logicInventoryRespDto.getBatch());
            if (appointBatchDtoMap.containsKey(key)) continue;
            String batchEnd = logicInventoryRespDto.getBatch().substring(logicInventoryRespDto.getBatch().length() - 1);
            String skuCodeKey = logicInventoryRespDto.getSkuCode() + "_" + batchEnd;
            if (skuCodeBatchMap.containsKey(skuCodeKey)) continue;
            passList.add(logicInventoryRespDto);
        }
        return passList;
    }

    @Override
    public List<CsLogicInventoryRespDto> queryByParam(CsLogicInventoryQueryDto queryDto) {
        logger.info("\u67e5\u8be2\u903b\u8f91\u6279\u6b21\u5e93\u5b58-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        ArrayList list = Lists.newArrayList();
        if (Objects.isNull(queryDto)) {
            return list;
        }
        QueryWrapper<LogicInventoryEo> wrapper = this.getQueryWrapper(queryDto);
        List selectList = this.logicInventoryDomain.getMapper().selectList(wrapper);
        for (LogicInventoryEo logicInventoryEo : selectList) {
            CsLogicInventoryRespDto respDto = new CsLogicInventoryRespDto();
            BeanUtils.copyProperties((Object)logicInventoryEo, (Object)respDto);
            respDto.setCargoCode(logicInventoryEo.getSkuCode());
            respDto.setLongCode(logicInventoryEo.getSkuCode());
            respDto.setCargoName(logicInventoryEo.getSkuName());
            list.add(respDto);
        }
        logger.info("\u67e5\u8be2\u903b\u8f91\u6279\u6b21\u5e93\u5b58-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)list));
        return list;
    }

    @Override
    public PageInfo<CsLogicInventoryRespDto> queryAvailableGtZeroByPage(CsLogicInventoryQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53ef\u7528\u5e93\u5b58\u5927\u4e8e0-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        QueryWrapper<LogicInventoryEo> wrapper = this.getQueryWrapper(queryDto);
        wrapper.gt((Object)"available", (Object)0);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List selectList = this.logicInventoryDomain.getMapper().selectList(wrapper);
        PageInfo info = new PageInfo(selectList);
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)pageInfo, (String[])new String[]{"list"});
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)selectList, CsLogicInventoryRespDto.class);
        pageInfo.setList((List)list);
        logger.info("\u5206\u9875\u67e5\u8be2\u53ef\u7528\u5e93\u5b58\u5927\u4e8e0-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)pageInfo));
        return pageInfo;
    }

    @Override
    public PageInfo<CsLogicInventoryRespDto> queryOtherByBatch(CsLogicInventoryQueryOtherBatchDto queryDto) {
        AssertUtil.isTrue(Objects.nonNull(queryDto), "\u67e5\u8be2\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)queryDto.getExcludeBatch()), "\u67e5\u8be2\u6392\u9664\u7684\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Integer pageNum = Objects.nonNull(queryDto.getPageNum()) && queryDto.getPageNum() > 0 ? queryDto.getPageNum() : 1;
        Integer pageSize = Objects.nonNull(queryDto.getPageSize()) && queryDto.getPageSize() > 0 ? queryDto.getPageSize() : 10;
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getWarehouseCode()})) {
            wrapper.eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getLongCode()})) {
            wrapper.eq((Object)"sku_code", (Object)queryDto.getLongCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getFuzzyQueryBatch())) {
            wrapper.like((Object)"batch", (Object)queryDto.getFuzzyQueryBatch());
        }
        wrapper.ne((Object)"batch", (Object)queryDto.getExcludeBatch());
        wrapper.isNotNull((Object)"batch");
        wrapper.orderByDesc((Object)queryDto.getOrderByDesc());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List selectList = this.logicInventoryDomain.getMapper().selectList((Wrapper)wrapper);
        PageInfo info = new PageInfo(selectList);
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)pageInfo, (String[])new String[]{"list"});
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)selectList, CsLogicInventoryRespDto.class);
        pageInfo.setList((List)list);
        logger.info("\u5206\u9875\u67e5\u8be2\u9664\u4e86\u5165\u53c2\u7684\u6279\u6b21\u53f7\u7684\u5176\u4ed6\u5e93\u5b58\u4fe1\u606f-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)pageInfo));
        return pageInfo;
    }

    @Override
    public List<CsLogicInventoryRespDto> queryInfoList(CsLogicInventoryQueryDto queryDto) {
        logger.info("\u67e5\u8be2\u5217\u8868\uff0c\u975e\u6a21\u7cca\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)"0");
        if (queryDto.getWarehouseId() != null) {
            wrapper.eq((Object)"warehouse_id", (Object)queryDto.getWarehouseId());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getWarehouseCode()})) {
            wrapper.eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getCargoCode()})) {
            wrapper.eq((Object)"sku_code", (Object)queryDto.getCargoCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getCargoName()})) {
            wrapper.eq((Object)"sku_name", (Object)queryDto.getCargoName());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getLongCode()})) {
            wrapper.eq((Object)"sku_code", (Object)queryDto.getLongCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getBatch()})) {
            wrapper.eq((Object)"batch", (Object)queryDto.getBatch());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getLongCodes())) {
            wrapper.in((Object)"sku_code", (Collection)queryDto.getLongCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getWarehouseCodeList())) {
            wrapper.in((Object)"warehouse_code", (Collection)queryDto.getWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getBatchList())) {
            wrapper.in((Object)"batch", (Collection)queryDto.getBatchList());
        }
        wrapper.isNotNull((Object)"batch");
        wrapper.orderByDesc((Object)queryDto.getOrderByDesc());
        List selectList = this.logicInventoryDomain.getMapper().selectList((Wrapper)wrapper);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)selectList, CsLogicInventoryRespDto.class);
        logger.info("\u67e5\u8be2\u903b\u8f91\u6279\u6b21\u5e93\u5b58-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)list));
        return list;
    }

    private QueryWrapper<LogicInventoryEo> getQueryWrapper(CsLogicInventoryQueryDto queryDto) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)"0");
        if (queryDto.getWarehouseId() != null) {
            wrapper.eq((Object)"warehouse_id", (Object)queryDto.getWarehouseId());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getWarehouseCode()})) {
            wrapper.eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getCargoCode()})) {
            wrapper.like((Object)"sku_code", (Object)queryDto.getCargoCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getCargoName()})) {
            wrapper.like((Object)"sku_name", (Object)("%" + queryDto.getCargoName() + "%"));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getLongCode()})) {
            wrapper.like((Object)"sku_code", (Object)("%" + queryDto.getLongCode() + "%"));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getBatch()})) {
            wrapper.like((Object)"batch", (Object)queryDto.getBatch());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getLongCodes())) {
            wrapper.in((Object)"sku_code", (Collection)queryDto.getLongCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getWarehouseCodeList())) {
            wrapper.in((Object)"warehouse_code", (Collection)queryDto.getWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getBatchList())) {
            wrapper.in((Object)"batch", (Collection)queryDto.getBatchList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getLongCodeBatchPairs())) {
            wrapper.and(w -> {
                for (int i = 0; i < queryDto.getLongCodeBatchPairs().size(); ++i) {
                    CsLogicInventoryQueryDto.LongCodeBatchPair pair = (CsLogicInventoryQueryDto.LongCodeBatchPair)queryDto.getLongCodeBatchPairs().get(i);
                    if (!StringUtils.isNotBlank((CharSequence)pair.getLongCode()) || !StringUtils.isNotBlank((CharSequence)pair.getBatch())) continue;
                    if (i > 0) {
                        w.or();
                    }
                    ((QueryWrapper)w.and(subW -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)subW.eq((Object)"sku_code", (Object)pair.getLongCode())).eq((Object)"batch", (Object)pair.getBatch());
                    })).eq((Object)"dr", (Object)0);
                }
            });
        }
        if (Boolean.TRUE.equals(queryDto.getFilterGtZero())) {
            wrapper.gt((Object)"available", (Object)0);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getFilterLongCodes()) && StringUtils.isNotBlank((CharSequence)queryDto.getUnLikeBatch())) {
            wrapper.apply("( sku_code not in ({0}) or batch not like {1} )", new Object[]{String.join((CharSequence)",", queryDto.getFilterLongCodes()), "%" + queryDto.getUnLikeBatch()});
        } else {
            wrapper.notIn(CollectionUtils.isNotEmpty((Collection)queryDto.getFilterLongCodes()), (Object)"sku_code", (Collection)queryDto.getFilterLongCodes());
            wrapper.apply(StringUtils.isNotBlank((CharSequence)queryDto.getUnLikeBatch()), " batch not like {0} ", new Object[]{"%" + queryDto.getUnLikeBatch()});
        }
        wrapper.isNotNull(queryDto.getFilterProduceTime().booleanValue(), (Object)"produce_time");
        wrapper.isNotNull((Object)"batch");
        wrapper.orderByDesc((Object)queryDto.getOrderByDesc());
        return wrapper;
    }
}

