/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ConsignmentOrderDeliveryInfoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ConsignmentOrderDeliveryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IConsignmentOrderDeliveryInfoService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ConsignmentOrderDeliveryInfoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ConsignmentOrderDeliveryInfoEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.ShippingJsonDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutResultOrderRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dao.das.IInOutResultOrderDas;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsignmentOrderDeliveryInfoServiceImpl
implements IConsignmentOrderDeliveryInfoService {
    @Resource
    private ConsignmentOrderDeliveryInfoDas consignmentOrderDeliveryInfoDas;
    @Resource
    private IInOutResultOrderDas inOutResultOrderDas;

    @Override
    public Long addConsignmentOrderDeliveryInfo(ConsignmentOrderDeliveryInfoReqDto addReqDto) {
        ConsignmentOrderDeliveryInfoEo consignmentOrderDeliveryInfoEo = new ConsignmentOrderDeliveryInfoEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)consignmentOrderDeliveryInfoEo);
        this.consignmentOrderDeliveryInfoDas.insert((BaseEo)consignmentOrderDeliveryInfoEo);
        return consignmentOrderDeliveryInfoEo.getId();
    }

    @Override
    public void modifyConsignmentOrderDeliveryInfo(ConsignmentOrderDeliveryInfoReqDto modifyReqDto) {
        ConsignmentOrderDeliveryInfoEo consignmentOrderDeliveryInfoEo = new ConsignmentOrderDeliveryInfoEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)consignmentOrderDeliveryInfoEo);
        this.consignmentOrderDeliveryInfoDas.updateSelective((BaseEo)consignmentOrderDeliveryInfoEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeConsignmentOrderDeliveryInfo(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.consignmentOrderDeliveryInfoDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ConsignmentOrderDeliveryInfoRespDto queryById(Long id) {
        ConsignmentOrderDeliveryInfoEo consignmentOrderDeliveryInfoEo = (ConsignmentOrderDeliveryInfoEo)this.consignmentOrderDeliveryInfoDas.selectByPrimaryKey(id);
        ConsignmentOrderDeliveryInfoRespDto consignmentOrderDeliveryInfoRespDto = new ConsignmentOrderDeliveryInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)consignmentOrderDeliveryInfoEo, (BaseVo)consignmentOrderDeliveryInfoRespDto);
        return consignmentOrderDeliveryInfoRespDto;
    }

    @Override
    public PageInfo<ConsignmentOrderDeliveryInfoRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ConsignmentOrderDeliveryInfoReqDto consignmentOrderDeliveryInfoReqDto = (ConsignmentOrderDeliveryInfoReqDto)JSON.parseObject((String)filter, ConsignmentOrderDeliveryInfoReqDto.class);
        ConsignmentOrderDeliveryInfoEo consignmentOrderDeliveryInfoEo = new ConsignmentOrderDeliveryInfoEo();
        DtoHelper.dto2Eo((BaseVo)consignmentOrderDeliveryInfoReqDto, (BaseEo)consignmentOrderDeliveryInfoEo);
        PageInfo eoPageInfo = this.consignmentOrderDeliveryInfoDas.selectPage((BaseEo)consignmentOrderDeliveryInfoEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ConsignmentOrderDeliveryInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ConsignmentOrderDeliveryInfoRespDto> queryByParam(ConsignmentOrderDeliveryInfoReqDto consignmentOrderDeliveryInfoReqDto) {
        ConsignmentOrderDeliveryInfoEo consignmentOrderDeliveryInfoEo = new ConsignmentOrderDeliveryInfoEo();
        DtoHelper.dto2Eo((BaseVo)consignmentOrderDeliveryInfoReqDto, (BaseEo)consignmentOrderDeliveryInfoEo);
        List select = this.consignmentOrderDeliveryInfoDas.selectList((BaseEo)consignmentOrderDeliveryInfoEo);
        ArrayList<ConsignmentOrderDeliveryInfoRespDto> list = new ArrayList<ConsignmentOrderDeliveryInfoRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            DtoHelper.eoList2DtoList((Collection)select, list, ConsignmentOrderDeliveryInfoRespDto.class);
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modify(ConsignmentOrderDeliveryInfoReqDto modifyReqDto) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)modifyReqDto.getConsignmentNo()), "\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List infoEoList = ((ExtQueryChainWrapper)this.consignmentOrderDeliveryInfoDas.filter().eq((Object)"consignment_no", (Object)modifyReqDto.getConsignmentNo())).list();
        AssertUtil.isTrue(CollectionUtil.isNotEmpty((Collection)infoEoList), "\u6ca1\u6709\u627e\u5230\u8be5\u8fd0\u5355\u53f7");
        ConsignmentOrderDeliveryInfoEo eo = (ConsignmentOrderDeliveryInfoEo)infoEoList.get(0);
        Long id = eo.getId();
        ConsignmentOrderDeliveryInfoEo consignmentOrderDeliveryInfoEo = new ConsignmentOrderDeliveryInfoEo();
        BeanUtils.copyProperties((Object)modifyReqDto, (Object)consignmentOrderDeliveryInfoEo);
        consignmentOrderDeliveryInfoEo.setId(id);
        this.consignmentOrderDeliveryInfoDas.updateSelective((BaseEo)consignmentOrderDeliveryInfoEo);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)eo.getOutResultNo()), "\u8be5\u8fd0\u5355\u53f7\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u7ed3\u679c\u5355");
        List eoList = ((ExtQueryChainWrapper)this.inOutResultOrderDas.filter().eq((Object)"document_no", (Object)eo.getOutResultNo())).list();
        AssertUtil.isTrue(CollectionUtil.isNotEmpty((Collection)eoList), "\u6ca1\u6709\u627e\u5230\u8be5\u7ed3\u679c\u5355");
        InOutResultOrderEo inOutResultOrderEo = (InOutResultOrderEo)eoList.get(0);
        InOutResultOrderEo orderEo = new InOutResultOrderEo();
        orderEo.setId(inOutResultOrderEo.getId());
        if (StringUtils.isNotBlank((CharSequence)inOutResultOrderEo.getShippingJson())) {
            List shippingJsonDtoList = JSONObject.parseArray((String)inOutResultOrderEo.getShippingJson(), ShippingJsonDto.class);
            for (ShippingJsonDto dto : shippingJsonDtoList) {
                if (StringUtils.isNotBlank((CharSequence)modifyReqDto.getCarrierType())) {
                    dto.setLogisticsType(modifyReqDto.getCarrierType());
                }
                if (StringUtils.isNotBlank((CharSequence)modifyReqDto.getCarrierCode())) {
                    dto.setShippingCompanyCode(modifyReqDto.getCarrierCode());
                }
                if (!StringUtils.isNotBlank((CharSequence)modifyReqDto.getCarrierName())) continue;
                dto.setShippingCompanyName(modifyReqDto.getCarrierName());
            }
            orderEo.setShippingJson(JSON.toJSONString((Object)shippingJsonDtoList));
        }
        orderEo.setShippingCompanyCode(modifyReqDto.getCarrierCode());
        orderEo.setShippingCompany(modifyReqDto.getCarrierName());
        orderEo.setShippingType(modifyReqDto.getCarrierType());
        this.inOutResultOrderDas.updateSelective((BaseEo)orderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyOutResultOrder(CsOutResultOrderRespDto modifyReqDto) {
        AssertUtil.isTrue(modifyReqDto.getId() != null, "id\u4e0d\u80fd\u4e3a\u7a7a");
        InOutResultOrderEo orderEo = (InOutResultOrderEo)this.inOutResultOrderDas.selectByPrimaryKey(modifyReqDto.getId());
        AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)orderEo), "\u8be5id\u4e0d\u5b58\u5728");
        InOutResultOrderEo eo = new InOutResultOrderEo();
        BeanUtils.copyProperties((Object)modifyReqDto, (Object)eo);
        eo.setId(modifyReqDto.getId());
        if (modifyReqDto.getTotalVolume() != null) {
            String volume = modifyReqDto.getTotalVolume().setScale(6, 4).stripTrailingZeros().toPlainString();
            eo.setTotalVolume(new BigDecimal(volume));
        }
        if (modifyReqDto.getTotalWeight() != null) {
            String weight = modifyReqDto.getTotalWeight().setScale(6, 4).stripTrailingZeros().toPlainString();
            eo.setTotalWeight(new BigDecimal(weight));
        }
        this.inOutResultOrderDas.updateSelective((BaseEo)eo);
    }
}

