/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.IGenerateCodeService;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="generateCodeUtils")
public class GenerateCodeUtils {
    static Logger logger = LoggerFactory.getLogger(GenerateCodeUtils.class);
    public static final String GENERATE_CODE_PREFIX = "Cs";
    public static final String GENERATE_CODE_SUFFIX = "ServiceImpl";
    public static final String COMMON = "Common";
    public static final String DELIVERY_NOTICE_ORDER = "DeliveryNoticeOrder";
    public static final String IN_TRANSIT_DELIVERY_NOTICE_ORDER = "InTransitDeliveryNoticeOrder";
    public static final String OUT_NOTICE_ORDER = "OutNoticeOrder";
    public static final String OUT_RESULT_ORDER = "OutResultOrder";
    public static final String DELIVERY_RESULT_ORDER = "DeliveryResultOrder";
    public static final String IN_TRANSIT_DELIVERY_RESULT_ORDER = "InTransitDeliveryResultOrder";
    public static final String RECEIVE_NOTICE_ORDER = "ReceiveNoticeOrder";
    public static final String IN_TRANSIT_RECEIVE_NOTICE_ORDER = "InTransitReceiveNoticeOrder";
    public static final String IN_NOTICE_ORDER = "InNoticeOrder";
    public static final String IN_RESULT_ORDER = "InResultOrder";
    public static final String RECEIVE_RESULT_ORDER = "ReceiveResultOrder";
    public static final String IN_TRANSIT_RECEIVE_RESULT_ORDER = "InTransitReceiveResultOrder";
    public static final String PHYSICS_WAREHOUSE = "PhysicsWarehouse";
    public static final String LOGIC_WAREHOUSE = "LogicWarehouse";
    public static final String VIRTUAL_WAREHOUSE = "VirtualWarehouse";
    public static final String CHANNEL_WAREHOUSE = "ChannelWarehouse";
    public static final String PURCHASE = "purchase";
    public static final String OUTSOURCE = "outsource";
    public static final String PURCHASE_RETREAT = "purchaseRetreat";
    public static final String OUTSOURCE_RETREAT = "outsourceRetreat";
    public static final String PRODUCT_REPAIR = "productionRetreat";
    public static final String PRODUCTION = "production";
    public static final String PRODUCTION_MATERIALS = "production_materials";
    public static final String PRODUCTION_MATERIALS_RETURN = "production_materials_return";
    public static final String BATCH_ADJUSTMENT_ORDER = "BatchAdjustmentOrder";
    public static final String TAKE_STOCK_ORDER = "TakeStockOrder";
    public static final String QUALITY_DETAIL = "QualityDetail";
    public static final String OTHER_STORAGE_ORDER = "otherStorageOrder";
    public static final String OTHER_STORAGE_ORDER_OUT = "otherStorageOrderOut";
    public static final String OTHER_STORAGE_ORDER_IN = "otherStorageOrderIn";
    public static final String TRANSFER_ORDER = "transferOrder";
    public static final String DISPATCHER_ORDER = "dispatcherOrder";
    public static final String PCP_TRANSFER_ORDER = "pcpTransferOrder";
    public static final String CLAIM_TRANSFER_ORDER = "claimTransferOrder";
    public static final String BORROW_TRANSFER_ORDER = "borrowTransferOrder";
    public static final String IN_TRANSIT_TRANSFER_ORDER = "inTransitTransferOrder";
    public static final String LOCK_ORDER = "lockOrder";
    public static final String UNLOCK_ORDER = "unlockOrder";
    public static final String SHARE_GOODS_ORDER = "ShareGoodsOrder";
    public static final String ADJUSTMENT_INVENTORY_ORDER = "adjustmentInventoryOrder";
    public static final String IN_TRANSIT_ADJUSTMENT_INVENTORY_ORDER = "inTransitAdjustmentInventoryOrder";
    public static final String RECEIVE_STRATEGY = "receiveStrategy";
    public static final String SHOP_ENQUIRY_APPLY = "shopEnquiryApply";
    @Autowired
    private List<IGenerateCodeService> generateCodeServiceList;
    private static Map<String, IGenerateCodeService> generateCodeServiceMap = Maps.newConcurrentMap();

    @PostConstruct
    public void initStrategy() {
        generateCodeServiceMap = this.generateCodeServiceList.stream().collect(Collectors.toMap(IGenerateCodeService::getGenerateCodeStrategy, Function.identity()));
    }

    public static IGenerateCodeService getStrategy(String generateCodeStrategy) {
        logger.info("getStrategy==>\u83b7\u53d6\u751f\u6210\u7f16\u7801\u7b56\u7565\u7c7b,generateCodeStrategy:{}", (Object)generateCodeStrategy);
        if (StringUtils.isBlank((CharSequence)generateCodeStrategy)) {
            return generateCodeServiceMap.get(CsGenerateCodeStrategyEnum.COMMON.getCode());
        }
        CsGenerateCodeStrategyEnum generateCodeStrategyEnum = CsGenerateCodeStrategyEnum.getByCode((String)generateCodeStrategy);
        if (null == generateCodeStrategyEnum) {
            throw new BizException(String.format("\u3010%s\u3011\u7f16\u7801\u751f\u6210\u7b56\u7565\u6709\u8bef", generateCodeStrategy));
        }
        return generateCodeServiceMap.get(generateCodeStrategyEnum.getCode());
    }
}

