/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.CsBasicsExternalStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.ICsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsShipmenetEnterpriseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsShipmenetEnterpriseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsWmsBasicsDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsExternalStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.CsOutNoticePushStatusEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="csSinceTheClosedLoopHandlerService")
public class CsSinceTheClosedLoopHandlerService {
    private static final Logger logger = LoggerFactory.getLogger(CsSinceTheClosedLoopHandlerService.class);
    private final String DEFAULT_OTHER = "OTHER";
    private final String DEFALUT_NO = "XN123456";
    private final String ZT = "ZT";
    private final String OTHER = "OTHER";
    private final String ZT_SHIPMENT_NO = "zitifahuo";
    private final String OTHER_SHIPMENT_NO = "xunifahuo";
    @Autowired
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Autowired
    private CsShipmenetEnterpriseMapper shipmenetEnterpriseMapper;

    public void handleByDocumentNo(String documentNo) {
        logger.info("handleByDocumentNo==>\u81ea\u95ed\u73af\u6839\u636e\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7\u8fdb\u884c\u5904\u7406,documentNo:{}", (Object)documentNo);
        QueryWrapper csOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        csOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        csOutNoticeOrderEoQueryWrapper.in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.INO_WAIT_IN.getCode()}));
        List csOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)csOutNoticeOrderEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csOutNoticeOrderEoList)) {
            logger.error("handleByDocumentNo==>\u81ea\u95ed\u73af\u6839\u636e\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7\u8fdb\u884c\u5904\u7406\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f,documentNo:{}", (Object)documentNo);
            return;
        }
        InOutNoticeOrderEo csOutNoticeOrderEo = (InOutNoticeOrderEo)csOutNoticeOrderEoList.get(0);
        if (CsOutNoticePushStatusEnum.WITHOUT_PUSH.getCode().equals(csOutNoticeOrderEo.getPushStatus())) {
            logger.error("handleByDocumentNo==>\u81ea\u95ed\u73af\u6839\u636e\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7documentNo:{} \u72b6\u6001\u5df2\u662f\uff1a\u3010\u4e0d\u9700\u8981\u63a8\u9001\u3011\uff0c\u65e0\u9700\u5904\u7406", (Object)documentNo);
            return;
        }
        QueryWrapper csOutNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        csOutNoticeOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csOutNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        List outNoticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)csOutNoticeOrderDetailEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)outNoticeOrderDetailEoList)) {
            logger.error("handleByDocumentNo==>\u81ea\u95ed\u73af\u6839\u636e\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7\u8fdb\u884c\u5904\u7406\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5546\u54c1\u660e\u7ec6\u4fe1\u606f,documentNo:{}", (Object)documentNo);
            return;
        }
        csOutNoticeOrderEoQueryWrapper.clear();
        csOutNoticeOrderEoQueryWrapper.eq((Object)"id", (Object)csOutNoticeOrderEo.getId());
        csOutNoticeOrderEo.setPushStatus(CsOutNoticePushStatusEnum.WITHOUT_PUSH.getCode());
        this.inOutNoticeOrderDomain.getMapper().update((Object)csOutNoticeOrderEo, (Wrapper)csOutNoticeOrderEoQueryWrapper);
        String orderType = csOutNoticeOrderEo.getOrderType();
        if ("in".equals(orderType)) {
            this.handleInNotice(csOutNoticeOrderEo, outNoticeOrderDetailEoList);
        } else {
            this.handleOutNotice(csOutNoticeOrderEo, outNoticeOrderDetailEoList);
        }
    }

    private void formatDefaultShipmentInfo(InOutNoticeOrderEo csOutNoticeOrderEo, CsBasicsReceiveReqDto csBasicsReceiveReqDto) {
        logger.info("formatDefaultShipmentInfo==>\u81ea\u95ed\u73af\u7269\u6d41\u5904\u7406,csOutNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(csOutNoticeOrderEo));
        String shipmentEnterpriseCode = csOutNoticeOrderEo.getShipmentEnterpriseCode();
        if (!"ZT".equals(shipmentEnterpriseCode) && !"OTHER".equals(shipmentEnterpriseCode)) {
            return;
        }
        String shippingNo = "xunifahuo";
        if ("ZT".equals(shipmentEnterpriseCode)) {
            shippingNo = "zitifahuo";
        }
        String shipmentName = this.getShipmentName(shipmentEnterpriseCode);
        csOutNoticeOrderEo.setShipmentEnterpriseCode(shipmentEnterpriseCode);
        csOutNoticeOrderEo.setShipmentEnterpriseName(shipmentName);
        ArrayList<CsWmsShippingInfoReqDto> shippingInfoReqDtoList = new ArrayList<CsWmsShippingInfoReqDto>(1);
        CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = new CsWmsShippingInfoReqDto();
        csWmsShippingInfoReqDto.setShippingNo(shippingNo);
        csWmsShippingInfoReqDto.setShippingCompanyCode(csOutNoticeOrderEo.getShipmentEnterpriseCode());
        csWmsShippingInfoReqDto.setShippingCompanyName(csOutNoticeOrderEo.getShippingCompanyName());
        csWmsShippingInfoReqDto.setOutNoticeOrderNo(csOutNoticeOrderEo.getDocumentNo());
        csWmsShippingInfoReqDto.setPlatformOrderNo(csOutNoticeOrderEo.getExternalOrderNo());
        csWmsShippingInfoReqDto.setDeliveryTime(new Date());
        shippingInfoReqDtoList.add(csWmsShippingInfoReqDto);
        logger.info("formatDefaultShipmentInfo==>\u81ea\u95ed\u73af\u7269\u6d41\u5904\u7406,shippingInfoReqDtoList:{}", (Object)LogUtils.buildLogContent(shippingInfoReqDtoList));
        csBasicsReceiveReqDto.setShippingInfoReqDtoList(shippingInfoReqDtoList);
        csBasicsReceiveReqDto.setSinceTheClosedLoopFlag(Boolean.TRUE);
    }

    private String getShipmentName(String shippingCompanyCode) {
        QueryWrapper csShipmenetEnterpriseEoQueryWrapper = new QueryWrapper();
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"shipment_enterprise_code", (Object)shippingCompanyCode);
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"shipment_enterprise_status", (Object)YesNoEnum.YES.getValue());
        List csShipmenetEnterpriseEoList = this.shipmenetEnterpriseMapper.selectList((Wrapper)csShipmenetEnterpriseEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csShipmenetEnterpriseEoList)) {
            return null;
        }
        return ((CsShipmenetEnterpriseEo)csShipmenetEnterpriseEoList.get(0)).getShipmentEnterpriseName();
    }

    private void handleOutNotice(InOutNoticeOrderEo csOutNoticeOrderEo, List<InOutNoticeOrderDetailEo> outNoticeOrderDetailEoList) {
        logger.info("handleOutNotice==>\u51fa\u5e93,csOutNoticeOrderEo:{},outNoticeOrderDetailEoList:{}", (Object)LogUtils.buildLogContent(csOutNoticeOrderEo), (Object)LogUtils.buildLogContent(outNoticeOrderDetailEoList));
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
        csBasicsReceiveReqDto.setPlatformOrderNo(csOutNoticeOrderEo.getExternalOrderNo());
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(csOutNoticeOrderEo.getDocumentNo());
        csBasicsReceiveReqDto.setInOutTime(new Date());
        csBasicsReceiveReqDto.setWmsOrderNo(IdUtils.getId() + "");
        csBasicsReceiveReqDto.setEstimatedTime(new Date());
        csBasicsReceiveReqDto.setMergeQuantity(BigDecimal.ZERO);
        csBasicsReceiveReqDto.setTotalCartons(BigDecimal.ZERO);
        csBasicsReceiveReqDto.setShippingInfoReqDtoList(null);
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (InOutNoticeOrderDetailEo outNoticeOrderDetailEo : outNoticeOrderDetailEoList) {
            CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto = new CsWmsBasicsDetailReqDto();
            csWmsBasicsDetailReqDto.setBatch(outNoticeOrderDetailEo.getBatch());
            csWmsBasicsDetailReqDto.setQuantity(outNoticeOrderDetailEo.getPlanQuantity());
            csWmsBasicsDetailReqDto.setSkuCode(outNoticeOrderDetailEo.getSkuCode());
            csWmsBasicsDetailReqDto.setWarehouseCode(csOutNoticeOrderEo.getOutLogicWarehouseCode());
            csWmsBasicsDetailReqDto.setTradeOrderItemId(outNoticeOrderDetailEo.getPreOrderItemId());
            detailReqDtoList.add(csWmsBasicsDetailReqDto);
        }
        csBasicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
        this.formatDefaultShipmentInfo(csOutNoticeOrderEo, csBasicsReceiveReqDto);
        logger.info("handleOutNotice==>\u51fa\u5e93,csBasicsReceiveReqDto:{}", (Object)LogUtils.buildLogContent(csBasicsReceiveReqDto));
        wmsExternalService.receiveOut(csBasicsReceiveReqDto);
    }

    private void handleInNotice(InOutNoticeOrderEo csOutNoticeOrderEo, List<InOutNoticeOrderDetailEo> outNoticeOrderDetailEoList) {
        logger.info("handleInNotice==>\u5165\u5e93,csOutNoticeOrderEo:{},outNoticeOrderDetailEoList:{}", (Object)LogUtils.buildLogContent(csOutNoticeOrderEo), (Object)LogUtils.buildLogContent(outNoticeOrderDetailEoList));
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
        csBasicsReceiveReqDto.setPlatformOrderNo(csOutNoticeOrderEo.getExternalOrderNo());
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(csOutNoticeOrderEo.getDocumentNo());
        csBasicsReceiveReqDto.setInOutTime(new Date());
        csBasicsReceiveReqDto.setWmsOrderNo(IdUtils.getId() + "");
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (InOutNoticeOrderDetailEo inDetailEo : outNoticeOrderDetailEoList) {
            CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto = new CsWmsBasicsDetailReqDto();
            csWmsBasicsDetailReqDto.setBatch(inDetailEo.getBatch());
            csWmsBasicsDetailReqDto.setQuantity(inDetailEo.getPlanQuantity());
            csWmsBasicsDetailReqDto.setSkuCode(inDetailEo.getSkuCode());
            csWmsBasicsDetailReqDto.setWarehouseCode(csOutNoticeOrderEo.getInLogicWarehouseCode());
            csWmsBasicsDetailReqDto.setTradeOrderItemId(inDetailEo.getPreOrderItemId());
            csWmsBasicsDetailReqDto.setProduceTime(new Date());
            detailReqDtoList.add(csWmsBasicsDetailReqDto);
        }
        csBasicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
        this.formatDefaultShipmentInfo(csOutNoticeOrderEo, csBasicsReceiveReqDto);
        logger.info("handleOutNotice==>\u5165\u5e93,csBasicsReceiveReqDto:{}", (Object)LogUtils.buildLogContent(csBasicsReceiveReqDto));
        wmsExternalService.receiveIn(csBasicsReceiveReqDto);
    }
}

