/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.mj.biz.commons.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.ICsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.constant.SendBackBizTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInPlannedOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsOutPlannedOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsWmsBasicsDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.basicdata.api.IPcpDictApi;
import com.yunxi.dg.base.center.basicdata.enums.DictEnum;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.ProjectEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractCsBasicsExternalService
implements ICsBasicsExternalService {
    private static final Logger log = LoggerFactory.getLogger(AbstractCsBasicsExternalService.class);
    protected BigDecimal overchargeProportion = new BigDecimal(1.1);
    @Resource
    private CsCommonService csCommonService;
    @Autowired
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    private IPcpDictApi pcpDictApi;
    @Autowired
    private CsInPlannedOrderMapper csInPlannedOrderMapper;
    @Autowired
    IItemSkuQueryApiProxy itemSkuQueryApiProxy;
    @Value(value="${ignore.batch.flag:false}")
    protected Boolean ignoreBatch;
    @Value(value="${ignore.overcharge.flag:false}")
    protected Boolean ignoreOvercharge;
    @Value(value="${yunxi.dg.base.project}")
    protected String projectCode;
    @Autowired
    protected ILogicInventoryDomain logicInventoryDomain;
    @Autowired
    protected ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    protected CsOutPlannedOrderMapper csOutPlannedOrderMapper;
    @Autowired
    protected IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Autowired
    protected CsTransferOrderMapper csTransferOrderMapper;

    @Override
    public Boolean send(CsBasicsOrderReqDto sendInfo) {
        return null;
    }

    @Override
    public Boolean receive(CsBasicsOrderReqDto receiveInfo) {
        return null;
    }

    @Override
    public Boolean receiveIn(CsBasicsReceiveReqDto csBasicsReceiveReqDto) {
        return null;
    }

    @Override
    public Boolean receiveInWms(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        return null;
    }

    @Override
    public Boolean receiveOut(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        return null;
    }

    protected void matchLineNo(List<CsWmsBasicsDetailReqDto> detailReqDtoList, List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEoList) {
        Map<String, Long> sourceMap;
        for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : detailReqDtoList) {
            csWmsBasicsDetailReqDto.setTradeOrderItemId(null);
        }
        boolean hasPreOrderNo = detailReqDtoList.stream().noneMatch(d -> Objects.isNull(d.getTradeOrderItemId()));
        if (hasPreOrderNo) {
            detailReqDtoList.forEach(detail -> inOutNoticeOrderDetailEoList.stream().filter(o -> Objects.equals(detail.getTradeOrderItemId(), o.getPreOrderItemId())).findFirst().ifPresent(noticeDetailEo -> detail.setLineNo(noticeDetailEo.getLineNo())));
        } else if (InventoryConfig.isNoneBatch()) {
            sourceMap = inOutNoticeOrderDetailEoList.stream().collect(Collectors.toMap(InOutNoticeOrderDetailEo::getSkuCode, InOutNoticeOrderDetailEo::getLineNo, (o, o1) -> o));
            detailReqDtoList.forEach(d -> d.setLineNo((Long)sourceMap.get(d.getSkuCode())));
        } else {
            sourceMap = inOutNoticeOrderDetailEoList.stream().collect(Collectors.toMap(i -> i.getSkuCode() + i.getBatch(), Function.identity(), (o, o1) -> o));
            Map<Long, BigDecimal> marginMap = inOutNoticeOrderDetailEoList.stream().collect(Collectors.toMap(BaseEo::getId, InOutNoticeOrderDetailEo::getWaitQuantity));
            Optional.of(detailReqDtoList.stream().filter(r -> Optional.ofNullable(sourceMap.get(r.getSkuCode() + r.getBatch())).map(eo -> {
                r.setLineNo(eo.getLineNo());
                r.setTradeOrderItemId(eo.getPreOrderItemId());
                marginMap.computeIfPresent(eo.getId(), (d, v) -> {
                    BigDecimal subtract = v.subtract(r.getQuantity());
                    if (subtract.compareTo(BigDecimal.ZERO) < 1) {
                        return null;
                    }
                    return subtract;
                });
                return false;
            }).orElse(true)).collect(Collectors.toList())).filter(CollectionUtils::isNotEmpty).ifPresent(list -> {
                Map<String, List<InOutNoticeOrderDetailEo>> codeSourceMap = inOutNoticeOrderDetailEoList.stream().sorted(Comparator.comparing(BaseEo::getId)).collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getSkuCode));
                list.forEach(k -> Optional.ofNullable(codeSourceMap.get(k.getSkuCode())).ifPresent(eoList -> {
                    if (eoList.size() == 1) {
                        k.setLineNo(((InOutNoticeOrderDetailEo)eoList.get(0)).getLineNo());
                        k.setTradeOrderItemId(((InOutNoticeOrderDetailEo)eoList.get(0)).getPreOrderItemId());
                    }
                    for (InOutNoticeOrderDetailEo inOutNoticeOrderDetailEo : eoList) {
                        BigDecimal decimal = (BigDecimal)marginMap.get(inOutNoticeOrderDetailEo.getId());
                        if (Objects.isNull(decimal)) continue;
                        marginMap.computeIfPresent(inOutNoticeOrderDetailEo.getId(), (d, v) -> {
                            BigDecimal subtract = v.subtract(k.getQuantity());
                            if (subtract.compareTo(BigDecimal.ZERO) < 1) {
                                return null;
                            }
                            return subtract;
                        });
                        k.setLineNo(inOutNoticeOrderDetailEo.getLineNo());
                        break;
                    }
                    k.setLineNo(((InOutNoticeOrderDetailEo)eoList.get(0)).getLineNo());
                    k.setTradeOrderItemId(((InOutNoticeOrderDetailEo)eoList.get(0)).getPreOrderItemId());
                }));
            });
        }
    }

    protected void checkParams(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        log.info("checkParams==>\u53c2\u6570\u6821\u9a8c,basicsReceiveBasicsReqDto:{}", (Object)LogUtils.buildLogContent(basicsReceiveBasicsReqDto));
        AssertUtil.isTrue(null != basicsReceiveBasicsReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String wmsOrderNo = basicsReceiveBasicsReqDto.getWmsOrderNo();
        String inNoticeOrderNo = basicsReceiveBasicsReqDto.getInOutNoticeOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inNoticeOrderNo), "\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        if (null != basicsReceiveBasicsReqDto.getZeroDetailCount() && basicsReceiveBasicsReqDto.getZeroDetailCount().booleanValue()) {
            return;
        }
        List detailReqDtoList = basicsReceiveBasicsReqDto.getDetailReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)detailReqDtoList), "\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsWmsBasicsDetailReqDto detailReqDto : detailReqDtoList) {
            String batch = detailReqDto.getBatch();
            if (SendBackBizTypeEnum.E3.getCode().equals(basicsReceiveBasicsReqDto.getBizType()) && StringUtils.isBlank((CharSequence)batch)) {
                batch = "20221221-666";
                detailReqDto.setBatch(batch);
            }
            AssertUtil.isTrue(ProjectEnum.getByCode((String)this.projectCode).getNoneBatch() != false || StringUtils.isNotBlank((CharSequence)batch), "\u5546\u54c1\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
            String skuCode = detailReqDto.getSkuCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)skuCode), "\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal quantity = detailReqDto.getQuantity();
            AssertUtil.isTrue(null != quantity, "\u5546\u54c1\u6570\u91cf\u6709\u8bef");
            String warehouseCode = detailReqDto.getWarehouseCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseCode), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)wmsOrderNo)) {
            QueryWrapper InOutResultOrderEoQueryWrapper = new QueryWrapper();
            InOutResultOrderEoQueryWrapper.eq((Object)"wms_order_no", (Object)wmsOrderNo);
            List InOutResultOrderEoList = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)InOutResultOrderEoQueryWrapper);
            AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)InOutResultOrderEoList), "WMS\u5355\u53f7\u5df2\u5b58\u5728");
        }
    }

    protected void checkParamsForE3(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        log.info("checkParams==>\u53c2\u6570\u6821\u9a8c,basicsReceiveBasicsReqDto:{}", (Object)LogUtils.buildLogContent(basicsReceiveBasicsReqDto));
        AssertUtil.isTrue(null != basicsReceiveBasicsReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String wmsOrderNo = basicsReceiveBasicsReqDto.getWmsOrderNo();
        String inNoticeOrderNo = basicsReceiveBasicsReqDto.getInOutNoticeOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inNoticeOrderNo), "\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        if (basicsReceiveBasicsReqDto.getZeroDetailCount().booleanValue()) {
            return;
        }
        List detailReqDtoList = basicsReceiveBasicsReqDto.getDetailReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)detailReqDtoList), "\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsWmsBasicsDetailReqDto detailReqDto : detailReqDtoList) {
            if (StringUtils.isBlank((CharSequence)detailReqDto.getBatch())) {
                detailReqDto.setBatch("20221221-666");
            }
            String skuCode = detailReqDto.getSkuCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)skuCode), "\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal quantity = detailReqDto.getQuantity();
            AssertUtil.isTrue(null != quantity, "\u5546\u54c1\u6570\u91cf\u6709\u8bef");
        }
        List longCodeList = detailReqDtoList.stream().map(CsWmsBasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
        List skuDtoList = this.itemSkuQueryApiProxy.queryBySkuCodes(longCodeList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)skuDtoList), "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        if (StringUtils.isNotBlank((CharSequence)wmsOrderNo)) {
            QueryWrapper csOutResultOrderEoQueryWrapper = new QueryWrapper();
            csOutResultOrderEoQueryWrapper.eq((Object)"wms_order_no", (Object)wmsOrderNo);
            List csOutResultOrderEoList = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)csOutResultOrderEoQueryWrapper);
            AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)csOutResultOrderEoList), "WMS\u5355\u53f7\u5df2\u5b58\u5728");
        }
    }

    protected void buildOverchargeProportion(InOutNoticeOrderEo InOutNoticeOrderEo2) {
        log.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,InOutNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(InOutNoticeOrderEo2));
        String relevanceTableName = InOutNoticeOrderEo2.getRelevanceTableName();
        if (!CsRelevanceTableNameEnum.CS_IN_PLANNED_ORDER.getCode().equals(relevanceTableName)) {
            this.overchargeProportion = BigDecimal.ONE;
            return;
        }
        String orderType = InOutNoticeOrderEo2.getOrderType();
        if (!"in".equals(orderType)) {
            this.overchargeProportion = BigDecimal.ONE;
            return;
        }
        String plannedOrderType = this.getPlannedOrderType(InOutNoticeOrderEo2);
        String code = DictEnum.PURCHASE_ORDER_RATIO.getCode();
        if (CsPlannedOrderTypeEnum.PRODUCTION.getCode().equals(plannedOrderType)) {
            code = DictEnum.PRODUCTION_ORDER_RATIO.getCode();
        } else if (CsPlannedOrderTypeEnum.OUTSOURCE.getCode().equals(plannedOrderType)) {
            code = DictEnum.OUT_SOURCED_ORDER_RATIO.getCode();
        }
        try {
            log.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,GROUP_CODE:{},code:{}", (Object)DictEnum.PURCHASE_ORDER_RATIO.getGroupCode(), (Object)code);
            RestResponse dtoRestResponse = this.pcpDictApi.queryByGroupCodeAndCode(DictEnum.PURCHASE_ORDER_RATIO.getGroupCode(), code);
            DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)dtoRestResponse);
            log.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,dictDto:{}", (Object)LogUtils.buildLogContent(dictDto));
            AssertUtil.isTrue(null != dictDto, "\u8ba1\u5212\u5165\u5355\u636e\u7c7b\u672a\u914d\u7f6e\u8d85\u6536\u6bd4\u4f8b\u4fe1\u606f");
            if (null == dictDto) {
                return;
            }
            String value = dictDto.getValue();
            Integer intVal = Integer.valueOf(value);
            BigDecimal decimalVal = new BigDecimal(intVal).divide(new BigDecimal(100));
            this.overchargeProportion = decimalVal.add(BigDecimal.ONE);
            log.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,\u57fa\u7840\u6570\u636e\u4e2d\u5fc3\u8ba1\u7b97\u4e4b\u540e\u7684,overchargeProportion:{}", (Object)this.overchargeProportion);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getPlannedOrderType(InOutNoticeOrderEo InOutNoticeOrderEo2) {
        String relevanceNo = InOutNoticeOrderEo2.getRelevanceNo();
        QueryWrapper csInPlannedOrderEoQueryWrapper = new QueryWrapper();
        csInPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csInPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)relevanceNo);
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)csInPlannedOrderEoQueryWrapper);
        AssertUtil.isTrue(null != csInPlannedOrderEo, "\u67e5\u8be2\u4e0d\u5230\u8ba1\u5212\u5355\u636e\u4fe1\u606f");
        return csInPlannedOrderEo.getOrderType();
    }

    @Override
    public Boolean cancel(CsBasicsCancelReqDto csBasicsCancelReqDto) {
        return null;
    }

    @Override
    public void pushPackageMaterialDeliveryResultOrderMsg(CsOrderBusinessCallBackContext callBackContext) {
    }

    @Override
    public void createConsignmentOrder(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
    }

    protected String checkOverchargeIn(InOutNoticeOrderEo noticeOrderEo, List<InOutNoticeOrderDetailEo> noticeOrderDetailEos, List<CsWmsBasicsDetailReqDto> wmsDetailDtos) {
        ArrayList errorList = Lists.newArrayList();
        String formatStr = "SKU\uff1a%s\uff0c\u8ba1\u5212\u5165\u5e93\u6570\u91cf\uff1a%s\uff0c\u5b9e\u9645\u7d2f\u8ba1\u5df2\u5165\u5e93\u6570\u91cf\uff1a%s\uff0c\u8d85\u8fc7\u51c6\u5165\u6570\u91cf\uff0c\u7cfb\u7edf\u6302\u8d77\u3002";
        HashMap planInMap = Maps.newHashMap();
        for (InOutNoticeOrderDetailEo noticeOrderDetailEo : noticeOrderDetailEos) {
            planInMap.put(noticeOrderDetailEo.getSkuCode(), BigDecimalUtils.add((BigDecimal)((BigDecimal)planInMap.get(noticeOrderDetailEo.getSkuCode())), (BigDecimal)noticeOrderDetailEo.getPlanQuantity()));
        }
        HashMap hasInMap = Maps.newHashMap();
        List inOutResultOrderEos = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderEo.class).eq(InOutResultOrderEo::getPreOrderNo, (Object)noticeOrderEo.getDocumentNo())).in(InOutResultOrderEo::getOrderStatus, (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.IRO_DONE_IN.getCode(), BaseOrderStatusEnum.IRO_HANG_UP.getCode()}))).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isNotEmpty((Collection)inOutResultOrderEos)) {
            List resultOrderDocumentList = inOutResultOrderEos.stream().map(InOutResultOrderEo::getDocumentNo).distinct().collect(Collectors.toList());
            List inOutResultOrderDetailEos = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderDetailEo.class).in(InOutResultOrderDetailEo::getDocumentNo, resultOrderDocumentList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            for (InOutResultOrderDetailEo inOutResultOrderDetailEo : inOutResultOrderDetailEos) {
                hasInMap.put(inOutResultOrderDetailEo.getSkuCode(), BigDecimalUtils.add((BigDecimal)((BigDecimal)hasInMap.get(inOutResultOrderDetailEo.getSkuCode())), (BigDecimal)inOutResultOrderDetailEo.getDoneQuantity()));
            }
        }
        HashMap targetInMap = Maps.newHashMap();
        for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : wmsDetailDtos) {
            targetInMap.put(csWmsBasicsDetailReqDto.getSkuCode(), BigDecimalUtils.add((BigDecimal)((BigDecimal)targetInMap.get(csWmsBasicsDetailReqDto.getSkuCode())), (BigDecimal)csWmsBasicsDetailReqDto.getQuantity()));
        }
        for (Map.Entry entry : targetInMap.entrySet()) {
            BigDecimal hasIn;
            BigDecimal planIn = BigDecimalUtils.multiply((BigDecimal)((BigDecimal)planInMap.get(entry.getKey())), (BigDecimal)this.overchargeProportion);
            BigDecimal availableIn = BigDecimalUtils.subtract((BigDecimal)planIn, (BigDecimal)(hasIn = (BigDecimal)hasInMap.get(entry.getKey())));
            if (!BigDecimalUtils.lt((BigDecimal)availableIn, (BigDecimal)((BigDecimal)entry.getValue())).booleanValue()) continue;
            errorList.add(String.format(formatStr, entry.getKey(), BigDecimalUtils.toStr((BigDecimal)((BigDecimal)planInMap.get(entry.getKey()))), BigDecimalUtils.toStr((BigDecimal)hasIn)));
        }
        return StringUtils.join((Iterable)errorList, (String)",");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String checkOverchargeFlag(InOutNoticeOrderEo noticeOrderEo, Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, List<CsWmsBasicsDetailReqDto> wmsDetailDtos) {
        log.info("\u5f00\u59cb\u5904\u7406\u6302\u8d77\u5224\u65ad................");
        log.info("noticeDetails: {}", (Object)LogUtils.buildLogContent(batchNoticeDetailEosMap));
        log.info("wmsDetails: {}", (Object)LogUtils.buildLogContent(wmsDetailDtos));
        boolean inFlag = StringUtils.equals((CharSequence)"in", (CharSequence)noticeOrderEo.getOrderType());
        String checkEqualBatchMsg = this.checkEqualBatch(batchNoticeDetailEosMap, wmsDetailDtos, inFlag);
        boolean isEqualBatch = StringUtils.isBlank((CharSequence)checkEqualBatchMsg);
        String checkEqualSumMsg = this.checkEqualSum(batchNoticeDetailEosMap, wmsDetailDtos, inFlag);
        boolean isEqualSum = StringUtils.isBlank((CharSequence)checkEqualSumMsg);
        boolean isEqualBatchAndNum = true;
        String checkEqualBatchAndNumMsg = "";
        if (isEqualBatch && isEqualSum) {
            checkEqualBatchAndNumMsg = this.checkEqualBatchAndNum(batchNoticeDetailEosMap, wmsDetailDtos, inFlag);
            isEqualBatchAndNum = StringUtils.isBlank((CharSequence)checkEqualBatchAndNumMsg);
        }
        log.info("isEqualBatch: {}, isEqualSum: {}", (Object)isEqualBatch, (Object)isEqualSum);
        if (CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode().equals(noticeOrderEo.getRelevanceTableName())) {
            if (!isEqualSum) {
                return checkEqualSumMsg;
            }
            if (inFlag) return "";
            return this.checkInventory(noticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, false);
        }
        if (CsRelevanceTableNameEnum.CS_ORDER_SALE_REFUND.getCode().equals(noticeOrderEo.getRelevanceTableName())) {
            if (isEqualSum) return "";
            return checkEqualSumMsg;
        }
        if (CsRelevanceTableNameEnum.CS_IN_PLANNED_ORDER.getCode().equals(noticeOrderEo.getRelevanceTableName())) {
            CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsInPlannedOrderEo.class).eq(CsInPlannedOrderEo::getOrderNo, (Object)noticeOrderEo.getRelevanceNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtil.assertNotNull(csInPlannedOrderEo, "\u8ba1\u5212\u5165\u8ba2\u5355\u67e5\u8be2\u4e0d\u5b58\u5728: {}", noticeOrderEo.getRelevanceNo());
            if (!CsPcpBusinessTypeEnum.PRODUCTION.getCode().equals(csInPlannedOrderEo.getBusinessType()) || isEqualBatch) return "";
            return checkEqualBatchMsg;
        }
        if (CsRelevanceTableNameEnum.CS_OUT_PLANNED_ORDER.getCode().equals(noticeOrderEo.getRelevanceTableName())) {
            CsOutPlannedOrderEo csOutPlannedOrderEo = (CsOutPlannedOrderEo)this.csOutPlannedOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsOutPlannedOrderEo.class).eq(CsOutPlannedOrderEo::getOrderNo, (Object)noticeOrderEo.getRelevanceNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtil.assertNotNull(csOutPlannedOrderEo, "\u8ba1\u5212\u51fa\u8ba2\u5355\u67e5\u8be2\u4e0d\u5b58\u5728: {}", noticeOrderEo.getRelevanceNo());
            if (CsPcpBusinessTypeEnum.PURCHASE_REFUND.getCode().equals(csOutPlannedOrderEo.getBusinessType())) {
                if (!isEqualSum) {
                    return checkEqualSumMsg;
                }
                if (inFlag) return "";
                return this.checkInventory(noticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, false);
            }
            if (!CsPcpBusinessTypeEnum.PRODUCT_REPAIR.getCode().equals(csOutPlannedOrderEo.getBusinessType())) return "";
            if (!isEqualBatch) {
                return checkEqualBatchMsg;
            }
            if (isEqualSum) return "";
            return checkEqualSumMsg;
        }
        if (CsRelevanceTableNameEnum.CS_OTHER_STORAGE_ORDER.getCode().equals(noticeOrderEo.getRelevanceTableName())) {
            if (!isEqualSum) {
                return checkEqualSumMsg;
            }
            if (inFlag) return "";
            return this.checkInventory(noticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, false);
        }
        if (!CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(noticeOrderEo.getRelevanceTableName())) return "";
        CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)this.csTransferOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getTransferOrderNo, (Object)noticeOrderEo.getRelevanceNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(csTransferOrderEo, "\u8c03\u62e8\u5355\u5355\u67e5\u8be2\u4e0d\u5b58\u5728: {}", noticeOrderEo.getRelevanceNo());
        if (CsPcpBusinessTypeEnum.ALLOT_OUT.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.MAIYOU_ALLOT_OUT.getCode().equals(csTransferOrderEo.getType())) {
            if (inFlag) {
                if (!isEqualBatch) {
                    return checkEqualBatchMsg;
                }
                if (this.checkGt(batchNoticeDetailEosMap, wmsDetailDtos)) {
                    return checkEqualSumMsg;
                }
                if (isEqualBatchAndNum) return "";
                return checkEqualBatchAndNumMsg;
            }
            if (!this.checkGt(batchNoticeDetailEosMap, wmsDetailDtos)) return this.checkInventory(noticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, false);
            return checkEqualSumMsg;
        }
        if (CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.INTERNAL_ALLOT.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.INTERNAL_DEAL_BA.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL_BA.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN_BA.getCode().equals(csTransferOrderEo.getType())) {
            if (!isEqualSum) {
                return checkEqualSumMsg;
            }
            if (inFlag) return "";
            return this.checkInventory(noticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, inFlag);
        }
        if (CsPcpBusinessTypeEnum.ALLOT_LOSE_EFFICACY.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.INSPECTION_UNQUALIFIED.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.INSPECTION_QUALIFIED.getCode().equals(csTransferOrderEo.getType())) {
            if (!isEqualBatch) {
                return checkEqualBatchMsg;
            }
            if (isEqualSum) return "";
            return checkEqualSumMsg;
        }
        if (CsPcpBusinessTypeEnum.BC_ALLOT.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.BC_EQUAL_ALLOT.getCode().equals(csTransferOrderEo.getType())) {
            if (!isEqualSum) {
                return checkEqualSumMsg;
            }
            if (inFlag) return "";
            return this.checkInventory(noticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, inFlag);
        }
        if (CsPcpBusinessTypeEnum.CB_ALLOT.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.CB_EQUAL_ALLOT.getCode().equals(csTransferOrderEo.getType())) {
            if (isEqualSum) return "";
            return checkEqualSumMsg;
        }
        if (CsPcpBusinessTypeEnum.CC_ALLOT.getCode().equals(csTransferOrderEo.getType())) {
            if (isEqualSum) return "";
            return checkEqualSumMsg;
        }
        if (CsPcpBusinessTypeEnum.ALLOT_IN_ONLY.getCode().equals(csTransferOrderEo.getType())) {
            if (!isEqualBatch) {
                return checkEqualBatchMsg;
            }
            if (!this.checkGt(batchNoticeDetailEosMap, wmsDetailDtos)) return "";
            return checkEqualSumMsg;
        }
        if (CsPcpBusinessTypeEnum.ALLOT_OUT_ONLY.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.INTERNAL_EXPORT_DEAL.getCode().equals(csTransferOrderEo.getType())) {
            if (!isEqualSum) {
                return checkEqualSumMsg;
            }
            if (inFlag) return "";
            return this.checkInventory(noticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, inFlag);
        }
        if (CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.ALLOT_SALE_BH.getCode().equals(csTransferOrderEo.getType())) {
            if (StringUtils.isNotBlank((CharSequence)csTransferOrderEo.getSecondTransferOrderNo())) {
                return "";
            }
            if (!isEqualSum) {
                return checkEqualSumMsg;
            }
            if (inFlag) return "";
            return this.checkInventory(noticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, false);
        }
        if (!isEqualBatch) {
            return checkEqualBatchMsg;
        }
        if (isEqualSum) return "";
        return checkEqualSumMsg;
    }

    private String checkEqualBatch(Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, List<CsWmsBasicsDetailReqDto> wmsDetailDtos, boolean inFlag) {
        ArrayList errorMsgList = Lists.newArrayList();
        String formatStr = "SKU\uff1a%s\uff0c\u8ba1\u5212%s\u6279\u6b21\uff1a%s\uff0c\u5b9e\u9645%s\u6279\u6b21\uff1a%s\uff0c\u6279\u6b21\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77\u3002";
        String flagStr = inFlag ? "\u5165\u5e93" : "\u51fa\u5e93";
        Map<String, List<CsWmsBasicsDetailReqDto>> batchWmsDetailsMap = wmsDetailDtos.stream().collect(Collectors.groupingBy(CsWmsBasicsDetailReqDto::getSkuCode));
        block0: for (Map.Entry<String, List<CsWmsBasicsDetailReqDto>> cargoEntry : batchWmsDetailsMap.entrySet()) {
            String cargoCode = cargoEntry.getKey();
            List<CsWmsBasicsDetailReqDto> wmsBatchList = cargoEntry.getValue();
            List<InOutNoticeOrderDetailEo> batchList = batchNoticeDetailEosMap.getOrDefault(cargoCode, Lists.newArrayList());
            List noticeBatchList = batchList.stream().map(InOutNoticeOrderDetailEo::getBatch).distinct().collect(Collectors.toList());
            for (CsWmsBasicsDetailReqDto wmsBatch : wmsBatchList) {
                InOutNoticeOrderDetailEo batch = batchList.stream().filter(o -> StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)wmsBatch.getBatch())).findFirst().orElse(null);
                if (null != batch) continue;
                errorMsgList.add(String.format(formatStr, cargoCode, flagStr, StringUtils.join(noticeBatchList, (String)","), flagStr, wmsBatch.getBatch()));
                continue block0;
            }
        }
        return StringUtils.join((Iterable)errorMsgList, (String)",");
    }

    private String checkEqualSum(Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, List<CsWmsBasicsDetailReqDto> wmsDetailDtos, boolean inFlag) {
        BigDecimal num;
        String cargoCode;
        boolean isEqualSum = true;
        ArrayList errorMsgList = Lists.newArrayList();
        String formatStr = "SKU\uff1a%s\uff0c\u8ba1\u5212%s\uff1a%s\uff0c\u5b9e\u9645%s\u6570\u91cf%s\uff0c\u4e0e\u8ba1\u5212\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77";
        String flagStr = inFlag ? "\u5165\u5e93" : "\u51fa\u5e93";
        HashMap noticeNumMap = Maps.newHashMap();
        HashMap wmsNumMap = Maps.newHashMap();
        for (Map.Entry<String, List<InOutNoticeOrderDetailEo>> entry : batchNoticeDetailEosMap.entrySet()) {
            cargoCode = entry.getKey();
            num = BigDecimal.ZERO;
            for (InOutNoticeOrderDetailEo detailEo : entry.getValue()) {
                num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)detailEo.getPlanQuantity());
            }
            noticeNumMap.put(cargoCode, num);
        }
        for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : wmsDetailDtos) {
            cargoCode = csWmsBasicsDetailReqDto.getSkuCode();
            num = (BigDecimal)wmsNumMap.get(cargoCode);
            num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)csWmsBasicsDetailReqDto.getQuantity());
            wmsNumMap.put(cargoCode, num);
        }
        for (Map.Entry<String, List<Object>> entry : noticeNumMap.entrySet()) {
            cargoCode = entry.getKey();
            isEqualSum = BigDecimalUtils.equals((BigDecimal)((BigDecimal)((Object)entry.getValue())), (BigDecimal)((BigDecimal)wmsNumMap.get(cargoCode)));
            if (isEqualSum) continue;
            errorMsgList.add(String.format(formatStr, cargoCode, flagStr, BigDecimalUtils.toStr((BigDecimal)((BigDecimal)((Object)entry.getValue()))), flagStr, BigDecimalUtils.toStr((BigDecimal)((BigDecimal)wmsNumMap.get(cargoCode)))));
        }
        return StringUtils.join((Iterable)errorMsgList, (String)",");
    }

    private String checkEqualBatchAndNum(Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, List<CsWmsBasicsDetailReqDto> wmsDetailDtos, boolean inFlag) {
        String skuAndBatch;
        boolean isEqualBatchAndNum = true;
        ArrayList errorMsgList = Lists.newArrayList();
        String formatStr = "SKU+\u6279\u6b21\uff1a%s\uff0c\u8ba1\u5212%s\uff1a%s\uff0c\u5b9e\u9645%s\u6570\u91cf%s\uff0c\u4e0e\u8ba1\u5212\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77";
        String flagStr = inFlag ? "\u5165\u5e93" : "\u51fa\u5e93";
        HashMap wmsNumMap = Maps.newHashMap();
        HashMap skuBatchNumMap = Maps.newHashMap();
        for (Map.Entry<String, List<InOutNoticeOrderDetailEo>> entry : batchNoticeDetailEosMap.entrySet()) {
            String cargoCode = entry.getKey();
            for (InOutNoticeOrderDetailEo detailEo : entry.getValue()) {
                String batch = detailEo.getBatch();
                String batchKey = cargoCode + "-" + batch;
                BigDecimal num = (BigDecimal)skuBatchNumMap.get(batchKey);
                num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)detailEo.getPlanQuantity());
                skuBatchNumMap.put(batchKey, num);
            }
        }
        for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : wmsDetailDtos) {
            skuAndBatch = csWmsBasicsDetailReqDto.getSkuCode() + "-" + csWmsBasicsDetailReqDto.getBatch();
            BigDecimal num = (BigDecimal)wmsNumMap.get(skuAndBatch);
            num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)csWmsBasicsDetailReqDto.getQuantity());
            wmsNumMap.put(skuAndBatch, num);
        }
        for (Map.Entry<String, List<Object>> entry : skuBatchNumMap.entrySet()) {
            skuAndBatch = entry.getKey();
            isEqualBatchAndNum = BigDecimalUtils.equals((BigDecimal)((BigDecimal)((Object)entry.getValue())), (BigDecimal)((BigDecimal)wmsNumMap.get(skuAndBatch)));
            if (isEqualBatchAndNum) continue;
            errorMsgList.add(String.format(formatStr, skuAndBatch, flagStr, BigDecimalUtils.toStr((BigDecimal)((BigDecimal)((Object)entry.getValue()))), flagStr, BigDecimalUtils.toStr((BigDecimal)((BigDecimal)wmsNumMap.get(skuAndBatch)))));
        }
        return StringUtils.join((Iterable)errorMsgList, (String)",");
    }

    private boolean checkGt(Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, List<CsWmsBasicsDetailReqDto> wmsDetailDtos) {
        BigDecimal num;
        String cargoCode;
        Boolean hasGt = false;
        HashMap noticeNumMap = Maps.newHashMap();
        HashMap wmsNumMap = Maps.newHashMap();
        for (Map.Entry<String, List<InOutNoticeOrderDetailEo>> entry : batchNoticeDetailEosMap.entrySet()) {
            cargoCode = entry.getKey();
            num = BigDecimal.ZERO;
            for (InOutNoticeOrderDetailEo detailEo : entry.getValue()) {
                num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)detailEo.getPlanQuantity());
            }
            noticeNumMap.put(cargoCode, num);
        }
        for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : wmsDetailDtos) {
            cargoCode = csWmsBasicsDetailReqDto.getSkuCode();
            num = (BigDecimal)wmsNumMap.get(cargoCode);
            num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)csWmsBasicsDetailReqDto.getQuantity());
            wmsNumMap.put(cargoCode, num);
        }
        for (Map.Entry<String, List<Object>> entry : noticeNumMap.entrySet()) {
            cargoCode = entry.getKey();
            BigDecimal noticeSum = (BigDecimal)((Object)entry.getValue());
            BigDecimal wmsSum = (BigDecimal)wmsNumMap.get(cargoCode);
            if (!BigDecimalUtils.gt((BigDecimal)wmsSum, (BigDecimal)noticeSum).booleanValue()) continue;
            hasGt = true;
            break;
        }
        return hasGt;
    }

    private String checkInventory(InOutNoticeOrderEo InOutNoticeOrderEo2, Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, List<CsWmsBasicsDetailReqDto> wmsDetailDtos, boolean inFlag) {
        String overInventoryReason = "";
        String warehouseCode = inFlag ? InOutNoticeOrderEo2.getInLogicWarehouseCode() : InOutNoticeOrderEo2.getOutLogicWarehouseCode();
        List cargoCodes = wmsDetailDtos.stream().map(CsWmsBasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
        List batches = wmsDetailDtos.stream().map(CsWmsBasicsDetailReqDto::getBatch).distinct().collect(Collectors.toList());
        if (StringUtils.isBlank((CharSequence)warehouseCode)) {
            log.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u4ed3\u5e93\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728: {}", (Object)warehouseCode);
            return "\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u4ed3\u5e93\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        if (CollectionUtils.isEmpty(cargoCodes)) {
            log.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u8d27\u54c1\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728: {}", (Object)LogUtils.buildLogContent(wmsDetailDtos));
            return "\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u8d27\u54c1\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        if (CollectionUtils.isEmpty(batches)) {
            log.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u6279\u6b21\u4fe1\u606f\u4e0d\u5b58\u5728: {}", (Object)LogUtils.buildLogContent(wmsDetailDtos));
            return "\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u6279\u6b21\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        List logicWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getWarehouseCode, (Object)warehouseCode)).eq(LogicWarehouseEo::getWarehouseStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)logicWarehouseEos)) {
            return "\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)logicWarehouseEos.get(0);
        List csLogicInventoryEos = this.logicInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).eq(LogicInventoryEo::getWarehouseCode, (Object)warehouseCode)).in(LogicInventoryEo::getSkuCode, cargoCodes)).in(LogicInventoryEo::getBatch, batches)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)csLogicInventoryEos)) {
            log.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728: {}", (Object)LogUtils.buildLogContent(wmsDetailDtos));
            return String.format("%s\u65e0\u6cd5\u67e5\u5230SKU\uff1a%s, \u6279\u6b21\uff1a%s \u7684\u4fe1\u606f\uff0c\u7cfb\u7edf\u6302\u8d77", logicWarehouseEo.getWarehouseName(), StringUtils.join(cargoCodes, (String)","), StringUtils.join(batches, (String)","));
        }
        for (CsWmsBasicsDetailReqDto wmsDetail : wmsDetailDtos) {
            LogicInventoryEo csLogicInventoryEo = csLogicInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)wmsDetail.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)wmsDetail.getBatch())).findFirst().orElse(null);
            if (null == csLogicInventoryEo) {
                log.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u67e5\u8be2\u4e0d\u5b58\u5728: {}", (Object)LogUtils.buildLogContent(wmsDetail));
                overInventoryReason = String.format("%s\u65e0\u6cd5\u67e5\u5230SKU\uff1a%s, \u6279\u6b21\uff1a%s \u7684\u4fe1\u606f\uff0c\u7cfb\u7edf\u6302\u8d77", logicWarehouseEo.getWarehouseName(), wmsDetail.getSkuCode(), wmsDetail.getBatch());
                break;
            }
            if (!BigDecimalUtils.gt((BigDecimal)wmsDetail.getQuantity(), (BigDecimal)csLogicInventoryEo.getBalance()).booleanValue()) continue;
            log.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u4e0d\u591f\u6263\u9664: \u5e93\u5b58\u5269\u4f59\u5373\u65f6\u5e93\u5b58:{}, \u9700\u8981\u6263\u9664\u5e93\u5b58: {}", (Object)csLogicInventoryEo.getBalance(), (Object)wmsDetail.getQuantity());
            overInventoryReason = String.format("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58 \u903b\u8f91\u4ed3\uff1a%s, SKU\uff1a%s, \u6279\u6b21\uff1a%s\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u4e0d\u591f\u6263\u9664: \u5e93\u5b58\u5269\u4f59\u5373\u65f6\u5e93\u5b58:%s, \u9700\u8981\u6263\u9664\u5e93\u5b58: %s", logicWarehouseEo.getWarehouseName(), wmsDetail.getSkuCode(), wmsDetail.getBatch(), csLogicInventoryEo.getAvailable(), wmsDetail.getQuantity());
            break;
        }
        return overInventoryReason;
    }

    protected void handlingVolumeWeight(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        try {
            List skuCodes = basicsReceiveBasicsReqDto.getDetailReqDtoList().stream().map(CsWmsBasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
            List pcpItemRespDtos = this.itemSkuQueryApiProxy.queryBySkuCodes(skuCodes);
            log.info("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)pcpItemRespDtos));
            HashMap itemRespDtoMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)pcpItemRespDtos)) {
                Map dtoMap = pcpItemRespDtos.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (k1, k3) -> k1));
                itemRespDtoMap.putAll(dtoMap);
            }
            List detailReqDtoList = basicsReceiveBasicsReqDto.getDetailReqDtoList();
            BigDecimal totalVolume = BigDecimal.ZERO;
            BigDecimal totalWeight = BigDecimal.ZERO;
            for (CsWmsBasicsDetailReqDto dto : detailReqDtoList) {
                ItemSkuDto itemSkuDto = (ItemSkuDto)itemRespDtoMap.get(dto.getSkuCode());
                if (ObjectUtil.isEmpty((Object)itemSkuDto)) continue;
                if (BigDecimalUtils.eqZero((BigDecimal)dto.getWeight()).booleanValue()) {
                    dto.setWeight(BigDecimalUtils.multiply((BigDecimal)itemSkuDto.getWeight(), (BigDecimal)dto.getQuantity()));
                }
                if (BigDecimalUtils.eqZero((BigDecimal)dto.getVolume()).booleanValue()) {
                    dto.setVolume(BigDecimalUtils.multiply((BigDecimal)itemSkuDto.getVolume(), (BigDecimal)dto.getQuantity()));
                }
                totalVolume = BigDecimalUtils.add((BigDecimal)dto.getVolume(), (BigDecimal)totalVolume);
                totalWeight = BigDecimalUtils.add((BigDecimal)dto.getWeight(), (BigDecimal)totalWeight);
            }
            basicsReceiveBasicsReqDto.setWeight(totalWeight);
            basicsReceiveBasicsReqDto.setVolume(totalVolume);
            log.info("\u5f00\u59cb\u751f\u6210\u51fa\u5e93\u7ed3\u679c\u5355,\u8865\u5145\u4f53\u79ef\u548c\u91cd\u91cf\u540e: {}", (Object)LogUtils.buildLogContent(basicsReceiveBasicsReqDto));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

