/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseExposedAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseOnLineEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csLogicWarehouseExposedServiceImpl")
public class CsLogicWarehouseExposedServiceImpl
implements ICsLogicWarehouseExposedService {
    private static Logger logger = LoggerFactory.getLogger(CsLogicWarehouseExposedServiceImpl.class);
    @Autowired
    ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Autowired
    IRelWarehouseDomain relWarehouseDomain;
    @Resource
    ILogicInventoryDomain logicInventoryDomain;
    @Resource
    private IContext context;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addLogicWarehouse(CsLogicWarehouseExposedAddReqDto csLogicWarehouseExposedAddReqDto) {
        logger.info("addLogicWarehouse==>\u65b0\u589e\u903b\u8f91\u4ed3\u4ed3\u5e93,csLogicWarehouseExposedAddReqDto:{}", (Object)LogUtils.buildLogContent(csLogicWarehouseExposedAddReqDto));
        this.checkParams(csLogicWarehouseExposedAddReqDto);
        this.checkWarehouseCode(csLogicWarehouseExposedAddReqDto);
        LogicWarehouseEo logicWarehouseEo = new LogicWarehouseEo();
        Long logicWarehouseId = IdUtils.getId();
        logicWarehouseEo.setId(logicWarehouseId);
        CubeBeanUtils.copyProperties((Object)logicWarehouseEo, (Object)csLogicWarehouseExposedAddReqDto, (String[])new String[0]);
        logger.info("addLogicWarehouse==>\u65b0\u589e\u903b\u8f91\u4ed3\u4ed3\u5e93,logicWarehouseEo:{}", (Object)LogUtils.buildLogContent(logicWarehouseEo));
        this.logicWarehouseDomain.insert((BaseEo)logicWarehouseEo);
        if (CsWarehouseClassifyEnum.LOGIC.getCode().equals(csLogicWarehouseExposedAddReqDto.getWarehouseClassify())) {
            this.maintainRelWarehouse(csLogicWarehouseExposedAddReqDto, logicWarehouseId);
        }
        return logicWarehouseId;
    }

    private void maintainRelWarehouse(CsLogicWarehouseExposedAddReqDto csLogicWarehouseExposedAddReqDto, Long logicWarehouseId) {
        Long subordinatePhysicsWarehouseId = csLogicWarehouseExposedAddReqDto.getSubordinatePhysicsWarehouseId();
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)this.physicsWarehouseDomain.getMapper().selectById((Serializable)subordinatePhysicsWarehouseId);
        logger.info("maintainRelWarehouse==>physicsWarehouseEo:{}", (Object)LogUtils.buildLogContent(physicsWarehouseEo));
        AssertUtil.isTrue(null != physicsWarehouseEo, "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        ArrayList<RelWarehouseEo> relWarehouseEoList = new ArrayList<RelWarehouseEo>(2);
        RelWarehouseEo csPhysicsEo = new RelWarehouseEo();
        relWarehouseEoList.add(csPhysicsEo);
        csPhysicsEo.setWarehouseId(physicsWarehouseEo.getId());
        csPhysicsEo.setWarehouseCode(physicsWarehouseEo.getWarehouseCode());
        csPhysicsEo.setWarehouseName(physicsWarehouseEo.getWarehouseName());
        csPhysicsEo.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        csPhysicsEo.setWarehouseType(physicsWarehouseEo.getWarehouseType());
        csPhysicsEo.setRefWarehouseId(logicWarehouseId);
        csPhysicsEo.setRefWarehouseName(csLogicWarehouseExposedAddReqDto.getWarehouseName());
        csPhysicsEo.setRefWarehouseCode(csLogicWarehouseExposedAddReqDto.getWarehouseCode());
        csPhysicsEo.setRefWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        csPhysicsEo.setWarehouseType(csLogicWarehouseExposedAddReqDto.getWarehouseType());
        csPhysicsEo.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
        RelWarehouseEo csLogicEo = new RelWarehouseEo();
        relWarehouseEoList.add(csLogicEo);
        csLogicEo.setWarehouseId(logicWarehouseId);
        csLogicEo.setWarehouseCode(csLogicWarehouseExposedAddReqDto.getWarehouseCode());
        csLogicEo.setWarehouseName(csLogicWarehouseExposedAddReqDto.getWarehouseName());
        csLogicEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        csLogicEo.setWarehouseType(physicsWarehouseEo.getWarehouseType());
        csLogicEo.setRefWarehouseId(subordinatePhysicsWarehouseId);
        csLogicEo.setRefWarehouseName(physicsWarehouseEo.getWarehouseName());
        csLogicEo.setRefWarehouseCode(physicsWarehouseEo.getWarehouseCode());
        csLogicEo.setRefWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        csLogicEo.setWarehouseType(physicsWarehouseEo.getWarehouseType());
        csLogicEo.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
        this.relWarehouseDomain.insertBatch(relWarehouseEoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateLogicWarehouse(CsLogicWarehouseExposedAddReqDto csLogicWarehouseExposedAddReqDto) {
        logger.info("updatePhysicsWarehouse==>\u7f16\u8f91\u903b\u8f91\u4ed3\u4ed3\u5e93,csLogicWarehouseExposedAddReqDto:{}", (Object)LogUtils.buildLogContent(csLogicWarehouseExposedAddReqDto));
        if (csLogicWarehouseExposedAddReqDto.getWarehouseStatus().equals("disable")) {
            QueryWrapper wrapper = new QueryWrapper();
            QueryWrapper LogicInventoryEoQueryWrapper = (QueryWrapper)((QueryWrapper)wrapper.eq((Object)"warehouse_code", (Object)csLogicWarehouseExposedAddReqDto.getWarehouseCode())).and(q -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)q.ne((Object)"balance", (Object)0)).or()).ne((Object)"available", (Object)0)).or()).ne((Object)"intransit", (Object)0)).or()).ne((Object)"future_in", (Object)0)).or()).ne((Object)"preempt", (Object)0)).or()).ne((Object)"allocate", (Object)0);
            });
            List LogicInventoryEoList = this.logicInventoryDomain.getMapper().selectList((Wrapper)LogicInventoryEoQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)LogicInventoryEoList)) {
                return false;
            }
        }
        this.checkParams(csLogicWarehouseExposedAddReqDto);
        this.checkWarehouseCode(csLogicWarehouseExposedAddReqDto);
        Long logicWarehouseId = csLogicWarehouseExposedAddReqDto.getId();
        AssertUtil.isTrue(null != logicWarehouseId, "\u4ed3\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a");
        LogicWarehouseEo originalEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectById((Serializable)logicWarehouseId);
        AssertUtil.isTrue(null != originalEo, "\u67e5\u8be2\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f");
        CubeBeanUtils.copyProperties((Object)originalEo, (Object)csLogicWarehouseExposedAddReqDto, (String[])new String[0]);
        logger.info("updateLogicWarehouse==>\u7f16\u8f91\u903b\u8f91\u4ed3\u4ed3\u5e93,originalEo:{}", (Object)LogUtils.buildLogContent(originalEo));
        int updateWarehouseFlag = this.logicWarehouseDomain.getMapper().updateById((BaseEo)originalEo);
        if (updateWarehouseFlag <= 0) {
            return false;
        }
        if (CsWarehouseClassifyEnum.LOGIC.getCode().equals(csLogicWarehouseExposedAddReqDto.getWarehouseClassify())) {
            RelWarehouseEo updateEo = new RelWarehouseEo();
            updateEo.setValidFlag(CsValidFlagEnum.DISABLE.getCode());
            UpdateWrapper eoUpdateWrapper = new UpdateWrapper();
            eoUpdateWrapper.eq((Object)"warehouse_id", (Object)logicWarehouseId);
            eoUpdateWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
            eoUpdateWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
            this.relWarehouseDomain.getMapper().update((Object)updateEo, (Wrapper)eoUpdateWrapper);
            eoUpdateWrapper.clear();
            eoUpdateWrapper.eq((Object)"ref_warehouse_id", (Object)logicWarehouseId);
            eoUpdateWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
            eoUpdateWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
            this.relWarehouseDomain.getMapper().update((Object)updateEo, (Wrapper)eoUpdateWrapper);
            this.maintainRelWarehouse(csLogicWarehouseExposedAddReqDto, logicWarehouseId);
        }
        return true;
    }

    private void checkParams(CsLogicWarehouseExposedAddReqDto csLogicWarehouseExposedAddReqDto) {
        AssertUtil.isTrue(null != csLogicWarehouseExposedAddReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csLogicWarehouseExposedAddReqDto.getWarehouseCode()), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csLogicWarehouseExposedAddReqDto.getWarehouseName()), "\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        String warehouseStatus = csLogicWarehouseExposedAddReqDto.getWarehouseStatus();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseStatus) && null != CsLogicWarehouseStatusEnum.getByCode((String)warehouseStatus), "\u4ed3\u5e93\u72b6\u6001\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csLogicWarehouseExposedAddReqDto.getCargoEscheatageId()), "\u8d27\u6743\u7ec4\u7ec7ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String cargoEscheatageName = csLogicWarehouseExposedAddReqDto.getCargoEscheatageName();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)cargoEscheatageName), "\u8d27\u6743\u7ec4\u7ec7\u540d\u79f0\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != csLogicWarehouseExposedAddReqDto.getOrganizationId(), "\u7ec4\u7ec7id\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String warehouseQuality = csLogicWarehouseExposedAddReqDto.getWarehouseQuality();
        AssertUtil.isTrue(null != CsLogicWarehouseQualityEnum.getByCode((String)warehouseQuality), "\u4ed3\u5e93\u54c1\u8d28\u53c2\u6570\u6709\u8bef");
        String warehouseProperty = csLogicWarehouseExposedAddReqDto.getWarehouseProperty();
        String easWarehouseCode = csLogicWarehouseExposedAddReqDto.getEasWarehouseCode();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)easWarehouseCode), "EAS\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String warehouseOnlineFlag = csLogicWarehouseExposedAddReqDto.getWarehouseOnlineFlag();
        AssertUtil.isTrue(null != CsLogicWarehouseOnLineEnum.getByCode((String)warehouseOnlineFlag), "\u7ebf\u4e0a\u7ebf\u4e0b\u6807\u8bc6\u53c2\u6570\u6709\u8bef");
        if (CsWarehouseClassifyEnum.LOGIC.getCode().equals(csLogicWarehouseExposedAddReqDto.getWarehouseClassify())) {
            Long subordinatePhysicsWarehouseId = csLogicWarehouseExposedAddReqDto.getSubordinatePhysicsWarehouseId();
            AssertUtil.isTrue(null != subordinatePhysicsWarehouseId, "\u6240\u5c5e\u903b\u8f91\u4ed3\u4ed3\u5e93ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            PhysicsWarehouseEo PhysicsWarehouseEo2 = (PhysicsWarehouseEo)this.physicsWarehouseDomain.getMapper().selectById((Serializable)subordinatePhysicsWarehouseId);
            AssertUtil.isTrue(null != PhysicsWarehouseEo2, "\u67e5\u8be2\u4e0d\u5230\u6240\u5c5e\u903b\u8f91\u4ed3\u4fe1\u606f");
        }
        if (YesNoEnum.YES.getValue().equals(csLogicWarehouseExposedAddReqDto.getIsReturnWarehouse())) {
            this.logicWarehouseDomain.updateIsReturnWarehouseByOrganizationId(csLogicWarehouseExposedAddReqDto.getOrganizationId());
        }
        if (CsWarehouseClassifyEnum.IN_TRANSIT.getCode().equals(csLogicWarehouseExposedAddReqDto.getWarehouseClassify())) {
            Long subordinateLogicWarehouseId = csLogicWarehouseExposedAddReqDto.getSubordinateLogicWarehouseId();
            AssertUtil.isTrue(null != subordinateLogicWarehouseId, "\u6240\u5c5e\u903b\u8f91\u4ed3\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            LogicWarehouseEo LogicWarehouseEo2 = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectById((Serializable)subordinateLogicWarehouseId);
            AssertUtil.isTrue(null != LogicWarehouseEo2 && null != LogicWarehouseEo2.getId(), "\u6240\u5c5e\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728");
            List LogicWarehouseEoList = this.logicWarehouseDomain.queryBySubordinateLogicWarehouseId(subordinateLogicWarehouseId);
            if (CollectionUtils.isNotEmpty((Collection)LogicWarehouseEoList)) {
                for (LogicWarehouseEo logicWarehouseEo : LogicWarehouseEoList) {
                    AssertUtil.isTrue(logicWarehouseEo.getWarehouseCode().equals(csLogicWarehouseExposedAddReqDto.getWarehouseCode()), "\u6240\u5c5e\u903b\u8f91\u4ed3\u5df2\u914d\u7f6e\u5728\u9014\u4ed3");
                }
            }
            csLogicWarehouseExposedAddReqDto.setSubordinateLogicWarehouseName(LogicWarehouseEo2.getWarehouseName());
        }
    }

    private void checkWarehouseCode(CsLogicWarehouseExposedAddReqDto csLogicWarehouseExposedAddReqDto) {
        String warehouseCode = csLogicWarehouseExposedAddReqDto.getWarehouseCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        List LogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)LogicWarehouseEoList)) {
            return;
        }
        Long updateId = csLogicWarehouseExposedAddReqDto.getId();
        if (null != updateId) {
            for (LogicWarehouseEo eo : LogicWarehouseEoList) {
                Long existId = eo.getId();
                if (null == existId || existId.equals(updateId)) continue;
                throw new BizException("\u4ed3\u5e93\u7f16\u7801\u5df2\u5b58\u5728");
            }
        } else {
            throw new BizException("\u4ed3\u5e93\u7f16\u7801\u5df2\u5b58\u5728");
        }
    }

    @Override
    public List<String> modifyPhysicalWarehouseStatus(List<String> ids, String status) {
        List<String> failList = new ArrayList<String>();
        List<Object> notInList = new ArrayList();
        Object[] updateIds = ids.stream().map(Long::valueOf).collect(Collectors.toList()).toArray(new Long[ids.size()]);
        if (StringUtils.isNotBlank((CharSequence)status) && "disable".equals(status)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.in((Object)"warehouse_id", updateIds)).eq((Object)"dr", (Object)0)).and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.ne((Object)"balance", (Object)0)).or()).ne((Object)"preempt", (Object)0)).or()).ne((Object)"allocate", (Object)0)).or()).ne((Object)"activity_allocate", (Object)0)).or()).ne((Object)"intransit", (Object)0)).or()).ne((Object)"future_in", (Object)0)).or()).ne((Object)"future_retreat", (Object)0)).or()).ne((Object)"available", (Object)0)).or()).ne((Object)"lock_inventory", (Object)0);
            })).groupBy((Object)"warehouse_code");
            List list = this.logicInventoryDomain.getMapper().selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                failList = list.stream().map(LogicInventoryEo::getWarehouseCode).collect(Collectors.toList());
                notInList = list.stream().map(LogicInventoryEo::getWarehouseId).collect(Collectors.toList());
            }
        }
        Long[] notInIds = notInList.toArray(new Long[notInList.size()]);
        String updatePerson = null == this.context.userName() ? "-1" : this.context.userName();
        this.logicWarehouseDomain.batchUpdateStatusByIds((Long[])updateIds, notInIds, status, updatePerson, new Date());
        return failList;
    }
}

