/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsPhysicsWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsPhysicsWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPhysicsWarehouseStatusEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csPhysicsWarehouseService")
public class CsPhysicsWarehouseServiceImpl
implements ICsPhysicsWarehouseService {
    private static Logger logger = LoggerFactory.getLogger(CsPhysicsWarehouseServiceImpl.class);
    @Autowired
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Autowired
    private ICsPhysicsWarehouseQueryService csPhysicsWarehouseQueryService;
    @Autowired
    private ICsLogicWarehouseService csLogicWarehouseService;
    @Autowired
    private ICsRelWarehouseService csRelWarehouseService;

    @Override
    public Long add(CsPhysicsWarehouseAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        PhysicsWarehouseEo insertEo = new PhysicsWarehouseEo();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.physicsWarehouseDomain.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsPhysicsWarehouseUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        PhysicsWarehouseEo updateEo = new PhysicsWarehouseEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.physicsWarehouseDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        PhysicsWarehouseEo eo = this.csPhysicsWarehouseQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        this.physicsWarehouseDomain.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long initPhysicsWarehouse(CsPhysicsWarehouseAddReqDto physicsAddReqDto) {
        this.validParam(physicsAddReqDto);
        physicsAddReqDto.setWarehouseStatus(CsPhysicsWarehouseStatusEnum.ENABLE.getCode());
        Long physicsWarehouseId = this.add(physicsAddReqDto);
        CsLogicWarehouseAddReqDto logicAddReqDto = new CsLogicWarehouseAddReqDto();
        CubeBeanUtils.copyProperties((Object)logicAddReqDto, (Object)physicsAddReqDto, (String[])new String[0]);
        logicAddReqDto.setWarehouseName(physicsAddReqDto.getWarehouseName());
        logicAddReqDto.setWarehouseCode(physicsAddReqDto.getWarehouseCode());
        logicAddReqDto.setWarehouseStatus(CsLogicWarehouseStatusEnum.ENABLE.getCode());
        Long logicWarehouseId = this.csLogicWarehouseService.add(logicAddReqDto);
        CsRelWarehouseAddReqDto physicsRelWarehouseDto = new CsRelWarehouseAddReqDto();
        physicsRelWarehouseDto.setWarehouseId(physicsWarehouseId);
        physicsRelWarehouseDto.setWarehouseCode(physicsAddReqDto.getWarehouseCode());
        physicsRelWarehouseDto.setWarehouseName(physicsAddReqDto.getWarehouseName());
        physicsRelWarehouseDto.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        physicsRelWarehouseDto.setWarehouseType(null);
        physicsRelWarehouseDto.setRefWarehouseId(logicWarehouseId);
        physicsRelWarehouseDto.setRefWarehouseCode(logicAddReqDto.getWarehouseCode());
        physicsRelWarehouseDto.setRefWarehouseName(logicAddReqDto.getWarehouseName());
        physicsRelWarehouseDto.setRefWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        this.csRelWarehouseService.add(physicsRelWarehouseDto);
        CsRelWarehouseAddReqDto logicRelWarehouseDto = new CsRelWarehouseAddReqDto();
        logicRelWarehouseDto.setWarehouseId(logicWarehouseId);
        logicRelWarehouseDto.setWarehouseCode(logicAddReqDto.getWarehouseCode());
        logicRelWarehouseDto.setWarehouseName(logicAddReqDto.getWarehouseName());
        logicRelWarehouseDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        logicRelWarehouseDto.setRefWarehouseId(physicsWarehouseId);
        logicRelWarehouseDto.setRefWarehouseCode(physicsAddReqDto.getWarehouseCode());
        logicRelWarehouseDto.setRefWarehouseName(physicsAddReqDto.getWarehouseName());
        logicRelWarehouseDto.setRefWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        this.csRelWarehouseService.add(logicRelWarehouseDto);
        return physicsWarehouseId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePhysicsWarehouse(Long id, CsPhysicsWarehouseUpdateReqDto updateReqDto) {
        this.validParam2(updateReqDto);
        RelWarehouseEo csRelWarehouseEo = new RelWarehouseEo();
        csRelWarehouseEo.setRefWarehouseId(id);
        List<RelWarehouseEo> relWarehouseEoList = this.csRelWarehouseService.selectList(csRelWarehouseEo);
        AssertUtil.isTrue(CollectionUtil.isNotEmpty(relWarehouseEoList), "\u4ed3\u5e93\u5173\u8054\u5173\u7cfb\u4e0d\u5b58\u5728");
        relWarehouseEoList.forEach(eo -> {
            this.update(id, updateReqDto);
            CsLogicWarehouseUpdateReqDto logicUpdateReqDto = new CsLogicWarehouseUpdateReqDto();
            CubeBeanUtils.copyProperties((Object)logicUpdateReqDto, (Object)updateReqDto, (String[])new String[]{"id"});
            this.csLogicWarehouseService.update(eo.getWarehouseId(), logicUpdateReqDto);
        });
    }

    private void validParam(CsPhysicsWarehouseAddReqDto physicsAddReqDto) {
        if (StringUtils.isEmpty((CharSequence)physicsAddReqDto.getWarehouseName()) || StringUtils.isEmpty((CharSequence)physicsAddReqDto.getWarehouseCode()) || null == physicsAddReqDto.getOrganizationId() || StringUtils.isEmpty((CharSequence)physicsAddReqDto.getWarehouseStatus()) || StringUtils.isEmpty((CharSequence)physicsAddReqDto.getWarehouseType())) {
            AssertUtil.isTrue(false, "\u53c2\u6570\u672a\u8865\u5168");
        }
        physicsAddReqDto.setMainWarehouse(null == physicsAddReqDto.getMainWarehouse() ? YesNoEnum.YES.getValue() : physicsAddReqDto.getMainWarehouse());
        List physicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(physicsAddReqDto.getWarehouseCode());
        AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)physicsWarehouseEos), "\u4ed3\u5e93\u7f16\u7801\u5df2\u7ecf\u521d\u59cb\u5316" + physicsAddReqDto.getWarehouseCode());
    }

    private void validParam2(CsPhysicsWarehouseUpdateReqDto physicsAddReqDto) {
        if (StringUtils.isEmpty((CharSequence)physicsAddReqDto.getWarehouseName()) || StringUtils.isEmpty((CharSequence)physicsAddReqDto.getWarehouseCode()) || null == physicsAddReqDto.getOrganizationId() || StringUtils.isEmpty((CharSequence)physicsAddReqDto.getWarehouseStatus()) || StringUtils.isEmpty((CharSequence)physicsAddReqDto.getWarehouseType())) {
            AssertUtil.isTrue(false, "\u53c2\u6570\u672a\u8865\u5168");
        }
        physicsAddReqDto.setMainWarehouse(null == physicsAddReqDto.getMainWarehouse() ? YesNoEnum.YES.getValue() : physicsAddReqDto.getMainWarehouse());
    }

    @Override
    public Long add(PhysicsWarehouseEo csPhysicsWarehouseEo) {
        csPhysicsWarehouseEo.setId(null);
        this.physicsWarehouseDomain.insert((BaseEo)csPhysicsWarehouseEo);
        return csPhysicsWarehouseEo.getId();
    }

    @Override
    public Long update(PhysicsWarehouseEo csPhysicsWarehouseEo) {
        this.physicsWarehouseDomain.updateSelective((BaseEo)csPhysicsWarehouseEo);
        return csPhysicsWarehouseEo.getId();
    }
}

