/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.IPcpDeliveryNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsRelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcpDeliveryNoticeOrderServiceImpl")
public class PcpDeliveryNoticeOrderServiceImpl
implements IPcpDeliveryNoticeOrderService {
    private static final Logger logger = LoggerFactory.getLogger(PcpDeliveryNoticeOrderServiceImpl.class);
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private ICsRelWarehouseQueryService csRelWarehouseQueryService;
    @Resource
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private CsCommonService csCommonService;
    @Resource
    private SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    private RepeatFilter repeatFilter;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Autowired
    IRelWarehouseDomain relWarehouseDomain;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsDeliveryNoticeOrderAddReqDto addReqDto) {
        logger.info("\u521b\u5efa\u53d1\u8d27\u5355\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(addReqDto));
        this.repeatFilter.checkRepeat("DeliveryNotice:" + addReqDto.getPreOrderNo(), () -> this.preValid(addReqDto), true);
        this.dataValid(addReqDto);
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = new ReceiveDeliveryNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)deliveryNoticeOrderEo, (Object)addReqDto, (String[])new String[0]);
        String documentNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.DELIVERY_NOTICE_ORDER.getCode()).getCode();
        deliveryNoticeOrderEo.setDocumentNo(documentNo);
        deliveryNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
        deliveryNoticeOrderEo.setRelevanceNo(addReqDto.getPreOrderNo());
        deliveryNoticeOrderEo.setExtension(JSON.toJSONString((Object)addReqDto.getContactDto()));
        deliveryNoticeOrderEo.setOrderType("delivery");
        deliveryNoticeOrderEo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode());
        this.warehouseInfo(addReqDto, deliveryNoticeOrderEo);
        this.receiveDeliveryNoticeOrderDomain.insert((BaseEo)deliveryNoticeOrderEo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsDeliveryNoticeOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            ReceiveDeliveryNoticeOrderDetailEo detailEo = new ReceiveDeliveryNoticeOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)addReqDto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailAddReqDto, (String[])new String[]{"id"});
            detailEo.setDocumentNo(documentNo);
            detailEo.setPreOrderNo(deliveryNoticeOrderEo.getPreOrderNo());
            detailEo.setRelevanceNo(deliveryNoticeOrderEo.getRelevanceNo());
            detailEo.setSkuCode(detailAddReqDto.getLongCode());
            detailEo.setWaitQuantity(detailAddReqDto.getPlanQuantity());
            detailEo.setOriginPlanQuantity(detailAddReqDto.getPlanQuantity());
            detailEo.setInitFlag(YesNoEnum.YES.getValue());
            detailEoList.add(detailEo);
        }
        this.receiveDeliveryNoticeOrderDetailDomain.insertBatch((List)detailEoList);
        return deliveryNoticeOrderEo.getId();
    }

    private void warehouseInfo(CsDeliveryNoticeOrderAddReqDto addReqDto, ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo) {
        String warehouseCode = addReqDto.getWarehouseCode();
        QueryWrapper csLogicWarehouseEoQueryWrapper = new QueryWrapper();
        csLogicWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        List csLogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)csLogicWarehouseEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csLogicWarehouseEoList), "\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)csLogicWarehouseEoList.get(0);
        deliveryNoticeOrderEo.setDeliveryLogicWarehouseCode(csLogicWarehouseEo.getWarehouseCode());
        deliveryNoticeOrderEo.setDeliveryLogicWarehouseName(csLogicWarehouseEo.getWarehouseName());
        QueryWrapper csRelWarehouseEoQueryWrapper = new QueryWrapper();
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)csLogicWarehouseEo.getWarehouseCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        List csRelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)csRelWarehouseEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csRelWarehouseEoList), "\u7269\u7406\u4ed3\u5e93\u4e0d\u5b58\u5728");
        RelWarehouseEo csRelWarehouseEo = (RelWarehouseEo)csRelWarehouseEoList.get(0);
        deliveryNoticeOrderEo.setDeliveryPhysicsWarehouseCode(csRelWarehouseEo.getRefWarehouseCode());
        deliveryNoticeOrderEo.setDeliveryPhysicsWarehouseName(csRelWarehouseEo.getRefWarehouseName());
    }

    private void dataValid(CsDeliveryNoticeOrderAddReqDto addReqDto) {
        List<RelWarehouseEo> relPhysicList;
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getWarehouseCode()), "\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        AssertUtil.isTrue(addReqDto.getBusinessType() != null, "\u672a\u4f20\u5165\u7c7b\u578b");
        AssertUtil.isTrue(null != CsPcpBusinessTypeEnum.getByCode((String)addReqDto.getBusinessType()), "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
        List logicWarehouseEos = this.logicWarehouseDomain.queryByCodes((List)Lists.newArrayList((Object[])new String[]{addReqDto.getWarehouseCode()}));
        List itemList = addReqDto.getDetailAddReqDtoList().stream().map(CsDeliveryNoticeOrderDetailAddReqDto::getLongCode).collect(Collectors.toList());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicWarehouseEos), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(itemList), "\u8d27\u54c1\u4e0d\u5b58\u5728");
        List itemEoList = this.itemSkuProxy.queryBySkuCodes(itemList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)itemEoList), "\u5546\u54c1\u672a\u914d\u7f6e");
        if (itemEoList.size() != itemEoList.size()) {
            logger.info("error,\u8d27\u54c1\u4e0d\u4e00\u81f4\uff0c\u540e\u7eed\u5904\u7406\uff1b");
        }
        if (CollectionUtils.isNotEmpty(relPhysicList = this.csRelWarehouseQueryService.queryByRefWarehouseCode(addReqDto.getWarehouseCode(), CsWarehouseClassifyEnum.LOGIC.getCode()))) {
            addReqDto.setDeliveryPhysicsWarehouseCode(relPhysicList.get(0).getRefWarehouseCode());
            addReqDto.setDeliveryPhysicsWarehouseName(relPhysicList.get(0).getRefWarehouseName());
        }
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)logicWarehouseEos.get(0);
        addReqDto.setWarehouseId(csLogicWarehouseEo.getId());
        addReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
        addReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        addReqDto.setOrganizationId(csLogicWarehouseEo.getOrganizationId());
        addReqDto.setOrganizationName(csLogicWarehouseEo.getOrganizationName());
        Map<String, ItemSkuDto> cargoMap = itemEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, entity -> entity));
        for (CsDeliveryNoticeOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            ItemSkuDto itemEo = cargoMap.get(detailAddReqDto.getLongCode());
            if (null == itemEo) {
                logger.info("error,\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u540e\u7eed\u5904\u7406");
                continue;
            }
            detailAddReqDto.setCargoId(itemEo.getId());
            detailAddReqDto.setCargoName(itemEo.getSkuName());
            detailAddReqDto.setWaitQuantity(detailAddReqDto.getPlanQuantity());
        }
    }

    private void preValid(CsDeliveryNoticeOrderAddReqDto addReqDto) {
        List oldList = this.receiveDeliveryNoticeOrderDomain.queryByPreOrderNo(addReqDto.getPreOrderNo());
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo : oldList) {
                AssertUtil.isTrue(BaseOrderStatusEnum.DNO_CANCEL.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()), "304", deliveryNoticeOrderEo.getPreOrderNo() + "\u5df2\u5b58\u5728\u6d41\u8f6c\u6b63\u5e38\u7684\u524d\u7f6e\u5355\u636e");
            }
        }
    }

    @Override
    public void onlyUpdateDocumentStatus(String preOrderNo, String orderStatus) {
        BaseOrderStatusEnum statusByCode = BaseOrderStatusEnum.getStatusByCode((String)orderStatus);
        AssertUtil.isTrue(null != statusByCode, "\u53d8\u66f4\u72b6\u6001\u4e0d\u5b58\u5728");
        List deliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.queryByPreOrderNo(preOrderNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderEoList), "\u524d\u7f6e\u5355\u636e\u5173\u8054\u7684\u53d1\u8d27\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = new ReceiveDeliveryNoticeOrderEo();
        receiveDeliveryNoticeOrderEo.setId(((ReceiveDeliveryNoticeOrderEo)deliveryNoticeOrderEoList.get(0)).getId());
        receiveDeliveryNoticeOrderEo.setOrderStatus(orderStatus);
        CsRelWarehouseQueryDto queryDto = new CsRelWarehouseQueryDto();
        queryDto.setWarehouseId(((ReceiveDeliveryNoticeOrderEo)deliveryNoticeOrderEoList.get(0)).getWarehouseId());
        queryDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        queryDto.setRefWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        queryDto.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
        List<CsRelWarehouseRespDto> csRelWarehouseRespDtos = this.csRelWarehouseQueryService.queryWarehouseByConditions(queryDto);
        if (CollectionUtils.isNotEmpty(csRelWarehouseRespDtos)) {
            receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseName(csRelWarehouseRespDtos.get(0).getRefWarehouseName());
            receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseCode(csRelWarehouseRespDtos.get(0).getRefWarehouseCode());
        }
        this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)receiveDeliveryNoticeOrderEo);
    }

    @Override
    public void onlyUpdateDocumentStatusById(Long deliveryNoticeId, String orderStatus) {
        BaseOrderStatusEnum statusByCode = BaseOrderStatusEnum.getStatusByCode((String)orderStatus);
        AssertUtil.isTrue(null != statusByCode, "\u53d8\u66f4\u72b6\u6001\u4e0d\u5b58\u5728");
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)this.receiveDeliveryNoticeOrderDomain.getMapper().selectById((Serializable)deliveryNoticeId);
        AssertUtil.isTrue(null != deliveryNoticeOrderEo, "\u53d1\u8d27\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = new ReceiveDeliveryNoticeOrderEo();
        receiveDeliveryNoticeOrderEo.setId(deliveryNoticeOrderEo.getId());
        receiveDeliveryNoticeOrderEo.setOrderStatus(orderStatus);
        CsRelWarehouseQueryDto queryDto = new CsRelWarehouseQueryDto();
        queryDto.setWarehouseId(deliveryNoticeOrderEo.getWarehouseId());
        queryDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        queryDto.setRefWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        queryDto.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
        List<CsRelWarehouseRespDto> csRelWarehouseRespDtos = this.csRelWarehouseQueryService.queryWarehouseByConditions(queryDto);
        if (CollectionUtils.isNotEmpty(csRelWarehouseRespDtos)) {
            receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseName(csRelWarehouseRespDtos.get(0).getRefWarehouseName());
            receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseCode(csRelWarehouseRespDtos.get(0).getRefWarehouseCode());
        }
        this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)receiveDeliveryNoticeOrderEo);
    }

    @Override
    public void onlyUpdateDocumentStatusUnCheckTotal(String preOrderNo, String orderStatus) {
        logger.info("onlyUpdateDocumentStatusUnCheck==>preOrderNo:{},orderStatus:{}", (Object)preOrderNo, (Object)orderStatus);
        BaseOrderStatusEnum statusByCode = BaseOrderStatusEnum.getStatusByCode((String)orderStatus);
        AssertUtil.isTrue(null != statusByCode, "\u53d8\u66f4\u72b6\u6001\u4e0d\u5b58\u5728");
        QueryWrapper ReceiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)preOrderNo);
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List deliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)ReceiveDeliveryNoticeOrderEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)deliveryNoticeOrderEoList)) {
            return;
        }
        logger.info("onlyUpdateDocumentStatusUnCheck==>deliveryNoticeOrderEoList:{}", (Object)LogUtils.buildLogContent(deliveryNoticeOrderEoList));
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = new ReceiveDeliveryNoticeOrderEo();
        for (ReceiveDeliveryNoticeOrderEo selectEo : deliveryNoticeOrderEoList) {
            String selectOrderStatus = selectEo.getOrderStatus();
            if (orderStatus.equals(selectOrderStatus)) continue;
            receiveDeliveryNoticeOrderEo.setId(selectEo.getId());
            receiveDeliveryNoticeOrderEo.setOrderStatus(orderStatus);
            this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)receiveDeliveryNoticeOrderEo);
        }
    }

    @Override
    public void onlyUpdateDocumentStatusUnCheck(String preOrderNo, String orderStatus) {
        logger.info("onlyUpdateDocumentStatusUnCheck==>preOrderNo:{},orderStatus:{}", (Object)preOrderNo, (Object)orderStatus);
        BaseOrderStatusEnum statusByCode = BaseOrderStatusEnum.getStatusByCode((String)orderStatus);
        AssertUtil.isTrue(null != statusByCode, "\u53d8\u66f4\u72b6\u6001\u4e0d\u5b58\u5728");
        List deliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.queryByPreOrderNo(preOrderNo);
        if (CollectionUtils.isEmpty((Collection)deliveryNoticeOrderEoList)) {
            return;
        }
        logger.info("onlyUpdateDocumentStatusUnCheck==>deliveryNoticeOrderEoList:{}", (Object)LogUtils.buildLogContent(deliveryNoticeOrderEoList));
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = new ReceiveDeliveryNoticeOrderEo();
        receiveDeliveryNoticeOrderEo.setId(((ReceiveDeliveryNoticeOrderEo)deliveryNoticeOrderEoList.get(0)).getId());
        receiveDeliveryNoticeOrderEo.setOrderStatus(orderStatus);
        this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)receiveDeliveryNoticeOrderEo);
    }
}

