/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IConsignmentOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.IAdjustInTransitHandler;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsBusinessOrderCallBackUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.IPcpDeliveryResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ConsignmentOrderDeliveryInfoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ConsignmentOrderAddressEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ConsignmentOrderDeliveryInfoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ConsignmentOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.ConsignmentOrderAddressMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.ConsignmentOrderDeliveryInfoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.ConsignmentOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsWmsBasicsDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutResultOrderRepairDataDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderStringValidReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.ShippingJsonDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutResultSolutionToHangReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutResultSolutionToHangRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutMatchRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessCallBackStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryCoverInventoryFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsVersionDistinguishEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.BdTypeOfDocumentEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderUnhookFacadeBo;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csOutResultOrderService")
public class CsOutResultOrderServiceImpl
implements ICsOutResultOrderService {
    private static final Logger log = LoggerFactory.getLogger(CsOutResultOrderServiceImpl.class);
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    ICsOutResultOrderQueryService csOutResultOrderQueryService;
    @Resource
    SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    RepeatFilter repeatFilter;
    @Resource
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    private ICsRelWarehouseQueryService csRelWarehouseQueryService;
    @Autowired
    IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    private IPcpDeliveryResultOrderService pcpDeliveryResultOrderService;
    @Autowired
    CsTransferOrderMapper csTransferOrderMapper;
    @Value(value="${inventory.config.is_all_deal_with:1}")
    private Integer isAllDeal;
    @Autowired
    IAdjustInTransitHandler adjustInTransitHandler;
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Autowired
    ConsignmentOrderMapper consignmentOrderMapper;
    @Autowired
    ConsignmentOrderDeliveryInfoMapper consignmentOrderDeliveryInfoMapper;
    @Autowired
    ConsignmentOrderDeliveryInfoDas consignmentOrderDeliveryInfoDas;
    @Autowired
    IConsignmentOrderService consignmentOrderService;
    @Autowired
    ConsignmentOrderAddressMapper consignmentOrderAddressMapper;
    @Resource
    private ICsInventoryPreemptionService csInventoryPreemptionService;
    @Resource
    private ICsInventoryExposedService csInventoryExposedService;
    @Autowired
    TransactionCallBackService transactionCallBackService;
    @Autowired
    ICommonsMqService commonsMqService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsOutResultOrderAddReqDto addReqDto) {
        log.info("\u521b\u5efa\u51fa\u5e93\u7ed3\u679c\u5355\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(addReqDto));
        this.repeatFilter.checkRepeat("OutResult:" + addReqDto.getPreOrderNo(), () -> this.preValid(addReqDto), true);
        this.dataValid(addReqDto);
        InOutResultOrderEo outResultOrderEo = new InOutResultOrderEo();
        CubeBeanUtils.copyProperties((Object)outResultOrderEo, (Object)addReqDto, (String[])new String[0]);
        CsGenerateCodeEnum generateCodeEnum = this.simpleGenerateCodeUtil.pcpGenerateCode("402");
        String documentNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.OUT_RESULT_ORDER.getCode()).getCode();
        String orderStatus = generateCodeEnum.getStatus();
        outResultOrderEo.setDocumentNo(documentNo);
        if (StringUtils.isBlank((CharSequence)outResultOrderEo.getOrderStatus())) {
            outResultOrderEo.setOrderStatus(orderStatus);
        }
        outResultOrderEo.setExtension(com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)addReqDto.getContactDto()));
        this.inOutResultOrderDomain.insert((BaseEo)outResultOrderEo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsOutResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            InOutResultOrderDetailEo detailEo = new InOutResultOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)addReqDto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailAddReqDto, (String[])new String[]{"id"});
            detailEo.setDocumentNo(documentNo);
            detailEoList.add(detailEo);
        }
        this.inOutResultOrderDetailDomain.insertBatch((List)detailEoList);
        return outResultOrderEo.getId();
    }

    private void preValid(CsOutResultOrderAddReqDto addReqDto) {
        List oldList = this.inOutResultOrderDomain.queryByRelevanceNo(addReqDto.getRelevanceNo());
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (InOutResultOrderEo InOutResultOrderEo2 : oldList) {
                AssertUtil.isTrue(BaseOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(InOutResultOrderEo2.getOrderStatus()), CsInventoryExceptionCode.SUCCESS_CODE.getCode(), CsInventoryExceptionCode.SUCCESS_CODE.getMsg());
            }
        }
    }

    private void dataValid(CsOutResultOrderAddReqDto addReqDto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getWarehouseCode()), "\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getPreOrderNo()), "\u672a\u4f20\u5165\u524d\u7f6e\u4e1a\u52a1\u5355\u636e");
        AssertUtil.isTrue(addReqDto.getBusinessType() != null, "\u672a\u4f20\u5165\u7c7b\u578b");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)BusinessTypeEnum.getDescByCode((String)addReqDto.getBusinessType())), "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
        List InOutNoticeOrderEos = this.inOutNoticeOrderDomain.queryByPreOrderNo(addReqDto.getPreOrderNo());
        if (BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_SALES_ISSUE.getCode().equals(addReqDto.getBusinessType())) {
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)InOutNoticeOrderEos), "\u524d\u7f6e\u5355\u636e\u4e0d\u5b58\u5728");
            addReqDto.setExternalOrderNo(((InOutNoticeOrderEo)InOutNoticeOrderEos.get(0)).getExternalOrderNo());
            addReqDto.setRelevanceNo(((InOutNoticeOrderEo)InOutNoticeOrderEos.get(0)).getDocumentNo());
        }
        List physicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(addReqDto.getWarehouseCode());
        List cargoList = addReqDto.getDetailAddReqDtoList().stream().map(CsOutResultOrderDetailAddReqDto::getCargoCode).collect(Collectors.toList());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)physicsWarehouseEos), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(cargoList), "\u8d27\u54c1\u4e0d\u5b58\u5728");
        PhysicsWarehouseEo csPhysicsWarehouseEo = (PhysicsWarehouseEo)physicsWarehouseEos.get(0);
        addReqDto.setWarehouseId(csPhysicsWarehouseEo.getId());
        addReqDto.setWarehouseName(csPhysicsWarehouseEo.getWarehouseName());
        addReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
    }

    @Override
    public void update(Long id, CsOutResultOrderUpdateReqDto updateReqDto) {
        log.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InOutResultOrderEo updateEo = new InOutResultOrderEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.inOutResultOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        log.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        InOutResultOrderEo eo = this.csOutResultOrderQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        this.inOutResultOrderDomain.logicDeleteById(id);
    }

    @Override
    public String wmsSendBack(CsOutResultOrderAddReqDto csOutResultOrderAddReqDto) {
        log.info("WMS\u53d1\u8d27\u56de\u4f20,\u751f\u6210\u51fa\u5e93\u7ed3\u679c\u5355\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(csOutResultOrderAddReqDto));
        csOutResultOrderAddReqDto.setOrderStatus(BaseOrderStatusEnum.ORO_DONE_OUT.getCode());
        csOutResultOrderAddReqDto.setBusinessType(BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_SALES_OUT.getCode());
        Long id = this.add(csOutResultOrderAddReqDto);
        log.info("WMS\u53d1\u8d27\u56de\u4f20,\u751f\u6210\u51fa\u5e93\u7ed3\u679c\u5355\uff1a[id:{}]", (Object)id);
        InOutResultOrderEo csOutResultOrderEo = (InOutResultOrderEo)this.inOutResultOrderDomain.getMapper().selectById((Serializable)id);
        QueryWrapper noticeOrderEoQueryWrapper = new QueryWrapper();
        noticeOrderEoQueryWrapper.eq((Object)"pre_order_no", (Object)csOutResultOrderAddReqDto.getPreOrderNo());
        List csDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)noticeOrderEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csDeliveryNoticeOrderEoList), "\u67e5\u8be2\u4e0d\u5230\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f");
        Long deliveryResultOrderId = this.pcpDeliveryResultOrderService.createDeliveryResultOrder(csOutResultOrderEo.getDocumentNo(), ((ReceiveDeliveryNoticeOrderEo)csDeliveryNoticeOrderEoList.get(0)).getPreOrderNo());
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = (ReceiveDeliveryResultOrderEo)this.receiveDeliveryResultOrderDomain.selectByPrimaryKey(deliveryResultOrderId);
        csDeliveryResultOrderEo.setOrderStatus(BaseOrderStatusEnum.DRO_DELIVERED.getCode());
        csDeliveryResultOrderEo.setBusinessType(BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_SALES_OUT.getCode());
        UpdateWrapper deliveryResultWrapper = new UpdateWrapper();
        deliveryResultWrapper.eq((Object)"id", (Object)csDeliveryResultOrderEo.getId());
        this.receiveDeliveryResultOrderDomain.getMapper().update((Object)csDeliveryResultOrderEo, (Wrapper)deliveryResultWrapper);
        ReceiveDeliveryNoticeOrderEo csDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)csDeliveryNoticeOrderEoList.get(0);
        csDeliveryNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.DNO_TOTAL_DELIVERY.getCode());
        csDeliveryNoticeOrderEo.setBusinessType(BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_SALES_OUT.getCode());
        UpdateWrapper deliveryNoticeWrapper = new UpdateWrapper();
        deliveryNoticeWrapper.eq((Object)"id", (Object)csDeliveryNoticeOrderEo.getId());
        this.receiveDeliveryNoticeOrderDomain.getMapper().update((Object)csDeliveryNoticeOrderEo, (Wrapper)deliveryNoticeWrapper);
        InOutNoticeOrderEo csOutNoticeOrderEo = new InOutNoticeOrderEo();
        csOutNoticeOrderEo.setRelevanceNo(csDeliveryNoticeOrderEo.getDocumentNo());
        InOutNoticeOrderEo csOutResultEo = (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.selectOne((BaseEo)csOutNoticeOrderEo);
        AssertUtil.isTrue(Objects.nonNull(csOutResultEo), "\u67e5\u8be2\u4e0d\u5230\u51fa\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        csOutResultEo.setOrderStatus(BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode());
        this.inOutNoticeOrderDomain.update((BaseEo)csOutResultEo);
        QueryWrapper csOutNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        csOutNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)csOutResultEo.getDocumentNo());
        List csOutNoticeOrderDetailEos = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)csOutNoticeOrderDetailEoQueryWrapper);
        csOutNoticeOrderDetailEos.stream().forEach(eo -> {
            eo.setDoneQuantity(eo.getPlanQuantity());
            UpdateWrapper detailEoUpdateWrapper = new UpdateWrapper();
            detailEoUpdateWrapper.eq((Object)"id", (Object)eo.getId());
            this.inOutNoticeOrderDetailDomain.getMapper().update(eo, (Wrapper)detailEoUpdateWrapper);
        });
        QueryWrapper csDeliveryNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        noticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)csDeliveryNoticeOrderEo.getDocumentNo());
        List csDeliveryNoticeOrderDetailEos = this.receiveDeliveryNoticeOrderDetailDomain.getMapper().selectList((Wrapper)csDeliveryNoticeOrderDetailEoQueryWrapper);
        csDeliveryNoticeOrderDetailEos.stream().forEach(eo -> {
            eo.setWaitQuantity(BigDecimal.ZERO);
            eo.setDoneQuantity(eo.getPlanQuantity());
            UpdateWrapper detailEoUpdateWrapper = new UpdateWrapper();
            detailEoUpdateWrapper.eq((Object)"id", (Object)eo.getId());
            this.receiveDeliveryNoticeOrderDetailDomain.getMapper().update(eo, (Wrapper)detailEoUpdateWrapper);
        });
        this.operateInventory(csOutResultOrderAddReqDto);
        log.info("WMS\u53d1\u8d27\u56de\u4f20,\u51fa\u5e93\u5b8c\u6210");
        this.csInventoryPreemptionService.updateStatusDisableBySourceNo(csOutResultOrderAddReqDto.getPreOrderNo());
        log.info("WMS\u53d1\u8d27\u56de\u4f20,\u53d8\u66f4\u9884\u5360\u8bb0\u5f55\u72b6\u6001\u5b8c\u6210");
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStringValidResult(List<CsOutResultOrderStringValidReqDto> stringValidReqDtoList) {
        String key;
        HashMap<String, InOutResultOrderEo> InOutResultOrderEoMap = new HashMap<String, InOutResultOrderEo>();
        List externalOrderList = stringValidReqDtoList.stream().map(obj -> obj.getExternalOrderNo()).distinct().collect(Collectors.toList());
        List preOrderList = stringValidReqDtoList.stream().map(obj -> obj.getPreOrderNo()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(externalOrderList) && CollectionUtils.isEmpty(preOrderList)) {
            return;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(externalOrderList)) {
            queryWrapper.in((Object)"external_order_no", externalOrderList);
        } else {
            queryWrapper.in((Object)"pre_order_no", preOrderList);
        }
        List InOutResultOrderEos = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)InOutResultOrderEos)) {
            return;
        }
        for (InOutResultOrderEo InOutResultOrderEo2 : InOutResultOrderEos) {
            key = InOutResultOrderEo2.getExternalOrderNo() + "_" + InOutResultOrderEo2.getOrderType();
            String key2 = InOutResultOrderEo2.getPreOrderNo() + "_" + InOutResultOrderEo2.getOrderType();
            InOutResultOrderEoMap.put(key, InOutResultOrderEo2);
            InOutResultOrderEoMap.put(key2, InOutResultOrderEo2);
        }
        for (CsOutResultOrderStringValidReqDto resultOrderStringValidReqDto : stringValidReqDtoList) {
            key = resultOrderStringValidReqDto.getExternalOrderNo() + "_" + resultOrderStringValidReqDto.getOrderType();
            InOutResultOrderEo InOutResultOrderEo3 = (InOutResultOrderEo)InOutResultOrderEoMap.get(key);
            if (null != InOutResultOrderEo3 && null != InOutResultOrderEo3.getId()) {
                InOutResultOrderEo inOutResultOrderEo = new InOutResultOrderEo();
                inOutResultOrderEo.setId(InOutResultOrderEo3.getId());
                inOutResultOrderEo.setStringValidResult(resultOrderStringValidReqDto.getStringValidResult());
                this.inOutResultOrderDomain.getMapper().updateById((BaseEo)inOutResultOrderEo);
                continue;
            }
            String key2 = resultOrderStringValidReqDto.getPreOrderNo() + "_" + resultOrderStringValidReqDto.getOrderType();
            InOutResultOrderEo InOutResultOrderEo2 = (InOutResultOrderEo)InOutResultOrderEoMap.get(key2);
            if (null == InOutResultOrderEo2 || null == InOutResultOrderEo2.getId()) continue;
            InOutResultOrderEo inOutResultOrderEo = new InOutResultOrderEo();
            inOutResultOrderEo.setId(InOutResultOrderEo2.getId());
            inOutResultOrderEo.setStringValidResult(resultOrderStringValidReqDto.getStringValidResult());
            this.inOutResultOrderDomain.getMapper().updateById((BaseEo)inOutResultOrderEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void repairData(String documentNo, List<CsOutResultOrderRepairDataDto> repairDataDtos) {
        AssertUtil.assertNotBlank(documentNo, "\u7ed3\u679c\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        if (CollectionUtils.isEmpty(repairDataDtos)) {
            log.info("\u4fee\u590d\u6279\u6b21\u4fe1\u606f\u4e0d\u5b58\u5728");
            return;
        }
        InOutResultOrderEo eo = (InOutResultOrderEo)this.inOutResultOrderDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderEo.class).eq(InOutResultOrderEo::getDocumentNo, (Object)documentNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(eo, "\u7ed3\u679c\u5355\u5355\u53f7\u67e5\u8be2\u4e0d\u5b58\u5728", new Object[0]);
        if ("in".equals(eo.getOrderType())) {
            AssertUtil.isTrue(BaseOrderStatusEnum.IRO_HANG_UP.getCode().equals(eo.getOrderStatus()), "\u975e\u6302\u8d77\u72b6\u6001\u5355\u636e\u4e0d\u5141\u8bb8\u89e3\u6302");
        } else if ("out".equals(eo.getOrderType())) {
            AssertUtil.isTrue(BaseOrderStatusEnum.ORO_HANG_UP.getCode().equals(eo.getOrderStatus()), "\u975e\u6302\u8d77\u72b6\u6001\u5355\u636e\u4e0d\u5141\u8bb8\u89e3\u6302");
        }
        List detailEos = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderDetailEo.class).eq(InOutResultOrderDetailEo::getDocumentNo, (Object)documentNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotEmpty(detailEos, "\u67e5\u8be2\u7ed3\u679c\u5355\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]);
        Map detailEoMap = detailEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (CsOutResultOrderRepairDataDto dto : repairDataDtos) {
            InOutResultOrderDetailEo detailEo = (InOutResultOrderDetailEo)detailEoMap.get(dto.getId());
            if (null == detailEo) continue;
            AssertUtil.assertNotBlank(dto.getRepairBatch(), "\u8d27\u54c1\uff1a%s \u4fee\u590d\u6279\u6b21\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", detailEo.getSkuCode());
            if (BigDecimalUtils.ltZero((BigDecimal)dto.getRepairNum()).booleanValue()) {
                throw new CsInventoryException("\u8d27\u54c1\uff1a%s\uff0c \u6279\u6b21\uff1a%s \u4fee\u6b63\u6570\u91cf\u4e0d\u80fd\u4e3a\u8d1f\u6570", detailEo.getSkuCode(), new Object[]{dto.getRepairBatch()});
            }
            BigDecimal changeDoneQuantity = BigDecimalUtils.subtract((BigDecimal)dto.getRepairNum(), (BigDecimal)detailEo.getQuantity());
            InOutResultOrderDetailEo updateEo = new InOutResultOrderDetailEo();
            updateEo.setId(detailEo.getId());
            updateEo.setBatch(dto.getRepairBatch());
            updateEo.setQuantity(dto.getRepairNum());
            updateEo.setDoneQuantity(BigDecimalUtils.add((BigDecimal)detailEo.getDoneQuantity(), (BigDecimal)changeDoneQuantity));
            if (StringUtils.isNotBlank((CharSequence)dto.getProduceTime())) {
                updateEo.setProduceTime(DateUtil.parseDate((String)dto.getProduceTime(), (String)"yyyy-MM-dd"));
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getExpireTime())) {
                updateEo.setExpireTime(DateUtil.parseDate((String)dto.getExpireTime(), (String)"yyyy-MM-dd"));
            }
            this.inOutResultOrderDetailDomain.updateSelective((BaseEo)updateEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unhook(String documentNo, String remark) {
        AssertUtil.assertNotBlank(documentNo, "\u7ed3\u679c\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        InOutResultOrderEo eo = (InOutResultOrderEo)this.inOutResultOrderDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderEo.class).eq(InOutResultOrderEo::getDocumentNo, (Object)documentNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(eo, "\u7ed3\u679c\u5355\u5355\u53f7\u67e5\u8be2\u4e0d\u5b58\u5728", new Object[0]);
        if ("in".equals(eo.getOrderType())) {
            AssertUtil.isTrue(BaseOrderStatusEnum.IRO_HANG_UP.getCode().equals(eo.getOrderStatus()), "\u975e\u6302\u8d77\u72b6\u6001\u5355\u636e\u4e0d\u5141\u8bb8\u89e3\u6302");
        } else if ("out".equals(eo.getOrderType())) {
            AssertUtil.isTrue(BaseOrderStatusEnum.ORO_HANG_UP.getCode().equals(eo.getOrderStatus()), "\u975e\u6302\u8d77\u72b6\u6001\u5355\u636e\u4e0d\u5141\u8bb8\u89e3\u6302");
        }
        List detailEos = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderDetailEo.class).eq(InOutResultOrderDetailEo::getDocumentNo, (Object)documentNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotEmpty(detailEos, "\u67e5\u8be2\u7ed3\u679c\u5355\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]);
        log.info("unhook==>\u8c03\u6574\u3001\u89e3\u6302,\u5f00\u59cb, csInOutResultOrder documentNo:{}", (Object)eo.getDocumentNo());
        List inOutNoticeOrderEos = this.inOutNoticeOrderDomain.queryByDocumentNo(eo.getPreOrderNo());
        AssertUtil.assertNotEmpty(inOutNoticeOrderEos, "\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4e0d\u5b58\u5728", new Object[0]);
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)eo.getRelevanceTableName());
        ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        boolean inFlag = "in".equals(inOutNoticeOrderEo.getOrderType());
        CsOrderBusinessCallBackContext callBackContext = new CsOrderBusinessCallBackContext();
        callBackContext.setInResultOrderNo(eo.getDocumentNo());
        callBackContext.setRelevanceNo(eo.getRelevanceNo());
        callBackContext.setInFlag(Boolean.valueOf(inFlag));
        InOutResultOrderUnhookFacadeBo unhookFacadeBo = new InOutResultOrderUnhookFacadeBo();
        unhookFacadeBo.setDocumentNo(documentNo);
        unhookFacadeBo.setRemark(remark);
        if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(inOutNoticeOrderEo.getRelevanceTableName())) {
            CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)this.csTransferOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getTransferOrderNo, (Object)inOutNoticeOrderEo.getRelevanceNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notNull((Object)csTransferOrderEo, (String)"\u8c03\u62e8\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
            unhookFacadeBo.setTransferInLogicWarehouseCode(csTransferOrderEo.getInLogicWarehouseCode());
            unhookFacadeBo.setBusinessType(csTransferOrderEo.getType());
        }
        unhookFacadeBo.setCompleteCallBack(context -> {
            if (Objects.equals(eo.getRelevanceTableName(), "cs_transfer_order")) {
                this.adjustInTransitHandler.handle(new IAdjustInTransitHandler.AdjustInTransitHandlerVo(inOutNoticeOrderEo, inFlag, detailEos, eo, true));
            }
            if (context instanceof InOutResultOrderContext) {
                InOutResultOrderContext inOutResultOrderContext = (InOutResultOrderContext)context;
                InOutResultOrderEo inOutResultOrderEo = inOutResultOrderContext.getInOutResultOrderEo();
                callBackContext.setInOutResultOrderDetailEos(inOutResultOrderContext.getInOutResultOrderDetailEoList());
                callBackContext.setInOutResultOrderEo(inOutResultOrderEo);
                callBackContext.setPortionFlag(Boolean.valueOf(!inOutResultOrderContext.isNoticeEnd()));
                businessOrderCallBackService.inOutResultOrderCallBack(callBackContext);
                businessOrderCallBackService.deliveryReceiveResultOrderCallBack(callBackContext);
                this.createConsignmentByOutResultOrderNo(inOutResultOrderEo);
            }
        });
        unhookFacadeBo.setValidNegative(Boolean.valueOf(false));
        unhookFacadeBo.setIsSaleOrder(Boolean.valueOf(StringUtils.contains((CharSequence)eo.getRelevanceNo(), (CharSequence)"DD")));
        log.info("\u89e3\u6302\u7ed3\u679c\u5355\u4e0a\u4e0b\u6587\u5165\u53c2unhookFacadeBo:{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)unhookFacadeBo));
        if (inFlag) {
            if (CsPcpBusinessTypeEnum.cAllotList().contains(unhookFacadeBo.getBusinessType())) {
                unhookFacadeBo.setNoticeEnd(true);
            }
            this.baseOrderFacade.inResultOrderUnhook(unhookFacadeBo);
        } else {
            unhookFacadeBo.setNoticeEnd(true);
            this.baseOrderFacade.outResultOrderUnhook(unhookFacadeBo);
        }
    }

    @Override
    public CsOutResultSolutionToHangRespDto solutionToHang(CsOutResultSolutionToHangReqDto csOutResultSolutionToHangReqDto) {
        log.info("solutionToHang==>\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u89e3\u6302\u64cd\u4f5c,csOutResultSolutionToHangReqDto:{}", (Object)LogUtils.buildLogContent(csOutResultSolutionToHangReqDto));
        this.checkParams(csOutResultSolutionToHangReqDto);
        List documentNoList = csOutResultSolutionToHangReqDto.getDocumentNoList();
        String orderType = csOutResultSolutionToHangReqDto.getOrderType();
        QueryWrapper csOutResultOrderEoQueryWrapper = new QueryWrapper();
        csOutResultOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csOutResultOrderEoQueryWrapper.in((Object)"document_no", (Collection)documentNoList);
        if ("out".equals(orderType)) {
            csOutResultOrderEoQueryWrapper.eq((Object)"order_type", (Object)"out");
        } else if ("in".equals(orderType)) {
            csOutResultOrderEoQueryWrapper.eq((Object)"order_type", (Object)"in");
        }
        List csOutResultOrderEoList = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)csOutResultOrderEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csOutResultOrderEoList), "\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u4fe1\u606f");
        log.info("solutionToHangInventory==>csOutResultOrderEoList:{}", (Object)LogUtils.buildLogContent(csOutResultOrderEoList));
        for (InOutResultOrderEo inOutResultOrderEo : csOutResultOrderEoList) {
            if (!StringUtils.equals((CharSequence)"\u7269\u6d41\u6620\u5c04\u5f02\u5e38", (CharSequence)inOutResultOrderEo.getOverChargeReason())) continue;
            throw new BizException("\u7269\u6d41\u6620\u5c04\u5f02\u5e38\u6302\u8d77\u6682\u4e0d\u652f\u6301\u624b\u52a8\u89e3\u6302");
        }
        QueryWrapper csOutResultOrderDetailEoQueryWrapper = new QueryWrapper();
        csOutResultOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csOutResultOrderDetailEoQueryWrapper.in((Object)"document_no", (Collection)documentNoList);
        List csOutResultOrderDetailEoList = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)csOutResultOrderDetailEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csOutResultOrderDetailEoList), "\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u660e\u7ec6\u4fe1\u606f");
        return this.solutionToHangInventory(csOutResultSolutionToHangReqDto, csOutResultOrderEoList, csOutResultOrderDetailEoList);
    }

    @Override
    public void updateSapNoById(Long id, String sapNo) {
        log.info("\u66f4\u65b0sap\u7f16\u7801\u5230\u51fa\u5165\u5e93\u3001\u53d1\u6536\u8d27\u7ed3\u679c\u5355\uff0c\u51fa\u5165\u5e93\u7ed3\u679c\u5355id\uff1a{}\uff0cSapNo\uff1a{}", (Object)id.toString(), (Object)sapNo);
        InOutResultOrderEo outResultOrderEo = (InOutResultOrderEo)this.inOutResultOrderDomain.selectByPrimaryKey(id);
        AssertUtil.isTrue(outResultOrderEo != null, "\u7ed3\u679c\u5355\u636e\u4e0d\u5b58\u5728id:" + id);
        InOutResultOrderEo updateEo = new InOutResultOrderEo();
        updateEo.setId(id);
        updateEo.setSapNo(sapNo);
        this.inOutResultOrderDomain.updateSelective((BaseEo)updateEo);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"pre_order_no", (Object)outResultOrderEo.getDocumentNo());
        ReceiveDeliveryResultOrderEo deliveryResultOrderEo = new ReceiveDeliveryResultOrderEo();
        deliveryResultOrderEo.setSapNo(sapNo);
        this.receiveDeliveryResultOrderDomain.getMapper().update((Object)deliveryResultOrderEo, (Wrapper)updateWrapper);
    }

    private CsOutResultSolutionToHangRespDto solutionToHangInventory(CsOutResultSolutionToHangReqDto csOutResultSolutionToHangReqDto, List<InOutResultOrderEo> csOutResultOrderEoList, List<InOutResultOrderDetailEo> csOutResultOrderDetailEoList) {
        Map<String, List<InOutResultOrderDetailEo>> detailMap = csOutResultOrderDetailEoList.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getDocumentNo));
        int fail = 0;
        for (InOutResultOrderEo inOutResultOrderEo : csOutResultOrderEoList) {
            try {
                InOutResultOrderUnhookFacadeBo facadeBo = new InOutResultOrderUnhookFacadeBo();
                facadeBo.setInOutResultOrderEo(inOutResultOrderEo);
                facadeBo.setInOutResultOrderEoList(detailMap.get(inOutResultOrderEo.getDocumentNo()));
                facadeBo.setInFlag(BaseOrderOperateTypeEnum.IN.getCode().equalsIgnoreCase(inOutResultOrderEo.getOrderType()));
                boolean onlyProcessResult = this.isOnlyProcessResult(inOutResultOrderEo);
                if (onlyProcessResult) {
                    facadeBo.setOnlyProcessResult(true);
                    facadeBo.setAppendRecord(true);
                }
                this.baseOrderFacade.inOutResultOrderUnhook(facadeBo);
            }
            catch (Exception e) {
                e.printStackTrace();
                ++fail;
            }
        }
        return new CsOutResultSolutionToHangRespDto(Integer.valueOf(csOutResultOrderEoList.size() - fail), Integer.valueOf(fail));
    }

    private boolean isOnlyProcessResult(InOutResultOrderEo inOutResultOrderEo) {
        return BdTypeOfDocumentEnum.SAP_INVENTORY_SYNC.getCode().equals(inOutResultOrderEo.getBusinessType()) || "POS".equals(inOutResultOrderEo.getShopCode()) && Objects.equals(inOutResultOrderEo.getDisplayBusinessType(), CsPcpBusinessTypeEnum.DICT_ALLOT_STORE_RAISED.getCode());
    }

    private void checkParams(CsOutResultSolutionToHangReqDto csOutResultSolutionToHangReqDto) {
        AssertUtil.isTrue(null != csOutResultSolutionToHangReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List documentNoList = csOutResultSolutionToHangReqDto.getDocumentNoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)documentNoList), "\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String orderType = csOutResultSolutionToHangReqDto.getOrderType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderType) && ("in".equals(orderType) || "out".equals(orderType)), "\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
    }

    @Override
    public Long updateOutResultOrder(CsOutResultOrderAddReqDto updateReqDto) {
        ReceiveDeliveryResultOrderEo deliveryResultOrderEo;
        InOutResultOrderEo orderEo;
        if (ObjectUtils.isEmpty((Object)updateReqDto)) {
            return null;
        }
        List eos = ((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)updateReqDto.getDocumentNo())).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)eos), "\u67e5\u8be2\u4e0d\u5230\u51fa\u5e93\u901a\u77e5\u5355\u53f7");
        String relevanceNo = ((InOutNoticeOrderEo)eos.get(0)).getRelevanceNo();
        List csOutResultOrderEos = ((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq(StringUtils.isNotBlank((CharSequence)relevanceNo), (Object)"relevance_no", (Object)relevanceNo)).list();
        List deliveryResultOrderEos = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDomain.filter().eq(StringUtils.isNotBlank((CharSequence)relevanceNo), (Object)"relevance_no", (Object)relevanceNo)).list();
        if (CollectionUtils.isNotEmpty((Collection)csOutResultOrderEos) && ObjectUtils.isNotEmpty((Object)(orderEo = (InOutResultOrderEo)csOutResultOrderEos.get(0)))) {
            if (null != updateReqDto.getTotalQuantity()) {
                orderEo.setTotalQuantity(updateReqDto.getTotalQuantity());
            }
            if (null != updateReqDto.getTotalCartons()) {
                orderEo.setTotalCartons(updateReqDto.getTotalCartons());
            }
            if (null != updateReqDto.getMergeQuantity()) {
                orderEo.setMergeQuantity(updateReqDto.getMergeQuantity());
            }
            if (null != updateReqDto.getTotalWeight()) {
                orderEo.setTotalWeight(updateReqDto.getTotalWeight());
            }
            if (null != updateReqDto.getTotalVolume()) {
                orderEo.setTotalVolume(updateReqDto.getTotalVolume());
            }
            if (StringUtils.isNotBlank((CharSequence)updateReqDto.getShippingCompanyCode())) {
                orderEo.setShippingCompanyCode(updateReqDto.getShippingCompanyCode());
            }
            if (StringUtils.isNotBlank((CharSequence)updateReqDto.getShippingCompany())) {
                orderEo.setShippingCompany(updateReqDto.getShippingCompany());
            }
            if (StringUtils.isNotBlank((CharSequence)orderEo.getShippingJson())) {
                String shippingJson = orderEo.getShippingJson();
                JSONArray jsonArray = JSONObject.parseArray((String)shippingJson);
                ShippingJsonDto shippingJsonDto = (ShippingJsonDto)jsonArray.getObject(0, ShippingJsonDto.class);
                if (StringUtils.isNotBlank((CharSequence)updateReqDto.getShippingCode())) {
                    shippingJsonDto.setShippingNo(updateReqDto.getShippingCode());
                }
                if (StringUtils.isNotBlank((CharSequence)updateReqDto.getShippingType())) {
                    shippingJsonDto.setLogisticsType(updateReqDto.getShippingType());
                }
                if (StringUtils.isNotBlank((CharSequence)updateReqDto.getShippingCompany())) {
                    shippingJsonDto.setShippingCompanyName(updateReqDto.getShippingCompany());
                }
                if (StringUtils.isNotBlank((CharSequence)updateReqDto.getShippingCompanyCode())) {
                    shippingJsonDto.setShippingCompanyCode(updateReqDto.getShippingCompanyCode());
                }
                List<ShippingJsonDto> dtos = Arrays.asList(shippingJsonDto);
                String json = JSONObject.toJSONString(dtos);
                orderEo.setShippingJson(json);
            }
            if (StringUtils.isNotBlank((CharSequence)updateReqDto.getShippingCode())) {
                orderEo.setShippingCode(updateReqDto.getShippingCode());
            }
            if (StringUtils.isNotBlank((CharSequence)updateReqDto.getShippingType())) {
                orderEo.setShippingType(updateReqDto.getShippingType());
            }
            if (StringUtils.isNotBlank((CharSequence)updateReqDto.getConsignmentNo())) {
                orderEo.setConsignmentNo(updateReqDto.getConsignmentNo());
            }
            ConsignmentOrderEo consignmentOrderEo = (ConsignmentOrderEo)this.consignmentOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderEo.class).eq(ConsignmentOrderEo::getOutNoticeNo, (Object)orderEo.getPreOrderNo())).eq(ConsignmentOrderEo::getConsignmentType, (Object)1)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            log.info("\u67e5\u8be2\u51fa\u5e93\u901a\u77e5\u5355\u5173\u8054\u539f\u8fd0\u5355\u4fe1\u606f: {}", (Object)LogUtils.buildLogContent(consignmentOrderEo));
            if (null != consignmentOrderEo) {
                ConsignmentOrderDeliveryInfoEo consignmentOrderDeliveryInfoEo = (ConsignmentOrderDeliveryInfoEo)this.consignmentOrderDeliveryInfoMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderDeliveryInfoEo.class).eq(ConsignmentOrderDeliveryInfoEo::getConsignmentNo, (Object)consignmentOrderEo.getConsignmentNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                log.info("\u67e5\u8be2\u539f\u8fd0\u5355\u914d\u9001\u4fe1\u606f: {}", (Object)LogUtils.buildLogContent(consignmentOrderDeliveryInfoEo));
                ConsignmentOrderAddressEo receiveConsignmentOrderAddressEo = (ConsignmentOrderAddressEo)this.consignmentOrderAddressMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderAddressEo.class).eq(ConsignmentOrderAddressEo::getConsignmentNo, (Object)consignmentOrderEo.getConsignmentNo())).eq(ConsignmentOrderAddressEo::getAddressType, (Object)"receive")).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                if (null != consignmentOrderDeliveryInfoEo) {
                    ConsignmentOrderDeliveryInfoEo updateConsignmentOrderDeliveryInfoEo = new ConsignmentOrderDeliveryInfoEo();
                    updateConsignmentOrderDeliveryInfoEo.setId(consignmentOrderDeliveryInfoEo.getId());
                    updateConsignmentOrderDeliveryInfoEo.setCarrierCode(updateReqDto.getShippingCompanyCode());
                    updateConsignmentOrderDeliveryInfoEo.setCarrierName(updateReqDto.getShippingCompany());
                    updateConsignmentOrderDeliveryInfoEo.setCarrierType(updateReqDto.getShippingType());
                    int planDays = this.consignmentOrderService.calcPlanArriveDays(updateConsignmentOrderDeliveryInfoEo.getCarrierCode(), consignmentOrderEo.getPhysicsWarehouseCode(), receiveConsignmentOrderAddressEo.getDistrictName(), receiveConsignmentOrderAddressEo.getCityName(), receiveConsignmentOrderAddressEo.getProvinceName(), consignmentOrderDeliveryInfoEo.getCarrierType());
                    if (planDays > 0) {
                        updateConsignmentOrderDeliveryInfoEo.setPlanArriveDays(Integer.valueOf(planDays));
                        Date planArriveTime = DateUtil.addDays((Date)consignmentOrderDeliveryInfoEo.getDeliveryTime(), (int)planDays);
                        planArriveTime = DateUtils.getEndTime(planArriveTime);
                        updateConsignmentOrderDeliveryInfoEo.setPlanArriveTime(planArriveTime);
                        orderEo.setEstimatedTime(planArriveTime);
                    } else {
                        this.consignmentOrderDeliveryInfoDas.clearPlanDaysAndTime(consignmentOrderDeliveryInfoEo.getId());
                        orderEo.setEstimatedTime(null);
                    }
                    this.consignmentOrderDeliveryInfoDas.updateSelective((BaseEo)updateConsignmentOrderDeliveryInfoEo);
                }
            }
            this.inOutResultOrderDomain.update((BaseEo)orderEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)deliveryResultOrderEos) && ObjectUtils.isNotEmpty((Object)(deliveryResultOrderEo = (ReceiveDeliveryResultOrderEo)deliveryResultOrderEos.get(0)))) {
            ReceiveDeliveryResultOrderEo eo = new ReceiveDeliveryResultOrderEo();
            eo.setId(deliveryResultOrderEo.getId());
            eo.setTotalQuantity(updateReqDto.getTotalQuantity());
            eo.setTotalCartons(updateReqDto.getTotalCartons());
            eo.setMergeQuantity(updateReqDto.getMergeQuantity());
            eo.setTotalWeight(updateReqDto.getTotalWeight());
            eo.setTotalVolume(updateReqDto.getTotalVolume());
            eo.setShippingCompanyCode(updateReqDto.getShippingCompanyCode());
            eo.setShippingCompany(updateReqDto.getShippingCompany());
            eo.setShippingCode(updateReqDto.getShippingCode());
            if (StringUtils.isNotBlank((CharSequence)deliveryResultOrderEo.getShippingJson())) {
                String shippingJson = deliveryResultOrderEo.getShippingJson();
                JSONArray jsonArray = JSONObject.parseArray((String)shippingJson);
                ShippingJsonDto shippingJsonDto = (ShippingJsonDto)jsonArray.getObject(0, ShippingJsonDto.class);
                if (StringUtils.isNotBlank((CharSequence)updateReqDto.getShippingCode())) {
                    shippingJsonDto.setShippingNo(updateReqDto.getShippingCode());
                }
                if (StringUtils.isNotBlank((CharSequence)updateReqDto.getShippingType())) {
                    shippingJsonDto.setLogisticsType(updateReqDto.getShippingType());
                }
                if (StringUtils.isNotBlank((CharSequence)updateReqDto.getShippingCompany())) {
                    shippingJsonDto.setShippingCompanyName(updateReqDto.getShippingCompany());
                }
                if (StringUtils.isNotBlank((CharSequence)updateReqDto.getShippingCompanyCode())) {
                    shippingJsonDto.setShippingCompanyCode(updateReqDto.getShippingCompanyCode());
                }
                List<ShippingJsonDto> dtos = Arrays.asList(shippingJsonDto);
                String json = JSONObject.toJSONString(dtos);
                eo.setShippingJson(json);
            }
            eo.setShippingType(updateReqDto.getShippingType());
            this.receiveDeliveryResultOrderDomain.updateSelective((BaseEo)eo);
        }
        return null;
    }

    @Override
    public void createConsignmentByOutResultOrderNo(InOutResultOrderEo inOutResultOrderEo) {
        List consignmentOrderEos = this.consignmentOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderEo.class).eq(ConsignmentOrderEo::getOutResultNo, (Object)inOutResultOrderEo.getDocumentNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isNotEmpty((Collection)consignmentOrderEos)) {
            log.info("\u8be5\u7ed3\u679c\u5355\u5df2\u751f\u6210\u8fd0\u5355\u4fe1\u606f\uff0c\u8bf7\u52ff\u91cd\u590d\u751f\u6210");
            return;
        }
        CsBasicsReceiveReqDto basicsReceiveBasicsReqDto = new CsBasicsReceiveReqDto();
        basicsReceiveBasicsReqDto.setInOutResultOrderNo(inOutResultOrderEo.getDocumentNo());
        List shippingInfoReqDtoList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)inOutResultOrderEo.getShippingJson())) {
            shippingInfoReqDtoList = JSONArray.parseArray((String)inOutResultOrderEo.getShippingJson(), CsWmsShippingInfoReqDto.class);
        }
        basicsReceiveBasicsReqDto.setShippingInfoReqDtoList(shippingInfoReqDtoList);
        this.transactionCallBackService.execute(() -> {
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)JSON.toJSONString((Object)basicsReceiveBasicsReqDto));
            this.commonsMqService.sendSingleMessage("INVENTORY_BUSINESS_TOPIC", "CREATE_CONSIGNMENT_ORDER", (Object)messageVo);
        });
    }

    private CsBasicsReceiveReqDto changeParam(InOutResultOrderEo csInResultOrderEo, List<InOutResultOrderDetailEo> overchargeList) {
        CsBasicsReceiveReqDto basicsReceiveReqDto = new CsBasicsReceiveReqDto();
        basicsReceiveReqDto.setWmsOrderNo(csInResultOrderEo.getWmsOrderNo());
        basicsReceiveReqDto.setInOutNoticeOrderNo(csInResultOrderEo.getPreOrderNo());
        List detailReqDtoList = overchargeList.stream().map(obj -> {
            CsWmsBasicsDetailReqDto basicsDetailReqDto = new CsWmsBasicsDetailReqDto();
            CubeBeanUtils.copyProperties((Object)basicsDetailReqDto, (Object)obj, (String[])new String[0]);
            basicsDetailReqDto.setSkuCode(obj.getSkuCode());
            basicsDetailReqDto.setBatch(obj.getBatch());
            basicsDetailReqDto.setQuantity(obj.getDoneQuantity());
            basicsDetailReqDto.setExpireTime(obj.getExpireTime());
            basicsDetailReqDto.setProduceTime(obj.getProduceTime());
            return basicsDetailReqDto;
        }).collect(Collectors.toList());
        basicsReceiveReqDto.setDetailReqDtoList(detailReqDtoList);
        basicsReceiveReqDto.setIsAllDeal(this.isAllDeal);
        return basicsReceiveReqDto;
    }

    private CsInOutMatchRespDto matchInventory(InOutNoticeOrderEo InOutNoticeOrderEo2, InOutResultOrderEo csInResultOrderEo, ICsBusinessOrderCallBackService businessOrderCallBackService, CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        List InOutNoticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.queryInitByDocumentNo(csInResultOrderEo.getPreOrderNo());
        basicsReceiveBasicsReqDto.setIgnoreHandUp(Boolean.valueOf(true));
        return businessOrderCallBackService.matchDetail(InOutNoticeOrderEo2, InOutNoticeOrderDetailEoList, basicsReceiveBasicsReqDto);
    }

    public void operateInventory(CsOutResultOrderAddReqDto addReqDto) {
        log.info("operateInventory==>\u6a21\u62dfWMS\u53d1\u8d27\u56de\u4f20,\u51fa\u5e93\u903b\u8f91\u3001\u7269\u7406\u4ed3\u5e93\u5b58,cargoReqDto:{}", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(null != addReqDto, "\u53c2\u6570\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addReqDto.getWarehouseCode()), "\u53c2\u6570\u4e0d\u5b58\u5728");
        List detailAddReqDtoList = addReqDto.getDetailAddReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)detailAddReqDtoList), "\u8d27\u54c1\u4fe1\u606f\u53c2\u6570\u4e0d\u5b58\u5728");
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.PHYSICS.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.NO.getValue());
        csInventoryInOutBasicsDto.setSourceNo(addReqDto.getPreOrderNo());
        csInventoryInOutBasicsDto.setSourceType(Objects.requireNonNull(CsInventorySourceTypeEnum.getByValue((String)addReqDto.getBusinessType())).getCode());
        csInventoryInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        csInventoryInOutBasicsDto.setCoverInventoryFlag(CsInventoryCoverInventoryFlagEnum.UPDATE.getCode());
        csInventoryInOutBasicsDto.setUpdateTotalFlag(YesNoEnum.YES.getValue());
        for (CsOutResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setCargoCode(detailAddReqDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
            inOutBasicsCargoDto.setBalance(detailAddReqDto.getQuantity().abs().negate());
            inOutBasicsCargoDto.setPreempt(detailAddReqDto.getQuantity().abs().negate());
            inOutBasicsCargoDto.setWarehouseCode(addReqDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(detailAddReqDto.getBatch());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        csInventoryInOutBasicsDto.setOperateVersion(CsVersionDistinguishEnum.SECOND.getCode());
        this.csInventoryExposedService.wmsOperateRelInventory(csInventoryInOutBasicsDto);
        log.info("batchUpdateInInventoryV2==>\u6a21\u62dfWMS\u53d1\u8d27\u56de\u4f20,\u51fa\u5e93\u903b\u8f91\u3001\u7269\u7406\u4ed3\u5e93\u5b58,csInventoryInOutBasicsDto:{}", (Object)LogUtils.buildLogContent(csInventoryInOutBasicsDto));
    }
}

