/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.IGenerateCodeService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionProcessEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csReceiveNoticeOrderService")
public class CsReceiveNoticeOrderServiceImpl
implements ICsReceiveNoticeOrderService {
    private static Logger logger = LoggerFactory.getLogger(CsReceiveNoticeOrderServiceImpl.class);
    @Autowired
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Autowired
    ICsReceiveNoticeOrderQueryService csReceiveNoticeOrderQueryService;
    @Resource
    CsCommonService csCommonService;
    @Resource
    RepeatFilter repeatFilter;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsReceiveNoticeOrderAddReqDto addReqDto) {
        logger.info("\u521b\u5efa\u6536\u8d27\u901a\u77e5\u5355\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(addReqDto));
        this.repeatFilter.checkRepeat("ReceiveNotice:" + addReqDto.getPreOrderNo(), () -> this.preValid(addReqDto), true);
        this.dataValid(addReqDto);
        ReceiveDeliveryNoticeOrderEo receiveNoticeOrderEo = new ReceiveDeliveryNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)receiveNoticeOrderEo, (Object)addReqDto, (String[])new String[0]);
        String orderNo = this.generateCode();
        receiveNoticeOrderEo.setDocumentNo(orderNo);
        receiveNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.RECEIVE_WAIT_RECEIVE.getCode());
        receiveNoticeOrderEo.setExtension(JSON.toJSONString((Object)addReqDto.getContactDto()));
        this.receiveDeliveryNoticeOrderDomain.insert((BaseEo)receiveNoticeOrderEo);
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getReceiveNoticeOrderDetailAddReqDtoList())) {
            ArrayList detailEoList = Lists.newArrayList();
            for (CsReceiveNoticeOrderDetailAddReqDto detailAddReqDto : addReqDto.getReceiveNoticeOrderDetailAddReqDtoList()) {
                ReceiveDeliveryNoticeOrderDetailEo detailEo = new ReceiveDeliveryNoticeOrderDetailEo();
                CubeBeanUtils.copyProperties((Object)detailEo, (Object)addReqDto, (String[])new String[]{"id"});
                CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailAddReqDto, (String[])new String[]{"id"});
                detailEo.setDocumentNo(orderNo);
                detailEoList.add(detailEo);
            }
            this.receiveDeliveryNoticeOrderDetailDomain.insertBatch((List)detailEoList);
        }
        logger.info("\u521b\u5efa\u6536\u8d27\u901a\u77e5\u5355\uff0c\u5b8c\u6210\uff1a[\u6536\u8d27\u901a\u77e5\u5355id:{}]", (Object)receiveNoticeOrderEo.getId());
        addReqDto.setDocumentNo(orderNo);
        return receiveNoticeOrderEo.getId();
    }

    private void preValid(CsReceiveNoticeOrderAddReqDto addReqDto) {
        List oldList = this.receiveDeliveryNoticeOrderDomain.queryByPreOrderNo(addReqDto.getPreOrderNo());
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (ReceiveDeliveryNoticeOrderEo noticeOrderEo : oldList) {
                AssertUtil.isTrue(BaseOrderStatusEnum.RECEIVE_CANCEL.getCode().equals(noticeOrderEo.getOrderStatus()), "304", noticeOrderEo.getPreOrderNo() + "\u5df2\u5b58\u5728\u6d41\u8f6c\u6b63\u5e38\u7684\u524d\u7f6e\u5355\u636e");
            }
        }
    }

    private void dataValid(CsReceiveNoticeOrderAddReqDto addReqDto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getWarehouseCode()), "\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getPreOrderNo()), "\u672a\u4f20\u5165\u524d\u7f6e\u4e1a\u52a1\u5355\u636e");
        AssertUtil.isTrue(addReqDto.getBusinessType() != null, "\u672a\u4f20\u5165\u7c7b\u578b");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)BusinessTypeEnum.getDescByCode((String)addReqDto.getBusinessType())), "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
        List logicWarehouseEos = this.logicWarehouseDomain.queryByCodes((List)Lists.newArrayList((Object[])new String[]{addReqDto.getWarehouseCode()}));
        List cargoList = addReqDto.getReceiveNoticeOrderDetailAddReqDtoList().stream().map(CsReceiveNoticeOrderDetailAddReqDto::getCargoCode).collect(Collectors.toList());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicWarehouseEos), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)logicWarehouseEos.get(0);
        addReqDto.setWarehouseId(csLogicWarehouseEo.getId());
        addReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
        addReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        addReqDto.setOrganizationId(csLogicWarehouseEo.getOrganizationId());
        addReqDto.setOrganizationName(csLogicWarehouseEo.getOrganizationName());
        if (CollectionUtils.isNotEmpty(cargoList)) {
            List cargoEoList = this.itemSkuProxy.queryBySkuCodes(cargoList);
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)cargoEoList), "\u8d27\u54c1\u672a\u914d\u7f6e");
            if (cargoEoList.size() != cargoList.size()) {
                logger.info("error,\u5e93\u5b58\u8d27\u54c1\u4e0d\u4e00\u81f4\uff0c\u540e\u7eed\u5904\u7406\uff1b");
            }
            Map<String, ItemSkuDto> cargoMap = cargoEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, entity -> entity));
            BigDecimal totalQuantity = BigDecimal.ZERO;
            for (CsReceiveNoticeOrderDetailAddReqDto detailAddReqDto : addReqDto.getReceiveNoticeOrderDetailAddReqDtoList()) {
                ItemSkuDto cargoEo = cargoMap.get(detailAddReqDto.getCargoCode());
                if (null == cargoEo) {
                    logger.info("error,\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u540e\u7eed\u5904\u7406");
                    continue;
                }
                detailAddReqDto.setCargoId(cargoEo.getId());
                detailAddReqDto.setCargoName(cargoEo.getSkuName());
                detailAddReqDto.setWaitQuantity(detailAddReqDto.getPlanQuantity());
                totalQuantity = totalQuantity.add(detailAddReqDto.getWaitQuantity());
            }
            addReqDto.setTotalQuantity(totalQuantity);
        }
    }

    @Override
    public void update(Long id, CsReceiveNoticeOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ReceiveDeliveryNoticeOrderEo updateEo = new ReceiveDeliveryNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csReceiveNoticeOrderQueryService.selectByPrimaryKey(id);
        this.receiveDeliveryNoticeOrderDomain.logicDeleteById(id);
    }

    @Override
    public void updateOrderStatus(String preOrderNo, String action) {
        logger.info("\u4fee\u6539\u6536\u8d27\u5355\u5355\u636e\u72b6\u6001\uff1a[preOrderNo:{},action:{}]", (Object)preOrderNo, (Object)action);
        String descByCode = CsDocumentActionEnum.getDescByCode((String)action);
        AssertUtil.isTrue(null != descByCode, "\u64cd\u4f5c\u5f02\u5e38\uff0c\u4e0d\u5b58\u5728\u8be5\u64cd\u4f5c");
        List noticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.queryByPreOrderNo(preOrderNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)noticeOrderEoList), "\u524d\u7f6e\u5355\u636e\u5173\u8054\u7684\u6536\u8d27\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        ReceiveDeliveryNoticeOrderEo noticeOrderEo = (ReceiveDeliveryNoticeOrderEo)noticeOrderEoList.get(0);
        String suffixByAction = CsDocumentActionProcessEnum.getSuffixByAction((String)noticeOrderEo.getOrderStatus(), (String)action);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)suffixByAction), "\u64cd\u4f5c\u5f02\u5e38\uff0c\u4e0d\u5b58\u5728\u8be5\u64cd\u4f5c,\u5355\u636e\u5f53\u524d\u72b6\u6001\u4e3a\uff1a" + BaseOrderStatusEnum.getDescByCode((String)noticeOrderEo.getOrderStatus()));
        ReceiveDeliveryNoticeOrderEo csReceiveNoticeOrderEo = new ReceiveDeliveryNoticeOrderEo();
        csReceiveNoticeOrderEo.setId(noticeOrderEo.getId());
        csReceiveNoticeOrderEo.setOrderStatus(suffixByAction);
        this.receiveDeliveryNoticeOrderDomain.getMapper().updateById((BaseEo)csReceiveNoticeOrderEo);
        logger.info("\u4fee\u6539\u6536\u8d27\u5355\u5355\u636e\u72b6\u6001 \u6210\u529f\uff1a[preOrderNo\uff1a{}\uff0caction:{},suffixByAction\uff1a{}]", new Object[]{preOrderNo, action, suffixByAction});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean reCheckInInventoryOverall(CsReceiveResultOrderAddReqDto addReqDto) {
        return true;
    }

    private CsInventoryInOutBasicsDto getCsInventoryInOutBasicsDto(CsReceiveResultOrderAddReqDto addReqDto) {
        List detailAddReqDtoList = addReqDto.getDetailAddReqDtoList();
        if (CollectionUtils.isEmpty((Collection)detailAddReqDtoList)) {
            return null;
        }
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.IN.getCode());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.NO.getValue());
        csInventoryInOutBasicsDto.setSourceNo(addReqDto.getPreOrderNo());
        csInventoryInOutBasicsDto.setSourceType(CsInventorySourceTypeEnum.IN_BACKTRACK.getCode());
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        for (CsReceiveResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setCargoCode(detailAddReqDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(detailAddReqDto.getActivityId() == null ? YesNoEnum.NO.getValue() : YesNoEnum.YES.getValue());
            inOutBasicsCargoDto.setBalance(detailAddReqDto.getQuantity().abs());
            inOutBasicsCargoDto.setWarehouseCode(addReqDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(detailAddReqDto.getBatch());
            inOutBasicsCargoDto.setActivityId(detailAddReqDto.getActivityId());
            inOutBasicsCargoDto.setProduceTime(detailAddReqDto.getProduceTime());
            inOutBasicsCargoDto.setExpireTime(detailAddReqDto.getExpireTime());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        return csInventoryInOutBasicsDto;
    }

    private String generateCode() {
        IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.RECEIVE_NOTICE_ORDER.getCode());
        return generateCodeService.getCode();
    }
}

