/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.EditCustomerSaveTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.GetSubWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyConfigReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyRelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.BizImportRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyConfigRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyRelRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.rpc.ICustomerInfoV3XbApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.rpc.IShopQueryV3RpcApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.rpc.ITradeInfoRpcApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.rpc.dto.CustomerExtRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.rpc.dto.CustomerReqExtDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.rpc.dto.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.rpc.dto.QueryProgressTradeByCustomerIdReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.rpc.dto.QueryProgressTradeByCustomerIdRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.rpc.dto.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.rpc.dto.ShopQueryV3Dto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseSupplyConfigService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseSupplyRelService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.constant.ItemInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseSupplyRelDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseSupplyRelEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsLogicWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsLogicWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.BaseImportRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.vo.DeliveryConfigVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class WarehouseSupplyRelServiceImpl
implements IWarehouseSupplyRelService {
    private static final Logger log = LoggerFactory.getLogger(WarehouseSupplyRelServiceImpl.class);
    @Resource
    private WarehouseSupplyRelDas warehouseSupplyRelDas;
    @Resource
    private IWarehouseSupplyConfigService warehouseSupplyConfigService;
    @Resource
    private IShopQueryV3RpcApi shopQueryV3RpcApi;
    @Resource
    private ICustomerInfoV3XbApi customerInfoV3XbApi;
    @Resource
    private ICsLogicWarehouseQueryService csLogicWarehouseQueryService;
    @Resource
    private CsLogicWarehouseMapper csLogicWarehouseMapper;
    @Resource
    private ITradeInfoRpcApi tradeInfoRpcApi;
    @Resource
    private ApplicationContext applicationContext;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addWarehouseSupplyRel(WarehouseSupplyRelReqDto addReqDto) {
        log.info("\u6307\u5b9a\u5ba2\u6237\u53d1\u8d27\u4ed3\u914d\u7f6e reqParams is {} . ", (Object)JSON.toJSONString((Object)addReqDto));
        AssertUtil.assertTrue(!CollectionUtils.isEmpty((Collection)addReqDto.getWarehouseCodeList()), "\u4ed3\u5e93\u7f16\u7801\u4e3a\u7a7a", new Object[0]);
        AssertUtil.assertNotNull(addReqDto.getOrganizationId(), "\u7ec4\u7ec7ID\u4e3a\u7a7a", new Object[0]);
        AssertUtil.assertNotNull(addReqDto.getCustomerId(), "\u5ba2\u6237ID\u4e3a\u7a7a", new Object[0]);
        AssertUtil.assertNotNull(addReqDto.getWarehouseType(), "\u4ed3\u5e93\u7c7b\u578b\u4e3a\u7a7a", new Object[0]);
        CsLogicWarehouseRespDto csLogicWarehouseRespDto = this.getWarehouseInfo(addReqDto);
        AssertUtil.assertTrue(csLogicWarehouseRespDto != null, "\u5f53\u524d\u4ed3\u5e93\u4e0d\u5b58\u5728", new Object[0]);
        CustomerRespDto customerRespDto = (CustomerRespDto)((Object)RestResponseHelper.extractData(this.customerInfoV3XbApi.queryById(addReqDto.getCustomerId())));
        AssertUtil.assertNotNull((Object)customerRespDto, "\u5ba2\u6237\u4e0d\u5b58\u5728", new Object[0]);
        ArrayList merchantIds = Lists.newArrayList();
        merchantIds.add(customerRespDto.getMerchantId());
        List customerExtRespDtos = (List)RestResponseHelper.extractData(this.customerInfoV3XbApi.queryByOrgIdList(merchantIds));
        AssertUtil.assertTrue(!CollectionUtils.isEmpty((Collection)customerExtRespDtos), "\u4e0a\u7ea7\u5ba2\u6237\u4e0d\u5b58\u5728", new Object[0]);
        CustomerExtRespDto customerExtRespDto = (CustomerExtRespDto)((Object)customerExtRespDtos.stream().findFirst().get());
        AssertUtil.assertTrue(YesNoEnum.YES.getValue().equals(customerExtRespDto.getIsWarehouseEnable()), "\u4e0a\u7ea7\u5ba2\u6237\u672a\u5f00\u542f\u5206\u4ed3\u53d1\u8d27\u7b56\u7565", new Object[0]);
        if ("0".equals(addReqDto.getWarehouseType())) {
            this.checkProgressTrade(addReqDto);
        }
        Long shopId = this.getShopIdByWarehouseSupplyReqParam(addReqDto);
        CustomerReqExtDto customerReqExtDto = new CustomerReqExtDto();
        CubeBeanUtils.copyProperties((Object)((Object)customerReqExtDto), (Object)((Object)customerRespDto), (String[])new String[0]);
        customerReqExtDto.setIsWarehouseEnable(addReqDto.getMainWarehouse());
        customerReqExtDto.setSaveType(EditCustomerSaveTypeEnum.CUSTOMER.getCode());
        this.customerInfoV3XbApi.update(customerReqExtDto);
        WarehouseSupplyConfigReqDto warehouseSupplyConfigReqDto = new WarehouseSupplyConfigReqDto();
        warehouseSupplyConfigReqDto.setOrganizationId(addReqDto.getOrganizationId());
        warehouseSupplyConfigReqDto.setCustomerCode(customerRespDto.getCode());
        PageInfo<WarehouseSupplyConfigRespDto> warehouseSupplyConfigRespDtoPageInfo = this.warehouseSupplyConfigService.queryByPage(JSON.toJSONString((Object)warehouseSupplyConfigReqDto), 1, Integer.MAX_VALUE);
        if (CollectionUtils.isEmpty((Collection)warehouseSupplyConfigRespDtoPageInfo.getList())) {
            WarehouseSupplyConfigReqDto warehouseSupplyConfig = new WarehouseSupplyConfigReqDto(shopId, addReqDto.getOrganizationId(), addReqDto.getOrganizationCode(), addReqDto.getOrganizationName(), ItemInventoryStrategyEnum.SEPARATE.getTypeCode(), customerRespDto.getId(), customerRespDto.getCode());
            this.warehouseSupplyConfigService.addWarehouseSupplyConfig(warehouseSupplyConfig);
        } else {
            WarehouseSupplyConfigRespDto warehouseSupplyConfigRespDto = (WarehouseSupplyConfigRespDto)warehouseSupplyConfigRespDtoPageInfo.getList().stream().findFirst().get();
            WarehouseSupplyConfigReqDto modifyReqDto = new WarehouseSupplyConfigReqDto();
            CubeBeanUtils.copyProperties((Object)modifyReqDto, (Object)warehouseSupplyConfigRespDto, (String[])new String[0]);
            modifyReqDto.setSupplyType(YesNoEnum.YES.getValue().equals(csLogicWarehouseRespDto.getMainWarehouse()) ? ItemInventoryStrategyEnum.DEFAULT.getTypeCode() : ItemInventoryStrategyEnum.SEPARATE.getTypeCode());
            modifyReqDto.setShopId(shopId);
            this.warehouseSupplyConfigService.modifyWarehouseSupplyConfig(modifyReqDto);
        }
        WarehouseSupplyRelEo warehouseSupplyRelEo = new WarehouseSupplyRelEo();
        warehouseSupplyRelEo.setCustomerId(addReqDto.getCustomerId());
        warehouseSupplyRelEo.setWarehouseType(addReqDto.getWarehouseType());
        this.warehouseSupplyRelDas.delete((BaseEo)warehouseSupplyRelEo);
        List insertWarehouseList = addReqDto.getWarehouseCodeList().stream().map(warehouseCode -> WarehouseSupplyRelEo.builder().warehouseId(csLogicWarehouseRespDto.getId()).warehouseCode(warehouseCode).warehouseType(addReqDto.getWarehouseType()).warehouseName(csLogicWarehouseRespDto.getWarehouseName()).organizationId(addReqDto.getOrganizationId()).organizationCode(addReqDto.getOrganizationCode()).organizationName(addReqDto.getOrganizationName()).status(YesNoEnum.YES.getValue()).customerId(addReqDto.getCustomerId()).customerCode(customerRespDto.getCode()).build()).collect(Collectors.toList());
        this.warehouseSupplyRelDas.insertBatch(insertWarehouseList);
        return null;
    }

    private CsLogicWarehouseRespDto getWarehouseInfo(WarehouseSupplyRelReqDto addReqDto) {
        CsLogicWarehouseQueryDto csLogicWarehouseQueryDto = new CsLogicWarehouseQueryDto();
        csLogicWarehouseQueryDto.setOrganizationId(addReqDto.getOrganizationId());
        csLogicWarehouseQueryDto.setWarehouseCode((String)addReqDto.getWarehouseCodeList().get(0));
        csLogicWarehouseQueryDto.setPageNum(Integer.valueOf(1));
        csLogicWarehouseQueryDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        log.info("csLogicWarehouseQueryService.queryByPage param={}", (Object)JSONObject.toJSONString((Object)csLogicWarehouseQueryDto));
        PageInfo<CsLogicWarehouseRespDto> csLogicWarehouseRespDtoPageInfo = this.csLogicWarehouseQueryService.queryByPage(csLogicWarehouseQueryDto);
        log.info("csLogicWarehouseQueryService.queryByPage result={}", (Object)JSONObject.toJSONString(csLogicWarehouseRespDtoPageInfo));
        List logicWarehouseRespDtos = Optional.ofNullable(csLogicWarehouseRespDtoPageInfo.getList()).orElse(Lists.newArrayList());
        if (logicWarehouseRespDtos.size() > 1) {
            log.error("\u4ed3\u5e93\u7f16\u7801\u67e5\u8be2\u7ed3\u679c\u4e3a\u591a\u6761 addReqDto={}, logicWarehouseRespDtos={}", (Object)JSONObject.toJSONString((Object)addReqDto), (Object)JSONObject.toJSONString((Object)logicWarehouseRespDtos));
            throw new BizException("\u4ed3\u5e93\u7f16\u7801\u67e5\u8be2\u7ed3\u679c\u4e3a\u591a\u6761");
        }
        return (CsLogicWarehouseRespDto)logicWarehouseRespDtos.get(0);
    }

    private void checkProgressTrade(WarehouseSupplyRelReqDto addReqDto) {
        String errorInfo = this.checkProgressTradeForString(addReqDto);
        if (errorInfo != null) {
            throw new com.dtyunxi.cube.commons.exceptions.BizException(errorInfo);
        }
    }

    private String checkProgressTradeForString(WarehouseSupplyRelReqDto addReqDto) {
        log.info("checkProgressTrade addReqDto={}", (Object)JSONObject.toJSONString((Object)addReqDto));
        List progressTradeList = (List)this.tradeInfoRpcApi.queryProgressTradeByCustomerId(QueryProgressTradeByCustomerIdReqDto.builder().lss_cus(addReqDto.getCustomerId()).build()).getData();
        log.info("progressTradeList={}", (Object)JSONObject.toJSONString((Object)progressTradeList));
        if (progressTradeList != null && !progressTradeList.isEmpty()) {
            StringBuilder errorMsg = new StringBuilder("\u8bbe\u7f6e\u53d1\u8d27\u4ed3\u5e93\u5b57\u6bb5\u5931\u8d25\uff0c\u5b58\u5728\u5728\u9014\u5355\u636e\u9884\u5360\u5e93\u5b58\uff1a\r\n");
            for (QueryProgressTradeByCustomerIdRespDto progressTrade : progressTradeList) {
                errorMsg.append("\u5ba2\u6237: ").append(progressTrade.getLssCustomerName()).append("[").append(progressTrade.getLssCusCode()).append("]  ").append("\u8ba2\u5355\u53f7: ").append(progressTrade.getTradeNo()).append("  \u8ba2\u5355\u72b6\u6001: ").append(progressTrade.getOrderTradeStatusMapped()).append("\r\n");
            }
            return errorMsg.toString();
        }
        return null;
    }

    private Long getShopIdByWarehouseSupplyReqParam(WarehouseSupplyRelReqDto addReqDto) {
        ShopQueryV3Dto shopQueryParam = new ShopQueryV3Dto();
        shopQueryParam.setOrganizationId(addReqDto.getOrganizationId());
        PageInfo shopBaseDtoList = (PageInfo)RestResponseHelper.extractData(this.shopQueryV3RpcApi.queryBaseShopPage2(shopQueryParam, 1, 1));
        if (shopBaseDtoList == null || shopBaseDtoList.getList() == null || shopBaseDtoList.getList().isEmpty()) {
            throw new BizException("\u5e97\u94fa\u67e5\u8be2\u5f02\u5e38 orgId=" + addReqDto.getOrganizationId());
        }
        return ((ShopBaseDto)((Object)shopBaseDtoList.getList().get(0))).getId();
    }

    @Override
    public void modifyWarehouseSupplyRel(WarehouseSupplyRelReqDto modifyReqDto) {
        WarehouseSupplyRelEo warehouseSupplyRelEo = new WarehouseSupplyRelEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)warehouseSupplyRelEo);
        this.warehouseSupplyRelDas.updateSelective((BaseEo)warehouseSupplyRelEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeWarehouseSupplyRel(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.warehouseSupplyRelDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public WarehouseSupplyRelRespDto queryById(Long id) {
        WarehouseSupplyRelEo warehouseSupplyRelEo = (WarehouseSupplyRelEo)this.warehouseSupplyRelDas.selectByPrimaryKey(id);
        WarehouseSupplyRelRespDto warehouseSupplyRelRespDto = new WarehouseSupplyRelRespDto();
        DtoHelper.eo2Dto((BaseEo)warehouseSupplyRelEo, (BaseVo)warehouseSupplyRelRespDto);
        return warehouseSupplyRelRespDto;
    }

    @Override
    public PageInfo<WarehouseSupplyRelRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        WarehouseSupplyRelReqDto warehouseSupplyRelReqDto = (WarehouseSupplyRelReqDto)JSON.parseObject((String)filter, WarehouseSupplyRelReqDto.class);
        WarehouseSupplyRelEo warehouseSupplyRelEo = new WarehouseSupplyRelEo();
        DtoHelper.dto2Eo((BaseVo)warehouseSupplyRelReqDto, (BaseEo)warehouseSupplyRelEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty((Collection)warehouseSupplyRelReqDto.getCustomerIds())) {
            sqlFilters.add(SqlFilter.in((String)"customer_id", (Object)warehouseSupplyRelReqDto.getCustomerIds()));
        }
        warehouseSupplyRelEo.setSqlFilters(sqlFilters);
        PageInfo eoPageInfo = this.warehouseSupplyRelDas.selectPage((BaseEo)warehouseSupplyRelEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, WarehouseSupplyRelRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<WarehouseSupplyRelRespDto> queryByCustomerId(String customerId) {
        WarehouseSupplyRelEo params = new WarehouseSupplyRelEo();
        params.setCustomerId(Long.valueOf(customerId));
        List select = this.warehouseSupplyRelDas.select((BaseEo)params);
        ArrayList warehouseSupplyRelRespDto = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)select, (Collection)warehouseSupplyRelRespDto, WarehouseSupplyRelRespDto.class);
        return warehouseSupplyRelRespDto;
    }

    @Override
    public PageInfo<WarehouseSupplyRelRespDto> queryWarehousePage(String filter, Integer pageNum, Integer pageSize) {
        WarehouseSupplyRelReqDto warehouseSupplyRelReqDto = (WarehouseSupplyRelReqDto)JSON.parseObject((String)filter, WarehouseSupplyRelReqDto.class);
        Page warehouseSupplyRelEos = this.warehouseSupplyRelDas.queryWarehousePage(warehouseSupplyRelReqDto, pageNum, pageSize);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)warehouseSupplyRelEos, (String[])new String[]{"list", "navigatepageNums"});
        List warehouseSupplyRelEoList = warehouseSupplyRelEos.getResult();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)warehouseSupplyRelEoList)) {
            respDtoPageInfo.setList(warehouseSupplyRelEoList);
        }
        return respDtoPageInfo;
    }

    @Override
    @Deprecated
    public BizImportRespDto importWarehouseSupplyRel(BizImportRespDto<DeliveryConfigVo> addReqDto) {
        log.info("\u5bfc\u5165\u5206\u4ed3\u914d\u7f6e reqParams is {} . ", (Object)JSON.toJSONString(addReqDto));
        List importVoList = addReqDto.getObjects();
        Integer total = importVoList.size();
        Integer importSuccessTotal = 0;
        Integer importFailTotal = 0;
        List<Object> exportVoList = Lists.newArrayList();
        this.checkImportData(addReqDto);
        exportVoList = importVoList.stream().filter(c -> !StringUtils.isEmpty((Object)c.getErrorDesc())).collect(Collectors.toList());
        importFailTotal = exportVoList.size();
        importSuccessTotal = total - importFailTotal;
        List<DeliveryConfigVo> importVoCheckSuccess = importVoList.stream().filter(c -> StringUtils.isEmpty((Object)c.getErrorDesc())).collect(Collectors.toList());
        log.info("importVoCheckSuccess={}", (Object)JSONObject.toJSONString(importVoCheckSuccess));
        this.processWarehouseSupplyRel(importVoCheckSuccess, addReqDto.getOrgId());
        String url = "";
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(exportVoList)) {
            String excelName = "cube/\u5206\u4ed3\u914d\u7f6e\u5bfc\u5165\u5931\u8d25\u6587\u4ef6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                url = EasyPoiExportUtil.getExportUrl(exportVoList, DeliveryConfigVo.class, (String)null, (String)excelName, (String)"xls");
                log.info("\u3010\u5bfc\u5165\u5206\u4ed3\u914d\u7f6e\u3011\u5931\u8d25\u6587\u4ef6url : {}", (Object)url);
            }
            catch (Exception var15) {
                log.error("\u5bfc\u51fa\u5206\u4ed3\u914d\u7f6e-\u9519\u8bef:{}", (Object)var15.toString());
            }
        }
        BizImportRespDto bizImportRespDto = new BizImportRespDto(total, importSuccessTotal, importFailTotal, url);
        log.info("\u5bfc\u5165\u5206\u4ed3\u914d\u7f6e return is {} . ", (Object)JSON.toJSONString((Object)bizImportRespDto));
        return bizImportRespDto;
    }

    private List<DeliveryConfigVo> processWarehouseSupplyRel(List<DeliveryConfigVo> importVoCheckSuccess, Long orgId) {
        log.info("\u5f00\u59cb\u5f02\u6b65\u5199\u5165 processWarehouseSupplyRel importVoCheckSuccess={}, orgId={}", (Object)JSONObject.toJSONString(importVoCheckSuccess), (Object)orgId);
        ArrayList writeErrorList = Lists.newArrayList();
        Optional.of(importVoCheckSuccess).orElse(Lists.newArrayList()).forEach(configDto -> {
            if (configDto.getWarehouseCode() == null) {
                log.info("configDto={}, \u4ea7\u54c1\u4ed3\u7f16\u7801\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u4ea7\u54c1\u4ed3\u5bfc\u5165\uff0c\u4ec5\u5bfc\u5165\u9000\u8d27\u4ed3 ", (Object)JSONObject.toJSONString((Object)configDto));
                return;
            }
            WarehouseSupplyRelReqDto warehouseSupplyRelReqDto = WarehouseSupplyRelServiceImpl.getWarehouseSupplyRelReqDto(configDto, configDto.getWarehouseCode(), orgId, CsWarehouseTypeEnum.PRODUCT_WAREHOUSE);
            try {
                this.addWarehouseSupplyRel(warehouseSupplyRelReqDto);
            }
            catch (Exception e) {
                log.error("processWarehouseSupplyRel \u5f02\u6b65\u5199\u5165\u5f02\u5e38", (Throwable)e);
                configDto.setErrorDesc("\u4ea7\u54c1\u4ed3\u5199\u5165\u5f02\u5e38: " + e.getMessage());
                writeErrorList.add(configDto);
            }
        });
        Optional.of(importVoCheckSuccess).orElse(Lists.newArrayList()).forEach(configDto -> {
            if (configDto.getReturnWarehouseCode() == null) {
                log.info("configDto={}, \u9000\u8d27\u4ed3\u7f16\u7801\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u9000\u8d27\u4ed3\u5bfc\u5165\uff0c\u4ec5\u5bfc\u5165\u4ea7\u54c1\u4ed3 ", (Object)JSONObject.toJSONString((Object)configDto));
                return;
            }
            WarehouseSupplyRelReqDto warehouseSupplyRelReqDto = WarehouseSupplyRelServiceImpl.getWarehouseSupplyRelReqDto(configDto, configDto.getReturnWarehouseCode(), orgId, CsWarehouseTypeEnum.RETURN_WAREHOUSE);
            try {
                this.addWarehouseSupplyRel(warehouseSupplyRelReqDto);
            }
            catch (Exception e) {
                log.error("processWarehouseSupplyRel \u5f02\u6b65\u5199\u5165\u5f02\u5e38", (Throwable)e);
                if (configDto.getErrorDesc() != null) {
                    configDto.setErrorDesc(configDto.getErrorDesc() + "\r\n\u9000\u8d27\u4ed3\u5199\u5165\u5f02\u5e38: " + e.getMessage());
                } else {
                    configDto.setErrorDesc("\u9000\u8d27\u4ed3\u5199\u5165\u5f02\u5e38: " + e.getMessage());
                }
                writeErrorList.add(configDto);
            }
        });
        log.info("\u7ed3\u675f\u5f02\u6b65\u5199\u5165 processWarehouseSupplyRel writeErrorList={}, orgId={}", (Object)JSONObject.toJSONString((Object)writeErrorList), (Object)orgId);
        return writeErrorList;
    }

    private static WarehouseSupplyRelReqDto getWarehouseSupplyRelReqDto(DeliveryConfigVo configDto, String warehouseCode, Long orgId, CsWarehouseTypeEnum productWarehouse) {
        WarehouseSupplyRelReqDto warehouseSupplyRelReqDto = new WarehouseSupplyRelReqDto();
        warehouseSupplyRelReqDto.setCustomerId(configDto.getCustomerId());
        ArrayList warehouseCodes = Lists.newArrayList();
        warehouseCodes.add(warehouseCode);
        warehouseSupplyRelReqDto.setWarehouseCodeList((List)warehouseCodes);
        warehouseSupplyRelReqDto.setOrganizationId(orgId);
        warehouseSupplyRelReqDto.setWarehouseType(productWarehouse.getCode());
        log.info("warehouseSupplyRelReqDto={}", (Object)JSONObject.toJSONString((Object)warehouseSupplyRelReqDto));
        return warehouseSupplyRelReqDto;
    }

    private void checkImportData(BizImportRespDto<DeliveryConfigVo> addReqDto) {
        Map<Object, Object> jxsCustomerMap;
        log.info("checkImportData addReqDto={}", (Object)JSONObject.toJSONString(addReqDto));
        List importVoList = addReqDto.getObjects();
        List<String> customerCodes = importVoList.stream().map(DeliveryConfigVo::getCustomerCode).collect(Collectors.toList());
        log.info("customerExtThreeQueryApi.queryByCodeList param={}", (Object)JSONObject.toJSONString(customerCodes));
        List smallBCustomer = (List)RestResponseHelper.extractData(this.customerInfoV3XbApi.queryByCodeList(customerCodes));
        log.info("customerExtThreeQueryApi.queryByCodeList result={}", (Object)JSONObject.toJSONString((Object)smallBCustomer));
        Map<Object, Object> smallBCustomerMap = smallBCustomer == null ? new HashMap() : smallBCustomer.stream().collect(Collectors.toMap(CustomerRespDto::getCode, v -> v, (k1, k2) -> k1));
        log.info("smallBCustomerMap={}", (Object)JSONObject.toJSONString(smallBCustomerMap));
        if (smallBCustomerMap.isEmpty()) {
            jxsCustomerMap = new HashMap();
        } else {
            List<Long> merchantIds = smallBCustomer.stream().map(CustomerRespDto::getMerchantId).collect(Collectors.toList());
            log.info("customerExtThreeQueryApi.queryByOrgIdList param={}", (Object)JSONObject.toJSONString(merchantIds));
            List jxsCustomerExtRespDtos = (List)RestResponseHelper.extractData(this.customerInfoV3XbApi.queryByOrgIdList(merchantIds));
            log.info("customerExtThreeQueryApi.queryByOrgIdList result={}", (Object)JSONObject.toJSONString((Object)jxsCustomerExtRespDtos));
            jxsCustomerMap = jxsCustomerExtRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, v -> v, (k1, k2) -> k1));
        }
        log.info("jxsCustomerMap={}", (Object)JSONObject.toJSONString(jxsCustomerMap));
        CsLogicWarehouseQueryDto csLogicWarehouseQueryDto = new CsLogicWarehouseQueryDto();
        csLogicWarehouseQueryDto.setOrganizationId(addReqDto.getOrgId());
        csLogicWarehouseQueryDto.setPageNum(Integer.valueOf(1));
        csLogicWarehouseQueryDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        log.info("csLogicWarehouseQueryService.queryByPage param={}", (Object)JSONObject.toJSONString((Object)csLogicWarehouseQueryDto));
        PageInfo<CsLogicWarehouseRespDto> csLogicWarehouseRespDtoPageInfo = this.csLogicWarehouseQueryService.queryByPage(csLogicWarehouseQueryDto);
        log.info("csLogicWarehouseQueryService.queryByPage result={}", (Object)JSONObject.toJSONString(csLogicWarehouseRespDtoPageInfo));
        List logicWarehouseRespDtos = Optional.ofNullable(csLogicWarehouseRespDtoPageInfo.getList()).orElse(Lists.newArrayList());
        Map<String, CsLogicWarehouseRespDto> warehouseRespDtoMap = logicWarehouseRespDtos.stream().filter(c -> CsWarehouseTypeEnum.PRODUCT_WAREHOUSE.getDesc().equals(c.getWarehouseType())).collect(Collectors.toMap(CsLogicWarehouseRespDto::getWarehouseCode, v -> v, (k1, k2) -> k1));
        log.info("warehouseRespDtoMap={}", (Object)JSONObject.toJSONString(warehouseRespDtoMap));
        Map<String, CsLogicWarehouseRespDto> returnWarehouseRespDtoMap = logicWarehouseRespDtos.stream().filter(c -> CsWarehouseTypeEnum.RETURN_WAREHOUSE.getDesc().equals(c.getWarehouseType())).collect(Collectors.toMap(CsLogicWarehouseRespDto::getWarehouseCode, v -> v, (k1, k2) -> k1));
        log.info("returnWarehouseRespDtoMap={}", (Object)JSONObject.toJSONString(returnWarehouseRespDtoMap));
        importVoList.forEach(configVo -> {
            log.info("configVo={}", (Object)JSONObject.toJSONString((Object)configVo));
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)configVo.getCustomerCode())) {
                configVo.setErrorDesc("\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                log.info("configVo={}, error \u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object)JSONObject.toJSONString((Object)configVo));
                return;
            }
            boolean warehouseCodeNotExist = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)configVo.getWarehouseCode());
            boolean returnWarehouseCodeNotExist = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)configVo.getReturnWarehouseCode());
            if (warehouseCodeNotExist && returnWarehouseCodeNotExist) {
                configVo.setErrorDesc("\u4ea7\u54c1\u4ed3\u7f16\u7801\u548c\u9000\u8d27\u4ed3\u7f16\u7801\uff0c\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
                log.info("configVo={}, error \u4ea7\u54c1\u4ed3\u7f16\u7801\u548c\u9000\u8d27\u4ed3\u7f16\u7801\uff0c\u4e0d\u80fd\u90fd\u4e3a\u7a7a", (Object)JSONObject.toJSONString((Object)configVo));
                return;
            }
            CustomerExtRespDto smallBCustomerDto = (CustomerExtRespDto)((Object)((Object)smallBCustomerMap.get(configVo.getCustomerCode())));
            if (ObjectUtils.isEmpty((Object)((Object)smallBCustomerDto))) {
                configVo.setErrorDesc("\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728");
                log.info("configVo={}, error \u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728 smallBCustomerDto={}", (Object)JSONObject.toJSONString((Object)configVo), (Object)JSONObject.toJSONString((Object)((Object)smallBCustomerDto)));
                return;
            }
            configVo.setCustomerId(smallBCustomerDto.getId());
            log.info("configVo={}, success \u5ba2\u6237\u7f16\u7801\u5b58\u5728 smallBCustomerDto={}", (Object)JSONObject.toJSONString((Object)configVo), (Object)JSONObject.toJSONString((Object)((Object)smallBCustomerDto)));
            CustomerExtRespDto jxsCustomerDto = (CustomerExtRespDto)((Object)((Object)jxsCustomerMap.get(smallBCustomerDto.getMerchantId())));
            if (ObjectUtils.isEmpty((Object)((Object)jxsCustomerDto))) {
                configVo.setErrorDesc("\u95e8\u5e97\u4e0a\u7ea7\u7ecf\u9500\u5546\u4fe1\u606f\u4e0d\u5b58\u5728" + smallBCustomerDto.getCode() + " " + smallBCustomerDto.getName());
                log.info("configVo={}, error \u95e8\u5e97\u4e0a\u7ea7\u7ecf\u9500\u5546\u4fe1\u606f\u4e0d\u5b58\u5728 smallBCustomerDto={}", (Object)JSONObject.toJSONString((Object)configVo), (Object)JSONObject.toJSONString((Object)((Object)smallBCustomerDto)));
                return;
            }
            log.info("configVo={}, success \u95e8\u5e97\u4e0a\u7ea7\u7ecf\u9500\u5546\u4fe1\u606f\u5b58\u5728 jxsCustomerDto={}", (Object)JSONObject.toJSONString((Object)configVo), (Object)JSONObject.toJSONString((Object)((Object)jxsCustomerDto)));
            if (!YesNoEnum.YES.getValue().equals(jxsCustomerDto.getIsWarehouseEnable())) {
                configVo.setErrorDesc("\u7ecf\u9500\u5546\u672a\u5f00\u542f\u5206\u4ed3\u914d\u7f6e" + jxsCustomerDto.getCode() + " " + jxsCustomerDto.getName());
                log.info("configVo={}, error \u7ecf\u9500\u5546\u672a\u5f00\u542f\u5206\u4ed3\u914d\u7f6e jxsCustomerDto={}", (Object)JSONObject.toJSONString((Object)configVo), (Object)JSONObject.toJSONString((Object)((Object)jxsCustomerDto)));
                return;
            }
            log.info("configVo={}, success \u7ecf\u9500\u5546\u5f00\u542f\u5206\u4ed3\u914d\u7f6e jxsCustomerDto={}", (Object)JSONObject.toJSONString((Object)configVo), (Object)JSONObject.toJSONString((Object)((Object)jxsCustomerDto)));
            boolean warehouseCodeExist = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)configVo.getWarehouseCode());
            if (warehouseCodeExist) {
                CsLogicWarehouseRespDto csLogicWarehouseRespDto = (CsLogicWarehouseRespDto)warehouseRespDtoMap.get(configVo.getWarehouseCode());
                if (ObjectUtils.isEmpty((Object)csLogicWarehouseRespDto)) {
                    configVo.setErrorDesc("\u7ecf\u9500\u5546\u4e0d\u5b58\u5728\u8be5\u4ea7\u54c1\u4ed3\u7f16\u7801");
                    log.info("configVo={}, error \u7ecf\u9500\u5546\u4e0d\u5b58\u5728\u8be5\u4ea7\u54c1\u4ed3\u7f16\u7801 csLogicWarehouseRespDto={}", (Object)JSONObject.toJSONString((Object)configVo), (Object)JSONObject.toJSONString((Object)csLogicWarehouseRespDto));
                    return;
                }
                log.info("configVo={}, success \u7ecf\u9500\u5546\u5b58\u5728\u8be5\u4ea7\u54c1\u4ed3\u7f16\u7801 csLogicWarehouseRespDto={}", (Object)JSONObject.toJSONString((Object)configVo), (Object)JSONObject.toJSONString((Object)csLogicWarehouseRespDto));
            } else {
                log.info("configVo={}, continue \u4ea7\u54c1\u4ed3\u7f16\u7801\u4e3a\u7a7a \u8df3\u8fc7", (Object)JSONObject.toJSONString((Object)configVo));
            }
            if (warehouseCodeExist) {
                String progressTradeErrorInfo = this.checkProgressTradeForString(WarehouseSupplyRelReqDto.builder().customerId(smallBCustomerDto.getId()).build());
                if (progressTradeErrorInfo != null) {
                    configVo.setErrorDesc(progressTradeErrorInfo);
                    log.info("configVo={}, error \u5b58\u5728\u5728\u9014\u5355 progressTradeErrorInfo={}", (Object)JSONObject.toJSONString((Object)configVo), (Object)JSONObject.toJSONString((Object)progressTradeErrorInfo));
                    return;
                }
                log.info("configVo={}, success \u4e0d\u5b58\u5728\u5728\u9014\u5355 progressTradeErrorInfo={}", (Object)JSONObject.toJSONString((Object)configVo), (Object)JSONObject.toJSONString((Object)progressTradeErrorInfo));
            } else {
                log.info("configVo={}, continue \u672a\u5bfc\u5165\u4ea7\u54c1\u4ed3\u7f16\u7801 \u8df3\u8fc7", (Object)JSONObject.toJSONString((Object)configVo));
            }
            boolean warehouseReturnCodeExist = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)configVo.getReturnWarehouseCode());
            if (warehouseReturnCodeExist) {
                CsLogicWarehouseRespDto csLogicReturnWarehouseRespDto = (CsLogicWarehouseRespDto)returnWarehouseRespDtoMap.get(configVo.getReturnWarehouseCode());
                if (ObjectUtils.isEmpty((Object)csLogicReturnWarehouseRespDto)) {
                    configVo.setErrorDesc("\u7ecf\u9500\u5546\u4e0d\u5b58\u5728\u8be5\u9000\u8d27\u4ed3\u7f16\u7801");
                    log.info("configVo={}, error \u7ecf\u9500\u5546\u4e0d\u5b58\u5728\u8be5\u9000\u8d27\u4ed3\u7f16\u7801 csLogicReturnWarehouseRespDto={}", (Object)JSONObject.toJSONString((Object)configVo), (Object)JSONObject.toJSONString((Object)csLogicReturnWarehouseRespDto));
                    return;
                }
                log.info("configVo={}, success \u7ecf\u9500\u5546\u5b58\u5728\u8be5\u9000\u8d27\u4ed3\u7f16\u7801 csLogicReturnWarehouseRespDto={}", (Object)JSONObject.toJSONString((Object)configVo), (Object)JSONObject.toJSONString((Object)csLogicReturnWarehouseRespDto));
            } else {
                log.info("configVo={}, continue \u672a\u5bfc\u5165\u9000\u8d27\u4ed3\u7f16\u7801 \u8df3\u8fc7", (Object)JSONObject.toJSONString((Object)configVo));
            }
        });
        log.info("checkImportData end importVoList={}, addReqDto={}", (Object)JSONObject.toJSONString((Object)importVoList), (Object)JSONObject.toJSONString(addReqDto));
    }

    @Override
    public List<String> getWarehouseCodeListByOrgId(Long orgId) {
        log.info("getWarehouseCodeListByOrgId orgId={}", (Object)orgId);
        CsLogicWarehouseQueryDto queryDto = new CsLogicWarehouseQueryDto();
        queryDto.setOrganizationId(orgId);
        queryDto.setWarehouseType(CsWarehouseTypeEnum.PRODUCT_WAREHOUSE.getCode());
        List<CsLogicWarehouseRespDto> warehouseCodeList = this.csLogicWarehouseQueryService.queryByParam(queryDto);
        if (warehouseCodeList == null || warehouseCodeList.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> warehouseCodes = warehouseCodeList.stream().map(CsLogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toList());
        log.info("getWarehouseCodeListByOrgId warehouseCodes={}", (Object)JSONObject.toJSONString(warehouseCodes));
        return warehouseCodes;
    }

    @Override
    public BaseImportRespDto importSplitWarehouse(BizImportRespDto<DeliveryConfigVo> addReqDto) {
        log.info("\u5bfc\u5165\u5206\u4ed3\u914d\u7f6e reqParams is {} . ", (Object)JSON.toJSONString(addReqDto));
        List importVoList = addReqDto.getObjects();
        this.checkImportData(addReqDto);
        List errorList = importVoList.stream().filter(c -> !StringUtils.isEmpty((Object)c.getErrorDesc())).collect(Collectors.toList());
        log.info("errorList={}", (Object)JSONObject.toJSONString(errorList));
        List<DeliveryConfigVo> checkSuccessList = importVoList.stream().filter(c -> StringUtils.isEmpty((Object)c.getErrorDesc())).collect(Collectors.toList());
        log.info("checkSuccessList={}", (Object)JSONObject.toJSONString(checkSuccessList));
        List<DeliveryConfigVo> writeErrorList = this.processWarehouseSupplyRel(checkSuccessList, addReqDto.getOrgId());
        errorList.addAll(writeErrorList);
        return BaseImportRespDto.builder().num(Integer.valueOf(importVoList.size())).successNum(Integer.valueOf(checkSuccessList.size())).failNum(Integer.valueOf(errorList.size())).errorList(errorList).build();
    }

    @Override
    public WarehouseSupplyRelRespDto getSubWarehouse(GetSubWarehouseReqDto reqDto) {
        log.info("getSubWarehouse reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
        WarehouseSupplyRelReqDto warehouseSupplyRelReqDto = new WarehouseSupplyRelReqDto();
        warehouseSupplyRelReqDto.setWarehouseType(reqDto.getWarehouseType());
        warehouseSupplyRelReqDto.setCustomerId(reqDto.getCustomerId());
        warehouseSupplyRelReqDto.setOrganizationId(reqDto.getOrganizationId());
        Page warehouseSupplyRelEos = this.warehouseSupplyRelDas.queryWarehousePage(warehouseSupplyRelReqDto, Integer.valueOf(1), Integer.valueOf(1));
        if (warehouseSupplyRelEos.getResult() != null && !warehouseSupplyRelEos.getResult().isEmpty()) {
            log.info("getSubWarehouse \u67e5\u8be2\u5206\u4ed3\u4e3a={}", (Object)JSONObject.toJSONString(warehouseSupplyRelEos.getResult().get(0)));
            return (WarehouseSupplyRelRespDto)warehouseSupplyRelEos.getResult().get(0);
        }
        CsLogicWarehouseEo csLogicWarehouseEo = (CsLogicWarehouseEo)this.csLogicWarehouseMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CsLogicWarehouseEo::getOrganizationId, (Object)reqDto.getOrganizationId())).eq(CsLogicWarehouseEo::getWarehouseType, (Object)reqDto.getWarehouseType())).eq(CsLogicWarehouseEo::getMainWarehouse, (Object)"1"));
        log.info("getSubWarehouse \u67e5\u8be2\u4e3b\u4ed3\u4e3a={}", (Object)JSONObject.toJSONString((Object)csLogicWarehouseEo));
        WarehouseSupplyRelRespDto warehouseSupplyRelRespDto = new WarehouseSupplyRelRespDto();
        BeanUtil.copyProperties((Object)csLogicWarehouseEo, (Object)warehouseSupplyRelRespDto, (String[])new String[0]);
        warehouseSupplyRelRespDto.setWarehouseId(csLogicWarehouseEo.getId());
        log.info("getSubWarehouse \u8fd4\u56de\u4e3b\u4ed3\u4e3a={}", (Object)JSONObject.toJSONString((Object)warehouseSupplyRelRespDto));
        return warehouseSupplyRelRespDto;
    }
}

