/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.order;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.enus.OrderTypeEnu;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.order.ITcbjBaseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.order.ITcbjDeliveryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DRAOrderCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DRAOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjDRAOrderCargoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjDRAOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.SimpleRequestDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjNotiGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.RelOrderAndResnosDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.TcbjNotiDetailCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.TcbjResDetailCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.OrderStatus;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.OrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.MqContentOtherFieldDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.req.TcbjDeliveryAuReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.req.TcbjDeliveryNotiReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.req.TcbjDeliveryResReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.resp.TcbjDeliveryExcelRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.resp.TcbjDeliveryNotiDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.resp.TcbjDeliveryNotiRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.resp.TcbjDeliveryResDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.resp.TcbjDeliveryResRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.third.ThirdContent;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TcbjDeliveryServiceImpl
implements ITcbjDeliveryService {
    private static final Logger logger = LoggerFactory.getLogger(TcbjDeliveryServiceImpl.class);
    private final String COMBINATION_ACTIVITY = "COMBINATION_ACTIVITY";
    @Autowired
    private TcbjDRAOrderMapper tcbjDRAOrderMapper;
    @Autowired
    private TcbjDRAOrderCargoMapper tcbjDRAOrderCargoMapper;
    @Autowired
    private ITcbjBaseService tcbjBaseService;
    @Resource
    private IContext context;
    @Autowired
    private ICustomerExtQueryApi customerExtQueryApi;
    private final ExecutorService executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public RestResponse<String> gen(ThirdContent thirdContent) {
        return new RestResponse("0", "success", null);
    }

    @Override
    public RestResponse<PageInfo<TcbjDeliveryNotiRespDto>> notiPage(TcbjDeliveryNotiReqDto queryDto) {
        logger.info("\u83b7\u53d6\u53d1\u8d27\u901a\u77e5\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        QueryWrapper wrapper = new QueryWrapper();
        RestResponse restResponse = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId());
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        wrapper.eq((Object)"organization_id", (Object)orgId);
        wrapper.eq((Object)"category", (Object)"101");
        if (StringUtil.isNotBlank((String)queryDto.getType())) {
            wrapper.eq((Object)"type", (Object)queryDto.getType());
        }
        if (StringUtil.isNotBlank((String)queryDto.getStatus())) {
            wrapper.eq((Object)"status", (Object)queryDto.getStatus());
        }
        if (StringUtil.isNotBlank((String)queryDto.getNo())) {
            wrapper.like((Object)"pre_no", (Object)queryDto.getNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseName())) {
            wrapper.like((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseCode())) {
            wrapper.like((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtil.isNotBlank((String)queryDto.getCreateTimeStart()) && StringUtil.isNotBlank((String)queryDto.getCreateTimeEnd())) {
            wrapper.between((Object)"create_time", (Object)queryDto.getCreateTimeStart(), (Object)queryDto.getCreateTimeEnd());
        }
        wrapper.orderByDesc((Object)"create_time");
        try {
            List list = this.tcbjDRAOrderMapper.selectList((Wrapper)wrapper);
            PageInfo info = new PageInfo(list);
            List rList = list.stream().map(t -> {
                TcbjDeliveryNotiRespDto dto = new TcbjDeliveryNotiRespDto();
                try {
                    BeanUtils.copyProperties((Object)dto, (Object)t);
                }
                catch (Exception e) {
                    logger.error("\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                }
                return dto;
            }).collect(Collectors.toList());
            PageInfo result = new PageInfo(rList);
            org.springframework.beans.BeanUtils.copyProperties((Object)info, (Object)result);
            result.setList(rList);
            logger.info("\u83b7\u53d6\u53d1\u8d27\u901a\u77e5\u5355-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)result));
            return new RestResponse("0", "success", (Object)result);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53d1\u8d27\u901a\u77e5\u5355-\u9519\u8bef:{}", (Object)e.toString());
            return new RestResponse("-1", "fail", null);
        }
    }

    @Override
    public RestResponse<String> update(TcbjDeliveryNotiReqDto queryDto) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"no", (Object)queryDto.getNo());
        DRAOrderEo draOrderEo = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)wrapper);
        if (draOrderEo == null) {
            throw new BizException("\u6b64\u5355\u53f7\u4e0d\u5b58\u5728\u6570\u636e\uff0c\u66f4\u65b0\u5931\u8d25");
        }
        draOrderEo.setExpressCo(queryDto.getExpressCo());
        draOrderEo.setExpressNo(queryDto.getExpressNo());
        int i = this.tcbjDRAOrderMapper.updateById((BaseEo)draOrderEo);
        if (i > 0) {
            return new RestResponse("0", "\u4fdd\u5b58\u6210\u529f", null);
        }
        return new RestResponse("-1", "\u4fdd\u5b58\u5931\u8d25", null);
    }

    @Override
    public RestResponse<TcbjDeliveryNotiDetailRespDto> notiDetail(SimpleRequestDto dto) {
        logger.info("\u83b7\u53d6\u53d1\u8d27\u901a\u77e5\u8be6\u7ec6\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)dto));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"no", (Object)dto.getNo());
        DRAOrderEo one = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)wrapper);
        AssertUtil.isTrue(Objects.nonNull(one), "\u8be5\u8ba2\u5355\u7684\u51fa\u5e93\u5355\u672a\u627e\u5230");
        TcbjDeliveryNotiDetailRespDto respDto = new TcbjDeliveryNotiDetailRespDto();
        try {
            BeanUtils.copyProperties((Object)respDto, (Object)one);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RelOrderAndResnosDto orderAndResnosDto = new RelOrderAndResnosDto();
        orderAndResnosDto.setReciveName(one.getPreReciveName());
        orderAndResnosDto.setRecivePhone(one.getPreRecivePhone());
        orderAndResnosDto.setAddress(one.getPreAddress());
        orderAndResnosDto.setPlanTime(one.getPrePlanTime());
        orderAndResnosDto.setRemark(one.getPreRemark());
        QueryWrapper wrapper2 = new QueryWrapper();
        wrapper2.eq((Object)"pre_no", (Object)one.getPreNo());
        wrapper2.eq((Object)"category", (Object)"102");
        try {
            List draOrderEos = this.tcbjDRAOrderMapper.selectList((Wrapper)wrapper2);
            List strings = draOrderEos.stream().map(DRAOrderEo::getNo).collect(Collectors.toList());
            orderAndResnosDto.setResNos(strings);
            respDto.setRelOrderAndResnosDto(orderAndResnosDto);
            List<TcbjNotiDetailCargoRespDto> cargoEos = this.tcbjBaseService.getNotiCargo(dto.getNo());
            respDto.setCargos(cargoEos);
            this.doDeliveryNotifyOrder(one, respDto);
            logger.info("\u83b7\u53d6\u53d1\u8d27\u901a\u77e5\u8be6\u7ec6\u5355-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)respDto));
            return new RestResponse("0", "success", (Object)respDto);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53d1\u8d27\u901a\u77e5\u8be6\u7ec6\u5355-\u9519\u8bef:{}", (Object)e.toString());
            return new RestResponse("-1", "fail", null);
        }
    }

    private void doDeliveryNotifyOrder(DRAOrderEo draOrderEo, TcbjDeliveryNotiDetailRespDto deliveryNotifyDetailRespDto) {
        logger.info("doDeliveryNotifyOrder==>draOrderEo:{},deliveryNotifyDetailRespDto:{}", (Object)LogUtils.buildLogContent(draOrderEo), (Object)LogUtils.buildLogContent(deliveryNotifyDetailRespDto));
        List detailCargoList = deliveryNotifyDetailRespDto.getCargos();
        List relevanceOrderNoList = deliveryNotifyDetailRespDto.getRelOrderAndResnosDto().getResNos();
        Map<Object, Object> relevanceCargoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)relevanceOrderNoList)) {
            List<TcbjNotiDetailCargoRespDto> relevanceCargoList = this.tcbjBaseService.getNotifyCargoListByOrderNoList(relevanceOrderNoList);
            logger.info("doDeliveryNotifyOrder==>\u83b7\u53d6\u5173\u8054\u7684\u53d1\u8d27\u7ed3\u679c\u5355\u8d27\u54c1\u4fe1\u606f,relevanceCargoList:{}", (Object)LogUtils.buildLogContent(relevanceCargoList));
            if (CollectionUtil.isNotEmpty(relevanceCargoList)) {
                relevanceCargoMap = relevanceCargoList.stream().collect(Collectors.groupingBy(TcbjNotiDetailCargoRespDto::getCargoCode));
            }
        }
        if (OrderStatus.DELIVERY_WAIT_AUDIT.equals(draOrderEo.getStatus()) || OrderStatus.DELIVERY_OUT_ING.equals(draOrderEo.getStatus()) || OrderStatus.DELIVERY_OUT.equals(draOrderEo.getStatus())) {
            detailCargoList.forEach(cargo -> {
                cargo.setPlanNum(cargo.getNum());
                cargo.setSentNum(Integer.valueOf(0));
                cargo.setWaitNum(cargo.getNum());
                cargo.setCancelNum(Integer.valueOf(0));
            });
        } else if (OrderStatus.DELIVERY_OUT_FINISH.equals(draOrderEo.getStatus())) {
            for (TcbjNotiDetailCargoRespDto cargo2 : detailCargoList) {
                String cargoCode = cargo2.getCargoCode();
                Integer sentNum = cargo2.getNum();
                List cargoRespDtoList = (List)relevanceCargoMap.get(cargoCode);
                if (CollectionUtil.isNotEmpty((Collection)cargoRespDtoList)) {
                    sentNum = cargoRespDtoList.stream().map(TcbjNotiDetailCargoRespDto::getNum).reduce(Integer::sum).get();
                }
                cargo2.setPlanNum(cargo2.getNum());
                cargo2.setSentNum(sentNum);
                cargo2.setWaitNum(Integer.valueOf(0));
                cargo2.setCancelNum(Integer.valueOf(0));
            }
        } else if (OrderStatus.DELIVERY_CANCEL.equals(draOrderEo.getStatus()) || OrderStatus.ADJUST_REFUSE.equals(draOrderEo.getStatus())) {
            detailCargoList.forEach(cargo -> {
                cargo.setPlanNum(cargo.getNum());
                cargo.setSentNum(Integer.valueOf(0));
                cargo.setWaitNum(Integer.valueOf(0));
                cargo.setCancelNum(cargo.getNum());
            });
        }
    }

    @Override
    public RestResponse<PageInfo<TcbjDeliveryResRespDto>> resPage(TcbjDeliveryResReqDto queryDto) {
        logger.info("\u83b7\u53d6\u53d1\u8d27\u7ed3\u679c\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"category", (Object)"102");
        RestResponse restResponse = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId());
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        wrapper.eq((Object)"organization_id", (Object)orgId);
        if (StringUtil.isNotBlank((String)queryDto.getType())) {
            wrapper.eq((Object)"type", (Object)queryDto.getType());
        }
        if (StringUtil.isNotBlank((String)queryDto.getNo())) {
            wrapper.like((Object)"pre_no", (Object)queryDto.getNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseName())) {
            wrapper.like((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseCode())) {
            wrapper.like((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtil.isNotBlank((String)queryDto.getCreateTimeStart()) && StringUtil.isNotBlank((String)queryDto.getCreateTimeEnd())) {
            wrapper.between((Object)"create_time", (Object)queryDto.getCreateTimeStart(), (Object)queryDto.getCreateTimeEnd());
        }
        if (Objects.nonNull(queryDto.getIsExpress())) {
            if (0 == queryDto.getIsExpress()) {
                wrapper.isNull((Object)"express_no");
            } else {
                wrapper.isNotNull((Object)"express_no");
            }
        }
        wrapper.orderByDesc((Object)"create_time");
        try {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            List list = this.tcbjDRAOrderMapper.selectList((Wrapper)wrapper);
            PageInfo info = new PageInfo(list);
            List rList = list.stream().map(t -> {
                TcbjDeliveryResRespDto dto = new TcbjDeliveryResRespDto();
                try {
                    BeanUtils.copyProperties((Object)dto, (Object)t);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return dto;
            }).collect(Collectors.toList());
            PageInfo result = new PageInfo(rList);
            org.springframework.beans.BeanUtils.copyProperties((Object)info, (Object)result);
            result.setList(rList);
            logger.info("\u83b7\u53d6\u53d1\u8d27\u7ed3\u679c\u5355-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)result));
            return new RestResponse("0", "success", (Object)result);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53d1\u8d27\u901a\u77e5\u8be6\u7ec6\u5355-\u9519\u8bef:{}", (Object)e.toString());
            return new RestResponse("-1", "fail", null);
        }
    }

    @Override
    public RestResponse<TcbjDeliveryResDetailRespDto> resDetail(SimpleRequestDto dto) {
        DRAOrderEo one;
        logger.info("\u83b7\u53d6\u53d1\u8d27\u7ed3\u679c\u5355\u8be6\u7ec6-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)dto.getNo()));
        RelOrderAndResnosDto orderAndResnosDto = new RelOrderAndResnosDto();
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)dto.getNo())) {
            wrapper.eq((Object)"no", (Object)dto.getNo());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getPreNo())) {
            wrapper.eq((Object)"pre_no", (Object)dto.getPreNo());
            wrapper.eq((Object)"category", (Object)dto.getCategory());
        }
        if ((one = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)wrapper)) == null && !dto.isNotThrowException()) {
            logger.info("\u8be5\u8ba2\u5355\u7684\u51fa\u5e93\u5355\u672a\u627e\u5230");
            return new RestResponse();
        }
        if (one == null && dto.isNotThrowException()) {
            return new RestResponse();
        }
        TcbjDeliveryResDetailRespDto respDto = new TcbjDeliveryResDetailRespDto();
        try {
            BeanUtils.copyProperties((Object)respDto, (Object)one);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        QueryWrapper wrapper2 = new QueryWrapper();
        wrapper2.eq((Object)"pre_no", (Object)one.getPreNo());
        wrapper2.eq((Object)"category", (Object)"101");
        try {
            List draOrderEos = this.tcbjDRAOrderMapper.selectList((Wrapper)wrapper2);
            if (CollectionUtil.isNotEmpty((Collection)draOrderEos)) {
                DRAOrderEo notiOrder = (DRAOrderEo)draOrderEos.get(0);
                orderAndResnosDto.setReciveName(notiOrder.getPreReciveName());
                orderAndResnosDto.setRecivePhone(notiOrder.getPreRecivePhone());
                orderAndResnosDto.setAddress(notiOrder.getPreAddress());
                orderAndResnosDto.setPlanTime(notiOrder.getPrePlanTime());
                orderAndResnosDto.setRemark(notiOrder.getPreRemark());
                List strings = draOrderEos.stream().map(DRAOrderEo::getNo).collect(Collectors.toList());
                orderAndResnosDto.setResNos(strings);
                respDto.setRelOrderAndResnosDto(orderAndResnosDto);
            }
            List<TcbjResDetailCargoRespDto> cargoEos = this.tcbjBaseService.getResCargo(one.getNo());
            respDto.setCargos(cargoEos);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53d1\u8d27\u901a\u77e5\u8be6\u7ec6\u5355-\u9519\u8bef:{}", (Object)e.toString());
        }
        logger.info("\u83b7\u53d6\u53d1\u8d27\u7ed3\u679c\u5355\u8be6\u7ec6-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)respDto));
        return new RestResponse("0", "success", (Object)respDto);
    }

    @Override
    public RestResponse<String> send(TcbjNotiGenReqDto reqDto) {
        DRAOrderEo draOrderEo = new DRAOrderEo();
        draOrderEo.setCategory("101");
        draOrderEo.setType(reqDto.getType());
        draOrderEo.setWarehouseCode(reqDto.getWarehouseCode());
        draOrderEo.setPreNo(reqDto.getPreNo());
        draOrderEo.setPreReciveName(reqDto.getReciveName());
        draOrderEo.setPreRecivePhone(reqDto.getRecivePhone());
        draOrderEo.setPreAddress(reqDto.getAddress());
        draOrderEo.setPrePlanTime(reqDto.getPlanTime());
        draOrderEo.setOrganizationId(reqDto.getOrganizationId());
        List<DRAOrderCargoEo> draOrderCargoEos = reqDto.getNotiGenItemReqDtos().stream().map(d -> {
            DRAOrderCargoEo cargoEo = new DRAOrderCargoEo();
            cargoEo.setBatch(d.getBatch());
            cargoEo.setCargoCode(d.getCargoCode());
            cargoEo.setPlanNum(d.getPlanNum());
            cargoEo.setNum(d.getNum());
            cargoEo.setSentNum(d.getSentNum());
            cargoEo.setWaitNum(d.getWaitNum());
            cargoEo.setCancelNum(d.getCancelNum());
            cargoEo.setType(d.getType());
            cargoEo.setTradeOrderItemId(d.getTradeOrderItemId());
            cargoEo.setActivityId(d.getActivityId());
            Integer combinationFlag = d.getCombinationFlag();
            if (YesNoEnum.YES.getValue().equals(combinationFlag)) {
                cargoEo.setActivityType("COMBINATION_ACTIVITY");
            }
            cargoEo.setCombinationFlag(d.getCombinationFlag());
            return cargoEo;
        }).collect(Collectors.toList());
        Exception exception = null;
        try {
            this.tcbjBaseService.add(draOrderEo, draOrderCargoEos, 1, null);
            return RestResponse.SUCCEED;
        }
        catch (Exception e) {
            logger.error("\u53d1\u8d27\u901a\u77e5-\u9519\u8bef:{}" + e.getMessage(), (Throwable)e);
            if (e instanceof BizException) {
                return new RestResponse(((BizException)e).getCode(), e.getMessage(), null);
            }
            exception = e;
            return new RestResponse("-1", exception.getMessage(), null);
        }
    }

    @Override
    public RestResponse<String> sendback(TcbjResGenReqDto reqDto) {
        logger.info("sendback==>\u53d1\u8d27\u56de\u4f20,\u751f\u6210\u53d1\u8d27\u7ed3\u679c\u5355,\u5e93\u5b58\u53d8\u52a8\u6263\u51cf,reqDto:{}", (Object)LogUtils.buildLogContent(reqDto));
        DRAOrderEo one = new DRAOrderEo();
        one.setPreNo(reqDto.getPreNo());
        one.setNotiNo(reqDto.getNotiNo());
        DRAOrderEo draOrderEo = new DRAOrderEo();
        draOrderEo.setCategory("102");
        draOrderEo.setType(reqDto.getType());
        draOrderEo.setWarehouseCode(reqDto.getWarehouseCode());
        draOrderEo.setPreNo(reqDto.getPreNo());
        draOrderEo.setNotiNo(reqDto.getNotiNo());
        List<DRAOrderCargoEo> draOrderCargoEos = reqDto.getResGenItemReqDtos().stream().map(d -> {
            DRAOrderCargoEo cargoEo = new DRAOrderCargoEo();
            cargoEo.setBatch(d.getBatch());
            cargoEo.setCargoCode(d.getCargoCode());
            cargoEo.setNum(d.getNum());
            cargoEo.setProduceTime(d.getProduceTime());
            cargoEo.setExpireTime(d.getExpireTime());
            if (StringUtil.isNotBlank((String)d.getOtherField1())) {
                MqContentOtherFieldDto otherFieldDto = (MqContentOtherFieldDto)JSON.parseObject((String)d.getOtherField1(), MqContentOtherFieldDto.class);
                cargoEo.setTradeOrderItemId(otherFieldDto.getTradeOrderItemId());
            }
            return cargoEo;
        }).collect(Collectors.toList());
        try {
            logger.info("sendback==>\u5373\u5c06\u8c03\u7528,tcbjBaseService#add,draOrderEo:{},draOrderCargoEos:{},one:{}", new Object[]{LogUtils.buildLogContent(draOrderEo), LogUtils.buildLogContent(draOrderCargoEos), LogUtils.buildLogContent(one)});
            this.tcbjBaseService.add(draOrderEo, draOrderCargoEos, 1, one);
            this.executorService.execute(new Thread(() -> this.updateCustomerReturnsQuota(draOrderEo.getPreNo())));
            logger.info("sendback==>\u5373\u5c06\u8c03\u7528,manageInventoryActivity,reqDto:{},draOrderCargoEos:{}", (Object)LogUtils.buildLogContent(reqDto), (Object)LogUtils.buildLogContent(draOrderCargoEos));
            return RestResponse.SUCCEED;
        }
        catch (Exception e) {
            logger.error("\u53d1\u8d27\u901a\u77e5-\u9519\u8bef:{}" + e.getMessage(), (Throwable)e);
            if (e instanceof BizException) {
                return new RestResponse(((BizException)e).getCode(), e.getMessage(), null);
            }
            return new RestResponse("-1", e.toString(), null);
        }
    }

    @Override
    public RestResponse<String> cancel(SimpleRequestDto dto) {
        logger.info("\u53d6\u6d88\u53d1\u8d27\u5355\u8bf7\u6c42\u63d0\u793a:{}", (Object)JSONObject.toJSONString((Object)dto));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"no", (Object)dto.getNo());
        queryWrapper.eq((Object)"category", (Object)"101");
        DRAOrderEo dbEo = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)queryWrapper);
        if (dbEo != null) {
            try {
                dbEo.setStatus(OrderStatus.DELIVERY_CANCEL);
                dbEo.setDr(1);
                int update = this.tcbjDRAOrderMapper.updateById((BaseEo)dbEo);
                if (update <= 0) {
                    throw new BizException("\u975e\u53d1\u8d27\u901a\u77e5\u5355\u4e0d\u80fd\u53d6\u6d88\uff01");
                }
                logger.info("\u53d6\u6d88\u53d1\u8d27\u5355\u8fd4\u56de\u63d0\u793a:{}", (Object)JSONObject.toJSONString(null));
                return RestResponse.SUCCEED;
            }
            catch (Exception e) {
                logger.error("\u53d1\u8d27\u901a\u77e5-\u9519\u8bef:{}", (Object)e.toString());
            }
        }
        return new RestResponse("-1", "fail", null);
    }

    @Override
    public RestResponse<List<TcbjResDetailCargoRespDto>> outNum(SimpleRequestDto dto) {
        QueryWrapper qwrapper = new QueryWrapper();
        qwrapper.eq((Object)"pre_no", (Object)dto.getNo());
        qwrapper.eq((Object)"category", (Object)"101");
        qwrapper.last("limit 1");
        DRAOrderEo draOrderEo = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)qwrapper);
        AssertUtil.isTrue(Objects.nonNull(draOrderEo), "\u8be5\u8ba2\u5355\u7684\u51fa\u5e93\u5355\u672a\u627e\u5230");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"order_no", (Object)draOrderEo.getNo());
        try {
            List cargoEos = this.tcbjDRAOrderCargoMapper.selectList((Wrapper)wrapper);
            List collect = cargoEos.stream().map(c -> {
                TcbjResDetailCargoRespDto tmp = new TcbjResDetailCargoRespDto();
                tmp.setCargoCode(c.getCargoCode());
                tmp.setCargoName(c.getCargoName());
                tmp.setCargoNo(c.getCargoNo());
                tmp.setNum(c.getNum());
                tmp.setBatch(c.getBatch());
                return tmp;
            }).collect(Collectors.toList());
            return new RestResponse("0", "sucess", collect);
        }
        catch (Exception e) {
            logger.error("outNum-\u9519\u8bef:{}", (Object)e.toString());
            return new RestResponse("-1", "fail", null);
        }
    }

    @Override
    public RestResponse<String> audit(TcbjDeliveryAuReqDto dto) {
        logger.info("\u5ba1\u6838\u53d1\u8d27\u901a\u77e5\u5355\u8bf7\u6c42\u63d0\u793a:{}", (Object)JSONObject.toJSONString((Object)dto));
        QueryWrapper qwrapper = new QueryWrapper();
        qwrapper.eq((Object)"pre_no", (Object)dto.getPreNo());
        qwrapper.eq((Object)"category", (Object)"101");
        qwrapper.eq((Object)"dr", (Object)0);
        DRAOrderEo eo = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)qwrapper);
        if (eo.getStatus().equals(OrderStatus.DELIVERY_OUT_FINISH) || eo.getStatus().equals(OrderStatus.DELIVERY_CANCEL)) {
            return new RestResponse("-1", "fail", (Object)"\u8be5\u901a\u77e5\u5355\u5df2\u5b8c\u6210\u6216\u53d6\u6d88,\u4e0d\u80fd\u518d\u6b21\u4fee\u6539");
        }
        eo.setStatus(dto.getStatus());
        int update = this.tcbjDRAOrderMapper.updateById((BaseEo)eo);
        logger.info("\u5ba1\u6838\u53d1\u8d27\u901a\u77e5\u5355\u8fd4\u56de\u63d0\u793a:{}", (Object)update);
        return RestResponse.SUCCEED;
    }

    @Override
    public RestResponse<Object> exportExcel(TcbjDeliveryResReqDto queryDto) {
        logger.info("\u5bfc\u51fa\u83b7\u53d6\u53d1\u8d27\u7ed3\u679c\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"category", (Object)"102");
        RestResponse restResponse = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId());
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        wrapper.eq((Object)"organization_id", (Object)orgId);
        if (StringUtil.isNotBlank((String)queryDto.getType())) {
            wrapper.eq((Object)"type", (Object)queryDto.getType());
        }
        if (StringUtil.isNotBlank((String)queryDto.getNo())) {
            wrapper.like((Object)"no", (Object)queryDto.getNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseName())) {
            wrapper.like((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseCode())) {
            wrapper.like((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtil.isNotBlank((String)queryDto.getCreateTimeStart()) && StringUtil.isNotBlank((String)queryDto.getCreateTimeEnd())) {
            wrapper.between((Object)"create_time", (Object)queryDto.getCreateTimeStart(), (Object)queryDto.getCreateTimeEnd());
        }
        try {
            List list = this.tcbjDRAOrderMapper.selectList((Wrapper)wrapper);
            List rList = list.stream().map(t -> {
                TcbjDeliveryExcelRespDto dto = new TcbjDeliveryExcelRespDto();
                try {
                    BeanUtils.copyProperties((Object)dto, (Object)t);
                    dto.setResNo(t.getNo());
                    dto.setType(OrderTypeEnu.getDescByCode(Objects.toString(t.getType(), "")));
                    dto.setStatus(OrderStatusEnum.getDescByCode((Integer)t.getStatus()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return dto;
            }).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(rList)) {
                String exportUrl;
                String excelName = "cube/\u53d1\u8d27\u7ed3\u679c\u5355_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
                try {
                    exportUrl = EasyPoiExportUtil.getExportUrl(rList, TcbjDeliveryExcelRespDto.class, null, (String)excelName, (String)"xlsx");
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u51fa\u53d1\u8d27\u7ed3\u679c\u5355-\u9519\u8bef:{}", (Object)e.toString());
                    return new RestResponse("-1", "\u5bfc\u51fa\u53d1\u8d27\u7ed3\u679c\u5355-\u9519\u8bef:" + e.toString());
                }
                logger.info("\u5bfc\u51fa\u53d1\u8d27\u7ed3\u679c\u5355-\u8f93\u51fa:{}", (Object)JSON.toJSONString(rList));
                return new RestResponse("0", "\u5bfc\u51fa\u53d1\u8d27\u7ed3\u679c\u5355\u6210\u529f", (Object)exportUrl);
            }
            return new RestResponse("-1", "\u5bfc\u51fa\u53d1\u8d27\u7ed3\u679c\u5355,\u6570\u636e\u4e3a\u7a7a", null);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u53d1\u8d27\u7ed3\u679c\u5355-\u9519\u8bef:{}", (Object)e.toString());
            return new RestResponse("-1", "\u5bfc\u51fa\u5931\u8d25", null);
        }
    }

    @Override
    public RestResponse<Object> importExcel(MultipartFile serviceFile) throws Exception {
        byte[] bytes = serviceFile.getBytes();
        Optional.ofNullable(bytes).orElseThrow(() -> new BizException("-1", "\u5bfc\u5165\u6587\u4ef6\u4e3a\u7a7a\uff01"));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        Optional.ofNullable(inputStream).orElseThrow(() -> new BizException("-1", "\u5bfc\u5165\u53c2\u6570\u6709\u8bef"));
        ExcelImportResult data = EasyPoiExportUtil.importExcel((InputStream)inputStream, (Integer)0, (Integer)1, TcbjDeliveryExcelRespDto.class);
        if (data == null || CollectionUtil.isEmpty((Collection)data.getList())) {
            throw new BizException("\u8f6c\u6362excel\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        logger.info("\u83b7\u53d6\u5bfc\u5165\u53d1\u8d27\u7ed3\u679c\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)data.getList()));
        List importList = data.getList();
        logger.info("\u83b7\u53d6\u5bfc\u5165\u53d1\u8d27\u7ed3\u679c\u5355\u6570\u91cf:{}", (Object)data.getList().size());
        AtomicInteger count = new AtomicInteger(0);
        for (TcbjDeliveryExcelRespDto vo : importList) {
            DRAOrderEo draOrderEo;
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"category", (Object)"102");
            if (StringUtil.isNotBlank((String)vo.getResNo())) {
                wrapper.eq((Object)"no", (Object)vo.getResNo());
            }
            if ((draOrderEo = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)wrapper)) == null) continue;
            draOrderEo.setExpressCo(vo.getExpressCo());
            draOrderEo.setExpressNo(vo.getExpressNo());
            int i = this.tcbjDRAOrderMapper.updateById((BaseEo)draOrderEo);
            if (i <= 0) continue;
            count.addAndGet(1);
        }
        logger.info("\u83b7\u53d6\u5bfc\u5165\u53d1\u8d27\u7ed3\u679c\u5355\u5bfc\u5165\u6210\u529f\u6570\u91cf:{}", (Object)count.get());
        return new RestResponse("0", "\u83b7\u53d6\u5bfc\u5165\u53d1\u8d27\u7ed3\u679c\u5355\u5bfc\u5165\u6210\u529f\u6570\u91cf\uff1a" + count.get());
    }

    @Override
    public RestResponse<Void> testUpdateReturns(String orderNo) {
        this.updateCustomerReturnsQuota(orderNo);
        return RestResponse.VOID;
    }

    private void updateCustomerReturnsQuota(String orderNo) {
    }
}

