/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InventorySubItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInventoryItemExtendService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInventorySubItemService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BasePageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.InventoryItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryLogBasicsPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsActivityInventoryLogPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.InventoryItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsPageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log.CsActivityInventoryLogRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryLogDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInventoryLogRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.InventorySubItemRespDto;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCsInventoryQueryService
implements ICsInventoryQueryService {
    private Logger logger = LoggerFactory.getLogger(AbstractCsInventoryQueryService.class);
    @Autowired
    private IInventoryLogDomain inventoryLogDomain;
    @Resource
    private IInventoryItemExtendService inventoryItemExtendService;
    @Resource
    private IInventorySubItemService iInventorySubItemService;

    @Override
    public String getStrategy() {
        return CsInventoryStrategyEnum.COMMON.getCode();
    }

    @Override
    public List<CsInventoryBasicsQueryRespDto> queryCommonInventory(CsInventoryBasicsQueryReqDto query) {
        this.logger.info("queryCommonInventory==>\u57fa\u7840\u5e93\u5b58\u67e5\u8be2,query:{}", (Object)LogUtils.buildLogContent(query));
        return null;
    }

    protected Boolean checkQueryCommonParams(CsInventoryBasicsQueryReqDto query) {
        if (CollectionUtils.isEmpty((Collection)query.getWarehouseCodeList()) && CollectionUtils.isEmpty((Collection)query.getCargoCodeList()) && CollectionUtils.isEmpty((Collection)query.getBatchList())) {
            return false;
        }
        return true;
    }

    protected <T> void buildQueryCommonWrapper(CsInventoryBasicsQueryReqDto query, QueryWrapper<T> queryWrapper) {
        this.logger.info("buildQueryCommonWrapper==>\u5e93\u5b58\u901a\u7528\u67e5\u8be2\uff0c\u6784\u5efa\u67e5\u8be2\u53c2\u6570,query:{},queryWrapper:{}", (Object)LogUtils.buildLogContent(query), (Object)LogUtils.buildLogContent(queryWrapper));
        if (CollectionUtils.isNotEmpty((Collection)query.getWarehouseCodeList())) {
            queryWrapper.in((Object)"warehouse_code", (Collection)query.getWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)query.getCargoCodeList())) {
            queryWrapper.in((Object)"sku_code", (Collection)query.getCargoCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)query.getBatchList())) {
            queryWrapper.in((Object)"batch", (Collection)query.getBatchList());
        }
        if (CollectionUtils.isNotEmpty((Collection)query.getLongCodeList())) {
            queryWrapper.in((Object)"sku_code", (Collection)query.getLongCodeList());
        }
        queryWrapper.eq((Object)"dr", (Object)0);
    }

    protected <T> Boolean buildInventoryPageQueryDto(CsInventoryBasicsPageQueryReqDto queryParamDto, QueryWrapper<T> queryWrapper) {
        String batch;
        String warehouseCode;
        String warehouseName;
        String artNo;
        String cargoCode;
        this.logger.info("buildInventoryPageQueryDto==>\u5e93\u5b58\u5206\u9875\u67e5\u8be2\uff0c\u6784\u5efa\u67e5\u8be2\u53c2\u6570,queryParamDto:{},queryWrapper:{}", (Object)LogUtils.buildLogContent(queryParamDto), (Object)LogUtils.buildLogContent(queryWrapper));
        String cargoName = queryParamDto.getCargoName();
        if (StringUtils.isNotBlank((CharSequence)cargoName)) {
            queryWrapper.like((Object)"sku_name", (Object)cargoName);
        }
        if (StringUtils.isNotBlank((CharSequence)(cargoCode = queryParamDto.getCargoCode()))) {
            queryWrapper.like((Object)"sku_code", (Object)cargoCode);
        }
        if (StringUtils.isNotBlank((CharSequence)queryParamDto.getLongCode())) {
            queryWrapper.eq((Object)"sku_code", (Object)queryParamDto.getLongCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryParamDto.getSkuCodeList())) {
            queryWrapper.in((Object)"sku_code", (Collection)queryParamDto.getSkuCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)(artNo = queryParamDto.getArtNo()))) {
            queryWrapper.eq((Object)"art_no", (Object)artNo);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseName = queryParamDto.getWarehouseName()))) {
            queryWrapper.like((Object)"warehouse_name", (Object)warehouseName);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseCode = queryParamDto.getWarehouseCode()))) {
            queryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryParamDto.getWarehouseCodeList())) {
            queryWrapper.in((Object)"warehouse_code", (Collection)queryParamDto.getWarehouseCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)(batch = queryParamDto.getBatch()))) {
            queryWrapper.eq((Object)"batch", (Object)batch);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryParamDto.getBatchList())) {
            queryWrapper.in((Object)"batch", (Collection)queryParamDto.getBatchList());
        }
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.orderByDesc((Object)"create_time");
        return true;
    }

    @Override
    public PageInfo<CsInventoryLogRespDto> queryInventoryLogPage(CsInventoryLogBasicsPageQueryReqDto logPageQueryDto) {
        this.logger.info("queryInventoryLogPage===>\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2,logPageQueryDto:{}", (Object)LogUtils.buildLogContent(logPageQueryDto));
        this.checkParams((BasePageDto)logPageQueryDto);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!this.buildInventoryLogPageQueryDto(logPageQueryDto, queryWrapper).booleanValue()) {
            return new PageInfo();
        }
        if (CollectionUtils.isNotEmpty((Collection)logPageQueryDto.getCurrentUserWarehouseIds())) {
            queryWrapper.in((Object)"warehouse_id", (Collection)logPageQueryDto.getCurrentUserWarehouseIds());
        }
        queryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        PageHelper.startPage((int)logPageQueryDto.getPageNum(), (int)logPageQueryDto.getPageSize());
        this.logger.info("queryInventoryLogPage===>\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2,\u6784\u5efa\u540e\u7684\u67e5\u8be2\u53c2\u6570,queryWrapper:{}", (Object)LogUtils.buildLogContent(queryWrapper));
        List resultList = this.inventoryLogDomain.getMapper().selectList((Wrapper)queryWrapper);
        this.logger.info("queryInventoryLogPage===>\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2,\u67e5\u8be2\u7ed3\u679c\u96c6\u5408,resultList:{}", (Object)LogUtils.buildLogContent(resultList));
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return new PageInfo();
        }
        List respDtoList = resultList.stream().map(e -> {
            CsInventoryLogRespDto csInventoryLogRespDto = new CsInventoryLogRespDto();
            CubeBeanUtils.copyProperties((Object)csInventoryLogRespDto, (Object)e, (String[])new String[0]);
            return csInventoryLogRespDto;
        }).collect(Collectors.toList());
        PageInfo info = new PageInfo(resultList);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(respDtoList);
        return result;
    }

    private <T> Boolean buildInventoryLogPageQueryDto(CsInventoryLogBasicsPageQueryReqDto queryParamDto, QueryWrapper<T> queryWrapper) {
        String endChangeTime;
        String beginChangeTime;
        String sourceNo;
        String sourceType;
        String warehouseCode;
        String warehouseName;
        String artNo;
        String cargoCode;
        this.logger.info("buildInventoryPageQueryDto==>\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2\uff0c\u6784\u5efa\u67e5\u8be2\u53c2\u6570,queryParamDto:{},queryWrapper:{}", (Object)LogUtils.buildLogContent(queryParamDto), (Object)LogUtils.buildLogContent(queryWrapper));
        String cargoName = queryParamDto.getCargoName();
        if (StringUtils.isNotBlank((CharSequence)cargoName)) {
            queryWrapper.eq((Object)"sku_name", (Object)cargoName);
        }
        if (StringUtils.isNotBlank((CharSequence)(cargoCode = queryParamDto.getCargoCode()))) {
            queryWrapper.eq((Object)"sku_code", (Object)cargoCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(artNo = queryParamDto.getArtNo()))) {
            queryWrapper.eq((Object)"art_no", (Object)artNo);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseName = queryParamDto.getWarehouseName()))) {
            queryWrapper.eq((Object)"warehouse_name", (Object)warehouseName);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseCode = queryParamDto.getWarehouseCode()))) {
            queryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(sourceType = queryParamDto.getSourceType()))) {
            queryWrapper.eq((Object)"source_type", (Object)sourceType);
        }
        if (StringUtils.isNotBlank((CharSequence)(sourceNo = queryParamDto.getSourceNo()))) {
            queryWrapper.eq((Object)"source_no", (Object)sourceNo);
        }
        if (StringUtils.isNotBlank((CharSequence)(beginChangeTime = queryParamDto.getBeginChangeTime()))) {
            queryWrapper.ge((Object)"change_time", (Object)beginChangeTime);
        }
        if (StringUtils.isNotBlank((CharSequence)(endChangeTime = queryParamDto.getEndChangeTime()))) {
            queryWrapper.le((Object)"change_time", (Object)endChangeTime);
        }
        queryWrapper.eq((Object)"dr", (Object)0);
        return true;
    }

    protected void checkParams(BasePageDto basePageDto) {
        AssertUtil.isTrue(null != basePageDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != basePageDto.getPageNum() && basePageDto.getPageNum() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != basePageDto.getPageSize() && basePageDto.getPageSize() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
    }

    @Override
    public PageInfo<CsInventoryBasicsPageQueryRespDto> queryInventoryPage(CsInventoryBasicsPageQueryReqDto queryParamDto) {
        return null;
    }

    @Override
    public PageInfo<CsActivityInventoryLogRespDto> queryActivityInventoryLogPage(CsActivityInventoryLogPageQueryReqDto activityInventoryLogPageQueryReqDto) {
        return null;
    }

    public Map<String, InventoryItemExtendRespDto> getInventoryItemExtendMap(List<String> cargoCodes, List<String> batchs) {
        if (CollectionUtils.isEmpty(cargoCodes) || CollectionUtils.isEmpty(batchs)) {
            return null;
        }
        InventoryItemExtendReqDto inventoryItemExtendReqDto = new InventoryItemExtendReqDto();
        inventoryItemExtendReqDto.setItemCodes(cargoCodes);
        inventoryItemExtendReqDto.setBatchs(batchs);
        List<InventoryItemExtendRespDto> inventoryItemExtendRespDtos = this.inventoryItemExtendService.queryInventoryItemExtend(JSON.toJSONString((Object)inventoryItemExtendReqDto));
        return Optional.of(inventoryItemExtendRespDtos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(key -> key.getItemCode() + key.getBatch(), val -> val, (v1, v2) -> v2));
    }

    public Map<String, List<InventorySubItemRespDto>> getInventorySubItem(List<String> cargoCodes, List<String> batchs) {
        if (CollectionUtils.isEmpty(cargoCodes) || CollectionUtils.isEmpty(batchs)) {
            return Maps.newHashMap();
        }
        InventorySubItemReqDto inventorySubItemReqDto = new InventorySubItemReqDto();
        inventorySubItemReqDto.setParentItemCodes(cargoCodes);
        inventorySubItemReqDto.setParentBatchs(batchs);
        PageInfo<InventorySubItemRespDto> inventorySubItemRespDtoPageInfo = this.iInventorySubItemService.queryByPage(JSON.toJSONString((Object)inventorySubItemReqDto), 1, Integer.MAX_VALUE);
        List list = inventorySubItemRespDtoPageInfo.getList();
        return Optional.of(list).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(key -> key.getParentItemCode() + key.getParentBatch()));
    }
}

