/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.ICsRelWarehouseShipmentApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.ICsRelWarehouseShipmentService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsRelWarehouseShipmentAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsRelWarehouseShipmentGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsRelWarehouseShipmentUpdateReqDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CsRelWarehouseShipmentApiImpl
implements ICsRelWarehouseShipmentApi {
    protected static Logger logger = LoggerFactory.getLogger(CsRelWarehouseShipmentApiImpl.class);
    @Autowired
    protected ICsRelWarehouseShipmentService csRelWarehouseShipmentService;

    public RestResponse<Long> add(CsRelWarehouseShipmentAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csRelWarehouseShipmentService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsRelWarehouseShipmentUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        this.csRelWarehouseShipmentService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        this.csRelWarehouseShipmentService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<Boolean> generateRelInfo(CsRelWarehouseShipmentGenerateReqDto relWarehouseShipmentGenerateReqDto) {
        Boolean resFlag = this.csRelWarehouseShipmentService.generateRelInfo(relWarehouseShipmentGenerateReqDto);
        return new RestResponse((Object)resFlag);
    }

    public RestResponse<Void> deleteRelInfo(String warehouseCode) {
        this.csRelWarehouseShipmentService.deleteRelInfo(warehouseCode);
        return RestResponse.VOID;
    }

    public RestResponse<Boolean> editRelInfo(CsRelWarehouseShipmentGenerateReqDto relWarehouseShipmentGenerateReqDto) {
        Boolean resFlag = this.csRelWarehouseShipmentService.editRelInfo(relWarehouseShipmentGenerateReqDto);
        return new RestResponse((Object)resFlag);
    }
}

