/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory.CommonOrderService;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsStorageSendMqReqDto;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="SINGLE_TOPIC", tag="CREATE_RECEIVE_DELIVERY_RESULT_ORDER_TAG")
public class CreateReceiveDeliveryResultOrderProcess
implements IMessageProcessor<String> {
    private static final Logger logger = LoggerFactory.getLogger(CreateReceiveDeliveryResultOrderProcess.class);
    @Resource
    private CommonOrderService csCommonOrder;
    @Resource
    private ILockService lockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageResponse process(String message) {
        Mutex lock;
        block9: {
            MessageResponse messageResponse;
            block8: {
                logger.info("CreateReceiveDeliveryResultOrderProcess\uff1a{}", (Object)message);
                lock = null;
                try {
                    CsStorageSendMqReqDto csStorageSendMqReqDto = (CsStorageSendMqReqDto)JSON.parseObject((String)message, CsStorageSendMqReqDto.class);
                    String cacheKey = "mq_receive_delivery_result#" + csStorageSendMqReqDto.getPreDocumentNo();
                    lock = this.lockService.lock(cacheKey, "1", 20);
                    logger.info("\u5f00\u59cb\u521b\u5efa\u6536\u53d1\u8d27\u7ed3\u679c\u5355");
                    boolean successFlag = this.csCommonOrder.createReceiveDeliveryResultOrder(csStorageSendMqReqDto);
                    if (!successFlag) {
                        messageResponse = MessageResponse.ERROR;
                        if (lock == null) return messageResponse;
                        break block8;
                    }
                    logger.info("\u521b\u5efa\u6536\u53d1\u8d27\u7ed3\u679c\u5355\u7ed3\u675f");
                    if (lock == null) return MessageResponse.SUCCESS;
                    break block9;
                }
                catch (Exception e) {
                    logger.info("\u6d88\u606f\u961f\u5217\u521b\u5efa\u6536\u53d1\u8d27\u7ed3\u679c\u5355\u5931\u8d25,\u4fe1\u606f\uff1a{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
                    MessageResponse messageResponse2 = MessageResponse.ERROR;
                    return messageResponse2;
                }
            }
            this.lockService.unlock(lock);
            return messageResponse;
        }
        this.lockService.unlock(lock);
        return MessageResponse.SUCCESS;
        finally {
            if (lock != null) {
                this.lockService.unlock(lock);
            }
        }
    }
}

