/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CsCommonServiceImpl
implements CsCommonService {
    private static final Logger logger = LoggerFactory.getLogger(CsCommonServiceImpl.class);
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IDictQueryApi dictQueryApi;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;
    @Resource
    private ICsLogicWarehouseQueryService csLogicWarehouseQueryService;

    @Override
    public Long getUserOrganizationId() {
        RestResponse restResponse;
        Long userId = this.context.userId();
        logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7id\uff0cuserId:{}", (Object)userId);
        if (null != userId && null != (restResponse = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId())).getData()) {
            logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7id\uff0corganizationId:{}", restResponse.getData());
            return (Long)restResponse.getData();
        }
        return null;
    }

    @Override
    public Long getOrganizationIdByUserId(Long userId) {
        RestResponse restResponse = this.customerExtQueryApi.queryOrgIdByUserId(userId);
        if (null != restResponse.getData()) {
            return (Long)restResponse.getData();
        }
        return null;
    }

    @Override
    public String getItemCode(String cargoCode) {
        int i = cargoCode.lastIndexOf(".");
        String substring = cargoCode.substring(i + 1, cargoCode.length());
        return substring;
    }

    @Override
    public List<Long> getUserLogicWarehouseIds() {
        List<Long> warehouseIds = new ArrayList<Long>();
        Long userId = this.context.userId();
        logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684userId:{}", (Object)userId);
        if (Objects.isNull(userId)) {
            return warehouseIds;
        }
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
        logger.info("\u6839\u636euserId\u67e5\u8be2\u5230\u7ec4\u7ec7id\uff1a{}", (Object)orgId);
        if (Objects.isNull(orgId)) {
            return warehouseIds;
        }
        CsLogicWarehouseQueryDto queryDto = new CsLogicWarehouseQueryDto();
        queryDto.setOrganizationId(orgId);
        List<CsLogicWarehouseRespDto> list = this.csLogicWarehouseQueryService.queryByParam(queryDto);
        if (!CollectionUtils.isEmpty(list)) {
            warehouseIds = list.stream().map(e -> e.getId()).collect(Collectors.toList());
        }
        logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u903b\u8f91\u4ed3\u5e93id\u96c6\u5408\uff0c\u8fd4\u53c2\uff1a{}", (Object)JSON.toJSONString(warehouseIds));
        return warehouseIds;
    }

    @Override
    public void getSetUserName() {
        if (StringUtils.isBlank((CharSequence)this.context.userName())) {
            this.context.userName("system");
        }
    }

    @Override
    public void getSetUserName(String createPerson) {
        if (StringUtils.isBlank((CharSequence)this.context.userName())) {
            this.context.userName(StringUtils.isNotBlank((CharSequence)createPerson) ? createPerson : "system");
        }
    }

    @Override
    public String getCustomerIdByChannelName(String channelName) {
        try {
            DictDto dictDto = (DictDto)this.dictQueryApi.queryByGroupCodeAndCode(Long.valueOf(1L), "CHANNEL", "CONFIG").getData();
            if (dictDto == null || StringUtils.isEmpty((CharSequence)dictDto.getValue())) {
                logger.info("\u627e\u4e0d\u5230\u914d\u7f6e\u4fe1\u606f\uff0c\u7ec4\u540d\u79f0:{},\u7f16\u7801:{}", (Object)"CHANNEL", (Object)"CONFIG");
                return null;
            }
            Map channelMap = JacksonUtil.toMap((String)dictDto.getValue());
            if (channelMap.get(channelName) != null) {
                return String.valueOf(channelMap.get(channelName));
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u6e20\u9053\u540d\u79f0\u83b7\u53d6\u5ba2\u6237ID\u65f6\u5f02\u5e38", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }
}

