/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.cs.order;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsBusinessOrderCallBackUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessCallBackStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;

@Service(value="csReceiveNoticeOrderApi")
public class CsReceiveNoticeOrderApiImpl
implements ICsReceiveNoticeOrderApi {
    private static Logger logger = LoggerFactory.getLogger(CsReceiveNoticeOrderApiImpl.class);
    @Autowired
    private ICsReceiveNoticeOrderService csReceiveNoticeOrderService;
    @Resource
    private ICsInNoticeOrderService csInNoticeOrderService;
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;

    public RestResponse<Long> add(CsReceiveNoticeOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csReceiveNoticeOrderService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsReceiveNoticeOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csReceiveNoticeOrderService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csReceiveNoticeOrderService.delete(id);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/createReceiveOrderProcess"}, produces={"application/json"})
    public RestResponse<Long> createReceiveOrderProcess(CsReceiveNoticeOrderAddReqDto addReqDto) {
        logger.info("\u521b\u5efa\u6536\u8d27\u901a\u77e5\u5355\u6d41\u7a0b\uff1a\u5165\u53c2\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        ReceiveDeliveryNoticeOrderFacadeBo deliveryNoticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        deliveryNoticeOrderFacadeBo.setSourceType(addReqDto.getBusinessType());
        deliveryNoticeOrderFacadeBo.setBusinessType(addReqDto.getBusinessType());
        deliveryNoticeOrderFacadeBo.setRelevanceNo(addReqDto.getRelevanceNo());
        deliveryNoticeOrderFacadeBo.setExternalOrderNo(addReqDto.getExternalOrderNo());
        deliveryNoticeOrderFacadeBo.setPreOrderNo(addReqDto.getPreOrderNo());
        deliveryNoticeOrderFacadeBo.setDisplayBusinessType(CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode());
        deliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_SALE);
        deliveryNoticeOrderFacadeBo.setValidNegative(Boolean.valueOf(false));
        deliveryNoticeOrderFacadeBo.setLogicWarehouseCode(addReqDto.getWarehouseCode());
        Boolean shoutBatch = StringUtils.isNotBlank((CharSequence)((CsReceiveNoticeOrderDetailAddReqDto)addReqDto.getReceiveNoticeOrderDetailAddReqDtoList().get(0)).getBatch());
        deliveryNoticeOrderFacadeBo.setShoutBatch(shoutBatch);
        ArrayList detailReqDtoList = Lists.newArrayList();
        List skuDtoList = this.itemSkuProxy.queryBySkuCodes(addReqDto.getReceiveNoticeOrderDetailAddReqDtoList().stream().map(CsReceiveNoticeOrderDetailAddReqDto::getCargoCode).distinct().collect(Collectors.toList()));
        Map skuDtoMap = skuDtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity()));
        for (CsReceiveNoticeOrderDetailAddReqDto cargoReqDto : addReqDto.getReceiveNoticeOrderDetailAddReqDtoList()) {
            BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
            detailReqDto.setSkuCode(cargoReqDto.getCargoCode());
            detailReqDto.setBatch(cargoReqDto.getBatch());
            ItemSkuDto itemSkuDto = (ItemSkuDto)skuDtoMap.get(cargoReqDto.getCargoCode());
            AssertUtils.notNull((Object)itemSkuDto, (String)("SKU \u67e5\u8be2\u4e0d\u5b58\u5728:" + cargoReqDto.getCargoCode()));
            detailReqDto.setSkuName(itemSkuDto.getSkuName());
            detailReqDto.setQuantity(cargoReqDto.getPlanQuantity());
            detailReqDtoList.add(detailReqDto);
        }
        deliveryNoticeOrderFacadeBo.setOrderBasicsDetailReqDtoList((List)detailReqDtoList);
        ArrayList addressEoList = Lists.newArrayList();
        ContactDto contactDto = addReqDto.getContactDto();
        if (null != contactDto) {
            BaseOrderAddressEo receiveAddressEo = new BaseOrderAddressEo();
            receiveAddressEo.setContacts(contactDto.getReciveName());
            receiveAddressEo.setPhone(contactDto.getRecivePhone());
            receiveAddressEo.setDetailAddress(contactDto.getDetailAddress());
            receiveAddressEo.setCityCode(contactDto.getCityCode());
            receiveAddressEo.setCity(contactDto.getCity());
            receiveAddressEo.setDistrictCode(contactDto.getDistrictCode());
            receiveAddressEo.setDistrict(contactDto.getDistrict());
            receiveAddressEo.setProvinceCode(contactDto.getProvinceCode());
            receiveAddressEo.setProvince(contactDto.getProvince());
            receiveAddressEo.setRemark(contactDto.getRemark());
            HashMap extFields = Maps.newHashMap();
            extFields.put("customerCode", contactDto.getCustomerCode());
            extFields.put("preOrderNo", contactDto.getPreOrderNo());
            if (MapUtils.isNotEmpty((Map)contactDto.getExtFields())) {
                extFields.putAll(contactDto.getExtFields());
            }
            receiveAddressEo.setExtFields((Map)extFields);
            addressEoList.add(receiveAddressEo);
        }
        deliveryNoticeOrderFacadeBo.setBaseOrderAddressEoList((List)addressEoList);
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode());
        final ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        deliveryNoticeOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                if (context instanceof ReceiveDeliveryNoticeOrderContext) {
                    ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)context;
                    ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = receiveDeliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo();
                    if (CollectionUtils.isNotEmpty((Collection)receiveDeliveryNoticeOrderContext.getBaseOrderAddressEoList())) {
                        receiveDeliveryNoticeOrderEo.setExtension(JSON.toJSONString(receiveDeliveryNoticeOrderContext.getBaseOrderAddressEoList().get(0)));
                        receiveDeliveryNoticeOrderEo.setRemark(((BaseOrderAddressEo)receiveDeliveryNoticeOrderContext.getBaseOrderAddressEoList().get(0)).getRemark());
                    }
                }
                context.setTransparentCallback(Boolean.valueOf(true));
                if (context instanceof InOutNoticeOrderContext) {
                    businessOrderCallBackService.beforeNotice(context);
                }
            }

            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = this.baseOrderFacade.receiveNoticeOrderGen(deliveryNoticeOrderFacadeBo);
        logger.info("\u521b\u5efa\u6536\u8d27\u901a\u77e5\u5355\u6d41\u7a0b\uff1a\u5165\u5e93\u901a\u77e5\u5355id\uff1a[{}]", (Object)deliveryNoticeOrderFacadeBo);
        return new RestResponse((Object)receiveDeliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo().getId());
    }

    public RestResponse<Void> updateOrderStatus(String preOrderNo, String action) {
        logger.info("\u4fee\u6539\u6536\u8d27\u8d27\u5355\u5355\u636e\u72b6\u6001\uff1a[preOrderNo:{},action:{}]", (Object)preOrderNo, (Object)action);
        this.csReceiveNoticeOrderService.updateOrderStatus(preOrderNo, action);
        return RestResponse.VOID;
    }
}

