/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.cs.order;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveResultOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjReCheckDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjReCheckReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csReceiveResultOrderApi")
public class CsReceiveResultOrderApiImpl
implements ICsReceiveResultOrderApi {
    private static Logger logger = LoggerFactory.getLogger(CsReceiveResultOrderApiImpl.class);
    @Autowired
    private ICsReceiveResultOrderService csReceiveResultOrderService;
    @Resource
    private ICsReceiveNoticeOrderService csReceiveNoticeOrderService;

    public RestResponse<Long> add(CsReceiveResultOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csReceiveResultOrderService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsReceiveResultOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csReceiveResultOrderService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csReceiveResultOrderService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> reCheckInInventory(TcbjReCheckReqDto reCheckReqDto) {
        logger.info("\u590d\u6838\u5165\u5e93\uff0c\u751f\u6210\u6536\u8d27\u7ed3\u679c\u5355\uff0c\u5165\u53c2\uff1a[{}]", (Object)LogUtils.buildLogContent(reCheckReqDto));
        CsReceiveResultOrderAddReqDto addReqDto = this.changeParams(reCheckReqDto);
        Long addId = this.csReceiveResultOrderService.add(addReqDto);
        logger.info("\u590d\u6838\u5165\u5e93\uff0c\u751f\u6210\u6536\u8d27\u7ed3\u679c\u5355\uff0cid\uff1a[{}]", (Object)addId);
        this.csReceiveNoticeOrderService.updateOrderStatus(reCheckReqDto.getRefundOrderNo(), CsDocumentActionEnum.REVERSE_AUDIT_PASS.getCode());
        logger.info("\u590d\u6838\u5165\u5e93\uff0c\u751f\u6210\u6536\u8d27\u7ed3\u679c\u5355\uff0c\u66f4\u65b0\u5355\u636e\u72b6\u6001\u5b8c\u6210");
        CompletableFuture.runAsync(() -> {
            logger.info("\u590d\u6838\u5165\u5e93\uff08\u5f02\u6b65\u64cd\u4f5c\u5f00\u59cb\uff09\uff0c\u5373\u5c06\u6574\u4f53\u64cd\u4f5c\u5165\u5e93reCheckInInventoryOverall===>preOrderNo:{}", (Object)addReqDto.getPreOrderNo());
            Boolean inInventoryFlag = this.csReceiveNoticeOrderService.reCheckInInventoryOverall(addReqDto);
            logger.info("\u590d\u6838\u5165\u5e93(\u5f02\u6b65\u64cd\u4f5c\u7ed3\u675f)\uff0c\u5373\u5c06\u6574\u4f53\u64cd\u4f5c\u5165\u5e93reCheckInInventoryOverall\uff0c\u8fd4\u56de\u7ed3\u679c,inInventoryFlag:{}", (Object)inInventoryFlag);
        });
        return new RestResponse();
    }

    private CsReceiveResultOrderAddReqDto changeParams(TcbjReCheckReqDto reCheckReqDto) {
        CsReceiveResultOrderAddReqDto addReqDto = new CsReceiveResultOrderAddReqDto();
        addReqDto.setPreOrderNo(reCheckReqDto.getRefundOrderNo());
        addReqDto.setExternalOrderNo(reCheckReqDto.getExternalOrderNo());
        addReqDto.setWarehouseCode(reCheckReqDto.getWarehouseCode());
        addReqDto.setBusinessType(BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_EXCHANGE_IN.getCode());
        ArrayList detailAddReqDtoList = Lists.newArrayList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)reCheckReqDto.getReCheckDetailReqDtoList()), "\u8d27\u54c1\u8be6\u60c5\u7f3a\u5931");
        for (TcbjReCheckDetailReqDto tcbjReCheckDetailReqDto : reCheckReqDto.getReCheckDetailReqDtoList()) {
            CsReceiveResultOrderDetailAddReqDto detailAddReqDto = new CsReceiveResultOrderDetailAddReqDto();
            CubeBeanUtils.copyProperties((Object)detailAddReqDto, (Object)tcbjReCheckDetailReqDto, (String[])new String[0]);
            detailAddReqDto.setQuantity(tcbjReCheckDetailReqDto.getRefundNum());
            detailAddReqDtoList.add(detailAddReqDto);
        }
        addReqDto.setDetailAddReqDtoList((List)detailAddReqDtoList);
        return addReqDto;
    }
}

