/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.statemachine.DocumentActionService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.statemachine.impl.CsDocumentDeliveryCancelServiceImpl;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.RepeatFilter;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.out.CsDeliveryNoticeOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsDeliveryNoticeOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsDeliveryNoticeOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsLogicWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsDeliveryNoticeOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsDeliveryNoticeOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsLogicWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionProcessEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csDeliveryNoticeOrderService")
public class CsDeliveryNoticeOrderServiceImpl
implements ICsDeliveryNoticeOrderService {
    private static Logger logger = LoggerFactory.getLogger(CsDeliveryNoticeOrderServiceImpl.class);
    @Resource
    private CsDeliveryNoticeOrderDas csDeliveryNoticeOrderDas;
    @Resource
    private CsDeliveryNoticeOrderMapper csDeliveryNoticeOrderMapper;
    @Resource
    private CsDeliveryNoticeOrderDetailMapper csDeliveryNoticeOrderDetailMapper;
    @Resource
    private CsLogicWarehouseMapper csLogicWarehouseMapper;
    @Resource
    private CsCommonService csCommonService;
    @Resource
    private SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    private ICsDeliveryNoticeOrderQueryService csDeliveryNoticeOrderQueryService;
    @Resource
    private DocumentActionService documentActionService;
    @Resource
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private RepeatFilter repeatFilter;
    @Resource
    private ICsOutNoticeOrderService csOutNoticeOrderService;
    @Resource
    private CsDocumentDeliveryCancelServiceImpl csDocumentDeliveryCancelService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsDeliveryNoticeOrderAddReqDto addReqDto) {
        logger.info("\u521b\u5efa\u53d1\u8d27\u5355\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(addReqDto));
        this.repeatFilter.checkRepeat("DeliveryNotice:" + addReqDto.getPreOrderNo(), () -> this.preValid(addReqDto), true);
        this.dataValid(addReqDto);
        CsDeliveryNoticeOrderEo deliveryNoticeOrderEo = new CsDeliveryNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)deliveryNoticeOrderEo, (Object)addReqDto, (String[])new String[0]);
        CsGenerateCodeEnum generateCodeEnum = this.simpleGenerateCodeUtil.generateCode("101");
        String documentNo = generateCodeEnum.getCode();
        String orderStatus = generateCodeEnum.getStatus();
        deliveryNoticeOrderEo.setDocumentNo(documentNo);
        deliveryNoticeOrderEo.setOrderStatus(orderStatus);
        deliveryNoticeOrderEo.setExtension(JSON.toJSONString((Object)addReqDto.getContactDto()));
        this.csDeliveryNoticeOrderMapper.insert((Object)deliveryNoticeOrderEo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsDeliveryNoticeOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            CsDeliveryNoticeOrderDetailEo detailEo = new CsDeliveryNoticeOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)addReqDto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailAddReqDto, (String[])new String[]{"id"});
            detailEo.setArtNo(this.csCommonService.getItemCode(detailEo.getCargoCode()));
            detailEo.setDocumentNo(documentNo);
            detailEoList.add(detailEo);
        }
        this.csDeliveryNoticeOrderDetailMapper.insertBatch((List)detailEoList);
        return deliveryNoticeOrderEo.getId();
    }

    private void dataValid(CsDeliveryNoticeOrderAddReqDto addReqDto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getWarehouseCode()), "\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getPreOrderNo()), "\u672a\u4f20\u5165\u524d\u7f6e\u4e1a\u52a1\u5355\u636e");
        AssertUtil.isTrue(addReqDto.getBusinessType() != null, "\u672a\u4f20\u5165\u7c7b\u578b");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)BusinessTypeEnum.getDescByCode((String)addReqDto.getBusinessType())), "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
        List logicWarehouseEos = this.csLogicWarehouseMapper.queryByWarehouseCode(addReqDto.getWarehouseCode());
        List<String> cargoList = addReqDto.getDetailAddReqDtoList().stream().map(CsDeliveryNoticeOrderDetailAddReqDto::getCargoCode).collect(Collectors.toList());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicWarehouseEos), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(cargoList), "\u8d27\u54c1\u4e0d\u5b58\u5728");
        List<CargoEo> cargoEoList = this.csCommonService.queryCargo(cargoList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(cargoEoList), "\u8d27\u54c1\u672a\u914d\u7f6e");
        if (cargoEoList.size() != cargoList.size()) {
            logger.info("error,\u8d27\u54c1\u4e0d\u4e00\u81f4\uff0c\u540e\u7eed\u5904\u7406\uff1b");
        }
        CsLogicWarehouseEo csLogicWarehouseEo = (CsLogicWarehouseEo)logicWarehouseEos.get(0);
        addReqDto.setWarehouseId(csLogicWarehouseEo.getId());
        addReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
        addReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        addReqDto.setOrganizationId(csLogicWarehouseEo.getOrganizationId());
        addReqDto.setOrganizationName(csLogicWarehouseEo.getOrganizationName());
        Map<String, CargoEo> cargoMap = cargoEoList.stream().collect(Collectors.toMap(StdCargoEo::getCode, entity -> entity));
        for (CsDeliveryNoticeOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            CargoEo cargoEo = cargoMap.get(detailAddReqDto.getCargoCode());
            if (null == cargoEo) {
                logger.info("error,\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u540e\u7eed\u5904\u7406");
                continue;
            }
            detailAddReqDto.setCargoId(cargoEo.getId());
            detailAddReqDto.setCargoName(cargoEo.getName());
            detailAddReqDto.setWaitQuantity(detailAddReqDto.getPlanQuantity());
        }
    }

    private void preValid(CsDeliveryNoticeOrderAddReqDto addReqDto) {
        List oldList = this.csDeliveryNoticeOrderMapper.queryByPreOrderNo(addReqDto.getPreOrderNo());
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (CsDeliveryNoticeOrderEo deliveryNoticeOrderEo : oldList) {
                AssertUtil.isTrue(CsOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()), CsInventoryExceptionCode.EXIST_PRE_ORDER.getCode(), deliveryNoticeOrderEo.getPreOrderNo() + CsInventoryExceptionCode.EXIST_PRE_ORDER.getMsg());
            }
        }
    }

    @Override
    public void update(Long id, CsDeliveryNoticeOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsDeliveryNoticeOrderEo updateEo = CsDeliveryNoticeOrderEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csDeliveryNoticeOrderDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        CsDeliveryNoticeOrderEo eo = this.csDeliveryNoticeOrderQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        this.csDeliveryNoticeOrderDas.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void updateOrderStatus(String preOrderNo, String action) {
        logger.info("\u4fee\u6539\u53d1\u8d27\u5355\u5355\u636e\u72b6\u6001\uff1a[preOrderNo:{},action:{}]", (Object)preOrderNo, (Object)action);
        String descByCode = CsDocumentActionEnum.getDescByCode((String)action);
        AssertUtil.isTrue(null != descByCode, CsInventoryExceptionCode.OPERATION_NOT_EXIST.getCode(), CsInventoryExceptionCode.OPERATION_NOT_EXIST.getMsg());
        List deliveryNoticeOrderEoList = this.csDeliveryNoticeOrderMapper.queryByPreOrderNo(preOrderNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderEoList), CsInventoryExceptionCode.DELIVERY_NOTICE_NOT_EXIST.getCode(), CsInventoryExceptionCode.DELIVERY_NOTICE_NOT_EXIST.getMsg());
        CsDeliveryNoticeOrderEo csDeliveryNoticeOrderEo = new CsDeliveryNoticeOrderEo();
        for (CsDeliveryNoticeOrderEo deliveryNoticeOrderEo : deliveryNoticeOrderEoList) {
            if (CsOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(deliveryNoticeOrderEo.getOrderStatus())) continue;
            csDeliveryNoticeOrderEo = deliveryNoticeOrderEo;
        }
        if (null == csDeliveryNoticeOrderEo.getId()) {
            logger.info("\u65e0\u9700\u4fee\u6539\u5355\u636e\u72b6\u6001\uff1a[preOrderNo\uff1a{}\uff0caction:{}]", (Object)preOrderNo, (Object)action);
            return;
        }
        String suffixByAction = CsDocumentActionProcessEnum.getSuffixByAction((String)csDeliveryNoticeOrderEo.getOrderStatus(), (String)action);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)suffixByAction), CsInventoryExceptionCode.OPERATION_ERROR_DOCUMENT.getCode(), CsInventoryExceptionCode.OPERATION_ERROR_DOCUMENT.getMsg() + CsOrderStatusEnum.getDescByCode((String)csDeliveryNoticeOrderEo.getOrderStatus()));
        CsDeliveryNoticeOrderEo csDeliveryNoticeOrderEo1 = new CsDeliveryNoticeOrderEo();
        csDeliveryNoticeOrderEo1.setId(csDeliveryNoticeOrderEo.getId());
        csDeliveryNoticeOrderEo1.setOrderStatus(suffixByAction);
        this.csDeliveryNoticeOrderDas.updateSelective((BaseEo)csDeliveryNoticeOrderEo1);
        logger.info("\u4fee\u6539\u5355\u636e\u72b6\u6001\u6210\u529f\uff1a[preOrderNo\uff1a{}\uff0caction:{},suffixByAction\uff1a{}]", new Object[]{preOrderNo, action, suffixByAction});
        this.documentActionService.doAction(csDeliveryNoticeOrderEo.getDocumentNo(), preOrderNo, suffixByAction);
    }

    @Override
    public void onlyUpdateDocumentStatus(String preOrderNo, String orderStatus) {
        CsOrderStatusEnum statusByCode = CsOrderStatusEnum.getStatusByCode((String)orderStatus);
        AssertUtil.isTrue(null != statusByCode, CsInventoryExceptionCode.UPDATE_STATUS_NOT_EXIST.getCode(), CsInventoryExceptionCode.UPDATE_STATUS_NOT_EXIST.getMsg());
        List deliveryNoticeOrderEoList = this.csDeliveryNoticeOrderMapper.queryByPreOrderNo(preOrderNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderEoList), CsInventoryExceptionCode.DELIVERY_NOTICE_NOT_EXIST.getCode(), CsInventoryExceptionCode.DELIVERY_NOTICE_NOT_EXIST.getMsg());
        CsDeliveryNoticeOrderEo csDeliveryNoticeOrderEo1 = new CsDeliveryNoticeOrderEo();
        csDeliveryNoticeOrderEo1.setId(((CsDeliveryNoticeOrderEo)deliveryNoticeOrderEoList.get(0)).getId());
        csDeliveryNoticeOrderEo1.setOrderStatus(orderStatus);
        this.csDeliveryNoticeOrderDas.updateSelective((BaseEo)csDeliveryNoticeOrderEo1);
    }

    @Override
    public String updateDetailBatch(OrderDetailRespDto orderDetailRespDto) {
        Map<String, String> cargoBatchMap = this.paramValid(orderDetailRespDto);
        List detailEoList = this.csDeliveryNoticeOrderDetailMapper.queryByDocumentNo(orderDetailRespDto.getOrigOrderNo());
        for (CsDeliveryNoticeOrderDetailEo detailEo : detailEoList) {
            String batchNo = cargoBatchMap.get(detailEo.getCargoCode());
            detailEo.setBatch(batchNo);
            this.csDeliveryNoticeOrderDetailMapper.updateById((BaseEo)detailEo);
        }
        return "0";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer updateDetailBatch(CsInventoryOperateReqDto csInventoryOperateReqDto) {
        String documentNo = this.valid(csInventoryOperateReqDto);
        List detailEoList = this.csDeliveryNoticeOrderDetailMapper.queryByDocumentNo(documentNo);
        HashMap<String, CsDeliveryNoticeOrderDetailEo> detailAndActivityMap = new HashMap<String, CsDeliveryNoticeOrderDetailEo>(detailEoList.size());
        HashMap<String, CsDeliveryNoticeOrderDetailEo> detailMap = new HashMap<String, CsDeliveryNoticeOrderDetailEo>(detailEoList.size());
        for (CsDeliveryNoticeOrderDetailEo detailEo : detailEoList) {
            detailAndActivityMap.put(detailEo.getCargoCode() + detailEo.getActivityId(), detailEo);
            detailMap.put(detailEo.getCargoCode(), detailEo);
        }
        List detailIds = detailEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        this.csDeliveryNoticeOrderDetailMapper.deleteBatchIds(detailIds);
        ArrayList list = Lists.newArrayList();
        for (CsInventoryOperateCargoReqDto cargoReqDto : csInventoryOperateReqDto.getOperateCargoReqDtoList()) {
            CsDeliveryNoticeOrderDetailEo eo = (CsDeliveryNoticeOrderDetailEo)detailAndActivityMap.get(cargoReqDto.getCargoCode() + cargoReqDto.getActivityId());
            if (null == eo) {
                eo = (CsDeliveryNoticeOrderDetailEo)detailMap.get(cargoReqDto.getCargoCode());
            }
            CsDeliveryNoticeOrderDetailEo detailEo = new CsDeliveryNoticeOrderDetailEo();
            BeanUtils.copyProperties((Object)eo, (Object)detailEo);
            detailEo.setId(IdUtils.getId());
            detailEo.setPlanQuantity(cargoReqDto.getChangeInventory());
            detailEo.setWaitQuantity(cargoReqDto.getChangeInventory());
            detailEo.setBatch(cargoReqDto.getBatch());
            detailEo.setActivityId(cargoReqDto.getActivityId());
            list.add(detailEo);
        }
        return this.csDeliveryNoticeOrderDetailMapper.insertBatch((List)list);
    }

    private String valid(CsInventoryOperateReqDto csInventoryOperateReqDto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)csInventoryOperateReqDto.getSourceNo()), CsInventoryExceptionCode.PRE_ORDER_IS_NULL.getCode(), CsInventoryExceptionCode.PRE_ORDER_IS_NULL.getMsg());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csInventoryOperateReqDto.getOperateCargoReqDtoList()), CsInventoryExceptionCode.PRE_ORDER_RELEVANCE_ITEM_IS_NULL.getCode(), CsInventoryExceptionCode.PRE_ORDER_RELEVANCE_ITEM_IS_NULL.getMsg());
        List deliveryNoticeOrderEoList = this.csDeliveryNoticeOrderMapper.queryByPreOrderNo(csInventoryOperateReqDto.getSourceNo());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderEoList), CsInventoryExceptionCode.DELIVERY_NOTICE_NOT_EXIST.getCode(), CsInventoryExceptionCode.DELIVERY_NOTICE_NOT_EXIST.getMsg());
        CsDeliveryNoticeOrderEo deliveryNoticeOrderEo = (CsDeliveryNoticeOrderEo)deliveryNoticeOrderEoList.get(0);
        AssertUtil.isTrue(CsOrderStatusEnum.INIT.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()) || CsOrderStatusEnum.DELIVERY_WAIT_AUDIT.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()) || CsOrderStatusEnum.ADJUST_REFUSE.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()), CsInventoryExceptionCode.DOCUMENT_ALWAYS_OUT.getCode(), CsInventoryExceptionCode.DOCUMENT_ALWAYS_OUT.getMsg());
        for (CsInventoryOperateCargoReqDto orderItem : csInventoryOperateReqDto.getOperateCargoReqDtoList()) {
            AssertUtil.isTrue(!Strings.isNullOrEmpty((String)orderItem.getCargoCode()) || !Strings.isNullOrEmpty((String)orderItem.getBatch()), "\u8d27\u54c1\u7f16\u7801/\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return deliveryNoticeOrderEo.getDocumentNo();
    }

    @Override
    public Boolean generateOutNoticeOrder(String orderNo) {
        logger.info("generateOutNoticeOrder-->\u5e93\u5b58\u9884\u5360\u5b8c\u6210\u540e\uff0c\u6839\u636e\u8ba2\u5355\u53f7\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,orderNo:{}", (Object)orderNo);
        ArrayList<OrderQueryEnum> attrs = new ArrayList<OrderQueryEnum>();
        attrs.add(OrderQueryEnum.ADDRESS);
        attrs.add(OrderQueryEnum.ITEM);
        OrderDetailRespDto orderDto = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)this.orderBizQueryApi.getOrderDetail(orderNo, StringUtils.join(attrs, (String)",")));
        if (ObjectUtil.isEmpty((Object)orderDto)) {
            logger.info("----->\u83b7\u53d6\u8ba2\u5355\u660e\u7ec6\u5f02\u5e38\uff0c\u6ca1\u6709\u8ba2\u5355\u660e\u7ec6\uff1a{}", (Object)orderNo);
            return false;
        }
        OrderDeliveryRespDto orderDelivery = new OrderDeliveryRespDto();
        if (ObjectUtil.isNotEmpty((Object)orderDto.getDeliveryAddress())) {
            orderDelivery = (OrderDeliveryRespDto)JSONObject.parseObject((String)orderDto.getDeliveryAddress(), OrderDeliveryRespDto.class);
        }
        CsDeliveryNoticeOrderAddReqDto addReqDto = new CsDeliveryNoticeOrderAddReqDto();
        addReqDto.setPreOrderNo(orderDto.getOrderNo());
        addReqDto.setExternalOrderNo(orderDto.getThirdOrderNo());
        addReqDto.setWarehouseCode(orderDto.getWarehouseCode());
        ContactDto contactDto = new ContactDto();
        contactDto.setAddress(orderDelivery.getAddress());
        contactDto.setPlanTime(DateUtils.formatDate(orderDto.getPlaceTime(), "yyyy-MM-dd HH:mm:ss"));
        contactDto.setReciveName(orderDelivery.getDeliveryName());
        contactDto.setRecivePhone(orderDelivery.getDeliveryMobile());
        ArrayList detailAddReqDtoList = com.google.common.collect.Lists.newArrayList();
        BigDecimal totalQuantity = BigDecimal.ZERO;
        for (TradeItemRespDto item : orderDto.getOrderItems()) {
            CsDeliveryNoticeOrderDetailAddReqDto dto = new CsDeliveryNoticeOrderDetailAddReqDto();
            dto.setBatch(item.getBatchNo());
            dto.setCargoCode(item.getCargoSerial());
            dto.setPlanQuantity(BigDecimal.valueOf(item.getItemNum().intValue()));
            try {
                dto.setActivityId(item.getCombinedPackageActivityId());
            }
            catch (Exception ex) {
                logger.error("\u5546\u54c1\u53c2\u4e0e\u6d3b\u52a8id\u5f02\u5e38\uff0c\u4e0d\u8d4b\u503c\uff1bactivityId:{}", (Object)item.getCombinedPackageActivityId());
            }
            totalQuantity = totalQuantity.add(dto.getPlanQuantity());
            dto.setTradeOrderItemId(item.getId());
            detailAddReqDtoList.add(dto);
        }
        addReqDto.setTotalQuantity(totalQuantity);
        addReqDto.setDetailAddReqDtoList((List)detailAddReqDtoList);
        addReqDto.setContactDto(contactDto);
        addReqDto.setBusinessType(BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_SALES_ISSUE.getCode());
        logger.info("----->\u521b\u5efa\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f");
        this.add(addReqDto);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean batchUpdateNoticeStatusPass(List<String> preOrderNoList) {
        logger.info("\u6279\u91cf\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001(\u901a\u8fc7)\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(preOrderNoList));
        this.repeatFilter.checkRepeat("BatchUpdateOrderStatusPass:", () -> this.validParam(preOrderNoList), true);
        List<CsDeliveryNoticeOrderDetailEo> detailEoList = this.queryByPreOrderNoList(preOrderNoList);
        AssertUtil.isTrue(CollectionUtils.isEmpty(detailEoList), "\u6279\u91cf\u64cd\u4f5c\u4e2d\u5b58\u5728\u90e8\u5206\u672a\u6307\u5b9a\u6279\u6b21\u7684\u5355\u636e\uff0c\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c\uff01\u5355\u636e\u53f7\uff1a" + JSON.toJSONString(detailEoList.stream().map(CsDeliveryNoticeOrderDetailEo::getPreOrderNo).distinct().collect(Collectors.toList())));
        List<CsDeliveryNoticeOrderEo> deliveryNoticeOrderEoList = this.queryNoticeByPreOrderNoList(preOrderNoList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(deliveryNoticeOrderEoList), "\u524d\u7f6e\u5355\u636e\u5173\u8054\u7684\u53d1\u8d27\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        for (CsDeliveryNoticeOrderEo deliveryNoticeOrderEo : deliveryNoticeOrderEoList) {
            AssertUtil.isTrue(CsOrderStatusEnum.DELIVERY_WAIT_AUDIT.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()), "\u5b58\u5728\u975e\u8d22\u52a1\u5ba1\u6838\u6d41\u7a0b\u5ba1\u6838\u5355\u636e\uff0c\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c\uff01");
            CsDeliveryNoticeOrderEo deliveryNoticeOrderEo1 = new CsDeliveryNoticeOrderEo();
            deliveryNoticeOrderEo1.setId(deliveryNoticeOrderEo.getId());
            deliveryNoticeOrderEo1.setOrderStatus(CsOrderStatusEnum.DELIVERY_OUT_ING.getCode());
            this.csDeliveryNoticeOrderMapper.updateById((BaseEo)deliveryNoticeOrderEo1);
        }
        logger.info("\u6279\u91cf\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001(\u901a\u8fc7)\uff0c\u5f00\u59cb\u904d\u5386\u751f\u6210\u51fa\u5e93\u901a\u77e5\u5355");
        for (CsDeliveryNoticeOrderEo deliveryNoticeOrderEo : deliveryNoticeOrderEoList) {
            this.csOutNoticeOrderService.createOutNoticeOrder(deliveryNoticeOrderEo.getDocumentNo());
        }
        logger.info("\u6279\u91cf\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001(\u901a\u8fc7)\uff0c\u904d\u5386\u751f\u6210\u51fa\u5e93\u901a\u77e5\u5355\u5b8c\u6210");
        return true;
    }

    private List<CsDeliveryNoticeOrderDetailEo> queryByPreOrderNoList(List<String> preOrderNoList) {
        CsDeliveryNoticeOrderDetailEo detailEo = new CsDeliveryNoticeOrderDetailEo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"pre_order_no", preOrderNoList);
        queryWrapper.isNull((Object)"batch");
        return this.csDeliveryNoticeOrderDetailMapper.selectList((Wrapper)queryWrapper);
    }

    private void validParam(List<String> preOrderNoList) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(preOrderNoList), "\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5355\u636e\uff01");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean batchUpdateNoticeStatusNoPass(List<String> preOrderNoList) {
        logger.info("\u6279\u91cf\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001(\u4e0d\u901a\u8fc7)\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(preOrderNoList));
        this.repeatFilter.checkRepeat("BatchUpdateOrderStatusNoPass:", () -> this.validParam(preOrderNoList), true);
        List<CsDeliveryNoticeOrderEo> deliveryNoticeOrderEoList = this.queryNoticeByPreOrderNoList(preOrderNoList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(deliveryNoticeOrderEoList), "\u524d\u7f6e\u5355\u636e\u5173\u8054\u7684\u53d1\u8d27\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        for (CsDeliveryNoticeOrderEo deliveryNoticeOrderEo : deliveryNoticeOrderEoList) {
            AssertUtil.isTrue(CsOrderStatusEnum.DELIVERY_WAIT_AUDIT.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()), "\u5b58\u5728\u975e\u8d22\u52a1\u5ba1\u6838\u6d41\u7a0b\u5ba1\u6838\u5355\u636e\uff0c\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c\uff01");
            CsDeliveryNoticeOrderEo deliveryNoticeOrderEo1 = new CsDeliveryNoticeOrderEo();
            deliveryNoticeOrderEo1.setId(deliveryNoticeOrderEo.getId());
            deliveryNoticeOrderEo1.setOrderStatus(CsOrderStatusEnum.ADJUST_REFUSE.getCode());
            this.csDeliveryNoticeOrderMapper.updateById((BaseEo)deliveryNoticeOrderEo1);
        }
        logger.info("\u6279\u91cf\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001(\u4e0d\u901a\u8fc7)\uff0c\u5f00\u59cb\u904d\u5386\u91ca\u653e\u9884\u5360\u5e93\u5b58");
        for (CsDeliveryNoticeOrderEo deliveryNoticeOrderEo : deliveryNoticeOrderEoList) {
            this.csDocumentDeliveryCancelService.doAction(deliveryNoticeOrderEo.getDocumentNo(), deliveryNoticeOrderEo.getPreOrderNo());
        }
        logger.info("\u6279\u91cf\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001(\u4e0d\u901a\u8fc7)\uff0c\u904d\u5386\u751f\u91ca\u653e\u9884\u5360\u5e93\u5b58\u5b8c\u6210");
        return true;
    }

    private List<CsDeliveryNoticeOrderEo> queryNoticeByPreOrderNoList(List<String> preOrderNoList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"pre_order_no", preOrderNoList);
        return this.csDeliveryNoticeOrderMapper.selectList((Wrapper)queryWrapper);
    }

    private Map<String, String> paramValid(OrderDetailRespDto orderDetailRespDto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)orderDetailRespDto.getOrderNo()), "\u524d\u7f6e\u5355\u636e\u53f7\u4e3a\u7a7a");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)orderDetailRespDto.getOrderItems()), "\u524d\u7f6e\u5355\u636e\u5173\u8054\u7684\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
        List deliveryNoticeOrderEoList = this.csDeliveryNoticeOrderMapper.queryByPreOrderNo(orderDetailRespDto.getOrderNo());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderEoList), "\u524d\u7f6e\u5355\u636e\u4e0d\u5b58\u5728\u53d1\u8d27\u901a\u77e5\u5355");
        CsDeliveryNoticeOrderEo deliveryNoticeOrderEo = (CsDeliveryNoticeOrderEo)deliveryNoticeOrderEoList.get(0);
        AssertUtil.isTrue(CsOrderStatusEnum.INIT.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()) || CsOrderStatusEnum.DELIVERY_WAIT_AUDIT.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()) || CsOrderStatusEnum.ADJUST_REFUSE.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()), "\u5355\u636e\u5df2\u901a\u77e5\u51fa\u5e93\uff0c\u4e0d\u80fd\u66f4\u65b0\u6279\u6b21");
        HashMap<String, String> cargoBatchMap = new HashMap<String, String>();
        for (TradeItemRespDto orderItem : orderDetailRespDto.getOrderItems()) {
            AssertUtil.isTrue(!Strings.isNullOrEmpty((String)orderItem.getCargoSerial()) || !Strings.isNullOrEmpty((String)orderItem.getBatchNo()), "\u8d27\u54c1\u7f16\u7801/\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
            cargoBatchMap.put(orderItem.getCargoSerial(), orderItem.getBatchNo());
        }
        orderDetailRespDto.setOrigOrderNo(deliveryNoticeOrderEo.getDocumentNo());
        return cargoBatchMap;
    }
}

